import java.awt.*;

public class Sound extends java.applet.Applet { 

   //double buffer
  int xpos[] = new int[101] ;
  int rad[]  = new int[101] ;
  int sonic,freq ;
  int vel,vmax,vmin ;
  int ypos,count,stepper ;
  Ins ins ;
  Viewer view ;
  Image offscreenImg ;
  Graphics offsGg ;

  public void init() {
     offscreenImg = createImage(this.size().width,
                   this.size().height) ;
     offsGg = offscreenImg.getGraphics() ;
 
     setLayout(new GridLayout(2,1,0,0)) ;
 
     view = new Viewer(this) ;

     ins = new Ins(this) ;
                     
     add(view) ;
     add(ins) ;
 
     vel  = 0 ;
     vmin = 0 ;
     vmax = 40 ;
     sonic = 20 ;
     freq = 0 ;
 
     stepper = 0 ;

     view.start() ;
  }

  class Ins extends Panel {
     Sound outerparent ;
     Ins1 ins1;
     Ins2 ins2;
     Ins3 ins3;

     Ins (Sound target) {
        setLayout(new GridLayout(3,1,10,10)) ;

        ins1 = new Ins1(outerparent) ;
        ins2 = new Ins2(outerparent) ;
        ins3 = new Ins3(outerparent) ;
 
        add(ins1) ;
        add(ins2) ;
        add(ins3) ;
    }

    class Ins1 extends Panel {
      Sound outerparent ;
      Button b1,b2,b3,b4,b5 ;
      Label ls1 ;

      Ins1 (Sound target) {
        setLayout(new GridLayout(1,6,0,0)) ;
        b1 = new Button("Start") ;
        b1.setBackground(Color.blue) ;
        b1.setForeground(Color.white) ;
        b2 = new Button("Stop") ;
        b2.setBackground(Color.red) ;
        b2.setForeground(Color.white) ;
        b3 = new Button("Resume") ;
        b4 = new Button("Step Forward") ;
        b5 = new Button("Step Back") ;

        ls1 = new Label("FREQUENCY", Label.CENTER) ;
        ls1.setBackground(Color.blue) ;
        ls1.setForeground(Color.yellow) ;
 
        add(b1) ;
        add(b2) ;
        add(b4) ;
        add(b5) ;
        add(b3) ;
        add(ls1) ;
      }

      public Insets insets() {
        return new Insets(10,10,0,10) ;
      }

      public boolean action (Event evt, Object arg) {
       if (evt.target instanceof Button) {
          String label = (String)arg ;
          if (label.equals("Start")) {
              view.start() ;
          }
          if (label.equals("Stop")) {
              view.stop() ;
          }
          if (label.equals("Resume")) {
              view.restart() ;
          }
          if (label.equals("Step Forward")) {
              view.stepf() ;
          }
          if (label.equals("Step Back")) {
              view.stepb() ;
          }
          return true ;
        }
        else return false ;
      }
    }

    class Ins2 extends Panel {
      Sound outerparent ;
      Label l1,l2,l3,l4 ;
      Label lm1,lm2,lm3,lm4,lm5 ;

      Ins2 (Sound target) {
        setLayout(new GridLayout(2,5,10,10)) ;
 
        l1 = new Label("Speed Regime:", Label.CENTER) ;
        l1.setForeground(Color.magenta) ;
        l2 = new Label("Subsonic", Label.CENTER) ;
        l2.setForeground(Color.blue) ;
        l3 = new Label("Transonic", Label.CENTER) ;
        l3.setForeground(Color.black) ;
        l4 = new Label("Supersonic", Label.RIGHT) ;
        l4.setForeground(Color.red) ;

        add(l1) ;
        add(l2) ;
        add(l3) ;
        add(l4) ;
        add(new Label(" ", Label.CENTER)) ;

        lm1 = new Label("Mach = 0.0 ", Label.LEFT) ;
        lm1.setForeground(Color.blue) ;
        lm2 = new Label("Mach = 0.5", Label.CENTER) ;
        lm2.setForeground(Color.blue) ;
        lm3 = new Label("Mach = 1.0", Label.CENTER) ;
        lm3.setForeground(Color.black) ;
        lm4 = new Label("Mach = 1.5 ", Label.RIGHT) ;
        lm4.setForeground(Color.red) ;
        lm5 = new Label("Mach = 2.0 ", Label.RIGHT) ;
        lm5.setForeground(Color.red) ;

        add(lm1) ;
        add(lm2) ;
        add(lm3) ;
        add(lm4) ;
        add(lm5) ;
      }
    }

    class Ins3 extends Panel {
      Sound outerparent ;
      Scrollbar s1 ;

      Ins3 (Sound target) {
        
        setLayout(new GridLayout(1,1,10,10)) ;
   
        s1 = new Scrollbar(Scrollbar.HORIZONTAL,0,1,0,40) ;

        add(s1) ;
      }
 
      public boolean handleEvent(Event evt) {
        if (evt.id == Event.ACTION_EVENT) {
           this.handleBar(evt) ;
           return true ;
        }
        if (evt.id == Event.SCROLL_ABSOLUTE) {
           this.handleBar(evt) ;
           return true ;
        }
        if (evt.id == Event.SCROLL_LINE_UP) {
           this.handleBar(evt) ;
           return true ;
        }
        if (evt.id == Event.SCROLL_LINE_DOWN) {
           this.handleBar(evt) ;
           return true ;
        }
        if (evt.id == Event.SCROLL_PAGE_UP) {
           this.handleBar(evt) ;
           return true ;
        }
        if (evt.id == Event.SCROLL_PAGE_DOWN) {
           this.handleBar(evt) ;
           return true ;
        }
        else return false ;
      }
 
      public void handleBar(Event evt) {
          vel = s1.getValue() ;
          view.start() ;        
      }
    }
  }

  class Viewer extends Canvas 
     implements Runnable{
     Sound outerparent ;
     Thread runner ;

     Viewer (Sound target) {
        setBackground(Color.black) ;
        runner = null ;
     }

     public void start() {
        int i,j ;

        ypos = 75 ;
        for (i=0; i<=100; ++i) {
          xpos[i] = 10 ;
          rad[i] = 0 ;
        }
        count = 0 ;
        stepper = 0 ;
        freq = 0 ;
    
        if (runner == null) {
           runner = new Thread(this) ;
           runner.start() ;
        }
     }
 
     public void stop() {
       if (runner != null) {
          runner.stop() ;
          runner = null ;
       }
     }

     public void restart() {   
        if (runner == null) {
           runner = new Thread(this) ;
           stepper = 0 ;
           runner.start() ;
        }
     }

     public void stepf() {   
        if (runner == null) {
           runner = new Thread(this) ;
           stepper = 1 ;
           runner.start() ;
        }
     }

     public void stepb() {   
        if (runner == null) {
           runner = new Thread(this) ;
           stepper = 2 ;
           runner.start() ;
        }
     }

     public void run() {
       int i,j,v1 ;

       switch(stepper) {
         case 0: {      // loop steps
          while (true) {
            v1 = vel + 1 ;
            if (vel == 0) v1 =40;
            ++count ;
            for (j=0; j<=count; ++j) {
              rad[j] = rad[j] + sonic ;
            }
            xpos[count] = xpos[count-1] + vel ;
                            // determine frequency
            computeFreq() ;
            view.repaint();
            try { Thread.sleep(100); }
            catch (InterruptedException e) { }
            if(count >= (70 - v1)) {
              for (i=0; i<=100; ++i) {
                xpos[i] = 10 ;
                rad[i] = 0 ;
              }
              count = 0 ;
              freq = 0 ;
            }
          }
        }
        case 1: {   // step forward
          if (count == 80){
              view.repaint();
              runner = null ;
              return ;
          }
          ++count ;
          for (j=0; j<=count; ++j) {
              rad[j] = rad[j] + sonic ;
          }
          xpos[count] = xpos[count-1] + vel ;
          computeFreq() ;
          view.repaint();
          runner = null ;
          break ;
       }
       case 2: {   // step back
          if (count == 1){
              view.repaint();
              runner = null ;
              return ;
          }
          --count ;
          for (j=0; j<=count+1; ++j) {
              rad[j] = rad[j] - sonic ;
          }
          computeFreq() ;
          view.repaint();
          runner = null ;
          break ;
       }
      }
      return ;
     }

     public void computeFreq() {
       double factor ;
       int loc ;

       freq = 0 ;
       if (vel < sonic) {
          if (rad[0] > 300) {  // doppler shift
             factor = ((double) sonic) / ((double) sonic - (double) vel) ;
             if (factor > 1.95) factor = 1.95 ;
             freq = (int) (factor * 60 );
          }
          if (xpos[count] > 300) {  // doppler shift
             factor = ((double) sonic) / ((double) sonic + (double) vel) ;
             if (factor < .05) factor = .05 ;
             freq = (int) (factor * 60 );
          }
       }
       if (vel >= sonic) {    // shock wave
          factor = ((double) vel - (double) sonic) / ((double) sonic) ;
          loc = xpos[count] - (int) ( 75 * factor) ;
          if (loc > 300) freq = 125 ;
          if (loc > 340) freq = 25 ; 
       }
     }
 
     public void update(Graphics g) {
        view.paint(g) ;
     }

     public void paint(Graphics g) {
       int i ;
       int xs[] = new int[4] ;
       int ys[] = new int[4] ;

       offsGg.setColor(Color.white) ;
       offsGg.fillRect(0,0,500,150) ;

    // draw bug
       offsGg.setColor(Color.blue) ;
       offsGg.fillOval(xpos[count]-rad[count]+10,70,20,10);
       offsGg.fillOval(xpos[count]-rad[count]+25,70,8,8);
       xs[0] = xpos[count] -5 ;  xs[1] = xpos[count]+3;
       xs[2] = xpos[count] -4 ;  xs[3] = xpos[count] -13;
       ys[0] = 75 ; ys[1] = 70 ;
       ys[2] = 64 ; ys[3] = 68 ;
       offsGg.fillPolygon(xs,ys,4) ;
       xs[0] = xpos[count] -5 ;  xs[1] = xpos[count]+5;
       ys[0] = 82 ; ys[1] =70 ;
       offsGg.drawLine(xs[0],ys[0],xs[1],ys[1]) ;
       xs[0] = xpos[count] +10 ;  xs[1] = xpos[count]+5;
       ys[0] = 81 ; ys[1] =70 ;
       offsGg.drawLine(xs[0],ys[0],xs[1],ys[1]) ;
       xs[0] = xpos[count] +2 ;  xs[1] = xpos[count]+5;
       ys[0] = 81 ; ys[1] =70 ;
       offsGg.drawLine(xs[0],ys[0],xs[1],ys[1]) ;

    // draw microphone
       offsGg.setColor(Color.black) ;
       offsGg.fillOval(310,120,15,15);
       xs[0] = 315 ; xs[1] = 320 ;   xs[2] = 346 ; xs[3] = 344 ;
       ys[0] = 133 ; ys[1] = 122 ;   ys[2] = 139 ; ys[3] = 141 ;
       offsGg.fillPolygon(xs,ys,4) ;
       offsGg.fillRect(330,135,5,40) ;

     // Draw wave
       offsGg.setColor(Color.red) ;
       for (i=1 ; i<= count; ++i) {
          offsGg.drawOval(xpos[i]-rad[i],ypos-rad[i],2*rad[i],2*rad[i]);
      }
 
       offsGg.setColor(Color.white) ;
       offsGg.fillRect(500,0,100,150) ;
       offsGg.setColor(Color.blue) ;
       offsGg.fillRect(490,0,95,150) ;

       offsGg.setColor(Color.white) ;
       offsGg.drawString("SOUND",510,20) ;

       offsGg.setColor(Color.yellow) ;
       offsGg.fillRect(518,150 - freq,45,freq) ;
       offsGg.setColor(Color.white) ;
       for (i=25; i<=125; i = i + 25) {
         offsGg.drawString("___",495,i) ;
         offsGg.drawString("___",565,i) ;
       }

       g.drawImage(offscreenImg,0,0,this) ;   
    }
  }
}
