/*  
       Applet to calculate the altitude of a model rocket
                4 angles and a length input
*/

import java.awt.*;
import java.lang.Math ;

public class Altcalc extends java.applet.Applet {

   static double convdr = 3.1415926/180. ;
   double anga, angb, angc, angd, length, alt ;
   int lunits;
   int mode ;

   In in ;

   public void init() {

     setLayout(new GridLayout(1,1,0,0)) ;

     setDefaults () ;

     in = new In(this) ;

     add(in) ;

     computeAlt() ;
  }
 
  public void setDefaults() {
  
     mode = 0 ;
     lunits = 0;

     anga = 45.0 * convdr ;
     angb = 30.0 * convdr ;
     angc = 30.0 * convdr ;
     angd = 45.0 * convdr ;
 
     length = 100. ;
  }

  public void computeAlt() {
 
              // compute using 4 angles 
     if (mode == 0) {
        alt = (length * Math.tan(anga) * Math.tan(angd))/
              (Math.cos(angb)*Math.tan(angd) + Math.cos(angc)*Math.tan(anga));
     } 
              // compute ignoring angle a 
     if (mode == 1) {
        alt = (length * Math.sin(angb) * Math.tan(angd))/Math.sin(angb + angc);
     } 
              // compute ignoring angle d 
     if (mode == 2) {
        alt = (length * Math.sin(angc) * Math.tan(anga))/Math.sin(angb + angc);
     } 

     if (lunits == 0) {
        in.dn.o1.setText(String.valueOf(filter0(alt))) ;
     }
     if (lunits == 1) {
        in.dn.o1.setText(String.valueOf(filter0(alt * .3048))) ;
     }
  }
 
  public int filter0(double inumbr) {
     //  integer output
       float number ;
       int intermed ;

       intermed = (int) (inumbr) ;
       number = (float) (intermed);
       return intermed ;
  }
 
  public float filter3(double inumbr) {
     //  output only to .001
       float number ;
       int intermed ;
  
       intermed = (int) (inumbr * 1000.) ;
       number = (float) (intermed / 1000. );
       return number ;
  }

  public float filter5(double inumbr) {
     //  output only to .00001
       float number ;
       int intermed ;
  
       intermed = (int) (inumbr * 100000.) ;
       number = (float) (intermed / 100000. );
       return number ;
  }

  class In extends Panel {
     Altcalc outerparent ;
     Titl titl ;
     Up up ;
     Dn dn ;

     In (Altcalc target) {                           
        outerparent = target ;
        setLayout(new GridLayout(3,1,5,5)) ;

        titl = new Titl(outerparent) ;
        up = new Up(outerparent) ;
        dn = new Dn(outerparent) ;

        add(titl) ;
        add(up) ;
        add(dn) ;
     }

     class Titl extends Panel {
        Label la,lb,lc,ld ;

        Titl (Altcalc target) {                           
            outerparent = target ;
            setLayout(new GridLayout(4,1,0,0)) ;

            lc = new Label("Altitude Calculator", Label.CENTER) ;

            la = new Label("Enter values for angles and reference length ", Label.CENTER) ;
            la.setForeground(Color.red) ;

            ld = new Label(" Choose Compute Mode", Label.CENTER) ;
            ld.setForeground(Color.red) ;

            lb = new Label(" Press Compute Button ", Label.CENTER) ;
            lb.setForeground(Color.red) ;

            add(lc) ;
            add(la) ;
            add(ld) ;
            add(lb) ;
        }
     }

     class Up extends Panel {
        TextField o1,o2,o3,o4,o5 ;
        Label l1,l2,l3,l4,l5;
        Label l1u,l2u,l3u,l4u,l5u;
        Choice untch;

        Up (Altcalc target) {                           
            outerparent = target ;
            setLayout(new GridLayout(6,3,0,0)) ;

            l1 = new Label("#1  Angle a", Label.RIGHT) ;
            l1u = new Label(" degrees ", Label.LEFT) ;
            l2 = new Label("#1  Angle b", Label.RIGHT) ;
            l2u = new Label(" degrees ", Label.LEFT) ;
            l3 = new Label("#2  Angle c", Label.RIGHT) ;
            l3u = new Label(" degrees ", Label.LEFT) ;
            l4 = new Label("#2  Angle d", Label.RIGHT) ;
            l4u = new Label(" degrees ", Label.LEFT) ;
            l5 = new Label("Reference Length", Label.RIGHT) ;
            l5u = new Label(" feet ", Label.LEFT) ;
   
            o1 = new TextField("45.0",5) ;
            o1.setBackground(Color.white) ;
            o1.setForeground(Color.black) ;
            o2 = new TextField("30.0",5) ;
            o2.setBackground(Color.white) ;
            o2.setForeground(Color.black) ;
            o3 = new TextField("30.0",5) ;
            o3.setBackground(Color.white) ;
            o3.setForeground(Color.black) ;
            o4 = new TextField("45.0",5) ;
            o4.setBackground(Color.white) ;
            o4.setForeground(Color.black) ;
            o5 = new TextField("100.0",5) ;
            o5.setBackground(Color.white) ;
            o5.setForeground(Color.black) ;
 
            untch = new Choice() ;
            untch.addItem("English") ;
            untch.addItem("Metric");
            untch.select(0) ;

            add(new Label("Units: ", Label.RIGHT)) ;
            add(untch) ;
            add(new Label(" ", Label.RIGHT)) ;

            add(l1) ;
            add(o1) ;
            add(l1u) ;
            
            add(l2) ;
            add(o2) ;
            add(l2u) ;
            
            add(l3) ;
            add(o3) ;
            add(l3u) ;
            
            add(l4) ;
            add(o4) ;
            add(l4u) ;
            
            add(l5) ;
            add(o5) ;
            add(l5u) ;
        }

        public boolean action(Event evt, Object arg) {
            if(evt.target instanceof Choice) {
               this.handleProb(arg) ;
               return true ;
            }

            else return false ;
        }
 
        public void handleProb(Object obj) {

            lunits  = untch.getSelectedIndex() ;
 
            if (lunits == 0) {  // English units labels
                o5.setText(String.valueOf(filter0(length))) ;
                l5u.setText(" feet ") ;
                dn.o1.setText(String.valueOf(filter0(alt))) ;
                dn.l1u.setText(" feet ") ;
                
            }
            if (lunits == 1) {  // Metric units labels
                o5.setText(String.valueOf(filter0(length * .3048))) ;
                l5u.setText(" meters ") ;
                dn.l1u.setText(" meters ") ;
                dn.o1.setText(String.valueOf(filter0(alt * .3048))) ;
            }
 
            computeAlt() ;
        }
     }

     class Dn extends Panel {
        Altcalc outerparent ;
        TextField o1 ;
        Label l1,l1u;
        Button compb ;
        Choice modch;

        Dn (Altcalc target) {
            outerparent = target ;
            setLayout(new GridLayout(5,3,0,0)) ;
    
            l1 = new Label(" Altitude ", Label.RIGHT) ;
            l1u = new Label(" feet ", Label.LEFT) ;

            o1 = new TextField() ;
            o1.setBackground(Color.black) ;
            o1.setForeground(Color.yellow) ;

            modch = new Choice() ;
            modch.addItem("#1 use all") ;
            modch.addItem("#2 ignore a");
            modch.addItem("#3 ignore d");
            modch.select(0) ;

            compb = new Button("Compute") ;
            compb.setBackground(Color.red) ;
            compb.setForeground(Color.white) ;

            add(new Label("Compute Mode:", Label.RIGHT)) ;
            add(modch) ;
            add(new Label(" ", Label.RIGHT)) ;

            add(new Label(" ", Label.RIGHT)) ;
            add(new Label(" ", Label.RIGHT)) ;
            add(new Label(" ", Label.RIGHT)) ;

            add(new Label(" ", Label.RIGHT)) ;
            add(compb) ;
            add(new Label(" ", Label.RIGHT)) ;

            add(new Label(" ", Label.RIGHT)) ;
            add(new Label(" ", Label.RIGHT)) ;
            add(new Label(" ", Label.RIGHT)) ;

            add(l1) ;
            add(o1) ;
            add(l1u) ;
        }
        
        public boolean action(Event evt, Object arg) {
            
            if(evt.target instanceof Button) {
               this.handleText(evt) ;
               return true ;
            }

            if(evt.target instanceof Choice) {
               this.handleText(evt) ;
               return true ;
            }

            else return false ;
        }
 
        public void handleText(Event evt) {
            Double V1,V2,V3,V4,V5 ;
            double v1,v2,v3,v4,v5 ;
            double vmax,vmin ;

            mode = modch.getSelectedIndex() ;

            V1 = Double.valueOf(up.o1.getText()) ;
            v1 = V1.doubleValue() ;
            V2 = Double.valueOf(up.o2.getText()) ;
            v2 = V2.doubleValue() ;
            V3 = Double.valueOf(up.o3.getText()) ;
            v3 = V3.doubleValue() ;
            V4 = Double.valueOf(up.o4.getText()) ;
            v4 = V4.doubleValue() ;
            V5 = Double.valueOf(up.o5.getText()) ;
            v5 = V5.doubleValue() ;

            vmax = 180. ; 
            vmin = 0.0 ;      

            if (v1 < vmin) {
               v1 = vmin ;
               up.o1.setText(String.valueOf(filter0(v1))) ;
            }
            if (v1 > vmax) {
               v1 = vmax ;
               up.o1.setText(String.valueOf(filter0(v1))) ;
            }
            anga = convdr * v1 ;

            if (v2 < vmin) {
               v2 = vmin ;
               up.o2.setText(String.valueOf(filter0(v2))) ;
            }
            if (v2 > vmax) {
               v2 = vmax ;
               up.o2.setText(String.valueOf(filter0(v2))) ;
            }
            angb = convdr * v2 ;

            if (v3 < vmin) {
               v3 = vmin ;
               up.o3.setText(String.valueOf(filter0(v3))) ;
            }
            if (v3 > vmax) {
               v3 = vmax ;
               up.o3.setText(String.valueOf(filter0(v3))) ;
            }
            angc = convdr * v3 ;

            if (v4 < vmin) {
               v4 = vmin ;
               up.o4.setText(String.valueOf(filter0(v4))) ;
            }
            if (v4 > vmax) {
               v4 = vmax ;
               up.o4.setText(String.valueOf(filter0(v4))) ;
            }
            angd = convdr * v4 ;
                
            if (lunits == 0) {
                vmax = 500.; 
                vmin = 0.0 ;      

                if (v5 < vmin) {
                   v5 = vmin ;
                   up.o5.setText(String.valueOf(filter0(v5))) ;
                }
                if (v5 > vmax) {
                   v5 = vmax ;
                   up.o5.setText(String.valueOf(filter0(v5))) ;
                }
               
                length = v5 ;
            }
            if (lunits == 1) {
                vmax = 500. * .3048;
                vmin = 0.0 ;      

                if (v5 < vmin) {
                   v5 = vmin ;
                   up.o5.setText(String.valueOf(filter0(v5))) ;
                }
                if (v5 > vmax) {
                   v5 = vmax ;
                   up.o5.setText(String.valueOf(filter0(v5))) ;
                }
               
                length = v5 / .3048 ;
            }

            computeAlt() ;
        }
     }
  }
}
