/*
                          RocketModeler III

                           A Java Applet
               to design and fly a variety of model rockets
                 including stomp rockets, bottle rockets and 
                        solid powered rockets

                           Version 1.1b

                             Written by

                             Tom Benson
                       NASA Glenn Research Center

                               and
                           
                             Anthony Vila
                         Vanderbilt University

>                              NOTICE
>This software is in the Public Domain.  It may be freely copied and used in
>non-commercial products, assuming proper credit to the author is given.  IT
>MAY NOT BE RESOLD.  If you want to use the software for commercial
>products, contact the author.
>No copyright is claimed in the United States under Title 17, U. S. Code.
>This software is provided "as is" without any warranty of any kind, either
>express, implied, or statutory, including, but not limited to, any warranty
>that the software will conform to specifications, any implied warranties of
>merchantability, fitness for a particular purpose, and freedom from
>infringement, and any warranty that the documentation will conform to the
>program, or any warranty that the software will be error free.
>In no event shall NASA be liable for any damages, including, but not
>limited to direct, indirect, special or consequential damages, arising out
>of, resulting from, or in any way connected with this software, whether or
>not based on warranty, contract, tort or otherwise, whether or not injury
>was sustained by persons or property or otherwise, and whether or not loss
>was sustained from, or arose out of the results of, or use of, the software
>or services provided hereunder.
 
  New test -
             *      staging
             *        2 stage
                      3 stage
               add egg as payload
               lengthen launch tube for air rocket
                                           TJB  1 Feb 10

New Test A:
		-Add reset button to reset entire program
		-Add drag interpolator for Rocket designs

									AJV 7/15/2009

*/

import java.awt.*;
import java.lang.Math ;
import java.awt.event.*;

public class Rocket extends java.applet.Applet {
 
   static double convdr = 3.1415926/180. ;
   static double pid2 = 3.1415926/2.0 ;
   static double pi = 3.1415926 ;
   static double zero = 0.0 ;
   static double wtzero = 0.00001 ;
 
   int rktype,ntype,part,rtype,fintype,numfin,lunits,planet ;
   int nstage,numeng,nclust,btfair,balob,objtyp ;
   int istab,ifuel,ides,irange ;
            // body geometry
   static double blngth,blngd,blmax,blmin,bdiam,bdiamd,bdmax,bdmin,brad ;
            // tail fairing geometry
   static double tlngth,tlngd,tlmax,tlmin,tdiam,tdiamd,tdmax,tdmin,trad ;
            // bottle tail fairing
   static double btlngth,btlngd,btlmax,btlmin;
   static double btdiam,btdiamd,btdmax,btdmin,btrad;
            // payload geometry
   static double plngth,plngd,plmax,plmin,pdiam,pdiamd,pdmax,pdmin,prad ;
            // payload fairing geometry
   static double qlngth,qlngd,qlmax,qlmin ;
            // nose geometry
   static double nlngth,nlngd,nlmax,nlmin,ndiam,ndiamd,ndmax,ndmin,nrad ;
   static double nfact,nfact2 ;
            // fin geometry
   static double flngth,flngd,flmax,flmin,fwidth,fwid,fwmax,fwmin,fwex ;
   static double fleang,flemax,flemin,fteang,ftemax,ftemin ;
   static double ftanle,ftante ;
   static double floc,flocd,flcmax,flcmin ;
   static double delt,ap,thet;
   static double[][] finx = new double[3][4] ;
   static double[][] finy = new double[3][4] ;

   static double vmn1,vmn2,vmn3,vmn4,vmn5,vmn6,vmx1,vmx2,vmx3,vmx4,vmx5,vmx6 ;
   static double lconv1,lconv2,fconv,pconv ;
   static double aconv,dconv2,dconv3,vconv ;
               // weight and materials
   static int mbod,mtfr,mnose,mfin,mpay,mpfr,mbtfr ;
   static double wbod,wtfr,wnose,wpar,wfin,wpay,wpfr,wbtfr,weng,wfuel ;
   static double wbal,wbald,wmax,wmin ;
   static double sabod,satfr,sanose,sapay,sapfr,safin,sabtfr,satot;
   static double pabod,patfr,panose,papay,papfr,pafin,pabtfr,patot;
   static double cabod,canose,capay,catot,carec,caexit,cabexit ;
   static double vbod,vtfr,vnose,vpay,vpfr;
   static double dbod,dtfr,dnose,dfin,dpay,dpfr,dbtfr ;
   static double cgbod,cgtfr,cgnose,cgfin,cgpay,cgpfr,cgbtfr,cgeng,cgfuel ;
   static double cpbod,cptfr,cpnose,cpfin,cppay,cppfr,cpbtfr ;
   static double wobj,wobjd,wobmin,wobmax ;
               // ballistic 
   static double wtd, wtmax,wtmin,cdmin,cdmax,catd,camin,camax ;
   static double vmuzl,vmuzld,vmmax,vmmin ;
               // stomp launcher
   static double sv1,sv1d,sv1min,sv1max,sv2,sv2d,sv2min,sv2max ;
   static double sl,sld,slmin,slmax ;
   static double lpress,volrat,vstomp,presin ;
   static double lpresd,lpresmax,lpresmin ;
              // solid rocket thrust
   static double th1,th2,tim1,tim2,timd;
   static double th1b1,th2b1,tim1b1,tim2b1 ;
            // engine geometry
   static double elngth,ediam,erad,mediam,merad;
   static double b1elngth,b1ediam,b1erad;
            // booster 1 geometry
   static double b1fw,b1fwd,b1fwmax,b1fleang,b1fteang,b1ftanle,b1ftante;
   static double b1lngth,b1lngd,b1lmax,b1flngth,b1flngd;
   static double wengb1,wfuelb1,sab1,pab1,cgb1,cpb1;
   static double wfinb1,safb1,pafb1,cgfb1,cpfb1;
              // bottle rocket thrust
   static double wat,watd,watmin,watmax,fpres,fpresd,fpresmin,fpresmax ;
   static double nozdiam,nozdiamd,nozdmin,nozdmax ;
   static double nozrad,noza,hwat,watrad,volbot ;
   static double ltub,ltubd,ltubmin,ltubmax ;
   static double volair,instair,instwat,instpres,mdot,uexit,lothrust ;
               // flight
   int fire,comp,npt,nsav,nburn,cockflg,cockcal,stepon,step,presopt;
   static int[] npts = new int[5];
   static double weight,drag,thrust,wtflt ;
   static double cg,cp,cd,cdrec ;
   static double g0,q0,ps0,pt0,ts0,rho,rlhum,temf,gama,wtrat,rgas ;
   static double alt,altd,altmax,altmin ;
   static double wind,windd,wndmax,wndmin ;
   static double lnchang,langmax,langmin;
   static double rail,raild,railmin,railmax ;
   static double llaunch,timrail ;
   static double deltim,fltim,vacc,vvel,vloc,hacc,hvel,hloc,spd ;
   static double vmax,hmax,spdmax ;
   static double[][] posx = new double[10][5000] ;
   static double[][] posy = new double[10][5000] ;
   static double[] posa = new double [5000] ;
   static double posb1 ;
       /*  plot & probe data */
   static double fact,facmin,facrat;
   static double facts,facto,factc;
   static int xt,yt,sldloc,viewflg,gridon,lnchgrf,trakon,ldisplay;
   static int xts,yts,slds;
   static int xto,yto,sldo;
   static int xtc,ytc,sldc;


   static double cdNose,cdBody,cdFins;

   Solver solve ;
   View view ;
   Act act ;
   CardLayout layin,layen1,layen2 ;
   Image offImg ;
   Graphics offsGg ;

   public void init() {
     solve = new Solver() ;

     offImg = createImage(this.size().width,
                      this.size().height) ;
     offsGg = offImg.getGraphics() ;

     setLayout(new GridLayout(1,2,5,5)) ;

     view = new View(this) ;
     act = new Act(this) ;

     add(view) ;
     add(act) ;

     solve.setDefaults () ;
     loadInput() ;

     solve.comPute () ;

     view.start() ;
  }
 
  public Insets insets() {
     return new Insets(5,5,5,5) ;
  }

  public int filter0(double inumbr) {
        //  output only to .
       int number ;
       int intermed ;
 
       number = (int) (inumbr);
       return number ;
  }

  public float filter1(double inumbr) {
     //  output only to .1
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 10.) ;
       number = (float) (intermed / 10. );
       return number ;
  }
 
  public float filter3(double inumbr) {
     //  output only to .001
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 1000.) ;
       number = (float) (intermed / 1000. );
       return number ;
  }
 
  public float filter5(double inumbr) {
     //  output only to .00001
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 100000.) ;
       number = (float) (intermed / 100000. );
       return number ;
  }

  public void setDesignView() {   // initial design view
       viewflg = 0 ;
       lnchgrf = 0 ;
       fact = facto = 20.25;
       if (rktype == 2) fact = facto = 12.0;
       facmin = .25 ;
       facrat = .20 ;
       xt = xto = 140; 
       yt = yto = 370 ;
       if (rktype == 2) yt = yto = 320 ;
       sldloc = sldo = 250;
       if (rktype == 2) sldloc = sldo = 290;
  }
 
  public void restDesignView() {   // restore design view
       viewflg = 0 ;
       lnchgrf = 0 ;
       fact = facto ;
       facmin = .25 ;
       facrat = .20 ;
       xt = xto ; 
       yt = yto ;
       sldloc = sldo ;
  }
 
  public void setRangeView() {   // initial range view
       viewflg = 1 ;
       facts = fact = 2.01;
       facmin = .01 ;
       facrat = .02 ;
       xts = xt = 160; 
       yts = yt =370 ;
       slds = sldloc= 250;
  }
 
  public void restRangeView() {   // restore range view
       viewflg = 1 ;
       fact = facts ;
       facmin = .01 ;
       facrat = .02 ;
       xt = xts ; 
       yt = yts ;
       sldloc = slds ;
  }
 
  public void setGraphView() {   // initial graph view
       viewflg = 2 ;
       factc = fact = 1.25;
       facmin = .01 ;
       facrat = .02 ;
       xtc = xt = 100; 
       ytc = yt = 40 ;
       sldc = sldloc= 288;
  }
 
  public void restGraphView() {   // restore graph view
       viewflg = 2 ;
       fact = factc ;
       facmin = .01 ;
       facrat = .02 ;
       xt = xtc ; 
       yt = ytc ;
       sldloc = sldc ;
  }
 
  public void loadBallistic() {   // load Ballistic info
    // ballisitic shell
       rktype = 10 ;
       fire = 0 ;
       comp = 0 ;
       tim1 = .2 ;
       weng = 0.0;
       wfuel = 0.0 ;
       nstage = 1; 
       cg = 0.0 ;
       cp = 0.0 ;
       balob = 0 ;
       weight = 2.0 ;
       wtd = weight * fconv;
       wtmin = 0.1 * fconv ;  wtmax = 100 * fconv ;
       cd = .7 ;
       cdmin = 0.0 ;  cdmax = 2.0 ;
       catot = 1.0 ;
       catd = catot * aconv ;
       camin = 0.0 ;  camax = 10.0 * aconv ;
       vmuzl = 100. ; 
       vmuzld = vmuzl * lconv1 ; 
       vmmin = 0.0 ;  vmmax = 400. * lconv1 ;
  }

  public void loadStomp() {   // load Stomp info
       rktype = 1 ;
       part = 3;
   // nose
       ntype = 0 ;
       nlngth = 3.0 ;
       nlngd = nlngth * lconv2 ; ;
       nlmin = .05 * lconv2;  nlmax = 10. * lconv2 ;
       ndiam = 1.0 ;
       ndiamd = ndiam * lconv2 ;
       ndmin = .1 * lconv2;  ndmax = 5. * lconv2 ;
       nrad = .5 * ndiam ;
       mnose = 1; dnose = .074; 
       act.inp.nose.getGeom() ;
   // recovery 
       rtype = 0 ;
       wbald = wbal = 0.0 ;
       wmin = 0.0;  wmax = 50. * fconv ;
       wpar = 0.0 ;

   // payload tube
       plngd = plngth = 0.0 ;
       plmin = 0.0;  plmax = 36.* lconv2 ;
       pdiam = 1.0 ;
       pdiamd = pdiam * lconv2;
       pdmin = .1 * lconv2;  pdmax = 5. * lconv2 ;
       prad = .5 * pdiam ;
       mpay = 1; dpay = .0078; 
   // solid payload fairing 
       qlngd = qlngth = 0.0 ;
       qlmin = 0.0;  qlmax = 2. * lconv2 ;
       mpfr = 1; dpfr = .074; 
       act.inp.payl.getGeom() ;
   // payload weight
       objtyp = 0 ;
       act.inp.payl.rt.objch.select(0) ;
       wobjd = wobj = 0.0 ;
       wobmin = 0.0 ; wobmax = 80.0 * fconv ;

   // body tube
       blngth = 8.0 ;
       blngd = blngth * lconv2 ;
       blmin = 1.0 * lconv2 ;  blmax = 72. * lconv2  ;
       bdiam = 1.0 ;
       bdiamd = bdiam * lconv2  ;
       bdmin = .1 * lconv2 ;  bdmax = 5. * lconv2  ;
       brad = .5 * bdiam ;
       mbod = 1; dbod = .0078; 
   //  tail fairing 
       tlngd = tlngth = 0.0 ;
       tlmin = 0.0;  tlmax = 2. * lconv2 ;
       tdiam = 1.0 ;
       tdiamd = tdiam * lconv2 ;
       tdmin = .1 * lconv2;  tdmax = 1. * lconv2 ;
       trad = .5 * tdiam ;
       mtfr = 1; dtfr = .0075; 
       act.inp.body.getGeom() ;

   // fins
       numfin = 3 ;
       fintype = 0 ;
       flngth = 1.5 ;
       flngd = flngth * lconv2 ;
       flmin = .5 * lconv2;  flmax = 5. * lconv2 ;
       fleang = 45.0 ;
       flemin = 0.0 ; flemax = 85.0 ;  
       ftanle = Math.tan(convdr*fleang) ;
       fteang = 30.0 ;
       ftemin = - 30.0 ; ftemax = 60. ;  
       ftante = Math.tan(convdr*fteang) ;
       fwidth = 1.0  ;
       fwid = fwidth * lconv2;
       fwmin = .5 * lconv2;  
       fwex = 5.0 ;
       fwmax = (flngth * lconv2) / (ftanle - ftante) ;
       if (fwmax >= (fwex * lconv2)) fwmax = fwex * lconv2 ;
       flocd = floc = 0.0 ;
       flcmin = - .5 * flngth * lconv2;  flcmax = (blngth - flngth) * lconv2 ;
       mfin = 1; dfin = .0046; 
       act.inp.fins.getGeom() ;

    // stomp launcher
       sv1 = 8.0 ;
       sv1d = sv1 * vconv ;
       sv1min = 1.1 * vconv;  sv1max = 125. * vconv ;
       sv2 = 1.0 ;
       sv2d = sv2 * vconv ;
       sv2min = .1 * vconv;  sv2max = 50. * vconv ;
       sl = 2.0 ;
       sld = sl * lconv2;
       slmin = .5 * lconv2 ;   slmax = 4.0 * lconv2  ;
       llaunch = sl / 12.0 ;
       lpress = 37.8 ;
       lpresd = lpress * pconv ;
       lpresmin = ps0 * pconv; lpresmax = 500.0 * pconv ;
       act.inp.engs.getVexit() ;

       cd = .7 ;
       cdmin = 0.0 ;  cdmax = 2.0 ;
       weng = 0.0 ; 
       wfuel = 0.0 ;
       tim1 = .2 ;
       nstage = 1;
       mediam = ediam = .25; 
       merad = erad = .5 * ediam;
       elngth = 0.0; 
       cgeng = cgfuel = .5 * elngth ;
       act.inp.enge.fixBodyGeom() ;
  }

  public void loadBottle() {   // load Bottle info
       rktype = 2 ;
       part = 3;
       tim1 = .2 ;
       bdiam = 4.0 ;
       bdiamd = bdiam * lconv2 ;
       brad  = 2.0 ;
       blngth = 12.0 ;
       blngd = blngth * lconv2 ;
       wbod = 1.665 ;
       cgbod = 6.25 ;
       cpbod = 6.25 ;
       pabod = 39.75 ;
       cabod = 12.56 ;
       volbot = 115. ;
       act.inp.boti.lt.but2.setBackground(Color.yellow) ;
       act.inp.boti.lt.but2.setForeground(Color.black) ;
       act.inp.boti.lt.but20.setBackground(Color.blue) ;
       act.inp.boti.lt.but20.setForeground(Color.white) ;
       act.inp.boti.lt.but24.setBackground(Color.blue) ;
       act.inp.boti.lt.but24.setForeground(Color.white) ;
   // nose
       ntype = 0 ;
       nlngth = 3.0 ;
       nlngd = nlngth * lconv2 ; ;
       nlmin = .05 * lconv2;  nlmax = 10. * lconv2 ;
       ndiam = 4.0 ;
       ndiamd = ndiam * lconv2 ;
       ndmin = .1 * lconv2;  ndmax = 5. * lconv2 ;
       nrad = .5 * ndiam ;
       mnose = 1; dnose = .074; 
       act.inp.nose.getGeom() ;
   // recovery 
       rtype = 0 ;
       wbald = wbal = 0.0 ;
       wmin = 0.0;  wmax = 80. * fconv ;
       wpar = 0.0 ;

   // payload weight
       objtyp = 0 ;
       act.inp.payl.rt.objch.select(0) ;
       wobjd = wobj = 0.0 ;
       wobmin = 0.0 ; wobmax = 80.0 * fconv ;
   // payload tube
       plngd = plngth = 0.0 ;
       plmin = 0.0;  plmax = 100.* lconv2 ;
       pdiam = 4.0 ;
       pdiamd = pdiam * lconv2;
       pdmin = .1 * lconv2;  pdmax = 5. * lconv2 ;
       prad = .5 * pdiam ;
       mpay = 1; dpay = .0078; 
   // solid payload fairing 
       qlngd = qlngth = 0.0 ;
       qlmin = 0.0;  qlmax = 2. * lconv2 ;
       mpfr = 1; dpfr = .074; 
       act.inp.payl.getGeom() ;

   // fins
       numfin = 3 ;
       fintype = 0 ;
       flngth = 5.0 ;
       flngd = flngth * lconv2 ;
       flmin = .5 * lconv2;  flmax = 10. * lconv2 ;
       fleang = 45.0 ;
       flemin = 0.0 ; flemax = 85.0 ;  
       ftanle = Math.tan(convdr*fleang) ;
       fteang = 30.0 ;
       ftemin = - 30.0 ; ftemax = 60. ;  
       ftante = Math.tan(convdr*fteang) ;
       fwidth = 5.0  ;
       fwid = fwidth * lconv2;
       fwex = 10.0 ;
       fwmin = .5 * lconv2;  
       fwmax = (flngth * lconv2) / (ftanle - ftante) ;
       if (fwmax >= (fwex * lconv2)) fwmax = fwex * lconv2 ;
       floc = -2.5 ;
       flocd = floc *lconv2 ;
       flcmin = - .5 * flngth * lconv2;  flcmax = (blngth - flngth) * lconv2 ;
       mfin = 1; dfin = .0046; 
       act.inp.fins.getGeom() ;

   // bottle tail fairing 
       btfair = 1 ;
       btlngth = 4.0 ;
       btlngd = btlngth * lconv2 ;
       btlmin = 4.0 * lconv2;  btlmax = 8.0 * lconv2 ;
       btdiam = 1.0 ;
       btdiamd = btdiam * lconv2 ;
       btdmin = 1.0 * lconv2;  btdmax = 4. * lconv2 ;
       btrad = .5 * btdiam ;
       mbtfr = 1; dbtfr = .0075; 
       act.inp.boti.getGeom() ;

    // bottle launcher
       ltub = 2.0 ;
       ltubd = ltub * lconv2 ;
       ltubmin = 0.0;  ltubmax = 8. * lconv2 ;
       nozdiam = .385 ;
       nozdiamd = nozdiam * lconv2 ;
       nozdmin = .125 * lconv2;  nozdmax = .875 * lconv2 ;
       nozrad = .5 * nozdiam ;
       noza = pi * nozrad * nozrad ;
       watd = wat = 0.0 ;
       watmin = 0.0 ;  watmax = volbot * vconv ;
       fpres = 28.0 ;
       fpresd = fpres * pconv ;
       fpresmin = ps0 * pconv;  fpresmax = 200.0 * pconv ;
       timd = 20.;
       act.inp.engb.getGeom() ;

       cd = .7 ;
       cdmin = 0.0 ;  cdmax = 2.0 ;
       weng = 0.0 ;
       wfuel = 0.0 ;
       nburn = 0 ;
       nstage = 1 ; numeng = 1 ; nclust = 0 ;
  }

  public void loadModel() {   // load Model rocket info
       rktype = 3 ;
       part = 3 ;
   // nose
       ntype = 0 ;
       nlngth = 3.0 ;
       nlngd = nlngth * lconv2 ; ;
       nlmin = .05 * lconv2;  nlmax = 10. * lconv2 ;
       ndiam = 1.0 ;
       ndiamd = ndiam * lconv2 ;
       ndmin = .1 * lconv2;  ndmax = 5. * lconv2 ;
       nrad = .5 * ndiam ;
       mnose = 1; dnose = .074; 
       act.inp.nose.getGeom() ;
   // recovery 
       rtype = 0 ;
       wbal = 0.5 ;
       wbald = wbal * fconv ;
       wmin = 0.0;  wmax = 50. * fconv ;
       act.inp.nose.rt.rcho.select(1) ;
       wpar = .1 ; 
       cdrec = 1.7 ;
       carec = 144.0 ;

   // payload weight
       objtyp = 0 ;
       act.inp.payl.rt.objch.select(0) ;
       wobjd = wobj = 0.0 ;
       wobmin = 0.0 ; wobmax = 80.0 * fconv ;
   // payload tube
       plngd = plngth = 0.0 ;
       plmin = 0.0;  plmax = 36.* lconv2 ;
       pdiam = 1.0 ;
       pdiamd = pdiam * lconv2;
       pdmin = .1 * lconv2;  pdmax = 5. * lconv2 ;
       prad = .5 * pdiam ;
       mpay = 1; dpay = .0078; 
   // solid payload fairing 
       qlngd = qlngth = 0.0 ;
       qlmin = 0.0;  qlmax = 2. * lconv2 ;
       mpfr = 1; dpfr = .074; 
       act.inp.payl.getGeom() ;

   // body tube
       blngth = 8.0 ;
       blngd = blngth * lconv2 ;
       blmin = 1.0 * lconv2 ;  blmax = 72. * lconv2  ;
       bdiam = 1.0 ;
       bdiamd = bdiam * lconv2  ;
       bdmin = .1 * lconv2 ;  bdmax = 5. * lconv2  ;
       brad = .5 * bdiam ;
       mbod = 1; dbod = .0078; 
   //  tail fairing 
       tlngd = tlngth = 0.0 ;
       tlmin = 0.0;  tlmax = 2. * lconv2 ;
       tdiam = 1.0 ;
       tdiamd = tdiam * lconv2 ;
       tdmin = .1 * lconv2;  tdmax = 1. * lconv2 ;
       trad = .5 * tdiam ;
       mtfr = 1; dtfr = .0075; 
       act.inp.body.getGeom() ;

   // fins
       numfin = 3 ;
       fintype = 0 ;
       flngth = 1.5 ;
       flngd = flngth * lconv2 ;
       flmin = .5 * lconv2;  flmax = 5. * lconv2 ;
       fleang = 45.0 ;
       flemin = 0.0 ; flemax = 85.0 ;  
       ftanle = Math.tan(convdr*fleang) ;
       fteang = 30.0 ;
       ftemin = - 30.0 ; ftemax = 60. ;  
       ftante = Math.tan(convdr*fteang) ;
       fwidth = 1.0  ;
       fwid = fwidth * lconv2;
       fwex = 5.0 ;
       fwmin = .5 * lconv2;  
       fwmax = (flngth * lconv2) / (ftanle - ftante) ;
       if (fwmax >= (fwex * lconv2)) fwmax = fwex * lconv2 ;
       flocd = floc = 0.0 ;
       flcmin = - .5 * flngth * lconv2;  flcmax = (blngth - flngth) * lconv2 ;
       mfin = 1; dfin = .0046; 
       act.inp.fins.getGeom() ;

    //  solid engine
       nstage = 1 ; numeng = 1 ; nclust = 0 ;
       mediam = ediam = .75; 
       merad = erad = .5 * ediam;
       elngth = 2.75; 
       cgeng = cgfuel = .5 * elngth ;
       weng = 0.354 ; 
       wfuel = 0.116 ; 
       th1 = 2.25; tim1 = .25; th2 = 0.0; tim2 = .26; timd = 3.25;
       th1b1 = 2.25; tim1b1 = .25; th2b1 = 0.0; tim2b1 = .26;
       b1ediam = .75 ; b1elngth = 2.75 ; 
       wengb1 = .354 ; wfuelb1 = .116 ;
       act.inp.enge.getModThrst() ;

    // booster engine
       b1flngth = 2.75 ;
       b1flngd = b1flngth * lconv2 ;
       b1fleang = 30.0 ;
       b1lngth = 2.75 ;
       b1lngd = b1lngth * lconv2 ;
       b1lmax = 5.0 * lconv2 ;
       b1fw = 1.0 ;
       b1fwd = b1fw * lconv2;
       b1fwmax = 5.* lconv2 ;
       b1fteang = 0.0 ;
       act.inp.enge.fixBodyGeom() ;

       nburn = 0 ;
       act.inp.enge.up.eng2.select(1) ;
       act.inp.enge.up.engch.select(0) ;
  }

  public void loadInput() {   // load the input panels
       String outden2,outden3,outlng,outfor ;
       int i1,i2,i3,i4,i5,i6 ;
       double v1,v2,v3,v4,v5,v6 ;
       float fl1,fl2,fl3,fl4,fl5,fl6 ;

       outden2 = " oz/in2" ;
       if (lunits == 1) outden2 = " g/cs" ;
       outden3 = " oz/in3" ;
       if (lunits == 1) outden3 = " g/cc" ;
       outlng = " in" ;
       if (lunits == 1) outlng = " cm" ;
       outfor = " oz" ;
       if (lunits == 1) outfor = " g" ;

     // body tube
       v1 = blngd ;
       vmn1 = blmin;  vmx1 = blmax ;
       v2 = bdiamd ;
       vmn2 = bdmin;  vmx2 = bdmax ;

       act.inp.body.lt.f1.setText(String.valueOf(filter3(blngd))) ;
       act.inp.body.lt.f2.setText(String.valueOf(filter3(bdiamd))) ;
       act.inp.body.lt.di.setText(String.valueOf(filter3(dbod * dconv2)) + outden2) ;
       if (mbod == 0) {
         act.inp.body.lt.di.setText(String.valueOf(filter3(dbod * dconv2))) ;
       }

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;

       act.inp.body.rt.s1.setValue(i1) ;
       act.inp.body.rt.s2.setValue(i2) ;

    //tail fairing
       v3 = tlngd ;
       vmn3 = tlmin;  vmx3 = tlmax ;
       v4 = tdiamd ;
       vmn4 = tdmin;  vmx4 = tdmax ;
       v5 = cd ;
       vmn5 = cdmin; vmx5 = cdmax ;

       act.inp.body.lt.f3.setText(String.valueOf(filter3(tlngd))) ;
       act.inp.body.lt.f4.setText(String.valueOf(filter3(tdiamd))) ;
       act.inp.body.lt.f5.setText(String.valueOf(filter3(cd))) ;
       act.inp.body.lt.dt.setText(String.valueOf(filter3(dtfr * dconv2)) + outden2) ;
       if (mtfr == 0) {
         act.inp.body.lt.dt.setText(String.valueOf(filter3(dtfr * dconv2))) ;
       }

       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
       i5 = (int) (((v5 - vmn5)/(vmx5-vmn5))*1000.) ;

       act.inp.body.rt.s3.setValue(i3) ;
       act.inp.body.rt.s4.setValue(i4) ;
       act.inp.body.rt.s5.setValue(i5) ;

    //bottle fairing
       v3 = btlngd ;
       vmn3 = btlmin;  vmx3 = btlmax ;
       v4 = btdiamd ;
       vmn4 = btdmin;  vmx4 = btdmax ;
       v5 = cd ;
       vmn5 = cdmin; vmx5 = cdmax ;

       act.inp.boti.lt.f3.setText(String.valueOf(filter3(btlngd))) ;
       act.inp.boti.lt.f4.setText(String.valueOf(filter3(btdiamd))) ;
       act.inp.boti.lt.f5.setText(String.valueOf(filter3(cd))) ;
       act.inp.boti.lt.dt.setText(String.valueOf(filter3(dbtfr * dconv2)) + outden2) ;
       if (mbtfr == 0) {
         act.inp.boti.lt.dt.setText(String.valueOf(filter3(dbtfr * dconv2))) ;
       }
       act.inp.boti.rt.faircho.select(btfair) ;

       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
       i5 = (int) (((v5 - vmn5)/(vmx5-vmn5))*1000.) ;

       act.inp.boti.rt.s3.setValue(i3) ;
       act.inp.boti.rt.s4.setValue(i4) ;
       act.inp.boti.rt.s5.setValue(i5) ;

     // payload tube
       v1 = plngd ;
       vmn1 = plmin;  vmx1 = plmax ;
       v2 = pdiamd ;
       vmn2 = pdmin;  vmx2 = pdmax ;
       v4 = wobjd ;
       vmn4 = wobmin;  vmx4 = wobmax ;

       act.inp.payl.lt.f1.setText(String.valueOf(filter3(plngd))) ;
       act.inp.payl.lt.f2.setText(String.valueOf(filter3(pdiamd))) ;
       act.inp.payl.lt.f4.setText(String.valueOf(filter3(wobjd))) ;
       act.inp.payl.lt.di.setText(String.valueOf(filter3(dpay * dconv2)) + outden2) ;
       if (mpay == 0) {
          act.inp.payl.lt.di.setText(String.valueOf(filter3(dpay * dconv2))) ;
       }

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;

       act.inp.payl.rt.s1.setValue(i1) ;
       act.inp.payl.rt.s2.setValue(i2) ;
       act.inp.payl.rt.s4.setValue(i4) ;

    // payload fairing
       v3 = qlngd ;
       vmn3 = qlmin;  vmx3 = qlmax ;

       act.inp.payl.lt.f3.setText(String.valueOf(filter3(qlngd))) ;
       if (mpfr == 0) {
          act.inp.payl.lt.dt.setText(String.valueOf(filter3(dpfr * dconv3))) ;
       }
       if (mpfr > 0 && mpfr < 3) {
          act.inp.payl.lt.dt.setText(String.valueOf(filter3(dpfr * dconv3)) + outden3) ;
       }
       if (mpfr == 3) {
          act.inp.payl.lt.dt.setText(String.valueOf(filter3(dpfr * dconv2))) ;
       }
       if (mpfr > 3) {
          act.inp.payl.lt.dt.setText(String.valueOf(filter3(dpfr * dconv2)) + outden2) ;
       }

       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;

       act.inp.payl.rt.s3.setValue(i3) ;

     // nose
       v1 = nlngd ;
       vmn1 = nlmin;  vmx1 = nlmax ;
       v2 = ndiamd ;
       vmn2 = ndmin;  vmx2 = ndmax ;
       v3 = wbald ;
       vmn3 = wmin;  vmx3 = wmax ;

       act.inp.nose.lt.f1.setText(String.valueOf(filter3(nlngd))) ;
       act.inp.nose.lt.f2.setText(String.valueOf(filter3(ndiamd))) ;
       act.inp.nose.lt.f3.setText(String.valueOf(filter3(wbald))) ;
       if (mnose == 0) {
         act.inp.nose.lt.di.setText(String.valueOf(filter3(dnose * dconv3))) ;
       }
       if (mnose > 0 && mnose < 5) {
         act.inp.nose.lt.di.setText(String.valueOf(filter3(dnose * dconv3)) + outden3) ;
       }
       if (mnose == 5) {
         act.inp.nose.lt.di.setText(String.valueOf(filter3(dnose * dconv2))) ;
       }
       if (mnose > 5) {
         act.inp.nose.lt.di.setText(String.valueOf(filter3(dnose * dconv2)) + outden2) ;
       }

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;

       act.inp.nose.rt.s1.setValue(i1) ;
       act.inp.nose.rt.s2.setValue(i2) ;
       act.inp.nose.rt.s3.setValue(i3) ;
       act.inp.nose.rt.ncho.select(ntype) ;

     // fins
       v1 = flngd ;
       vmn1 = flmin;  vmx1 = flmax ;
       v2 = fwid ;
       vmn2 = fwmin;  vmx2 = fwmax ;
       v3 = fleang ;
       vmn3 = flemin; vmx3 = flemax ;
       v4 = fteang ;
       vmn4 = ftemin; vmx4 = ftemax ;
       v5 = flocd ;
       vmn5 = flcmin; vmx5 = flcmax ;

       act.inp.fins.lt.f1.setText(String.valueOf(filter3(flngd))) ;
       act.inp.fins.lt.f2.setText(String.valueOf(filter3(fwid))) ;
       act.inp.fins.lt.f3.setText(String.valueOf(filter0(fleang))) ;
       act.inp.fins.lt.f4.setText(String.valueOf(filter0(fteang))) ;
       act.inp.fins.lt.f5.setText(String.valueOf(filter3(flocd))) ;
       act.inp.fins.lt.f6.setText(String.valueOf(numfin)) ;
       act.inp.fins.lt.di.setText(String.valueOf(filter3(dfin* dconv2)) + outden2) ;
       if (mfin == 0) {
          act.inp.fins.lt.di.setText(String.valueOf(filter3(dfin* dconv2))) ;
       }

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
       i5 = (int) (((v5 - vmn5)/(vmx5-vmn5))*1000.) ;

       act.inp.fins.rt.s1.setValue(i1) ;
       act.inp.fins.rt.s2.setValue(i2) ;
       act.inp.fins.rt.s3.setValue(i3) ;
       act.inp.fins.rt.s4.setValue(i4) ;
       act.inp.fins.rt.s5.setValue(i5) ;
       act.inp.fins.rt.fcho.select(fintype) ;

     // ballisitic shell
       v1 = wtd ;
       vmn1 = wtmin; vmx1 = wtmax ;
       v2 = cd ;
       vmn2 = cdmin; vmx2 = cdmax ;
       v3 = catd ;
       vmn3 = camin; vmx3 = camax ;
       v4 = vmuzld ;
       vmn4 = vmmin; vmx4 = vmmax ;

       act.inp.bali.lt.f1.setText(String.valueOf(filter3(wtd))) ;
       act.inp.bali.lt.f2.setText(String.valueOf(filter3(cd))) ;
       act.inp.bali.lt.f3.setText(String.valueOf(filter3(catd))) ;
       act.inp.bali.lt.f4.setText(String.valueOf(filter3(vmuzld))) ;
       act.inp.bali.rt.obch.select(balob) ;

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;

       act.inp.bali.rt.s1.setValue(i1) ;
       act.inp.bali.rt.s2.setValue(i2) ;
       act.inp.bali.rt.s3.setValue(i3) ;
       act.inp.bali.rt.s4.setValue(i4) ;

     // solid propulsion
       act.inp.enge.up.o1.setText(String.valueOf(filter3(ediam * lconv2)) + outlng) ;
       act.inp.enge.up.o2.setText(String.valueOf(filter3(16.0*th1*fconv)) + outfor) ;
       act.inp.enge.up.o3.setText(String.valueOf(filter3(weng*fconv)) + outfor) ;
       act.inp.enge.up.o4.setText(String.valueOf(filter3(wfuel*fconv)) + outfor) ;
       act.inp.enge.m.s.o1.setText(String.valueOf(filter3(b1flngd))) ;
       act.inp.enge.m.s.o2.setText(String.valueOf(filter3(b1fleang))) ;
       act.inp.enge.m.s.o3.setText(String.valueOf(filter3(b1lngd))) ;
       act.inp.enge.m.s.o4.setText(String.valueOf(filter3(b1fwd))) ;
       act.inp.enge.m.s.o5.setText(String.valueOf(filter3(b1fteang))) ;
       act.inp.enge.m.c.o2.setText(String.valueOf(filter3(mediam * lconv2)) + outlng) ;

     // stomp launcher
// *** test for longer launch tube ***
       if (blngd > slmax) slmax = blngd ;
       v1 = sv1d ;
       vmn1 = sv1min;  vmx1 = sv1max ;
       v2 = sv2d ;
       vmn2 = sv2min;  vmx2 = sv2max ;
       v3 = sld ;
       vmn3 = slmin; vmx3 = slmax ;

       act.inp.engs.getVexit() ;

       act.inp.engs.lt.f1.setText(String.valueOf(filter3(sv1d))) ;
       act.inp.engs.lt.f2.setText(String.valueOf(filter3(sv2d))) ;
       act.inp.engs.lt.f3.setText(String.valueOf(filter3(sld))) ;

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;

       act.inp.engs.rt.s1.setValue(i1) ;
       act.inp.engs.rt.s2.setValue(i2) ;
       act.inp.engs.rt.s3.setValue(i3) ;

     // bottle launcher
       v1 = watd ;
       vmn1 = watmin;  vmx1 = watmax ;
       v2 = fpresd ;
       vmn2 = fpresmin;  vmx2 = fpresmax ;
       v3 = nozdiamd ;
       vmn3 = nozdmin; vmx3 = nozdmax ;
       v4 = ltubd ;
       vmn4 = ltubmin; vmx4 = ltubmax ;

       if (fpresd < fpresmin) fpresd = fpresmin ;

       act.inp.engb.lt.f1.setText(String.valueOf(filter3(watd))) ;
       act.inp.engb.lt.f2.setText(String.valueOf(filter3(fpresd))) ;
       act.inp.engb.lt.f3.setText(String.valueOf(filter3(nozdiamd))) ;
       act.inp.engb.lt.f4.setText(String.valueOf(filter3(ltubd))) ;

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;

       act.inp.engb.rt.s1.setValue(i1) ;
       act.inp.engb.rt.s2.setValue(i2) ;
       act.inp.engb.rt.s3.setValue(i3) ;
       act.inp.engb.rt.s4.setValue(i4) ;

     // range
       v1 = lnchang ;
       vmn1 = langmin;  vmx1 = langmax ;
       v2 = windd ;
       vmn2 = wndmin;  vmx2 = wndmax ;
       v3 = raild ;
       vmn3 = railmin;  vmx3 = railmax ;
       v4 = altd ;
       vmn4 = altmin;  vmx4 = altmax ;

       act.inp.rang.lt.f1.setText(String.valueOf(filter3(lnchang))) ;
       act.inp.rang.lt.f2.setText(String.valueOf(filter3(windd))) ;
       act.inp.rang.lt.f3.setText(String.valueOf(filter3(raild))) ;
       act.inp.rang.lt.f4.setText(String.valueOf(filter0(altd))) ;

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;

       act.inp.rang.rt.s1.setValue(i1) ;
       act.inp.rang.rt.s2.setValue(i2) ;
       act.inp.rang.rt.s3.setValue(i3) ;
       act.inp.rang.rt.s4.setValue(i4) ;

       return ;
  }

  public void loadOut() {   // output routine
     String outfor,outvel,outlng,outhi ;

     outfor = " oz" ;
     if (lunits == 1) outfor = " g" ;
     outlng = " in" ;
     if (lunits == 1) outlng = " cm" ;
     outhi = " ft" ;
     if (lunits == 1) outhi = " m" ;
     outvel = " ft/s" ;
     if (lunits == 1) outvel = " m/s" ;

     act.con.o1.setText(String.valueOf(filter3(wtrat * weight * fconv)) + outfor) ;
     act.con.o2.setText(String.valueOf(filter3(cd))) ;
     act.con.o3.setText(String.valueOf(filter3(cg * lconv2)) + outlng) ;
     act.con.o4.setText(String.valueOf(filter3(cp * lconv2)) + outlng) ;
     
     return ;
  } 
 
  class Solver {
 
     Solver () {
     }

     public void setDefaults() {
 
    // units
       lunits = 0 ;
       dconv2 = 1.0 ;
       dconv3 = 1.0 ;
       lconv1 = 1.0 ;
       lconv2 = 1.0 ;
       aconv = 1.0 ;
       vconv = 1.0 ;
       fconv = 1.0 ;
       pconv = 1.0 ;

       nsav = 0 ;

       planet = 0 ;
       g0 = 32.2 ;
       altd = alt = 0.0 ;
       altmin = 0.0;  altmax = 50000. ;
       ps0 = 14.7 ;
       rgas = 1718. ;
       getFreeStream() ;

       presin = 14.7 ;
       loadStomp() ;

       part = 3 ;
       istab = 1 ;
       ifuel = 0 ;
       ides = 0 ;
       irange = 0 ;
       stepon = 0 ;
       step = 0 ;

    // launch
       windd = wind = 0.0 ;
       wndmin = -20.0 ; wndmax = 20.0 ;
       lnchang = 0.0 ;
       langmin = -60.0 ;  langmax = 60.0 ;
       raild = rail = 3.0 ;
       railmin = 1.0; railmax = 5.0 ;
       cockflg = 0 ;
       presopt = 0 ;

       posa[0] = pid2 ;

       fire = 0 ;
       comp = 0 ;
       vacc = 0.0 ; vvel = 0.0 ; vloc = 0.0 ;
       hacc = 0.0 ; hvel = 0.0 ; hloc = 0.0 ;
       vmax = 0.0 ; hmax = 0.0 ; 
       spd = 0.0 ; spdmax = 0.0 ;

         // graphics
       ldisplay = 0 ;
       setRangeView() ;
       setGraphView() ;
       gridon = 1 ;
       trakon = 1 ;
       setDesignView() ;

       cdNose = 0;
       cdBody = 0;
       cdFins = 0;

       getWtCgCp() ;
       getCd();
       return ;
     }

     public void getWtCgCp() {

       weight = wnose + wbod + wtfr + wbal + wpar + wpay + wpfr + wfin
                + weng + wfuel ;
       patot = panose + pabod + patfr + papay + papfr + pafin ;

       cg = ( (wbod * cgbod) 
            + (weng * (cgeng - tlngth))
            + (wfuel *(cgfuel - tlngth))
            - (wtfr * cgtfr) 
            + ((wbal + wpar) * (blngth + qlngth + plngth))
            + (wpay * (blngth + qlngth + cgpay)) 
            + (wpfr * (blngth + cgpfr))
            + (wfin * (floc + cgfin))
            + (wnose * (blngth + qlngth + plngth + cgnose))
            ) / weight ;
       cp = ( (pabod * cpbod)  
            - (patfr * cptfr) 
            + (papay * (blngth + qlngth + cppay))
            + (papfr * (blngth + cppfr))
            + (pafin * (floc + cpfin))
            + (panose * (blngth + qlngth + plngth + cpnose))
            ) / patot ;

       if (rktype < 2 || rktype > 2) {
          if (cg >= cp) {
             act.con.o3.setForeground(Color.green) ;
             act.con.o4.setForeground(Color.green) ;
             istab = 1 ;
          }
          if (cg < cp) {
             act.con.o3.setForeground(Color.red) ;
             act.con.o4.setForeground(Color.red) ;
             act.con.btm1.setBackground(Color.red) ;
             act.con.btm1.setForeground(Color.white) ;
             istab = 0 ;
          }
       }
 
 // special for 2 stage solid rocket
       if (nstage == 2) {   
          weight = weight + wengb1 + wfuelb1 + wfinb1 ;
          patot = patot + pab1 + pafb1 ;
          cg = ( (wbod * cgbod) 
            + (weng * (cgeng - tlngth))
            + (wfuel *(cgfuel - tlngth))
            - (wtfr * cgtfr) 
            + ((wbal + wpar) * (blngth + qlngth + plngth))
            + (wpay * (blngth + qlngth + cgpay)) 
            + (wpfr * (blngth + cgpfr))
            + (wfin * (floc + cgfin))
            + (wnose * (blngth + qlngth + plngth + cgnose))
            - ((wengb1 + wfuelb1) * (cgb1 + tlngth))
            - (wfinb1 * (cgfb1 + tlngth))
            ) / weight ;
          cp = ( (pabod * cpbod)  
            - (patfr * cptfr) 
            + (papay * (blngth + qlngth + cppay))
            + (papfr * (blngth + cppfr))
            + (pafin * (floc + cpfin))
            + (panose * (blngth + qlngth + plngth + cpnose))
            - (pab1 * (cpb1 + tlngth))
            - (pafb1 * (cpfb1 + tlngth))
            ) / patot ;
          if (cg >= cp) {
             act.con.o3.setForeground(Color.green) ;
             act.con.o4.setForeground(Color.green) ;
             istab = 1 ;
          }
          if (cg < cp) {
             act.con.o3.setForeground(Color.red) ;
             act.con.o4.setForeground(Color.red) ;
             act.con.btm1.setBackground(Color.orange) ;
             act.con.btm1.setForeground(Color.black) ;
             istab = 0 ;
          }
       }

    // special for bottle rocket
       if (rktype == 2) { 
          weight = weight - wtfr ;
          patot = patot - patfr;
          cg = ( (wbod * cgbod) 
            + (weng * cgeng)
            + (wfuel * cgfuel)
            + ((wbal + wpar) * (blngth + qlngth + plngth))
            + (wpay * (blngth + qlngth + cgpay)) 
            + (wpfr * (blngth + cgpfr))
            + (wfin * (floc + cgfin))
            + (wnose * (blngth + qlngth + plngth + cgnose))
            ) / weight ;
          cp = ( (pabod * cpbod)  
            + (papay * (blngth + qlngth + cppay))
            + (papfr * (blngth + cppfr))
            + (pafin * (floc + cpfin))
            + (panose * (blngth + qlngth + plngth + cpnose))
            ) / patot ;

          if (btfair == 1) {
             weight = weight + wbtfr ;
             patot = patot + pabtfr;
             cg = ( (wbod * cgbod) 
               + (weng * cgeng)
               + (wbtfr * (4.0 - cgbtfr))
               + (wfuel * cgfuel)
               + ((wbal + wpar) * (blngth + qlngth + plngth))
               + (wpay * (blngth + qlngth + cgpay)) 
               + (wpfr * (blngth + cgpfr))
               + (wfin * (floc + cgfin))
               + (wnose * (blngth + qlngth + plngth + cgnose))
               ) / weight ;
             cp = ( (pabod * cpbod)  
               + (pabtfr * (4.0 - cpbtfr))
               + (papay * (blngth + qlngth + cppay))
               + (papfr * (blngth + cppfr))
               + (pafin * (floc + cpfin))
               + (panose * (blngth + qlngth + plngth + cpnose))
               ) / patot ;
          }

          if (cg >= cp) {
             act.con.o3.setForeground(Color.green) ;
             act.con.o4.setForeground(Color.green) ;
             istab = 1 ;
          }
          if (cg < cp) {
             act.con.o3.setForeground(Color.red) ;
             act.con.o4.setForeground(Color.red) ;
             act.con.btm1.setBackground(Color.red) ;
             act.con.btm1.setForeground(Color.white) ;
             istab = 0 ;
          }
          if (lothrust > (weight * wtrat)) {
             act.con.o1.setForeground(Color.green) ;
             act.inp.engb.lt.o2.setForeground(Color.green) ;
          }
          if (lothrust <= (weight * wtrat)) {
             act.con.o1.setForeground(Color.red) ;
             act.inp.engb.lt.o2.setForeground(Color.red) ;
             act.con.btm2.setBackground(Color.red) ;
             act.con.btm2.setForeground(Color.white) ;
          }
       }
 
    // special for solid rocket
       if (rktype == 3) { 
          if (nstage == 1) {
             if ((16.0*th1) > (weight * wtrat)) {
                act.con.o1.setForeground(Color.green) ;
                act.inp.enge.up.o2.setForeground(Color.green) ;
             }
             if ((16.0*th1) <= (weight * wtrat)) {
                act.con.o1.setForeground(Color.red) ;
                act.inp.enge.up.o2.setForeground(Color.red) ;
                act.con.btm2.setBackground(Color.red) ;
                act.con.btm2.setForeground(Color.white) ;
             }
          }
          if (nstage == 2) {
             if ((16.0*th1b1) > (weight * wtrat)) {
                act.con.o1.setForeground(Color.green) ;
                act.inp.enge.up.o2.setForeground(Color.green) ;
             }
             if ((16.0*th1b1) <= (weight * wtrat)) {
                act.con.o1.setForeground(Color.red) ;
                act.inp.enge.up.o2.setForeground(Color.red) ;
                act.con.btm2.setBackground(Color.red) ;
                act.con.btm2.setForeground(Color.white) ;
             }
          }
       }
    // cross-sectional area
       catot = cabod ; 
       if ((canose > catot) && (ntype < 4)) catot = canose ;
       if ((capay > catot) && (plngth > .01)) catot = capay ;

       wtflt = weight * wtrat ;

       return ;
     }
 
     public void getFreeStream() {    //  free stream conditions
     double hite,pvap ;       /* MODS  19 Jan 00  whole routine*/

       g0 = 32.2 ;
       rgas = 1718. ;                /* ft2/sec2 R */
       gama = 1.4 ;
       hite = alt ;
       wtrat = 1.0 ;
       if (planet <= 1) {    // Earth  standard day
          // Earth  standard day
          if (hite <= 36152.) {           // Troposphere
             ts0 = 518.6 - 3.56 * hite/1000. ;
             ps0 = 2116. * Math.pow(ts0/518.6,5.256) ;
          }
          if (hite >= 36152. && hite <= 82345.) {   // Stratosphere
             ts0 = 389.98 ;
             ps0 = 2116. * .2236 *
                  Math.exp((36000.-hite)/(53.35*389.98)) ;
          }
       }
       if (planet == 3) {   // Mars - curve fit of orbiter data
         rgas = 1149. ;                /* ft2/sec2 R */
         gama = 1.29 ;
         wtrat = .38 ;

         if (hite <= 22960.) {
            ts0 = 434.02 - .548 * hite/1000. ;
            ps0 = 14.62 * Math.pow(2.71828,-.00003 * hite) ;
         }
         if (hite > 22960.) {
            ts0 = 449.36 - 1.217 * hite/1000. ;
            ps0 = 14.62 * Math.pow(2.71828,-.00003 * hite) ;
         }
       }

       rho = ps0/(rgas * ts0) ;
       if (planet == 1) rho = 0.0 ;   // Earth no drag
       ps0 = ps0 / 144. ;   // psi

       if (planet == 2) {     // Moon
          wtrat = .1667 ;
          gama = 1.4 ;
          ps0 = 0.0 ;
          rho = 0.0 ;
       }
       fpresmin = ps0 * pconv ;
       lpresmin = ps0 * pconv ;

       loadInput() ;

       return ;
     }

     public void getCd()          //logic to find the cd of a model rocket by finding the cd of the nose, body, and fins
          {
          double cdNumberOfFins,cdLengthOfFins,cdWidthOfFins,cdAngleOfLeadingEdge;

          cdNumberOfFins = 0;
          cdLengthOfFins = 0;
          cdWidthOfFins = 0;
          cdAngleOfLeadingEdge = 0;

          if (rktype == 2)
               {
               cdBody = 0.172;
               act.inp.boti.lt.bodyDrag.setText(String.valueOf(cdBody));
               }
          else
               {
               cdBody = 0.566;
               act.inp.body.lt.bodyDrag.setText(String.valueOf(cdBody));
               }
        // fairing
          if (tlngth > 0.0 && trad < brad) {
               cdBody = cdBody * (.4* trad / brad + .6) ;
               act.inp.body.lt.bodyDrag.setText(String.valueOf(filter3(cdBody)));
          }
          if (act.inp.nose.rt.ncho.getSelectedIndex() == 0)
               {
               cdNose = -0.106;
               }
          else if (act.inp.nose.rt.ncho.getSelectedIndex() == 1)
               {
               cdNose = -0.169;
               }
          else if (act.inp.nose.rt.ncho.getSelectedIndex() == 2)
               {
               if (nlngth <= 5.0)
                    {
                    cdNose = -0.079;
                    }
               else
                    {
                    cdNose = -0.13;
                    }
               }
          else if (act.inp.nose.rt.ncho.getSelectedIndex() == 3)
               {
               if (nrad <= 1.25)
                    {
                    cdNose = -0.026;
                    }
               else
                    {
                    cdNose = -0.184;
                    }
               }
          else if (act.inp.nose.rt.ncho.getSelectedIndex() == 4)
               {
               cdNose = 0;
               }

          act.inp.nose.lt.noseDrag.setText(String.valueOf(cdNose));

          if (act.inp.fins.rt.fcho.getSelectedIndex() == 1)
               {
               cdFins = 0.013*(numfin/3.);
               }
          else
               {
               if (numfin == 3)
                    {
                    cdNumberOfFins = 0.356;
                    }
               else if (numfin == 4)
                    {
                    cdNumberOfFins = 0.504;
                    }
               else if (numfin >= 5)
                    {
                    cdNumberOfFins = 0.504 + (numfin * 0.148);
                    }

               if (lunits == 0)
                    {
                    cdLengthOfFins = 0.1194 * flngd - 0.2632;   //linear interpolation from rocket drag data.
                    cdWidthOfFins = -0.0134 * fwid + 0.0165;
                    cdAngleOfLeadingEdge = -0.0092 * fleang + 0.552;
                    }
               else if (lunits == 1)
                    {
                    cdLengthOfFins = 0.0470 * flngd - 0.2632;
                    cdWidthOfFins = -0.005276 * fwid + 0.0165;
                    cdAngleOfLeadingEdge = -0.0092 * fleang + 0.552;
                    }

               cdFins = cdNumberOfFins + cdLengthOfFins + cdWidthOfFins + cdAngleOfLeadingEdge;
               }
          act.inp.fins.lt.finDrag.setText(String.valueOf((float)cdFins));

          cd = cdNose + cdBody + cdFins;
          }

     public void comPute() {
 
       if (rktype <= 9) {
          getWtCgCp() ;
          
          if (act.con.dragSet.getSelectedIndex() == 0)
               {
               getCd();
               }
       }

       loadOut() ;

       return ;
     }
  }

  class Act extends Panel {
     Rocket outerparent ;
     Con con ;
     Inp inp ;

     Act (Rocket target) {

       outerparent = target ;
       setLayout(new GridLayout(2,1,5,5)) ;

       con = new Con(outerparent) ;
       inp = new Inp(outerparent) ;

       add(con) ;
       add(inp) ;
    }

    class Con extends Panel {
       Rocket outerparent ;
       Button btm1,btm2,btm3,btm4 ;
       Button bt1,bt2,bt3,bt4,bt5,bt6,bt7,bt8,bt9, resetButton ;
       Choice untch, dragSet ;
       TextField o1,o2,o3,o4,o5,o6 ;
       TextField diag1,diag2,diag3,diag4 ;
       Label lab1,lab2,lab3,lab4,lab5,lab6,lab7,lab8 ;

       Con (Rocket target) {
          outerparent = target ;
          setLayout(new GridLayout(9,4,5,5)) ;

          ActionListener reset = new ActionListener()
               {
               public void actionPerformed(ActionEvent e)
                    {
                    if (rktype == 10)
                         {
                         loadBallistic();
                         restRangeView();
                         layin.show(inp, "bal");
                         inp.bali.lt.butgo.setBackground(Color.white) ;
                         inp.bali.lt.butgo.setForeground(Color.blue) ;
                         }
                    else if (rktype == 1)
                         {
                         loadStomp();
                         restDesignView();
                         layin.show(inp, "bod");
                         inp.body.lt.butgo.setBackground(Color.white) ;
                         inp.body.lt.butgo.setForeground(Color.blue) ;
                         }
                    else if (rktype == 2)
                         {
                         loadBottle();
                         restDesignView();
                         layin.show(inp, "bot");
                         inp.boti.lt.butgo.setBackground(Color.white) ;
                         inp.boti.lt.butgo.setForeground(Color.blue) ;
                         }
                    else if (rktype == 3)
                         {
                         loadModel();
                         restDesignView();
                         layin.show(inp, "bod");
                         inp.body.lt.butgo.setBackground(Color.white) ;
                         inp.body.lt.butgo.setForeground(Color.blue) ;
                         }

                    dragSet.select(0);
                    untch.select(lunits);

                    btm1.setBackground(Color.yellow) ;
                    btm1.setForeground(Color.black) ;

                    btm2.setBackground(Color.white) ;
                    btm2.setForeground(Color.blue) ;

                    btm3.setBackground(Color.white) ;
                    btm3.setForeground(Color.blue) ;

                    btm4.setBackground(Color.white) ;
                    btm4.setForeground(Color.blue) ;

                    setUnits();
                    loadInput();
                    solve.comPute() ;
                    }
              };

          ItemListener switchDrag = new ItemListener()          //Listener to handle drag choice button
               {
               public void itemStateChanged(ItemEvent e)
                    {
                    String dragChoice;

                    dragChoice = dragSet.getSelectedItem();
                    if (dragChoice.equals("Calculated"))
                         {
                         inp.body.lt.l5.setVisible(false);
                         inp.body.lt.f5.setVisible(false);
                         inp.body.rt.s5.setVisible(false);

                         inp.boti.rt.s5.setVisible(false);
                         inp.boti.lt.l5.setVisible(false);
                         inp.boti.lt.f5.setVisible(false);

                         inp.nose.lt.noseDragLabel.setVisible(true);
                         inp.nose.lt.noseDrag.setVisible(true);
                         inp.body.lt.bodyDragLabel.setVisible(true);
                         inp.body.lt.bodyDrag.setVisible(true);
                         inp.fins.lt.finDragLabel.setVisible(true);
                         inp.fins.lt.finDrag.setVisible(true);
                         inp.boti.lt.bodyDragLabel.setVisible(true);
                         inp.boti.lt.bodyDrag.setVisible(true);
                         }
                    else if (dragChoice.equals("User Input"))
                         {
                         inp.body.lt.l5.setVisible(true);
                         inp.body.lt.f5.setVisible(true);
                         inp.body.rt.s5.setVisible(true);

                         inp.boti.rt.s5.setVisible(true);
                         inp.boti.lt.l5.setVisible(true);
                         inp.boti.lt.f5.setVisible(true);

                         inp.nose.lt.noseDragLabel.setVisible(false);
                         inp.nose.lt.noseDrag.setVisible(false);
                         inp.body.lt.bodyDragLabel.setVisible(false);
                         inp.body.lt.bodyDrag.setVisible(false);
                         inp.fins.lt.finDragLabel.setVisible(false);
                         inp.fins.lt.finDrag.setVisible(false);
                         inp.boti.lt.bodyDragLabel.setVisible(false);
                         inp.boti.lt.bodyDrag.setVisible(false);
                         }
                    }
              };

          lab1 = new Label("RocketModeler", Label.RIGHT) ;
          lab1.setForeground(Color.red) ;
          lab2 = new Label("- III - Vers 1.1b", Label.LEFT) ;
          lab2.setForeground(Color.red) ;
          lab3 = new Label("Mission ",Label.RIGHT) ;
          lab3.setForeground(Color.red) ;
          lab4 = new Label("Control",Label.LEFT) ;
          lab4.setForeground(Color.red) ;
          lab5 = new Label("Press GO",Label.RIGHT) ;
          lab5.setForeground(Color.blue) ;
          lab6 = new Label("for Green",Label.LEFT) ;
          lab6.setForeground(Color.blue) ;
          lab7 = new Label("Select",Label.RIGHT) ;
          lab7.setForeground(Color.blue) ;
          lab8 = new Label("Type",Label.LEFT) ;
          lab8.setForeground(Color.blue) ;

          bt2 = new Button("Ballistic") ;
          bt2.setBackground(Color.blue) ;
          bt2.setForeground(Color.white) ;
 
          bt3 = new Button("Air") ;
          bt3.setBackground(Color.yellow) ;
          bt3.setForeground(Color.black) ;
 
          bt4 = new Button("Water") ;
          bt4.setBackground(Color.blue) ;
          bt4.setForeground(Color.white) ;
 
          bt5 = new Button("Solid") ;
          bt5.setBackground(Color.blue) ;
          bt5.setForeground(Color.white) ;

          dragSet = new Choice();
          dragSet.add("Calculated");
          dragSet.add("User Input");
          dragSet.select(0);
          dragSet.addItemListener(switchDrag);

          untch = new Choice() ;
          untch.setBackground(Color.white) ;
          untch.setForeground(Color.blue) ;
          untch.addItem("English") ;
          untch.addItem("Metric") ;
          untch.select(0) ;
 
          btm1 = new Button("Design") ;
          btm1.setBackground(Color.yellow) ;
          btm1.setForeground(Color.black) ;
 
          btm2 = new Button("Fuel") ;
          btm2.setBackground(Color.white) ;
          btm2.setForeground(Color.blue) ;
 
          btm3 = new Button("Pad") ;
          btm3.setBackground(Color.white) ;
          btm3.setForeground(Color.blue) ;

          btm4 = new Button("Launch") ;
          btm4.setBackground(Color.white) ;
          btm4.setForeground(Color.blue) ;
 
          o1 = new TextField(String.valueOf((float)zero),5) ;
          o1.setBackground(Color.black) ;
          o1.setForeground(Color.green) ;

          o2 = new TextField(String.valueOf((float)zero),5) ;
          o2.setBackground(Color.black) ;
          o2.setForeground(Color.green) ;

          o3 = new TextField(String.valueOf((float)zero),5) ;
          o3.setBackground(Color.black) ;
          o3.setForeground(Color.green) ;

          o4 = new TextField(String.valueOf((float)zero),5) ;
          o4.setBackground(Color.black) ;
          o4.setForeground(Color.green) ;

          o5 = new TextField(String.valueOf((float)zero),5) ;
          o5.setBackground(Color.black) ;
          o5.setForeground(Color.green) ;

          o6 = new TextField(String.valueOf((float)zero),5) ;
          o6.setBackground(Color.black) ;
          o6.setForeground(Color.green) ;

          resetButton = new Button("RESET");
          resetButton.setBackground(Color.red);
          resetButton.setForeground(Color.white);
          resetButton.addActionListener(reset);

          diag1 = new TextField(String.valueOf((float)zero),5) ;
          diag2 = new TextField(String.valueOf((float)zero),5) ;
          diag3 = new TextField(String.valueOf((float)zero),5) ;
          diag4 = new TextField(String.valueOf((float)zero),5) ;

          add(lab3) ;
          add(lab4) ;
          add(lab1) ;
          add(lab2) ;

          add(btm1) ;
          add(btm2) ;
          add(btm3) ;
          add(btm4) ;

          add(new Label(" The  Buttons ", Label.RIGHT)) ;
          add(new Label(" Above  Must ", Label.LEFT)) ;
          add(new Label(" All  Be Green", Label.LEFT)) ;
          add(new Label(" To Launch ", Label.LEFT)) ;

          add(lab7) ;
          add(lab8) ;
          add(new Label(" ", Label.RIGHT)) ;
          add(resetButton) ;

          add(bt2) ;
          add(bt3) ;
          add(bt4) ;
          add(bt5) ;

          add(new Label("LO Weight", Label.RIGHT)) ;
          add(o1) ;
          add(new Label("Cg", Label.RIGHT)) ;
          add(o3) ;

          add(new Label("Cd", Label.RIGHT)) ;
          add(o2) ;
          add(new Label("Cp", Label.RIGHT)) ;
          add(o4) ;
/*
          add(diag1) ;
          add(diag2) ;
          add(diag3) ;
          add(diag4) ;
*/

          add(new Label("Drag Coeff.", Label.RIGHT));
          add(dragSet);
          add(new Label("Units:", Label.RIGHT)) ;
          add(untch) ;

          add(lab5) ;
          add(lab6) ;
          add(new Label(" ", Label.CENTER));
          add(new Label(" ", Label.CENTER));
       }
 
       public boolean action(Event evt, Object arg) {
         if(evt.target instanceof Choice) {
            this.handleCho(evt,arg) ;
            return true ;
         }
         if(evt.target instanceof Button) {
            this.handleBut(evt,arg) ;
            return true ;
         }
         else return false ;
       }
 
       public void handleCho(Event evt, Object obj) {
         String label = (String)obj ;

         if(label.equals("English")) {
            lunits = 0 ;
            setUnits () ;
         }
         if(label.equals("Metric")) {
            lunits = 1 ;
            setUnits () ;
         }

         solve.comPute() ;
       }
 
       public void setUnits() {   // Switching Units
         String outfor,outht,outspd ;
         double alts,altmxs,rals,ralmns,ralmxs,wnds,wndmns,wndmxs ;
         double vmzs,vmzmxs,vmzmns,cats,catmxs,catmns;
         double wtns,wtmns,wtmxs,lprns,lprmns,lprmxs ;
         double blns,blmns,blmxs,bdms,bdmns,bdmxs ;
         double btlns,btlmns,btlmxs,btdms,btdmns,btdmxs ;
         double tlns,tlmns,tlmxs,tdms,tdmns,tdmxs ;
         double plns,plmns,plmxs,pdms,pdmns,pdmxs,qlns,qlmns,qlmxs ;
         double nlns,nlmns,nlmxs,ndms,ndmns,ndmxs ;
         double wbns,wbmns,wbmxs,fpns,fpmns,fpmxs ;
         double flns,flmns,flmxs,fwdms,fwdmns,fwdmxs,flons,flomns,flomxs ;
         double sv1ns,sv1mns,sv1mxs,sv2ns,sv2mns,sv2mxs,slns,slmns,slmxs ;
         double watns,watmns,watmxs,nzdns,nzdmns,nzdmxs,ltns,ltmns,ltmxs ;
         double b1flns,b1flmxs,b1fwdms,b1fwdmxs,b1lns,b1lmxs ;
         double wobjs,wobmxs,wobmns ;
 
         alts = altd / lconv1 ;
         altmxs = altmax / lconv1 ;
         rals = raild / lconv1 ;
         ralmns = railmin / lconv1;
         ralmxs = railmax / lconv1;
         wnds = windd / lconv1 ;
         wndmns = wndmin / lconv1;
         wndmxs = wndmax / lconv1;
         vmzs = vmuzld / lconv1 ;
         vmzmns = vmmin / lconv1;
         vmzmxs = vmmax / lconv1;
         cats = catd / aconv ;
         catmns = camin / aconv;
         catmxs = camax / aconv;
         wtns = wtd / fconv ;
         wtmns = wtmin / fconv;
         wtmxs = wtmax / fconv;
         blns = blngd / lconv2 ;
         blmns = blmin / lconv2;
         blmxs = blmax / lconv2;
         bdms = bdiamd / lconv2 ;
         bdmns = bdmin / lconv2;
         bdmxs = bdmax / lconv2;
         tlns = tlngd / lconv2 ;
         tlmns = tlmin / lconv2;
         tlmxs = tlmax / lconv2;
         tdms = tdiamd / lconv2 ;
         tdmns = tdmin / lconv2;
         tdmxs = tdmax / lconv2;
         plns = plngd / lconv2 ;
         plmns = plmin / lconv2;
         plmxs = plmax / lconv2;
         pdms = pdiamd / lconv2 ;
         pdmns = pdmin / lconv2;
         pdmxs = pdmax / lconv2;
         qlns = qlngd / lconv2 ;
         qlmns = qlmin / lconv2;
         qlmxs = qlmax / lconv2;
         nlns = nlngd / lconv2 ;
         nlmns = nlmin / lconv2;
         nlmxs = nlmax / lconv2;
         ndms = ndiamd / lconv2 ;
         ndmns = ndmin / lconv2;
         ndmxs = ndmax / lconv2;
         wbns = wbald / fconv ;
         wbmns = wmin / fconv;
         wbmxs = wmax / fconv;
         flns = flngd / lconv2 ;
         flmns = flmin / lconv2;
         flmxs = flmax / lconv2;
         fwdms = fwid / lconv2 ;
         fwdmns = fwmin / lconv2;
         fwdmxs = fwmax / lconv2;
         flons = flocd / lconv2 ;
         flomns = flcmin / lconv2;
         flomxs = flcmax / lconv2;
         btlns = btlngd / lconv2 ;
         btlmns = btlmin / lconv2;
         btlmxs = btlmax / lconv2;
         btdms = btdiamd / lconv2 ;
         btdmns = btdmin / lconv2;
         btdmxs = btdmax / lconv2;
         sv1ns = sv1d / vconv ;
         sv1mns = sv1min / vconv;
         sv1mxs = sv1max / vconv;
         sv2ns = sv2d / vconv ;
         sv2mns = sv2min / vconv;
         sv2mxs = sv2max / vconv;
         slns = sld / lconv2 ;
         slmns = slmin / lconv2;
         slmxs = slmax / lconv2;
         lprns = lpresd / pconv ;
         lprmns = lpresmin / pconv ;
         lprmxs = lpresmax / pconv ;
         watns = watd / vconv ;
         watmns = watmin / vconv;
         watmxs = watmax / vconv;
         nzdns = nozdiamd / lconv2 ;
         nzdmns = nozdmin / lconv2;
         nzdmxs = nozdmax / lconv2;
         fpns = fpresd / pconv ;
         fpmns = fpresmin / pconv ;
         fpmxs = fpresmax / pconv ;
         ltns = ltubd / lconv2 ;
         ltmns = ltubmin / lconv2;
         ltmxs = ltubmax / lconv2;
         b1flns = b1flngd / lconv2 ;
         b1fwdms = b1fwd / lconv2 ;
         b1fwdmxs = b1fwmax / lconv2;
         b1lns = b1lngd / lconv2 ;
         b1lmxs = b1lmax / lconv2;
         wobjs = wobjd / fconv ;
         wobmxs = wobmax / fconv ;
         wobmns = wobmin / fconv ;

         switch (lunits) {
            case 0:{                   /* English Units */
                 outfor = " oz" ; outht = " ft"; outspd = " fps";
                 lconv1 = 1.0 ; lconv2 = 1.0 ; fconv = 1.0 ; 
                 pconv  = 1.0 ; 

                 act.inp.rang.lt.l4.setText("Altitude-ft") ;
                 act.inp.rang.lt.l3.setText("Length-ft") ;
                 act.inp.rang.lt.l2.setText("Wind fps") ;
                 act.inp.bali.lt.l1.setText("Weight oz") ;
                 act.inp.bali.lt.l3.setText("Area sq in") ;
                 act.inp.bali.lt.l4.setText("Speed fps") ;
                 act.inp.body.lt.l1.setText("Length in") ;
                 act.inp.body.lt.l2.setText("Diam in") ;
                 act.inp.body.lt.l3.setText("Length in") ;
                 act.inp.body.lt.l4.setText("Diam in") ;
                 act.inp.payl.lt.l1.setText("Length in") ;
                 act.inp.payl.lt.l2.setText("Diam in") ;
                 act.inp.payl.lt.l3.setText("Length in") ;
                 act.inp.payl.lt.l4.setText("Weight oz") ;
                 act.inp.nose.lt.l1.setText("Length in") ;
                 act.inp.nose.lt.l2.setText("Diam in") ;
                 act.inp.nose.lt.l3.setText("Ballast oz") ;
                 act.inp.fins.lt.l1.setText("Length in") ;
                 act.inp.fins.lt.l2.setText("Width in") ;
                 act.inp.fins.lt.l5.setText("Locate in") ;
                 act.inp.boti.lt.l3.setText("Length in") ;
                 act.inp.boti.lt.l4.setText("Diam in") ;
                 act.inp.engs.lt.l1.setText("Begin in3") ;
                 act.inp.engs.lt.l2.setText("End in3") ;
                 act.inp.engs.lt.l3.setText("Length in") ;
                 act.inp.engs.lt.l4.setText("Pressure psi") ;
                 act.inp.engb.lt.l1.setText("Vol cu in") ;
                 act.inp.engb.lt.l2.setText("Pressure psi") ;
                 act.inp.engb.lt.l3.setText("Diam in") ;
                 act.inp.engb.lt.l4.setText("Length in") ;
                 act.inp.engb.lt.o1.setText(String.valueOf(filter1(wfuel*fconv))+outfor) ;
                 act.inp.engb.lt.o2.setText(String.valueOf(filter1(lothrust*fconv))+outfor) ;
                 act.inp.lnch.o2.setText(String.valueOf(filter0(vloc*lconv1))+outht) ;
                 act.inp.lnch.o3.setText(String.valueOf(filter0(spd*lconv1))+outspd) ;
                 act.inp.lnch.o4.setText(String.valueOf(filter0(posx[nsav][npt] * lconv1))+outht);
                 act.inp.lnch.o5.setText(String.valueOf(filter0(vmax*lconv1))+outht) ;
                 act.inp.lnch.o7.setText(String.valueOf(filter0(hmax*lconv1))+outht) ;
                 act.inp.lnch.o6.setText(String.valueOf(filter0(spdmax*lconv1))+outspd) ;
                 break ;
            }
            case 1:{                   /* Metric Units */
                 outfor = " g" ; outht = " m"; outspd = " mps";
                 lconv1 = .3048 ; lconv2 = 2.54 ; fconv = 28.35 ;
                 pconv  = 6.891 ; 

                 act.inp.rang.lt.l4.setText("Altitude-m") ;
                 act.inp.rang.lt.l3.setText("Length-m") ;
                 act.inp.rang.lt.l2.setText("Wind mps") ;
                 act.inp.bali.lt.l1.setText("Weight g") ;
                 act.inp.bali.lt.l3.setText("Area sq cm") ;
                 act.inp.bali.lt.l4.setText("Speed mps") ;
                 act.inp.body.lt.l1.setText("Length cm") ;
                 act.inp.body.lt.l2.setText("Diam cm") ;
                 act.inp.body.lt.l3.setText("Length cm") ;
                 act.inp.body.lt.l4.setText("Diam cm") ;
                 act.inp.payl.lt.l1.setText("Length cm") ;
                 act.inp.payl.lt.l2.setText("Diam cm") ;
                 act.inp.payl.lt.l3.setText("Length cm") ;
                 act.inp.payl.lt.l4.setText("Weight g") ;
                 act.inp.nose.lt.l1.setText("Length cm") ;
                 act.inp.nose.lt.l2.setText("Diam cm") ;
                 act.inp.nose.lt.l3.setText("Ballast g") ;
                 act.inp.fins.lt.l1.setText("Length cm") ;
                 act.inp.fins.lt.l2.setText("Width cm") ;
                 act.inp.fins.lt.l5.setText("Locate cm") ;
                 act.inp.boti.lt.l3.setText("Length cm") ;
                 act.inp.boti.lt.l4.setText("Diam cm") ;
                 act.inp.engs.lt.l1.setText("Begin cc") ;
                 act.inp.engs.lt.l2.setText("End cc") ;
                 act.inp.engs.lt.l3.setText("Length cm") ;
                 act.inp.engs.lt.l4.setText("Pressure kPa") ;
                 act.inp.engb.lt.l1.setText("Vol cc") ;
                 act.inp.engb.lt.l2.setText("Pressure kPa") ;
                 act.inp.engb.lt.l3.setText("Diam cm") ;
                 act.inp.engb.lt.l4.setText("Length cm") ;
                 act.inp.engb.lt.o1.setText(String.valueOf(filter1(wfuel*fconv))+outfor) ;
                 act.inp.engb.lt.o2.setText(String.valueOf(filter1(lothrust*fconv))+outfor) ;
                 act.inp.lnch.o2.setText(String.valueOf(filter0(vloc*lconv1))+outht) ;
                 act.inp.lnch.o3.setText(String.valueOf(filter0(spd*lconv1))+outspd) ;
                 act.inp.lnch.o4.setText(String.valueOf(filter0(posx[nsav][npt] * lconv1))+outht);
                 act.inp.lnch.o5.setText(String.valueOf(filter0(vmax*lconv1))+outht) ;
                 act.inp.lnch.o7.setText(String.valueOf(filter0(hmax*lconv1))+outht) ;
                 act.inp.lnch.o6.setText(String.valueOf(filter0(spdmax*lconv1))+outspd) ;
                 break ;
            }
          }
          aconv = lconv2 * lconv2 ;
          vconv = aconv * lconv2 ;
          dconv2 = fconv / aconv ;
          dconv3 = fconv / vconv ;
 
          altd = alts * lconv1 ;
          altmax = altmxs * lconv1 ;
          raild = rals * lconv1 ;
          railmin = ralmns * lconv1 ;
          railmax = ralmxs * lconv1 ;
          windd = wnds * lconv1 ;
          wndmin = wndmns * lconv1 ;
          wndmax = wndmxs * lconv1 ;
          vmuzld = vmzs * lconv1 ;
          vmmin = vmzmns * lconv1 ;
          vmmax = vmzmxs * lconv1 ;
          catd = cats * aconv ;
          camin = catmns * aconv ;
          camax = catmxs * aconv ;
          wtd = wtns * fconv ;
          wtmin = wtmns * fconv ;
          wtmax = wtmxs * fconv ;
          blngd = blns * lconv2 ;
          blmin = blmns * lconv2 ;
          blmax = blmxs * lconv2 ;
          bdiamd = bdms * lconv2 ;
          bdmin = bdmns * lconv2 ;
          bdmax = bdmxs * lconv2 ;
          tlngd = tlns * lconv2 ;
          tlmin = tlmns * lconv2 ;
          tlmax = tlmxs * lconv2 ;
          tdiamd = tdms * lconv2 ;
          tdmin = tdmns * lconv2 ;
          tdmax = tdmxs * lconv2 ;
          plngd = plns * lconv2 ;
          plmin = plmns * lconv2 ;
          plmax = plmxs * lconv2 ;
          pdiamd = pdms * lconv2 ;
          pdmin = pdmns * lconv2 ;
          pdmax = pdmxs * lconv2 ;
          qlngd = qlns * lconv2 ;
          qlmin = qlmns * lconv2 ;
          qlmax = qlmxs * lconv2 ;
          nlngd = nlns * lconv2 ;
          nlmin = nlmns * lconv2 ;
          nlmax = nlmxs * lconv2 ;
          ndiamd = ndms * lconv2 ;
          ndmin = ndmns * lconv2 ;
          ndmax = ndmxs * lconv2 ;
          wbald = wbns * fconv ;
          wmin = wbmns * fconv ;
          wmax = wbmxs * fconv ;
          flngd = flns * lconv2 ;
          flmin = flmns * lconv2 ;
          flmax = flmxs * lconv2 ;
          fwid = fwdms * lconv2 ;
          fwmin = fwdmns * lconv2 ;
          fwmax = fwdmxs * lconv2 ;
          flocd = flons * lconv2 ;
          flcmin = flomns * lconv2 ;
          flcmax = flomxs * lconv2 ;
          btlngd = btlns * lconv2 ;
          btlmin = btlmns * lconv2 ;
          btlmax = btlmxs * lconv2 ;
          btdiamd = btdms * lconv2 ;
          btdmin = btdmns * lconv2 ;
          btdmax = btdmxs * lconv2 ;
          sv1d = sv1ns * vconv ;
          sv1min = sv1mns * vconv ;
          sv1max = sv1mxs * vconv ;
          sv2d = sv2ns * vconv ;
          sv2min = sv2mns * vconv ;
          sv2max = sv2mxs * vconv ;
          sld = slns * lconv2 ;
          slmin = slmns * lconv2 ;
          slmax = slmxs * lconv2 ;
          lpresd = lprns * pconv ;
          lpresmin = lprmns * pconv ;
          lpresmax = lprmxs * pconv ;
          watd = watns * vconv ;
          watmin = watmns * vconv ;
          watmax = watmxs * vconv ;
          nozdiamd = nzdns * lconv2 ;
          nozdmin = nzdmns * lconv2 ;
          nozdmax = nzdmxs * lconv2 ;
          fpresd = fpns * pconv ;
          fpresmin = fpmns * pconv ;
          fpresmax = fpmxs * pconv ;
          ltubd = ltns * lconv2 ;
          ltubmin = ltmns * lconv2 ;
          ltubmax = ltmxs * lconv2 ;
          b1flngd  = b1flns * lconv2 ;
          b1fwd = b1fwdms * lconv2 ;
          b1fwmax = b1fwdmxs * lconv2;
          b1lngd = b1lns * lconv2 ;
          b1lmax = b1lmxs * lconv2;
          wobjd = wobjs * fconv ;
          wobmax = wobmxs * fconv ;
          wobmin = wobmns * fconv ;
               // change input and output 
          loadOut () ;
          loadInput () ;
  
          return ;
       }

       public void handleBut(Event evt, Object obj) {
         String label = (String)obj ;
         String outlng,outfor ;
         int i ;

         outlng = " in" ;
         if (lunits == 1) outlng = " cm" ;
         outfor = " oz" ;
         if (lunits == 1) outfor = " g" ;

         if(label.equals("Ballistic")) {
            ldisplay = 0 ;
            loadBallistic() ;
            layin.show(inp, "bal")  ;
            act.inp.bali.lt.butgo.setBackground(Color.white) ;
            act.inp.bali.lt.butgo.setForeground(Color.blue) ;
            act.con.o3.setForeground(Color.green) ;
            act.con.o4.setForeground(Color.green) ;
            istab = 1;
            setRangeView() ;
            setConBut() ;
            setRocBut() ;
            bt2.setBackground(Color.yellow) ;
            bt2.setForeground(Color.black) ;
            btm2.setBackground(Color.yellow) ;
            btm2.setForeground(Color.black) ;
            act.con.o1.setForeground(Color.green) ;
            act.inp.lnch.l11.setText(" ") ;
            act.inp.lnch.o11.setText("N/A") ;
            act.inp.lnch.o11.setForeground(Color.red) ;
            act.inp.lnch.l12.setText(" ") ;
            act.inp.lnch.o12.setText("N/A") ;
            act.inp.lnch.o12.setForeground(Color.red) ;
            loadInput() ;
         }
         if(label.equals("Air")) {
            ldisplay = 0 ;
            part = 3;
            loadStomp() ;
            layin.show(inp, "bod")  ;
            act.inp.body.lt.butgo.setBackground(Color.white) ;
            act.inp.body.lt.butgo.setForeground(Color.blue) ;
            setDesignView() ;
            setConBut() ;
            setRocBut() ;
            bt3.setBackground(Color.yellow) ;
            bt3.setForeground(Color.black) ;
            act.con.o1.setForeground(Color.green) ;
            act.inp.lnch.l11.setText(" ") ;
            act.inp.lnch.o11.setText("N/A") ;
            act.inp.lnch.o11.setForeground(Color.red) ;
            act.inp.lnch.l12.setText(" ") ;
            act.inp.lnch.o12.setText("N/A") ;
            act.inp.lnch.o12.setForeground(Color.red) ;
            loadInput() ;
         }
         if(label.equals("Water")) {
            ldisplay = 0 ;
            part = 3;
            loadBottle() ;
            layin.show(inp, "bot")  ;
            act.inp.boti.lt.butgo.setBackground(Color.white) ;
            act.inp.boti.lt.butgo.setForeground(Color.blue) ;
            setDesignView() ;
            setConBut() ;
            setRocBut() ;
            bt4.setBackground(Color.yellow) ;
            bt4.setForeground(Color.black) ;
            act.inp.lnch.l11.setText("Press.") ;
            act.inp.lnch.o11.setForeground(Color.green) ;
            act.inp.lnch.l12.setText("Fuel Wt.") ;
            act.inp.lnch.o12.setForeground(Color.green) ;
            loadInput() ;
         }
         if(label.equals("Solid")) {
            ldisplay = 0 ;
            part = 3;
            loadModel() ;
            loadInput() ;
            layin.show(inp, "bod")  ;
            act.inp.body.lt.butgo.setBackground(Color.white) ;
            act.inp.body.lt.butgo.setForeground(Color.blue) ;
            layen1.show(act.inp.enge.m, "first")  ;
            setDesignView() ;
            setConBut() ;
            setRocBut() ;
            bt5.setBackground(Color.yellow) ;
            bt5.setForeground(Color.black) ;
            act.inp.lnch.l11.setText(" ") ;
            act.inp.lnch.o11.setText("N/A") ;
            act.inp.lnch.o11.setForeground(Color.red) ;
            act.inp.lnch.l12.setText(" ") ;
            act.inp.lnch.o12.setText("N/A") ;
            act.inp.lnch.o12.setForeground(Color.red) ;
         }

         if(label.equals("Fuel")) {
           ifuel = 0 ;
           btm2.setBackground(Color.yellow) ;
           btm2.setForeground(Color.black) ;
           if (ides == 0) {
               btm1.setBackground(Color.white) ;
               btm1.setForeground(Color.blue) ; 
           }            
           btm4.setBackground(Color.white) ;
           btm4.setForeground(Color.blue) ;
           if (rktype <= 9) {
              restDesignView() ;
              fire = 0 ;
              comp = 0 ;
              solve.getFreeStream() ;
              if(rktype == 1) {
                 lnchgrf = 1 ;
                 layin.show(inp, "ens")  ;
                 act.inp.engs.lt.butgo.setBackground(Color.white) ;
                 act.inp.engs.lt.butgo.setForeground(Color.blue) ;
              }
              if(rktype == 2) {
                 lnchgrf = 2 ;
                 layin.show(inp, "enb")  ;
                 act.inp.engb.lt.butgo.setBackground(Color.white) ;
                 act.inp.engb.lt.butgo.setForeground(Color.blue) ;
                 act.inp.engb.getGeom() ;
              }
              if(rktype == 3) {
                 lnchgrf = 3 ;
                 layin.show(inp, "ene")  ;
                 act.inp.enge.up.butgo.setBackground(Color.white) ;
                 act.inp.enge.up.butgo.setForeground(Color.blue) ;
                 act.inp.enge.getModThrst() ;
              }
           }
           if(rktype == 10) {
              layin.show(inp, "bal")  ;
              ides = 0 ;
              btm1.setBackground(Color.yellow) ;
              btm1.setForeground(Color.black) ;
              act.inp.bali.lt.butgo.setBackground(Color.white) ;
              act.inp.bali.lt.butgo.setForeground(Color.blue) ;
           }
         }

         if(label.equals("Design")) {
            ides = 0 ;
            lnchgrf = 0 ;
            btm1.setBackground(Color.yellow) ;
            btm1.setForeground(Color.black) ;
            if (ifuel == 0) {
                btm2.setBackground(Color.white) ;
                btm2.setForeground(Color.blue) ;
            }
            if(rktype <= 9) {
              if (viewflg >= 1) restDesignView() ;
              if(part == 1) {
                 layin.show(inp, "nos")  ;
                 act.inp.nose.lt.butgo.setBackground(Color.white) ;
                 act.inp.nose.lt.butgo.setForeground(Color.blue) ;
              }
              if(part == 2) {
                 layin.show(inp, "pay")  ;
                 act.inp.payl.lt.butgo.setBackground(Color.white) ;
                 act.inp.payl.lt.butgo.setForeground(Color.blue) ;
              }
              if(part == 3) {
                 if (rktype < 2 || rktype > 2) {
                    layin.show(inp, "bod")  ;
                    act.inp.body.lt.butgo.setBackground(Color.white) ;
                    act.inp.body.lt.butgo.setForeground(Color.blue) ;
                 }
                 if (rktype == 2) {
                    layin.show(inp, "bot")  ;
                    act.inp.boti.lt.butgo.setBackground(Color.white) ;
                    act.inp.boti.lt.butgo.setForeground(Color.blue) ;
                 }
              }
              if(part == 4) {
                 layin.show(inp, "fin")  ;
                 act.inp.fins.lt.butgo.setBackground(Color.white) ;
                 act.inp.fins.lt.butgo.setForeground(Color.blue) ;
              }
           }
           if(rktype == 10) {
              layin.show(inp, "bal")  ;
              ifuel = 0 ;
              btm2.setBackground(Color.yellow) ;
              btm2.setForeground(Color.black) ;
              act.inp.bali.lt.butgo.setBackground(Color.white) ;
              act.inp.bali.lt.butgo.setForeground(Color.blue) ;
           }
         }

         if(label.equals("Pad")) {
           restRangeView() ;
           layin.show(inp, "rng")  ;
           act.inp.rang.lt.butgo.setBackground(Color.white) ;
           act.inp.rang.lt.butgo.setForeground(Color.blue) ;
           fire = 0 ;
           comp = 0 ;
           irange = 0 ;
           btm3.setBackground(Color.yellow) ;
           btm3.setForeground(Color.black) ;
           if (ides == 0) {
              btm1.setBackground(Color.white) ;
              btm1.setForeground(Color.blue) ;
           }
           if (ifuel == 0) {
              btm2.setBackground(Color.white) ;
              btm2.setForeground(Color.blue) ;
           }
           for (i=0; i<=npts[nsav]; ++i){
              posx[nsav][i] = 0.0 ;  
              posy[nsav][i] = 0.0 ;  
              posa[i] = pid2 ;
              posb1 = 0.0 ;
           }
           npts[nsav] = 0 ;
         }

         if(label.equals("Launch")) {
           if (ifuel == 1 && ides == 1 && irange ==1 && istab ==1 ) {
              restRangeView() ;
              layin.show(inp, "lch")  ;
              btm4.setBackground(Color.green) ;
              btm4.setForeground(Color.black) ;
              act.inp.lnch.bt5.setBackground(Color.white) ;
              act.inp.lnch.bt5.setForeground(Color.blue) ;
              act.inp.lnch.bt7.setLabel("Data") ;
           }
           if (istab == 0 || irange == 0 || ifuel == 0 || ides == 0) {
              btm4.setBackground(Color.red) ;
              btm4.setForeground(Color.white) ;
              fire = 0 ;
           }
         }
         solve.comPute() ;
       }

       public void setRocBut() {
          bt2.setBackground(Color.blue) ;
          bt2.setForeground(Color.white) ;
          bt3.setBackground(Color.blue) ;
          bt3.setForeground(Color.white) ;
          bt4.setBackground(Color.blue) ;
          bt4.setForeground(Color.white) ;
          bt5.setBackground(Color.blue) ;
          bt5.setForeground(Color.white) ;
       }

       public void setConBut() {
          ides = 0 ;
          btm1.setBackground(Color.yellow) ;
          btm1.setForeground(Color.black) ;
          ifuel = 0 ;
          btm2.setBackground(Color.white) ;
          btm2.setForeground(Color.blue) ;
          irange = 0 ;
          btm3.setBackground(Color.white) ;
          btm3.setForeground(Color.blue) ;
          btm4.setBackground(Color.white) ;
          btm4.setForeground(Color.blue) ;
       }
    }  // end Con

    class Inp extends Panel {
       Rocket outerparent ;
       Lnch lnch ;
       Body body ;
       Nose nose ;
       Fins fins ;
       Payl payl ;
       Engs engs ;
       Engb engb ;
       Enge enge ;
       Bali bali ;
       Boti boti ;
       Rang rang ;

       Inp (Rocket target) {

          outerparent = target ;
          layin = new CardLayout() ;
          setLayout(layin) ;

          lnch = new Lnch(outerparent) ;
          body = new Body(outerparent) ;
          nose = new Nose(outerparent) ;
          fins = new Fins(outerparent) ;
          payl = new Payl(outerparent) ;
          engs = new Engs(outerparent) ;
          engb = new Engb(outerparent) ;
          enge = new Enge(outerparent) ;
          bali = new Bali(outerparent) ;
          boti = new Boti(outerparent) ;
          rang = new Rang(outerparent) ;

          add ("bod", body) ;
          add ("nos", nose) ;
          add ("fin", fins) ;
          add ("pay", payl) ;
          add ("ens", engs) ;
          add ("enb", engb) ;
          add ("ene", enge) ;
          add ("bal", bali) ;
          add ("bot", boti) ;
          add ("rng", rang) ;
          add ("lch", lnch) ;
       }

       class Lnch extends Panel {
          Rocket outerparent ;                           
          TextField o1,o2,o3,o4 ;
          Button bt1,bt2,bt3,bt4,bt5,bt6,bt7,bt8 ;
          TextField o5,o6,o7,o8,o9,o10,o11,o12 ;
          Label lab1, lab2, lab3, l11,l12 ;

          Lnch (Rocket target) {
  
            outerparent = target ;
            setLayout(new GridLayout(7,5,2,5)) ;        

            lab1 = new Label("Launch ",Label.RIGHT) ;
            lab1.setForeground(Color.red) ;

            lab2 = new Label("Control",Label.LEFT) ;
            lab2.setForeground(Color.red) ;

            lab3 = new Label("Telemetry",Label.LEFT) ;
            lab3.setForeground(Color.red) ;

            o1 = new TextField(String.valueOf((float)zero),5) ;
            o1.setBackground(Color.black) ;
            o1.setForeground(Color.green) ;

            o2 = new TextField(String.valueOf((float)zero),5) ;
            o2.setBackground(Color.black) ;
            o2.setForeground(Color.green) ;
     
            o3 = new TextField(String.valueOf((float)zero),5) ;
            o3.setBackground(Color.black) ;
            o3.setForeground(Color.green) ;
     
            o4 = new TextField(String.valueOf((float)zero),5) ;
            o4.setBackground(Color.black) ;
            o4.setForeground(Color.green) ;

            bt3 = new Button("Pause") ;
            bt3.setBackground(Color.blue) ;
            bt3.setForeground(Color.white) ;
 
            bt5 = new Button("Fire") ;
            bt5.setBackground(Color.white) ;
            bt5.setForeground(Color.blue) ;
 
            bt4 = new Button("Reset") ;
            bt4.setBackground(Color.blue) ;
            bt4.setForeground(Color.white) ;
 
            bt6 = new Button("Abort") ;
            bt6.setBackground(Color.red) ;
            bt6.setForeground(Color.white) ;
 
            bt7 = new Button("Data") ;
            bt7.setBackground(Color.blue) ;
            bt7.setForeground(Color.white) ;
 
            bt8 = new Button("Step") ;
            bt8.setBackground(Color.blue) ;
            bt8.setForeground(Color.white) ;
 
            o5 = new TextField(String.valueOf((float)zero),5) ;
            o5.setBackground(Color.black) ;
            o5.setForeground(Color.yellow) ;
     
            o6 = new TextField(String.valueOf((float)zero),5) ;
            o6.setBackground(Color.black) ;
            o6.setForeground(Color.yellow) ;
     
            o7 = new TextField(String.valueOf((float)zero),5) ;
            o7.setBackground(Color.black) ;
            o7.setForeground(Color.yellow) ;

            o8 = new TextField(String.valueOf((float)zero),5) ;
            o8.setBackground(Color.black) ;
            o8.setForeground(Color.green) ;

            o9 = new TextField(String.valueOf((float)zero),5) ;
            o9.setBackground(Color.black) ;
            o9.setForeground(Color.green) ;

            o10 = new TextField(String.valueOf((float)zero),5) ;
            o10.setBackground(Color.black) ;
            o10.setForeground(Color.green) ;

            l11 = new Label(" ",Label.RIGHT) ;
            o11 = new TextField("N/A",5) ;
            o11.setBackground(Color.black) ;
            o11.setForeground(Color.red) ;

            l12 = new Label(" ",Label.RIGHT) ;
            o12 = new TextField("N/A",5) ;
            o12.setBackground(Color.black) ;
            o12.setForeground(Color.red) ;

            add(lab1) ;
            add(lab2) ;
            add(bt5) ;
            add(bt4) ;
            add(bt6) ;

            add(new Label(" ", Label.CENTER)) ;
            add(lab3) ;
            add(new Label("Height", Label.CENTER)) ;
            add(new Label("Speed", Label.CENTER)) ;
            add(new Label("Range", Label.CENTER)) ;

            add(new Label("Time", Label.CENTER)) ;
            add(new Label("Current ", Label.RIGHT)) ;
            add(o2) ;
            add(o3) ;
            add(o4) ;

            add(o1) ;
            add(new Label("Maximum", Label.RIGHT)) ;
            add(o5) ;
            add(o6) ;
            add(o7) ;

            add(bt3) ;
            add(new Label("Thrust ", Label.RIGHT)) ;
            add(o8) ;
            add(new Label("Drag", Label.RIGHT)) ;
            add(o9) ;

            add(bt8) ;
            add(new Label("Output", Label.RIGHT)) ;
            add(bt7) ;
            add(new Label("Weight", Label.RIGHT)) ;
            add(o10) ;

            add(new Label(" ", Label.CENTER)) ;
            add(l11) ;
            add(o11) ;
            add(l12) ;
            add(o12) ;
          }

          public boolean action(Event evt, Object arg) {
            if(evt.target instanceof Button) {
               this.handleBut(evt,arg) ;
               return true ;
            }
            else return false ;
          }

          public void handleBut(Event evt, Object obj) {
            String label = (String)obj ;
            int i,j ;
            double angle ;

            if(label.equals("Pause")) {
              comp = 0 ;
              stepon = 1;
              step = 0 ;
              bt3.setLabel("Resume") ;
              bt3.setBackground(Color.white) ;
              bt3.setForeground(Color.blue) ;
              bt8.setBackground(Color.white) ;
              bt8.setForeground(Color.blue) ;
            }
            if(label.equals("Resume")) {
              comp = 1 ;
              stepon = 0 ;
              bt3.setLabel("Pause") ;
              bt3.setBackground(Color.blue) ;
              bt3.setForeground(Color.white) ;
              bt8.setBackground(Color.blue) ;
              bt8.setForeground(Color.white) ;
            }
            if(label.equals("Step")) {
              step = 1 ;
            }
            if(label.equals("Data")) {
              bt7.setLabel("View") ;
              restGraphView() ;
            }
            if(label.equals("View")) {
              bt7.setLabel("Data") ;
              restRangeView() ;
            }
            if(label.equals("Reset")) {
              fire = 0 ;
              comp = 0 ;
              stepon = 0 ;
              ifuel =1 ;
              ides = 1 ;
              irange = 1 ;
              for (i=0; i<=npts[nsav]; ++i){
                 posx[nsav][i] = 0.0 ;  
                 posy[nsav][i] = 0.0 ;  
                 posa[i] = pid2 ;
                 posb1 = 0.0 ;
              }
              npts[nsav] = 0 ;
              act.con.btm1.setBackground(Color.green) ;
              act.con.btm1.setForeground(Color.black) ;
              act.con.btm2.setBackground(Color.green) ;
              act.con.btm2.setForeground(Color.black) ;
              act.con.btm3.setBackground(Color.green) ;
              act.con.btm3.setForeground(Color.black) ;
              act.con.btm4.setBackground(Color.green) ;
              act.con.btm4.setForeground(Color.black) ;
              bt5.setBackground(Color.white) ;
              bt5.setForeground(Color.blue) ;
              bt3.setLabel("Pause") ;
              bt3.setBackground(Color.blue) ;
              bt3.setForeground(Color.white) ;
              bt8.setBackground(Color.blue) ;
              bt8.setForeground(Color.white) ;
            }
            if(label.equals("Fire")) {
              if (ifuel == 1 && ides == 1 && irange ==1 && istab ==1 ) {
                 bt5.setBackground(Color.yellow) ;
                 bt5.setForeground(Color.black) ;
                 fire = 1 ;
                 comp = 1 ;
                 cockcal = 0 ;
                 fltim = -5.0 ;
                 drag = 0.0 ;
                 timrail = 0.0 ;
                 if (rktype == 10) {
                    spd = vmuzl ;
                    llaunch = 0.0 ;
                    drag = (16.0 * cd * .5 * rho * catot * spd * spd / 144.) ; 
                    angle = (90.0 - lnchang) * convdr ;
                    vacc = (-drag*Math.sin(angle)-(weight*wtrat))/(weight/g0) ;
                    hacc = (-drag*Math.cos(angle)) / (weight/g0)  ;
                    cockflg = 0 ;
                    act.inp.rang.rt.cockch.select(cockflg) ;
                 }
                 if (rktype == 1) {
                    act.inp.engs.getVexit() ;
                    spd = vstomp ;
                    llaunch = sl / 12.0 ;
                    drag = (16.0 * cd * .5 * rho * catot * spd * spd / 144.) ; 
                    angle = (90.0 - lnchang) * convdr ;
                    vacc = (-drag*Math.sin(angle)-(weight*wtrat))/(weight/g0) ;
                    hacc = (-drag*Math.cos(angle)) / (weight/g0)  ;
                 }
                 if (rktype == 2) {
                    spd = 0.0 ;
                    llaunch = ltub / 12.0  ;
                 }
                 if (rktype == 3) {
                    spd = 0.0 ;
                    llaunch = rail ;
                 }
                 vvel = spd * Math.cos(convdr*lnchang) ;
                 hvel = spd * Math.sin(convdr*lnchang) ;
                 vloc = 0.0 ;
                 hloc = 0.0 ;
                 hmax = 0.0 ;
                 vmax = 0.0 ;
                 spdmax = 0.0 ;
                 npt = 0 ;
                 act.inp.lnch.o1.setForeground(Color.yellow) ;
                 if (viewflg == 2) {
                   for (j=0; j<=4; ++j) {
                      for (i=0; i<=npts[j]; ++i){
                         posx[j][i] = 0.0 ;  
                         posy[j][i] = 0.0 ;  
                       }
                       npts[j] = 0 ;
                    }
                 }
              }
            }
            if(label.equals("Abort")) {
              fire = 0 ;
              comp = 0 ;
              nsav = 0 ;
              for (j=0; j<=4; ++j) {
                 for (i=0; i<=npts[j]; ++i){
                    posx[j][i] = 0.0 ;  
                    posy[j][i] = 0.0 ;  
                    posa[i] = pid2 ;
                    posb1 = 0.0 ;
                 }
                 npts[j] = 0 ;
              }
              irange = 0 ;
              act.con.btm3.setBackground(Color.white) ;
              act.con.btm3.setForeground(Color.blue) ;
              ifuel = 0 ;
              act.con.btm2.setBackground(Color.white) ;
              act.con.btm2.setForeground(Color.blue) ;
              ides = 0 ;
              act.con.btm1.setBackground(Color.yellow) ;
              act.con.btm1.setForeground(Color.black) ;
              act.con.btm4.setBackground(Color.white) ;
              act.con.btm4.setForeground(Color.blue) ;
            }
          }  // end handler
       }   // end launch

       class Rang extends Panel {
          Rocket outerparent ;                           
          Rt rt ;
          Lt lt ;

          Rang (Rocket target) {
  
             outerparent = target ;
             setLayout(new GridLayout(1,2,0,0)) ;        

             rt = new Rt(outerparent) ;
             lt = new Lt(outerparent) ;
    
             add(lt) ;
             add(rt) ;
          }

          class Rt extends Panel {
             Rocket outerparent ;
             Scrollbar s1,s2,s3,s4;
             Choice cockch,plntch ;

             Rt (Rocket target) {

               int i1,i2,i3,i4 ;

               outerparent = target ;
               setLayout(new GridLayout(7,1,5,5)) ;

               i1 = (int) (((lnchang - langmin)/(langmax-langmin))*1000.) ;
               i2 = (int) (((windd - wndmin)/(wndmax-wndmin))*1000.) ;
               i3 = (int) (((raild - railmin)/(railmax-railmin))*1000.) ;
               i4 = (int) (((altd - altmin)/(altmax-altmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
  
               cockch = new Choice() ;
               cockch.addItem("Weathercock OFF") ;
               cockch.addItem("Weathercock ON") ;
               cockch.setBackground(Color.white) ;
               cockch.setForeground(Color.blue) ;
               cockch.select(0) ;
 
               plntch = new Choice() ;
               plntch.addItem("Earth - Average Day") ;
               plntch.addItem("Ideal Earth-No Drag") ;
               plntch.addItem("Moon") ;
               plntch.addItem("Mars");
               plntch.setBackground(Color.white) ;
               plntch.setForeground(Color.blue) ;
               plntch.select(0) ;
 
               add(plntch) ;
               add(s4) ;
               add(cockch) ;
               add(s2) ;
               add(new Label("Launch Rail", Label.CENTER)) ;
               add(s1) ;
               add(s3) ;
           }
 
           public boolean handleEvent(Event evt) {
              if(evt.id == Event.ACTION_EVENT) {
                 this.handleCho(evt) ;
                 return true ;
              }
              if(evt.id == Event.SCROLL_ABSOLUTE) {
                 this.handleBar(evt) ;
                 return true ;
              }
              if(evt.id == Event.SCROLL_LINE_DOWN) {
                 this.handleBar(evt) ;
                 return true ;
              }
              if(evt.id == Event.SCROLL_LINE_UP) {
                 this.handleBar(evt) ;
                 return true ;
              }
              if(evt.id == Event.SCROLL_PAGE_DOWN) {
                 this.handleBar(evt) ;
                 return true ;
              }
              if(evt.id == Event.SCROLL_PAGE_UP) {
                 this.handleBar(evt) ;
                 return true ;
              }
              else return false ;
           }

           public void handleCho(Event evt) {     // range
              cockflg = cockch.getSelectedIndex() ;
              planet  = plntch.getSelectedIndex() ;

              solve.getFreeStream() ;
           }

           public void handleBar(Event evt) {     // range
             int i1,i2,i3,i4 ;
             double v1,v2,v3,v4 ;
             float fl1,fl2,fl3,fl4 ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;
             i4 = s4.getValue() ;

             vmn1 = langmin;    vmx1 = langmax ;
             vmn2 = wndmin;    vmx2 = wndmax ;
             vmn3 = railmin;   vmx3 = railmax ;
             vmn4 = altmin;    vmx4 = altmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
             v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
 
             lnchang = v1 ;
             windd = v2 ;
             wind = windd / lconv1 ;
             raild = v3 ;
             rail = raild / lconv1 ;
             altd = v4 ;
             alt = altd / lconv1 ;
 
             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl3 = filter3(v3) ;
             fl4 = filter3(v4) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f3.setText(String.valueOf(fl3)) ;
             lt.f4.setText(String.valueOf(fl4)) ;

             npt = 0 ;

             solve.getFreeStream() ;
           }  // end handle
         }  // end right

         class Lt extends Panel {
           Rocket outerparent ;
           TextField f1, f2, f3, f4 ;
           Label l1, l2, l3, l4,  lab ;
           Button butgo ;

           Lt (Rocket target) {
              outerparent = target ;
              setLayout(new GridLayout(7,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;
 
              l1 = new Label("Angle", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)lnchang),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("Wind fps", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)windd),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              l3 = new Label("Length ft", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)raild),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("Altitude-ft", Label.CENTER) ;
              f4 = new TextField("0.0",5) ;
              f4.setBackground(Color.white) ;
              f4.setForeground(Color.black) ;

              add(butgo) ;
              add(new Label("Location", Label.CENTER)) ;

              add(l4) ;
              add(f4) ;

              add(new Label(" ", Label.CENTER)) ;
              add(new Label(" ", Label.CENTER)) ;

              add(l2) ;
              add(f2) ;

              add(new Label(" ", Label.CENTER)) ;
              add(new Label(" ", Label.CENTER)) ;

              add(l1) ;
              add(f1) ;

              add(l3) ;
              add(f3) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 irange = 1 ;
                 act.con.btm3.setBackground(Color.green) ;
                 act.con.btm3.setForeground(Color.black) ;
                 act.con.btm4.setBackground(Color.white) ;
                 act.con.btm4.setForeground(Color.blue) ;
                 butgo.setBackground(Color.green) ;
                 butgo.setForeground(Color.black) ;
              }
           }

           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4 ;
             double v1,v2,v3,v4 ;
             int i1,i2,i3,i4;
             float fl1 ;

             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
             V4 = Double.valueOf(f4.getText()) ;
             v4 = V4.doubleValue() ;
  // launch angle
             lnchang  = v1 ;
             vmn1 = langmin;   vmx1 = langmax ;
             if(v1 < vmn1) {
                 lnchang = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 lnchang =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
   // wind
             windd  = v2 ;
             vmn2 = wndmin;   vmx2 = wndmax ;
             if(v2 < vmn2) {
                 windd = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 windd =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             wind = windd / lconv1 ;
   // altitude
             altd = v4 ;
             vmn4 = altmin;   vmx4 = altmax ;
             if(v4 < vmn4) {
               altd = v4 = vmn4 ;
               fl1 = (float) v4 ;
               f4.setText(String.valueOf(fl1)) ;
             }
             if(v4 > vmx4) {
               altd = v4 = vmx4 ;
               fl1 = (float) v4 ;
               f4.setText(String.valueOf(fl1)) ;
             }
             alt = altd / lconv1 ;
    // rail length
             raild = v3 ;
             vmn3 = railmin;   vmx3 = railmax ;
             if(v3 < vmn3) {
               raild = v3 = vmn3 ;
               fl1 = (float) v3 ;
               f3.setText(String.valueOf(fl1 )) ;
             }
             if(v3 > vmx3) {
               raild = v3 = vmx3 ;
               fl1 = (float) v3 ;
               f3.setText(String.valueOf(fl1)) ;
             }
             rail = raild / lconv1 ;


             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
             i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;

             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;
             rt.s4.setValue(i4) ;

             npt = 0 ;

             solve.getFreeStream() ;

           }  // end handle
         }  //  end  left
       }   // end range
  
       class Body extends Panel {
          Rocket outerparent ;
          Lt lt ;
          Rt rt ;
  
          Body (Rocket target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Rocket outerparent ;
             Scrollbar s1,s2,s3,s4,s5;
             Choice bmat,tmat ;

             Rt (Rocket target) {

               int i1,i2,i3,i4,i5 ;
  
               outerparent = target ;
               setLayout(new GridLayout(8,1,10,5)) ;

               i1 = (int) (((blngd - blmin)/(blmax-blmin))*1000.) ;
               i2 = (int) (((bdiamd - bdmin)/(bdmax-bdmin))*1000.) ;
               i3 = (int) (((tlngd - tlmin)/(tlmax-tlmin))*1000.) ;
               i4 = (int) (((tdiamd - tdmin)/(tdmax-tdmin))*1000.) ;
               i5 = (int) (((cd - cdmin)/(cdmax-cdmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
               s5 = new Scrollbar(Scrollbar.HORIZONTAL,i5,10,0,1000);
  
               bmat = new Choice() ;
               bmat.setBackground(Color.white) ;
               bmat.setForeground(Color.blue) ;
               bmat.addItem("<-- My Material") ;
               bmat.addItem("1/32 Cardboard") ;
               bmat.addItem("1/8 Plastic") ;
               bmat.addItem("1/16 Plastic") ;
               bmat.addItem("1/32 Plastic") ;
               bmat.addItem("1/64 Manilla") ;
               bmat.addItem("3/16 Sponge");
               bmat.addItem("2-ply Paper");
               bmat.addItem("2-ply Magazine");
               bmat.addItem("1/16 Gray Cardboard");
               bmat.select(1) ;
  
               tmat = new Choice() ;
               tmat.setBackground(Color.white) ;
               tmat.setForeground(Color.blue) ;
               tmat.addItem("<-- My Material") ;
               tmat.addItem("1/32 Cardboard") ;
               tmat.addItem("1/8 Plastic") ;
               tmat.addItem("1/16 Plastic") ;
               tmat.addItem("1/32 Plastic") ;
               tmat.addItem("1/64 Manilla") ;
               tmat.addItem("3/16 Sponge");
               tmat.addItem("2-ply Paper");
               tmat.addItem("2-ply Magazine");
               tmat.addItem("1/16 Gray Cardboard");
               tmat.select(1) ;

               s5.setVisible(false);

               add(bmat) ;
               add(s1) ;
               add(s2) ;
               add(tmat) ;
               add(s3) ;
               add(s4) ;
		   add(new Label(" ", Label.CENTER));
               add(s5) ;
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleMat(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
           public void handleMat(Event evt) {  // materials
              String outden2 ;
              Double V1,V2 ;
              double v1,v2 ;

         // body tube
              outden2 = " oz/in2" ;
              if (lunits == 1) outden2 = " g/cs" ;

              mbod = bmat.getSelectedIndex() ;
              if (mbod > 0) {
                lt.di.setBackground(Color.black) ;
                lt.di.setForeground(Color.yellow) ;
              }
              if (mbod == 0) {
                lt.di.setBackground(Color.white) ;
                lt.di.setForeground(Color.blue) ;
                lt.di.setText(String.valueOf(filter3(dbod*dconv2))) ;
              }
              switch (mbod) {
                case 0: {
                   V1 = Double.valueOf(lt.di.getText()) ;
                   v1 = V1.doubleValue() ;
                   dbod = v1/dconv2 ;
                   break ;
                }
                case 1: {   // 1/32 cardboard
                   dbod = .0078 ; 
                   lt.di.setText(String.valueOf(filter3(dbod*dconv2))+outden2) ;
                   break ;
                }
                case 2: {  // 1/8 plastic
                   dbod = .06 ; 
                   lt.di.setText(String.valueOf(filter3(dbod*dconv2))+outden2) ;
                   break ;
                }
                case 3: {  // 1/16 plastic
                   dbod = .03 ; 
                   lt.di.setText(String.valueOf(filter3(dbod*dconv2))+outden2) ;
                   break ;
                }
                case 4: {  // 1/32 plastic
                   dbod = .015 ; 
                   lt.di.setText(String.valueOf(filter3(dbod*dconv2))+outden2) ;
                   break ;
                }
                case 5: {  // 1/64  manilla  folder
                   dbod = .0061 ; 
                   lt.di.setText(String.valueOf(filter3(dbod*dconv2))+outden2) ;
                   break ;
                }
                case 6: {  // 3/16 sponge
                   dbod = .0031 ; 
                   lt.di.setText(String.valueOf(filter3(dbod*dconv2))+outden2) ;
                   break ;
                }
                case 7: {  // 2-ply paper
                   dbod = .0036 ; 
                   lt.di.setText(String.valueOf(filter3(dbod*dconv2))+outden2) ;
                   break ;
                }
                case 8: {  // 2-ply magazine
                   dbod = .0031 ; 
                   lt.di.setText(String.valueOf(filter3(dbod*dconv2))+outden2) ;
                   break ;
                }
                case 9: {  // 1/16 gray cardboard
                   dbod = .016 ; 
                   lt.di.setText(String.valueOf(filter3(dbod*dconv2))+outden2) ;
                   break ;
                }
              }

              wbod = sabod * dbod ;

         // tail fairing
              outden2 = " oz/in2" ;
              if (lunits == 1) outden2 = " g/cs" ;

              mtfr = tmat.getSelectedIndex() ;
              if (mtfr > 0) {
                lt.dt.setBackground(Color.black) ;
                lt.dt.setForeground(Color.yellow) ;
              }
              if (mtfr == 0) {
                lt.dt.setBackground(Color.white) ;
                lt.dt.setForeground(Color.blue) ;
                lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))) ;
              }
              switch (mtfr) {
                case 0: {
                   V2 = Double.valueOf(lt.dt.getText()) ;
                   v2 = V2.doubleValue() ;
                   dtfr = v2/dconv2 ;
                   break ;
                }
                case 1: {   // 1/32 cardboard
                   dtfr = .0078 ; 
                   lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))+outden2) ;
                   break ;
                }
                case 2: {  // 1/8 plastic
                   dtfr = .06 ; 
                   lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))+outden2) ;
                   break ;
                }
                case 3: {  // 1/16 plastic
                   dtfr = .03 ; 
                   lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))+outden2) ;
                   break ;
                }
                case 4: {  // 1/32 plastic
                   dtfr = .015 ; 
                   lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))+outden2) ;
                   break ;
                }
                case 5: {  // 1/64  manilla  folder
                   dtfr = .0061 ; 
                   lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))+outden2) ;
                   break ;
                }
                case 6: {  // 3/16 sponge
                   dtfr = .0031 ; 
                   lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))+outden2) ;
                   break ;
                }
                case 7: {  // 2-ply paper
                   dtfr = .0036 ; 
                   lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))+outden2) ;
                   break ;
                }
                case 8: {  // 2-ply magazine
                   dtfr = .0031 ; 
                   lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))+outden2) ;
                   break ;
                }
                case 9: {  // 1/16 gray cardboard
                   dtfr = .016 ; 
                   lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))+outden2) ;
                   break ;
                }
              }

              wtfr = .25 * pi * dtfr * (bdiam + tdiam) * Math.sqrt(
                     4.0 * tlngth * tlngth +
                     ((bdiam - tdiam)*(bdiam - tdiam))) ;

              solve.comPute() ;
           }

           public void handleBar(Event evt) {     // body tube
             int i1,i2,i3,i4,i5 ;
             double v1,v2,v3,v4,v5 ;
             float fl1,fl2,fl3,fl4,fl5 ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;
             i4 = s4.getValue() ;
             i5 = s5.getValue() ;

             vmn1 = blmin;    vmx1 = blmax ;
             vmn2 = bdmin;    vmx2 = bdmax ;
             vmn3 = tlmin;    vmx3 = tlmax ;
             vmn4 = tdmin;    vmx4 = tdmax ;
             vmn5 = cdmin;    vmx5 = cdmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
             v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
             v5 = i5 * (vmx5 - vmn5)/ 1000. + vmn5 ;
 
             blngd = v1 ;
             blngth = blngd / lconv2 ;
             bdiamd = v2 ;
             bdiam = bdiamd / lconv2 ;
             brad = .5 * bdiam ;
             tlngd = v3 ;
             tlngth = tlngd / lconv2 ;
             tdiamd = v4 ;
             tdiam = tdiamd / lconv2 ;
             trad = .5 * tdiam ;
             cd = v5 ;
 
             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl3 = filter3(v3) ;
             fl4 = filter3(v4) ;
             fl5 = filter3(v5) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f3.setText(String.valueOf(fl3)) ;
             lt.f4.setText(String.valueOf(fl4)) ;
             lt.f5.setText(String.valueOf(fl5)) ;

             getGeom();

        // change limits on exit diameter
             vmx4 = tdmax = bdiamd ;
             v4 = tdiamd ;
             i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
             s4.setValue(i4) ;

             solve.comPute() ;

           }  // end handle
         }  // end right
 
         class Lt extends Panel {
           Rocket outerparent ;
           TextField f1, f2, di, f3, f4, dt, f5, bodyDrag ;
           Label l1, l2, l3, l4, l5, lab, lab2, bodyDragLabel ;
	     Choice dragSet;
           Button butgo ;
  
           Lt (Rocket target) {
              outerparent = target ;
              setLayout(new GridLayout(8,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;

              lab2 = new Label("Fairing", Label.CENTER) ;
              lab2.setForeground(Color.red) ;

              l1 = new Label("Length in", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)blngd),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("Diam in", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)bdiamd),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              di = new TextField(String.valueOf((float)dbod),5) ;
              di.setBackground(Color.black) ;
              di.setForeground(Color.yellow) ;

              l3 = new Label("Length in", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)tlngd),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("Diam in", Label.CENTER) ;
              f4 = new TextField(String.valueOf((float)tdiamd),5) ;
              f4.setBackground(Color.white) ;
              f4.setForeground(Color.black) ;

              l5 = new Label("Drag Coeff", Label.CENTER) ;
              f5 = new TextField(String.valueOf((float)cd),5) ;
              f5.setBackground(Color.white) ;
              f5.setForeground(Color.black) ;

              dt = new TextField(String.valueOf((float)dtfr),5) ;
              dt.setBackground(Color.black) ;
              dt.setForeground(Color.yellow) ;

              bodyDragLabel = new Label("Body Drag Co.");

              bodyDrag = new TextField(String.valueOf(cdBody),5);
              bodyDrag.setBackground(Color.black) ;
              bodyDrag.setForeground(Color.yellow) ;

              l5.setVisible(false);
              f5.setVisible(false);

              add(butgo) ;
              add(di) ;

              add(l1) ;
              add(f1) ;

              add(l2) ;
              add(f2) ;

              add(lab2) ;
              add(dt) ;

              add(l3) ;
              add(f3) ;

              add(l4) ;
              add(f4) ;

              add(bodyDragLabel);
              add(bodyDrag);

              add(l5) ;
              add(f5) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 ides = 1 ;
                 act.con.btm1.setBackground(Color.green) ;
                 act.con.btm1.setForeground(Color.black) ;
                 act.con.btm4.setBackground(Color.white) ;
                 act.con.btm4.setForeground(Color.blue) ;
                 butgo.setBackground(Color.green) ;
                 butgo.setForeground(Color.black) ;
              }
           }

           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4,V5,V6,V7 ;
             double v1,v2,v3,v4,v5,v6,v7 ;
             int i1,i2,i3,i4,i5 ;
             float fl1 ;

     // body tube 
             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
     // tube material
             if (mbod == 0) {
               V7 = Double.valueOf(di.getText()) ;
               v7 = V7.doubleValue() ;
               if (v7 <= wtzero*dconv2) {
                  v7 = wtzero*dconv2 ;
                  di.setText(String.valueOf(filter0(v7*dconv2))) ;
               }
               dbod = v7/dconv2 ;
             }

     // tube length
             blngd  = v1 ;
             vmn1 = blmin;   vmx1 = blmax ;
             if(v1 < vmn1) {
                 blngd = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 blngd =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             blngth = blngd / lconv2 ;
     // tube diameter
             bdiamd  = v2 ;
             vmn2 = bdmin;   vmx2 = bdmax ;
             if(v2 < vmn2) {
                 bdiamd = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 bdiamd =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             bdiam = bdiamd / lconv2;
             brad = .5 * bdiam ;

     // tail fairing
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
             V4 = Double.valueOf(f4.getText()) ;
             v4 = V4.doubleValue() ;
     // material
             if (mtfr == 0) {
               V6 = Double.valueOf(dt.getText()) ;
               v6 = V6.doubleValue() ;
               if (v6 <= wtzero*dconv2) {
                  v6 = wtzero*dconv2 ;
                  dt.setText(String.valueOf(filter0(v6*dconv2))) ;
               }
               dtfr = v6/dconv2 ;
             }
     // length
             tlngd  = v3 ;
             vmn3 = tlmin;   vmx3 = tlmax ;
             if(v3 < vmn3) {
                 tlngd = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 tlngd =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             tlngth = tlngd / lconv2 ;
     // diameter
             tdiamd  = v4 ;
             vmn4 = tdmin;   vmx4 = tdmax ;
             if(v4 < vmn4) {
                 tdiamd = v4 = vmn4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             if(v4 > vmx4) {
                 tdiamd =  v4 = vmx4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             tdiam = tdiamd / lconv2 ;
             trad = .5 * tdiam ;

     // drag coefficient
             V5 = Double.valueOf(f5.getText()) ;
             v5 = V5.doubleValue() ;
             cd  = v5 ;
             vmn5 = cdmin;   vmx5 = cdmax ;
             if(v5 < vmn5) {
                 cd = v5 = vmn5 ;
                 fl1 = (float) v5 ;
                 f5.setText(String.valueOf(fl1)) ;
             }
             if(v5 > vmx5) {
                 cd =  v5 = vmx5 ;
                 fl1 = (float) v5 ;
                 f5.setText(String.valueOf(fl1)) ;
             }

             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
             i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
             i5 = (int) (((v5 - vmn5)/(vmx5-vmn5))*1000.) ;
  
             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;
             rt.s4.setValue(i4) ;
             rt.s5.setValue(i5) ;

             getGeom();

        // change limits on exit diameter
             vmx4 = tdmax = bdiamd ;
             v4 = tdiamd ;
             i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
             rt.s4.setValue(i4) ;

             solve.comPute() ;

           }  // end handle
         }  //  end  left

         public void getGeom() {
             Double V1,V2,V3,V4,V5,V6 ;
             double v1,v2,v3,v4,v5,v6 ;
             int i1,i2,i3,i4 ;
             float fl1 ;

             vbod = pi * brad * brad * blngth ;
             sabod = pi * bdiam * blngth ;
             pabod = blngth * bdiam ;
             cgbod = .5 * blngth ;
             cpbod = .5 * blngth ;
             cabod = pi * brad * brad ;
             wbod = sabod * dbod ;

             vtfr = pi * tlngth * (trad*trad + trad*brad* brad*brad) / 3.0 ;
             satfr = pi * (brad + trad) * 
                     Math.sqrt(tlngth*tlngth + (brad-trad)*(brad-trad)) ;
             patfr = tlngth * (brad + trad) ;
             cgtfr = tlngth * (brad + 2.0 * trad) / (brad + trad) / 3.0 ;
             cptfr = tlngth * (brad + 2.0 * trad) / (brad + trad) / 3.0 ;
             caexit = pi * trad * trad ;
             wtfr = satfr * dtfr ;

        // make nose diameter match body diameter
             if (plngth <= 0.02 && qlngth <= 0.02) {
                nrad = brad ;
                ndiam = bdiam ;
                ndiamd = bdiamd ;
                v2 = ndiamd ;
                vmn2 = ndmin;  vmx2 = ndmax ;
                act.inp.nose.lt.f2.setText(String.valueOf(filter3(ndiamd))) ;
                i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                act.inp.nose.rt.s2.setValue(i2) ;
                if (ntype == 3) {
                  nlngth = nrad;
                  nlngd = v1 = nlngth * lconv2 ;
                  vmn1 = nlmin;  vmx1 = nlmax ;
                  act.inp.nose.lt.f1.setText(String.valueOf(filter3(nlngd))) ;
                  i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
                  act.inp.nose.rt.s1.setValue(i1) ;
                }
                act.inp.nose.getGeom() ;
             }

        // change the limits on the fin location
             flcmax = lconv2 * (blngth - flngth) ;
             i4 = (int) (((flocd - flcmin)/(flcmax-flcmin))*1000.) ;
             act.inp.fins.rt.s5.setValue(i4) ;

             if (nstage == 2) act.inp.enge.getFinGeom() ;

             return ;
         }  // end geom
       }   // end body

       class Boti extends Panel {  // body panel for bottle rocket
          Rocket outerparent ;
          Lt lt ;
          Rt rt ;
  
          Boti (Rocket target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Rocket outerparent ;
             Scrollbar s1,s2,s3,s4,s5;
             Choice tmat,faircho ;

             Rt (Rocket target) {

               int i3,i4,i5 ;
  
               outerparent = target ;
               setLayout(new GridLayout(7,1,10,5)) ;

               i3 = (int) (((btlngd - btlmin)/(btlmax-btlmin))*1000.) ;
               i4 = (int) (((btdiamd - btdmin)/(btdmax-btdmin))*1000.) ;
               i5 = (int) (((cd - cdmin)/(cdmax-cdmin))*1000.) ;
  
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
               s5 = new Scrollbar(Scrollbar.HORIZONTAL,i5,10,0,1000);
  
               faircho = new Choice() ;
               faircho.addItem("No Fairing") ;
               faircho.addItem("Fairing") ;
               faircho.select(1) ;

               tmat = new Choice() ;
               tmat.setBackground(Color.white) ;
               tmat.setForeground(Color.blue) ;
               tmat.addItem("<-- My Material") ;
               tmat.addItem("1/32 Cardboard") ;
               tmat.addItem("1/8 Plastic") ;
               tmat.addItem("1/16 Plastic") ;
               tmat.addItem("1/32 Plastic") ;
               tmat.addItem("1/64 Manilla") ;
               tmat.addItem("3/16 Sponge");
               tmat.addItem("2-ply Paper");
               tmat.addItem("2-ply Magazine");
               tmat.addItem("1/16 Gray Cardboard");
               tmat.select(1) ;

               add(new Label(" ", Label.CENTER)) ;
               add(faircho) ;
               add(tmat) ;
               add(s3) ;
               add(s4) ;
               add(new Label(" ", Label.CENTER)) ;
               add(s5) ;
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleMat(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
           public void handleMat(Event evt) {  // materials
              String outden2 ;
              Double V1,V2 ;
              double v1,v2 ;
 
         // fairing option
              btfair = faircho.getSelectedIndex() ;
              cd = .7 ;
              if (btfair == 0) cd = .8 ;
              act.inp.boti.lt.f5.setText(String.valueOf(filter3(cd))) ;

         // bottle tail fairing
              outden2 = " oz/in2" ;
              if (lunits == 1) outden2 = " g/cs" ;

              mbtfr = tmat.getSelectedIndex() ;
              if (mbtfr > 0) {
                lt.dt.setBackground(Color.black) ;
                lt.dt.setForeground(Color.yellow) ;
              }
              if (mbtfr == 0) {
                lt.dt.setBackground(Color.white) ;
                lt.dt.setForeground(Color.blue) ;
                lt.dt.setText(String.valueOf(filter3(dtfr*dconv2))) ;
              }
              switch (mbtfr) {
                case 0: {
                   V2 = Double.valueOf(lt.dt.getText()) ;
                   v2 = V2.doubleValue() ;
                   dbtfr = v2/dconv2 ;
                   break ;
                }
                case 1: {   // 1/32 cardboard
                   dbtfr = .0078 ; 
                   lt.dt.setText(String.valueOf(filter3(dbtfr*dconv2))+outden2) ;
                   break ;
                }
                case 2: {  // 1/8 plastic
                   dbtfr = .06 ; 
                   lt.dt.setText(String.valueOf(filter3(dbtfr*dconv2))+outden2) ;
                   break ;
                }
                case 3: {  // 1/16 plastic
                   dbtfr = .03 ; 
                   lt.dt.setText(String.valueOf(filter3(dbtfr*dconv2))+outden2) ;
                   break ;
                }
                case 4: {  // 1/32 plastic
                   dbtfr = .015 ; 
                   lt.dt.setText(String.valueOf(filter3(dbtfr*dconv2))+outden2) ;
                   break ;
                }
                case 5: {  // 1/64  manilla  folder
                   dbtfr = .0061 ; 
                   lt.dt.setText(String.valueOf(filter3(dbtfr*dconv2))+outden2) ;
                   break ;
                }
                case 6: {  // 3/16 sponge
                   dbtfr = .0031 ; 
                   lt.dt.setText(String.valueOf(filter3(dbtfr*dconv2))+outden2) ;
                   break ;
                }
                case 7: {  // 2-ply paper
                   dbtfr = .0036 ; 
                   lt.dt.setText(String.valueOf(filter3(dbtfr*dconv2))+outden2) ;
                   break ;
                }
                case 8: {  // 2-ply magazine
                   dbtfr = .0031 ; 
                   lt.dt.setText(String.valueOf(filter3(dbtfr*dconv2))+outden2) ;
                   break ;
                }
                case 9: {  // 1/16 gray cardboard
                   dbtfr = .016 ; 
                   lt.dt.setText(String.valueOf(filter3(dbtfr*dconv2))+outden2) ;
                   break ;
                }
              }

              wbtfr = .25 * pi * dbtfr * (bdiam + btdiam) * Math.sqrt(
                     4.0 * btlngth * btlngth +
                     ((bdiam - btdiam)*(bdiam - btdiam))) ;

              solve.comPute() ;
           }

           public void handleBar(Event evt) {     // bottle fairing
             int i3,i4,i5 ;
             double v3,v4,v5 ;
             float fl3,fl4,fl5 ;

             i3 = s3.getValue() ;
             i4 = s4.getValue() ;
             i5 = s5.getValue() ;

             vmn3 = btlmin;    vmx3 = btlmax ;
             vmn4 = btdmin;    vmx4 = btdmax ;
             vmn5 = cdmin;     vmx5 = cdmax ;

             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
             v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
             v5 = i5 * (vmx5 - vmn5)/ 1000. + vmn5 ;
 
             btlngd = v3 ;
             btlngth = btlngd / lconv2 ;
             btdiamd = v4 ;
             btdiam = btdiamd / lconv2 ;
             btrad = .5 * btdiam ;
             cd = v5 ;
 
             fl3 = filter3(v3) ;
             fl4 = filter3(v4) ;
             fl5 = filter3(v5) ;

             lt.f3.setText(String.valueOf(fl3)) ;
             lt.f4.setText(String.valueOf(fl4)) ;
             lt.f5.setText(String.valueOf(fl5)) ;

             getGeom();

             solve.comPute() ;

           }  // end handle
         }  // end right
 
         class Lt extends Panel {
           Rocket outerparent ;
           TextField f3, f4, f5,  dt, bodyDrag ;
           Label l3, l4, l5, lab, lab2, bodyDragLabel ;
           Button butgo,but2,but24,but20 ;
  
           Lt (Rocket target) {
              outerparent = target ;
              setLayout(new GridLayout(7,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;
 
              but2 = new Button("2 Liter") ;
              but2.setBackground(Color.yellow) ;
              but2.setForeground(Color.black) ;
  
              but24 = new Button("24 oz") ;
              but24.setBackground(Color.blue) ;
              but24.setForeground(Color.white) ;
 
              but20 = new Button("20 oz") ;
              but20.setBackground(Color.blue) ;
              but20.setForeground(Color.white) ;

              lab2 = new Label("Fairing", Label.CENTER) ;
              lab2.setForeground(Color.red) ;

              l3 = new Label("Length in", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)btlngd),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("Diam in", Label.CENTER) ;
              f4 = new TextField(String.valueOf((float)btdiamd),5) ;
              f4.setBackground(Color.white) ;
              f4.setForeground(Color.black) ;

              l5 = new Label("Drag Coeff", Label.CENTER) ;
              f5 = new TextField(String.valueOf((float)cd),5) ;
              f5.setBackground(Color.white) ;
              f5.setForeground(Color.black) ;

              dt = new TextField(String.valueOf((float)dtfr),5) ;
              dt.setBackground(Color.black) ;
              dt.setForeground(Color.yellow) ;

              bodyDragLabel = new Label("Body Drag Co.");

              bodyDrag = new TextField(String.valueOf(cdBody),5);
              bodyDrag.setBackground(Color.black) ;
              bodyDrag.setForeground(Color.yellow) ;

              add(butgo) ;
              add(but2) ;

              add(but20) ;
              add(but24) ;

              add(lab2) ;
              add(dt) ;

              add(l3) ;
              add(f3) ;

              add(l4) ;
              add(f4) ;

              add(bodyDragLabel) ;
              add(bodyDrag) ;

              add(l5) ;
              add(f5) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 ides = 1 ;
                 act.con.btm1.setBackground(Color.green) ;
                 act.con.btm1.setForeground(Color.black) ;
                 act.con.btm4.setBackground(Color.white) ;
                 act.con.btm4.setForeground(Color.blue) ;
                 butgo.setBackground(Color.green) ;
                 butgo.setForeground(Color.black) ;
              }

              if(label.equals("2 Liter")) {
                 bdiam = 4.0 ;
                 bdiamd = bdiam * lconv2 ;
                 brad  = 2.0 ;
                 blngth = 12.0 ;
                 blngd = blngth * lconv2 ;
                 wbod = 1.665 ;
                 cgbod = 6.25 ;
                 cpbod = 6.25 ;
                 pabod = 39.75 ;
                 cabod = 12.56 ;
                 volbot = 115. ;
                 but2.setBackground(Color.yellow) ;
                 but2.setForeground(Color.black) ;
                 but20.setBackground(Color.blue) ;
                 but20.setForeground(Color.white) ;
                 but24.setBackground(Color.blue) ;
                 but24.setForeground(Color.white) ;
                 getGeom();
                 solve.comPute() ;
              }

              if(label.equals("20 oz")) {
                 bdiam = 3.0 ;
                 bdiamd = bdiam * lconv2 ;
                 brad  = 1.5 ;
                 blngth = 7.0 ;
                 blngd = blngth * lconv2 ;
                 wbod = .549 ;
                 cgbod = 3.75 ;
                 cpbod = 3.75 ;
                 pabod = 17.4 ;
                 cabod = 7.068 ;
                 volbot = 115. * 591. / 2000. ;
                 but2.setBackground(Color.blue) ;
                 but2.setForeground(Color.white) ;
                 but20.setBackground(Color.yellow) ;
                 but20.setForeground(Color.black) ;
                 but24.setBackground(Color.blue) ;
                 but24.setForeground(Color.white) ;
                 getGeom();
                 solve.comPute() ;
              }

              if(label.equals("24 oz")) {
                 bdiam = 3.0 ;
                 bdiamd = bdiam * lconv2 ;
                 brad  = 1.5 ;
                 blngth = 9.0 ;
                 blngd = blngth * lconv2 ;
                 wbod = .706 ;
                 cgbod = 4.75 ;
                 cpbod = 4.75 ;
                 pabod = 22.4 ;
                 cabod = 7.068 ;
                 volbot = 115. * 710. / 2000. ;
                 but2.setBackground(Color.blue) ;
                 but2.setForeground(Color.white) ;
                 but20.setBackground(Color.blue) ;
                 but20.setForeground(Color.white) ;
                 but24.setBackground(Color.yellow) ;
                 but24.setForeground(Color.black) ;
                 getGeom();
                 solve.comPute() ;
              }
           }

           public void handleText(Event evt, Object arg) {
             Double V3,V4,V5,V6 ;
             double v3,v4,v5,v6 ;
             int i3,i4,i5 ;
             float fl1 ;

     // tail fairing
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
             V4 = Double.valueOf(f4.getText()) ;
             v4 = V4.doubleValue() ;
             V5 = Double.valueOf(f5.getText()) ;
             v5 = V5.doubleValue() ;
     // material
             if (mbtfr == 0) {
               V6 = Double.valueOf(dt.getText()) ;
               v6 = V6.doubleValue() ;
               if (v6 <= wtzero*dconv2) {
                  v6 = wtzero*dconv2 ;
                  dt.setText(String.valueOf(filter0(v6*dconv2))) ;
               }
               dbtfr = v6/dconv2 ;
             }
     // length
             btlngd  = v3 ;
             vmn3 = btlmin;   vmx3 = btlmax ;
             if(v3 < vmn3) {
                 btlngd = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 btlngd =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             btlngth = btlngd / lconv2 ;
     // diameter
             btdiamd  = v4 ;
             vmn4 = btdmin;   vmx4 = btdmax ;
             if(v4 < vmn4) {
                 btdiamd = v4 = vmn4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             if(v4 > vmx4) {
                 btdiamd =  v4 = vmx4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             btdiam = btdiamd / lconv2 ;
             btrad = .5 * btdiam ;
      // drag coefficient
             cd  = v5 ;
             vmn5 = cdmin;   vmx5 = cdmax ;
             if(v5 < vmn5) {
                 cd = v5 = vmn5 ;
                 fl1 = (float) v5 ;
                 f5.setText(String.valueOf(fl1)) ;
             }
             if(v5 > vmx5) {
                 cd =  v5 = vmx5 ;
                 fl1 = (float) v5 ;
                 f5.setText(String.valueOf(fl1)) ;
             }

             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
             i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
             i5 = (int) (((v5 - vmn5)/(vmx5-vmn5))*1000.) ;
  
             rt.s3.setValue(i3) ;
             rt.s4.setValue(i4) ;
             rt.s5.setValue(i5) ;

             getGeom();

             solve.comPute() ;

           }  // end handle
         }  //  end  left

         public void getGeom() {
             Double V1,V2,V3,V4,V5,V6 ;
             double v1,v2,v3,v4,v5,v6 ;
             int i1,i2,i3,i4 ;
             float fl1 ;

             sabtfr = pi * (brad + btrad) * 
                     Math.sqrt(btlngth*btlngth + (brad-btrad)*(brad-btrad)) ;
             pabtfr = btlngth * (brad + btrad) ;
             cgbtfr = btlngth * (brad + 2.0 * btrad) / (brad + btrad) / 3.0 ;
             cpbtfr = btlngth * (brad + 2.0 * btrad) / (brad + btrad) / 3.0 ;
             cabexit = pi * btrad * btrad ;
             wbtfr = sabtfr * dbtfr ;

        // make nose diameter match body diameter
             if (plngth <= 0.02 && qlngth <= 0.02) {
                nrad = brad ;
                ndiam = bdiam ;
                ndiamd = bdiamd ;
                v2 = ndiamd ;
                vmn2 = ndmin;  vmx2 = ndmax ;
                act.inp.nose.lt.f2.setText(String.valueOf(filter3(ndiamd))) ;
                i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                act.inp.nose.rt.s2.setValue(i2) ;
                if (ntype == 3) {
                  nlngth = nrad;
                  nlngd = v1 = nlngth * lconv2;
                  vmn1 = nlmin;  vmx1 = nlmax ;
                  act.inp.nose.lt.f1.setText(String.valueOf(filter3(nlngd))) ;
                  i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
                  act.inp.nose.rt.s1.setValue(i1) ;
                }
                act.inp.nose.getGeom() ;
             }

             return ;
         }  // end geom
       }   // end bottle body

       class Nose extends Panel {
          Rocket outerparent ;
          Lt lt ;
          Rt rt ;
  
          Nose (Rocket target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Rocket outerparent ;
             Scrollbar s1,s2,s3;
             Choice nmat,ncho,rcho ;

             Rt (Rocket target) {

               int i1,i2,i3 ;
  
               outerparent = target ;
               setLayout(new GridLayout(7,1,10,5)) ;

               i1 = (int) (((nlngd - nlmin)/(nlmax-nlmin))*1000.) ;
               i2 = (int) (((ndiamd - ndmin)/(ndmax-ndmin))*1000.) ;
               i3 = (int) (((wbald - wmin)/(wmax-wmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
  
               nmat = new Choice() ;
               nmat.setBackground(Color.white) ;
               nmat.setForeground(Color.blue) ;
               nmat.addItem("<-- My Solid Material") ;
               nmat.addItem("Solid Balsa") ;
               nmat.addItem("Solid Plastic");
               nmat.addItem("Solid Foam");
               nmat.addItem("Solid Rubber");
               nmat.addItem("<-- My Hollow Material") ;
               nmat.addItem("1/16 Hollow Plastic");
               nmat.addItem("1/16 Hollow Cardboard");
               nmat.select(1) ;
  
               ncho = new Choice() ;
               ncho.addItem("Conical") ;
               ncho.addItem("Elliptic") ;
               ncho.addItem("Parabolic");
               ncho.addItem("Spherical");
               ncho.addItem("None");
               ncho.select(0) ;
  
               rcho = new Choice() ;
               rcho.addItem("None");
               rcho.addItem("1 ft Parachute") ;
               rcho.addItem("2 ft Parachute") ;
               rcho.addItem("3 ft Parachute");
               rcho.addItem("Streamer");
               rcho.select(0) ;
  
               add(nmat) ;
               add(ncho) ;
               add(s1) ;
               add(s2) ;
               add(new Label(" ", Label.CENTER)) ;
               add(rcho) ;
               add(s3) ;
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleMat(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
           public void handleMat(Event evt) {  // choices and material
              String outden3,outden2 ;
              Double V1 ;
              double v1 ;

              outden2 = " oz/in2" ;
              if (lunits == 1) outden2 = " g/cs" ;
              outden3 = " oz/in3" ;
              if (lunits == 1) outden3 = " g/cc" ;

         //nose material 
               mnose = nmat.getSelectedIndex() ;
               if (mnose > 0) {
                  lt.di.setBackground(Color.black) ;
                  lt.di.setForeground(Color.yellow) ;
               }
               if (mnose == 0) {
                  lt.di.setBackground(Color.white) ;
                  lt.di.setForeground(Color.blue) ;
                  lt.di.setText(String.valueOf(filter3(dnose*dconv3))) ;
               }
               if (mnose == 5) {
                  lt.di.setBackground(Color.white) ;
                  lt.di.setForeground(Color.blue) ;
                  lt.di.setText(String.valueOf(filter3(dnose*dconv2))) ;
               }

               switch (mnose) {
                 case 0: {    // my solid material
                   V1 = Double.valueOf(lt.di.getText()) ;
                   v1 = V1.doubleValue() ;
                   dnose = v1/dconv3 ;
                   break ;
                 }
                 case 1: {  // solid balsa
                   dnose = .074 ;
                   lt.di.setText(String.valueOf(filter3(dnose*dconv3)) + outden3) ;
                   break ;
                 }
                 case 2: { // solid plastic
                   dnose = .606 ;
                   lt.di.setText(String.valueOf(filter3(dnose*dconv3)) + outden3) ;
                   break ;
                 }
                 case 3: { // solid foam
                   dnose = .104 ;
                   lt.di.setText(String.valueOf(filter3(dnose*dconv3)) + outden3) ;
                   break ;
                 }
                 case 4: { // solid rubber
                   dnose = .22 ;
                   lt.di.setText(String.valueOf(filter3(dnose*dconv3)) + outden3) ;
                   break ;
                 }
                 case 5: {    // my hollow material
                   V1 = Double.valueOf(lt.di.getText()) ;
                   v1 = V1.doubleValue() ;
                   dnose = v1/dconv2 ;
                   break ;
                 }
                 case 6: {  //  hollow plastic
                   dnose = .03 ;
                   lt.di.setText(String.valueOf(filter3(dnose*dconv2)) + outden2) ;
                   break ;
                 }
                 case 7: {  //  hollow cardboard
                   dnose = .016 ;
                   lt.di.setText(String.valueOf(filter3(dnose*dconv2)) + outden2) ;
                   break ;
                 }
               }

               ntype = ncho.getSelectedIndex() ;
               rtype = rcho.getSelectedIndex() ;
               if (rktype == 2) {
                 cd = .7 ;
                 if (ntype == 4) cd = .75 ;
                 act.inp.boti.lt.f5.setText(String.valueOf(filter3(cd))) ;
               } 
        // recovery system
               switch (rtype) {  
                  case 0: {        // none
                     wpar = 0.0 ; 
                     cdrec = 0.0 ;
                     carec = 0.0 ;
                     break ;
                  }
                  case 1: {   // 1 sq foot parachute
                     wpar = .1 ; 
                     cdrec = 1.7 ;
                     carec = 144.0 ;
                     break ;
                  }
                  case 2: {   // 2 sq foot parachute
                     wpar = .2;
                     cdrec = 1.7 ;
                     carec = 288.0 ;
                     break ;
                  }
                  case 3: {   // 3 sq foot parachute
                     wpar = .3; 
                     cdrec = 1.7 ;
                     carec = 432.0 ;
                     break ;
                  }
                  case 4: {   // streamer
                     wpar = .05; 
                     cdrec = .9 ;
                     carec = 10.0 ;
                     break ;
                  }
              }

              getGeom() ;

              solve.comPute() ;
           }

           public void handleBar(Event evt) {     // nose cone
             int i1,i2,i3 ;
             double v1,v2,v3 ;
             float fl1,fl2,fl3 ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;

             vmn1 = nlmin;    vmx1 = nlmax ;
             vmn2 = ndmin;    vmx2 = ndmax ;
             vmn3 = wmin;     vmx3 = wmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
 
             nlngd = v1 ;
             nlngth = nlngd / lconv2 ;
             ndiamd = v2 ;
             ndiam = ndiamd / lconv2 ;
             nrad = .5 * ndiam ;
             wbald = v3 ;
             wbal = wbald / fconv ;
             if (ntype == 3) {
                nlngth = nrad ;
                nlngd = v1 = nlngth * lconv2 ;
                i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
                s1.setValue(i1) ;
             }

             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl3 = filter3(v3) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f3.setText(String.valueOf(fl3)) ;

             getGeom() ;

             solve.comPute() ;

           }  // end handle
         }  // end right
 
         class Lt extends Panel {
           Rocket outerparent ;
           TextField f1, f2, f3, di, noseDrag ;
           Label l1, l2, l3, lab, lab2, noseDragLabel ;
           Button butgo ;
  
           Lt (Rocket target) {
              outerparent = target ;
              setLayout(new GridLayout(7,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;

              lab2 = new Label("Recovery", Label.CENTER) ;
              lab2.setForeground(Color.red) ;

              l1 = new Label("Length in", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)nlngd),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("Diam in", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)ndiamd),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              l3 = new Label("Ballast oz", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)wbald),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              di = new TextField(String.valueOf((float)dbod),5) ;
              di.setBackground(Color.black) ;
              di.setForeground(Color.yellow) ;

              noseDragLabel = new Label("Nose Drag Co.", Label.RIGHT);

              noseDrag = new TextField(String.valueOf(cdNose),5);
              noseDrag.setBackground(Color.black) ;
              noseDrag.setForeground(Color.yellow) ;

              add(butgo) ;
              add(di) ;

              add(new Label(" ", Label.RIGHT)) ;
              add(new Label("Shape:", Label.RIGHT)) ;

              add(l1) ;
              add(f1) ;

              add(l2) ;
              add(f2) ;

              add(noseDragLabel) ;
              add(noseDrag) ;

              add(lab2) ;
              add(new Label("System:", Label.RIGHT)) ;

              add(l3) ;
              add(f3) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 ides = 1 ;
                 act.con.btm1.setBackground(Color.green) ;
                 act.con.btm1.setForeground(Color.black) ;
                 act.con.btm4.setBackground(Color.white) ;
                 act.con.btm4.setForeground(Color.blue) ;
                 butgo.setBackground(Color.green) ;
                 butgo.setForeground(Color.black) ;
              }
           }

           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4 ;
             double v1,v2,v3,v4 ;
             int i1,i2,i3 ;
             float fl1 ;

             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;

     // materials
             if (mnose == 0) {
               V4 = Double.valueOf(di.getText()) ;
               v4 = V4.doubleValue() ;
               if (v4 <= wtzero*dconv3) {
                  v4 = wtzero*dconv3 ;
                  di.setText(String.valueOf(filter0(v4*dconv3))) ;
               }
               dnose = v4/dconv3 ;
             }
             if (mnose == 5) {
               V4 = Double.valueOf(di.getText()) ;
               v4 = V4.doubleValue() ;
               if (v4 <= wtzero*dconv2) {
                  v4 = wtzero*dconv2 ;
                  di.setText(String.valueOf(filter0(v4*dconv2))) ;
               }
               dnose = v4/dconv2 ;
             }

     // nose length
             nlngd  = v1 ;
             vmn1 = nlmin;   vmx1 = nlmax ;
             if(v1 < vmn1) {
                 nlngd = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 nlngd =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             nlngth = nlngd / lconv2 ;

     // nose diameter
             ndiamd  = v2 ;
             vmn2 = ndmin;   vmx2 = ndmax ;
             if(v2 < vmn2) {
                 ndiamd = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 ndiamd =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             ndiam = ndiamd / lconv2 ;
             nrad = .5 * ndiam;
             if (ntype == 3) {
                nlngth = nrad ;
                nlngd = v1 = nlngth * lconv2 ;
                fl1 = (float) nlngd ;
                f1.setText(String.valueOf(fl1)) ;
             }

     // ballast weight
             wbald  = v3 ;
             vmn3 = wmin;   vmx3 = wmax ;
             if(v3 < vmn3) {
                 wbald = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 wbald =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             wbal = wbald / fconv ;

             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
  
             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;

             getGeom() ;

             solve.comPute() ;

           }  // end handle
         }  //  end  left

         public void getGeom() {
           double v1 ;
           int i1 ;

           switch (ntype) {
              case 0: {  // cone
                vnose = pi * nrad * nrad * nlngth / 3.0 ; 
                sanose = pi * nrad * Math.sqrt(nlngth*nlngth + nrad*nrad) ;
                panose = nlngth * nrad ;
                cpnose = .3333 * nlngth ; 
                break ;
              }
              case 1: {  // ellipse
                vnose = 2.0 * pi * nrad*nrad*nlngth / 3.0 ;
                panose = .5 * pi * nrad * nlngth ;
                if ((nlngth - nrad) > .01) {
                  nfact = nlngth / Math.sqrt((nlngth*nlngth - nrad*nrad)/
                          (nlngth*nlngth)) ;
                  nfact2 = (nfact*nfact-nlngth*nlngth)
                         * (nfact*nfact-nlngth*nlngth)
                         * (nfact*nfact-nlngth*nlngth);
                  sanose = pi * nrad * (nrad + nfact * Math.asin(nlngth/nfact));
                  cpnose = (2.0 * pi * nrad /(3.0 * sanose * nfact))*
                     (nfact*nfact*nfact - Math.sqrt(nfact2)) ; 
                }
                if (Math.abs(nrad - nlngth) <= .01) {
                  sanose = 2.0 * pi * nrad * nrad ;
                  cpnose = .5 * nrad ;
                }
                if ((nrad - nlngth) > .01) {
                  nfact = Math.sqrt((nrad*nrad - nlngth*nlngth)/(nrad*nrad));
                  nfact2 = nlngth*nlngth/nfact/nrad ;
                  sanose = pi*(nrad*nrad + ((nlngth*nlngth)/(2.0*nfact))*
                      Math.log((1.0+nfact)/(1.0-nfact))) ;
                  cpnose = (2.0*pi*nrad/(3.0*sanose*nfact2)) *
                      (Math.sqrt((nlngth*nlngth + nfact2*nfact2) *
                                 (nlngth*nlngth + nfact2*nfact2) *
                                 (nlngth*nlngth + nfact2*nfact2))
                       - nfact2*nfact2*nfact2)  ;
                }
                break ;
              }
              case 2: {  // parabola
                vnose = 8.0 * pi * nrad * nrad * nlngth / 15.0 ;
                nfact =nlngth*nlngth/(2.0*nrad);
                nfact2 = nfact*nfact + nlngth*nlngth ;
                sanose = (pi / (8.0*nfact*nfact)) * (
                        (2.0*nlngth*nlngth*nlngth - nlngth*nfact*nfact)
                           * Math.sqrt(nfact2)
                     + (4.0*nlngth*nlngth*nfact*nfact+nfact*nfact*nfact*nfact)
                           * Math.log((nlngth + Math.sqrt(nfact2))/nfact));
                panose = 4.0 * nrad * nlngth / 3.0 ;
                cpnose = (pi / (15.0 * sanose * nfact*nfact))*
                   ((2.0*nlngth*nlngth + 2.0*nfact*nfact)
                         * Math.sqrt(nfact2*nfact2*nfact2)
                    - 2.0 * nfact*nfact*nfact*nfact*nfact
                    - 5.0 * nfact*nfact*nfact * nlngth*nlngth) ;
                         
                break ;
              }
              case 3: {  // sphere
                nlngth = nrad ;
                vnose = 2.0 * pi * nrad * nrad * nrad / 3.0 ;
                sanose = 2.0 * pi * nrad * nrad ;
                panose = .5 * pi * nrad * nrad ;
                cpnose = .5 * nrad ;
                nlngd = v1 = nlngth * lconv2 ;
                vmn1 = nlmin;  vmx1 = nlmax ;
                act.inp.nose.lt.f1.setText(String.valueOf(filter3(nlngd))) ;
                i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
                act.inp.nose.rt.s1.setValue(i1) ;
                break ;
              }
              case 4: {  // none
                vnose = 0.0 ;
                sanose = 0.0 ;
                panose = 0.0 ;
                cpnose = 0.0 ;
                break ;
              }
           } 

           if (mnose <= 4) {   // solid nose
              switch (ntype) {
                case 0: {  // cone
                  cgnose = .25 * nlngth ; 
                  break ;
                }
                case 1: {  // ellipse
                  cgnose = 3.0 * nlngth / 8.0 ;
                  break ;
                }
                case 2: {  // parabola
                  cgnose = 5.0 * nlngth / 16.0 ;
                  break ;
                }
                case 3: {  // sphere
                  cgnose = 3.0 * nlngth / 8.0 ;
                  break ;
                }
                case 4: {  // none
                  cgnose = 0.0 ;
                  break ;
                }
              } 
              wnose = vnose * dnose ;
           }
           if (mnose >= 5) {   // hollow nose
              switch (ntype) {
                case 0: {  // cone
                  cgnose = .3333 * nlngth ; 
                  break ;
                }
                case 1: {  // ellipse
                  if ((nlngth - nrad) > .001) {
                    cgnose = (2.0 * pi * nrad /(3.0 * sanose * nfact))*
                     (nfact*nfact*nfact - Math.sqrt(nfact2)) ; 
                  }
                  if (Math.abs(nlngth-nrad) < .001)cgnose = .5 * nrad ;
                  if ((nrad - nlngth) > .001) {
                    cgnose = (2.0 * pi * nrad /(3.0 * sanose * nfact2)) *
                      (Math.sqrt((nlngth*nlngth + nfact2*nfact2) *
                                 (nlngth*nlngth + nfact2*nfact2) *
                                 (nlngth*nlngth + nfact2*nfact2))
                       - nfact2*nfact2*nfact2)  ;
                  }

                  break ;
                }
                case 2: {  // parabola
                  cgnose = (pi / (15.0 * sanose * nfact*nfact))*
                   ((2.0*nlngth*nlngth + 2.0*nfact*nfact)
                          * Math.sqrt(nfact2*nfact2*nfact2)
                    - 2.0 * nfact*nfact*nfact*nfact*nfact
                    - 5.0 * nfact*nfact*nfact * nlngth*nlngth) ;
                  break ;
                }
                case 3: {  // sphere
                  cgnose = nrad / 2.0 ;
                  break ;
                }
                case 4: {  // none
                  cgnose = 0.0 ;
                  break ;
                }
              } 
              wnose = sanose * dnose ;
           }
           canose = pi * nrad * nrad ;
           return ;
         }  // end geom
       }   // end nose

       class Fins extends Panel {
          Rocket outerparent ;
          Lt lt ;
          Rt rt ;
  
          Fins (Rocket target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Rocket outerparent ;
             Scrollbar s1,s2,s3,s4,s5;
             Choice fmat,fcho ;

             Rt (Rocket target) {

               int i1,i2,i3,i4,i5 ;
  
               outerparent = target ;
               setLayout(new GridLayout(8,1,10,5)) ;

               i1 = (int) (((flngd - flmin)/(flmax-flmin))*1000.) ;
               i2 = (int) (((fwid - fwmin)/(fwmax-fwmin))*1000.) ;
               i3 = (int) (((fleang - flemin)/(flemax-flemin))*1000.) ;
               i4 = (int) (((fteang - ftemin)/(ftemax-ftemin))*1000.) ;
               i5 = (int) (((flocd - blmin)/(blmax-blmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
               s5 = new Scrollbar(Scrollbar.HORIZONTAL,i5,10,0,1000);
  
               fmat = new Choice() ;
               fmat.setBackground(Color.white) ;
               fmat.setForeground(Color.blue) ;
               fmat.addItem("<-- My Material") ;
               fmat.addItem("1/16 Balsa") ;
               fmat.addItem("1/8 Balsa");
               fmat.addItem("1/16 Plastic");
               fmat.addItem("1/8 Plastic");
               fmat.addItem("1/16 Gray Cardboard");
               fmat.addItem("1/8 Foam");
               fmat.addItem("1/64 Manilla") ;
               fmat.addItem("1-ply Paper");
               fmat.select(1) ;
  
               fcho = new Choice() ;
               fcho.addItem("Trapezoidal") ;
               fcho.addItem("Elliptical") ;
               fcho.select(0) ;
  
               add(fmat) ;
               add(fcho) ;
               add(s5) ;
               add(s1) ;
               add(s2) ;
               add(s3) ;
               add(s4) ;
               add(new Label(" ", Label.CENTER));
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleMat(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
           public void handleMat(Event evt) {  // choices and material
              String outden2 ;
              Double V1 ;
              double v1 ;

              outden2 = " oz/in2" ;
              if (lunits == 1) outden2 = " g/cs" ;
         //fin material 
               mfin = fmat.getSelectedIndex() ;
               if (mfin > 0) {
                  lt.di.setBackground(Color.black) ;
                  lt.di.setForeground(Color.yellow) ;
               }
               if (mfin == 0) {
                  lt.di.setBackground(Color.white) ;
                  lt.di.setForeground(Color.blue) ;
                  lt.di.setText(String.valueOf(filter3(dfin*dconv2))) ;
               }

               switch (mfin) {
                   case 0: {
                        V1 = Double.valueOf(lt.di.getText()) ;
                        v1 = V1.doubleValue() ;
                        dfin = v1/dconv2 ;
                        break ;
                   }
                   case 1: {   // 1/16 balsa
                      dfin = .0046 ; 
                      lt.di.setText(String.valueOf(filter3(dfin*dconv2))+outden2) ;
                      break ;
                   }
                   case 2: {  // 1/8 balsa
                      dfin = .0092 ; 
                      lt.di.setText(String.valueOf(filter3(dfin*dconv2))+outden2) ;
                      break ;
                   }
                   case 3: {   // 1/16 plastic
                      dfin = .03 ; 
                      lt.di.setText(String.valueOf(filter3(dfin*dconv2))+outden2) ;
                      break ;
                   }
                   case 4: {  // 1/8 plastic
                      dfin = .06 ; 
                      lt.di.setText(String.valueOf(filter3(dfin*dconv2))+outden2) ;
                      break ;
                   }
                   case 5: {  // 1/16 gray cardboard
                      dfin = .016 ; 
                      lt.di.setText(String.valueOf(filter3(dfin*dconv2))+outden2) ;
                      break ;
                   }
                   case 6: {  // 1/8 foam
                      dfin = .013 ; 
                      lt.di.setText(String.valueOf(filter3(dfin*dconv2))+outden2) ;
                      break ;
                   }
                   case 7: {  // 1/64  manilla  folder
                      dfin = .0061 ; 
                      lt.di.setText(String.valueOf(filter3(dfin*dconv2))+outden2) ;
                      break ;
                   }
                   case 8: {  // 1-ply paper
                      dfin = .0018 ; 
                      lt.di.setText(String.valueOf(filter3(dfin*dconv2))+outden2) ;
                      break ;
                   }
               }

               fintype = fcho.getSelectedIndex() ;
 
               getGeom();

               solve.comPute() ;
           }

           public void handleBar(Event evt) {     // fins
             int i1,i2,i3,i4,i5 ;
             double v1,v2,v3,v4,v5 ;
             float fl1,fl2,fl3,fl4,fl5 ;

             if (fintype == 0) {    // trapezoidal
               i3 = s3.getValue() ;
               i4 = s4.getValue() ;

               vmn3 = flemin;   vmx3 = flemax ;
               vmn4 = ftemin;   vmx4 = ftemax ;

               v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
               v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;

               fleang = v3 ;
               ftanle = Math.tan(convdr*fleang) ;
               fteang = v4 ;
               ftante = Math.tan(convdr*fteang) ;

               fl3 = filter0(v3) ;
               fl4 = filter0(v4) ;

               lt.f3.setText(String.valueOf(fl3)) ;
               lt.f4.setText(String.valueOf(fl4)) ;
             }

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i5 = s5.getValue() ;

             vmn1 = flmin;    vmx1 = flmax ;
             vmn2 = fwmin;    vmx2 = fwmax ;
             vmn5 = flcmin;   vmx5 = flcmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v5 = i5 * (vmx5 - vmn5)/ 1000. + vmn5 ;

             flngd = v1 ;
             flngth = flngd / lconv2 ;
             fwid = v2 ;
             fwidth = fwid / lconv2 ;
             flocd = v5 ;
             floc = flocd / lconv2 ;

        // limits on width for realistic geometry

             if (fintype == 0) {     // trapezoidal
               if ((ftanle - ftante) >= .02) {
                  fwmax = lconv2 * (flngth / (ftanle - ftante)) ;
                  if (fwmax >= fwex * lconv2 ) fwmax = fwex * lconv2 ;
                  vmx2 = fwmax ;
               }
               if (fwid >= fwmax) {
                  fwid = v2 = fwmax ; 
                  fwidth = fwid / lconv2 ;
               }
               i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
               s2.setValue(i2) ;
             }

             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl5 = filter3(v5) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f5.setText(String.valueOf(fl5)) ;

             getGeom() ;

        // reset the limits on location for change in fin size
             flcmin = - .5 * flngd;  flcmax = lconv2 * (blngth - flngth) ;
             i5 = (int) (((flocd - flcmin)/(flcmax-flcmin))*1000.) ;
             s5.setValue(i5) ;

             solve.comPute() ;

           }  // end handle
         }  // end right
 
         class Lt extends Panel {
           Rocket outerparent ;
           TextField f1, f2, f3, f4, f5, f6,  di, finDrag ;
           Label l1, l2, l3, l4, l5, lab, finDragLabel ;
           Button butgo ;
  
           Lt (Rocket target) {
              outerparent = target ;
              setLayout(new GridLayout(8,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;

              l1 = new Label("Length in", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)flngd),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("Width in", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)fwid),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              l3 = new Label("L.E. Ang", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)fleang),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("T.E. Ang", Label.CENTER) ;
              f4 = new TextField(String.valueOf((float)fteang),5) ;
              f4.setBackground(Color.white) ;
              f4.setForeground(Color.black) ;

              l5 = new Label("Locate in", Label.CENTER) ;
              f5 = new TextField(String.valueOf((float)flocd),5) ;
              f5.setBackground(Color.white) ;
              f5.setForeground(Color.black) ;

              f6 = new TextField(String.valueOf((float)numfin),5) ;
              f6.setBackground(Color.white) ;
              f6.setForeground(Color.black) ;

              di = new TextField(String.valueOf((float)dbod),5) ;
              di.setBackground(Color.black) ;
              di.setForeground(Color.yellow) ;

              finDragLabel = new Label("Fin Drag Coef.", Label.RIGHT);

              finDrag = new TextField(String.valueOf(cdFins),5);
              finDrag.setBackground(Color.black) ;
              finDrag.setForeground(Color.yellow) ;

              add(butgo) ;
              add(di) ;

              add(new Label("Number:", Label.RIGHT)) ;
              add(f6) ;

              add(l5) ;
              add(f5) ;

              add(l1) ;
              add(f1) ;

              add(l2) ;
              add(f2) ;

              add(l3) ;
              add(f3) ;

              add(l4) ;
              add(f4) ;

              add(finDragLabel);
              add(finDrag);
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 ides = 1 ;
                 act.con.btm1.setBackground(Color.green) ;
                 act.con.btm1.setForeground(Color.black) ;
                 act.con.btm4.setBackground(Color.white) ;
                 act.con.btm4.setForeground(Color.blue) ;
                 butgo.setBackground(Color.green) ;
                 butgo.setForeground(Color.black) ;
              }
           }

           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4,V5,V6,V7 ;
             double v1,v2,v3,v4,v5,v6,v7 ;
             int i1,i2,i3,i4,i5 ;
             float fl1 ;

             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
             V4 = Double.valueOf(f4.getText()) ;
             v4 = V4.doubleValue() ;
             V5 = Double.valueOf(f5.getText()) ;
             v5 = V5.doubleValue() ;
             V6 = Double.valueOf(f6.getText()) ;
             v6 = V6.doubleValue() ;
     // materials
             if (mfin == 0) {
               V7 = Double.valueOf(di.getText()) ;
               v7 = V7.doubleValue() ;
               if (v7 <= wtzero*dconv2) {
                  v7 = wtzero*dconv2 ;
                  di.setText(String.valueOf(filter0(v7*dconv2))) ;
               }
               dfin = v7/dconv2 ;
             }

     // number of fins 
             if (v6 < 3) {
               v6 = 3 ;
               f6.setText(String.valueOf(filter0(v6))) ;
             }
             if (v6 >= 10) {
               v6 = 10 ;
               f6.setText(String.valueOf(filter0(v6))) ;
             }
             numfin = (int) v6 ;

             if (fintype == 0) {
     // leading edge angle
               fleang  = v3 ;
               vmn3 = flemin;   vmx3 = flemax ;
               if(v3 < vmn3) {
                   fleang = v3 = vmn3 ;
                   fl1 = (float) v3 ;
                   f3.setText(String.valueOf(fl1)) ;
               }
               if(v3 > vmx3) {
                   fleang =  v3 = vmx3 ;
                   fl1 = (float) v3 ;
                   f3.setText(String.valueOf(fl1)) ;
               }
               ftanle = Math.tan(convdr*fleang) ;

     // trailing edge angle
               fteang  = v4 ;
               vmn4 = ftemin;   vmx4 = ftemax ;
               if(v4 < vmn4) {
                   fteang = v4 = vmn4 ;
                   fl1 = (float) v4 ;
                   f4.setText(String.valueOf(fl1)) ;
               }
               if(v4 > vmx4) {
                   fteang =  v4 = vmx4 ;
                   fl1 = (float) v4 ;
                   f4.setText(String.valueOf(fl1)) ;
               }
               ftante = Math.tan(convdr*fteang) ;

               i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
               i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;

               rt.s3.setValue(i3) ;
               rt.s4.setValue(i4) ;
             }

     // fin length
             flngd  = v1 ;
             vmn1 = flmin;   vmx1 = flmax ;
             if(v1 < vmn1) {
                 flngd = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 flngd =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             flngth = flngd / lconv2 ;

        // limits on width for realistic geometry

             if (fintype == 0) {     // trapezoidal
               if ((ftanle - ftante) >= .02) {
                  fwmax = lconv2 * (flngth / (ftanle - ftante)) ;
                  if (fwmax >= fwex * lconv2 ) fwmax = fwex * lconv2 ;
               }
             }

     // fin width
             fwid  = v2 ;
             vmn2 = fwmin;   vmx2 = fwmax ;
             if(v2 < vmn2) {
                 fwid = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 fwid =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             fwidth = fwid / lconv2 ;

     // fin location
             flocd  = v5 ;
             vmn5 = flcmin;   vmx5 = flcmax ;
             if(v5 < vmn5) {
                 flocd = v5 = vmn5 ;
                 fl1 = (float) v5 ;
                 f5.setText(String.valueOf(fl1)) ;
             }
             if(v5 > vmx5) {
                 flocd =  v5 = vmx5 ;
                 fl1 = (float) v5 ;
                 f5.setText(String.valueOf(fl1)) ;
             }
             floc = flocd / lconv2 ;
 
             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i5 = (int) (((v5 - vmn5)/(vmx5-vmn5))*1000.) ;
  
             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s5.setValue(i5) ;

             getGeom() ;

        // reset the limits on location for change in fin size
             flcmin = - .5 * flngd;  flcmax = lconv2 * (blngth - flngth) ;
             i5 = (int) (((flocd - flcmin)/(flcmax-flcmin))*1000.) ;
             rt.s5.setValue(i5) ;

             solve.comPute() ;

           }  // end handle
         }  //  end  left
 
         public void getGeom() {

           if (fintype == 0) {  // trapezoidal
             finx[0][3] = 0.0 ;
             finy[0][3] = floc ;
             finx[0][2] = fwidth ;
             finy[0][2] = floc - fwidth * ftante ;
             finx[0][1] = fwidth ;
             finy[0][1] = floc + flngth - fwidth * ftanle ;
             finx[0][0] = 0.0 ;
             finy[0][0] = floc + flngth ;

             safin = fwidth*flngth - .5 *fwidth*fwidth * (ftanle - ftante) ;
             cgfin = (fwidth * flngth * flngth
                    - fwidth * fwidth * flngth * ftanle
                    + (fwidth*fwidth*fwidth*((ftanle*ftanle)-(ftante*ftante)))/3.0
                    ) / (2.0 * safin) ;
             cpfin = cgfin ;
           }

           if (fintype == 1) {     // elliptical
             finx[0][0] = -fwidth ;
             finy[0][0] = floc + flngth  ;
             finx[0][1] = 2.0 * fwidth ;
             finy[0][1] = flngth  ;

             safin = .5 * pi * fwidth * flngth ;
             cgfin = .5 * flngth ;
             cpfin = cgfin ;
           }

           delt = 360. / (double) numfin ;
           ap   = 0.0 ;
           thet = 0.0 ;
           while (thet <= 180.) {
              ap = ap + safin * Math.sin(thet*convdr) ;
              thet = thet + delt ;
           }
           pafin = 2.0 * ap ;

           wfin = dfin * safin * numfin ;
 
           if (nstage == 2) act.inp.enge.getFinGeom() ;
 
           if (rktype == 2) {
             cd = .7 + (numfin - 3) * .05 ;
             act.inp.boti.lt.f5.setText(String.valueOf(filter3(cd))) ;
           } 
 
           return ;
         }  // end geom
       }   // end fins

       class Payl extends Panel {
          Rocket outerparent ;
          Lt lt ;
          Rt rt ;
  
          Payl (Rocket target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Rocket outerparent ;
             Scrollbar s1,s2,s3,s4;
             Choice pmat,qmat,objch ;

             Rt (Rocket target) {

               int i1,i2,i3,i4 ;
  
               outerparent = target ;
               setLayout(new GridLayout(7,1,10,5)) ;

               i1 = (int) (((plngd - plmin)/(plmax-plmin))*1000.) ;
               i2 = (int) (((pdiamd - pdmin)/(pdmax-pdmin))*1000.) ;
               i3 = (int) (((qlngd - qlmin)/(qlmax-qlmin))*1000.) ;
               i4 = (int) (((wobjd - wobmin)/(wobmax-wobmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
 
               objch = new Choice() ;
               objch.setBackground(Color.white) ;
               objch.setForeground(Color.blue) ;
               objch.addItem("Set  Weight") ;
               objch.addItem("Egg") ;
               objch.select(0) ;
 
               pmat = new Choice() ;
               pmat.setBackground(Color.white) ;
               pmat.setForeground(Color.blue) ;
               pmat.addItem("<-- My Material") ;
               pmat.addItem("1/32 Cardboard") ;
               pmat.addItem("1/32 Plastic") ;
               pmat.addItem("1/64 Manilla") ;
               pmat.addItem("3/16 Sponge");
               pmat.addItem("2-ply Paper");
               pmat.addItem("2-ply Magazine");
               pmat.addItem("1/16 Gray Cardboard");
               pmat.select(1) ;
  
               qmat = new Choice() ;
               qmat.setBackground(Color.white) ;
               qmat.setForeground(Color.blue) ;
               qmat.addItem("<-- My Solid Material") ;
               qmat.addItem("Solid Balsa") ;
               qmat.addItem("Solid Plastic");
               qmat.addItem("<-- My Hollow Material") ;
               qmat.addItem("1/16 Hollow Cardboard") ;
               qmat.addItem("1/16 Hollow Plastic");
               qmat.addItem("1/4 Hollow Balsa") ;
               qmat.select(1) ;

               add(objch) ;
               add(s4) ;
               add(pmat) ;
               add(s1) ;
               add(s2) ;
               add(qmat) ;
               add(s3) ;
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleMat(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
           public void handleMat(Event evt) {  // materials & choice box
              String outden2,outden3 ;
              Double V1,V2 ;
              double v1,v2 ;
              int i2 ;

      //  object type
              objtyp = objch.getSelectedIndex() ;
              if (objtyp == 0) {
                 plmin = 0.0 ;
                 pdmin = 0.0 ;
                 wobmin = 0.0 ;
              }
              if (objtyp == 1) {
                 wobj = 1.6 ;
                 wobjd = wobj * fconv ;
                 wobmin = wobjd ;
                 lt.f4.setText(String.valueOf(filter3(wobjd))) ;
                 plmin = 2.0 * lconv2 ;
                 plngth = 2.0 ;
                 plngd = plngth * lconv2;
                 lt.f1.setText(String.valueOf(filter3(plngd))) ;
                 pdiam = 1.75 ;
                 pdiamd = pdiam * lconv2 ;
                 pdmin = 1.75 * lconv2 ;
                 lt.f2.setText(String.valueOf(filter3(pdiamd))) ;
                 prad = pdiamd / 2.0 ;
              }

         // payload tube
              outden2 = " oz/in2" ;
              if (lunits == 1) outden2 = " g/cs" ;
              outden3 = " oz/in3" ;
              if (lunits == 1) outden3 = " g/cc" ;

              mpay = pmat.getSelectedIndex() ;
              if (mpay > 0) {
                lt.di.setBackground(Color.black) ;
                lt.di.setForeground(Color.yellow) ;
              }
              if (mpay == 0) {
                lt.di.setBackground(Color.white) ;
                lt.di.setForeground(Color.blue) ;
                lt.di.setText(String.valueOf(filter3(dpay*dconv2))) ;
              }
              switch (mpay) {
                case 0: {
                   V1 = Double.valueOf(lt.di.getText()) ;
                   v1 = V1.doubleValue() ;
                   dpay = v1/dconv2 ;
                   break ;
                }
                case 1: {   // 1/32 cardboard
                   dpay = .0078 ; 
                   lt.di.setText(String.valueOf(filter3(dpay*dconv2))+outden2) ;
                   break ;
                }
                case 2: {  // 1/32 plastic
                   dpay = .015 ; 
                   lt.di.setText(String.valueOf(filter3(dpay*dconv2))+outden2) ;
                   break ;
                }
                case 3: {  // 1/64  manilla  folder
                   dpay = .0061 ; 
                   lt.di.setText(String.valueOf(filter3(dpay*dconv2))+outden2) ;
                   break ;
                }
                case 4: {  // 3/16 sponge
                   dpay = .0031 ; 
                   lt.di.setText(String.valueOf(filter3(dpay*dconv2))+outden2) ;
                   break ;
                }
                case 5: {  // 2-ply paper
                   dpay = .0036 ; 
                   lt.di.setText(String.valueOf(filter3(dpay*dconv2))+outden2) ;
                   break ;
                }
                case 6: {  // 2-ply magazine
                   dpay = .0031 ; 
                   lt.di.setText(String.valueOf(filter3(dpay*dconv2))+outden2) ;
                   break ;
                }
                case 7: {  // 1/16 gray cardboard
                   dpay = .016 ; 
                   lt.di.setText(String.valueOf(filter3(dpay*dconv2))+outden2) ;
                   break ;
                }
              }

         // fairing
              mpfr = qmat.getSelectedIndex() ;
              if (mpfr > 0) {
                lt.dt.setBackground(Color.black) ;
                lt.dt.setForeground(Color.yellow) ;
              }
              if (mpfr == 0) {
                lt.dt.setBackground(Color.white) ;
                lt.dt.setForeground(Color.blue) ;
                lt.dt.setText(String.valueOf(filter3(dpfr*dconv3))) ;
              }
              if (mpfr == 3) {
                lt.dt.setBackground(Color.white) ;
                lt.dt.setForeground(Color.blue) ;
                lt.dt.setText(String.valueOf(filter3(dpfr*dconv2))) ;
              }
              switch (mpfr) {  
                case 0: {    // my solid material
                   V2 = Double.valueOf(lt.dt.getText()) ;
                   v2 = V2.doubleValue() ;
                   dpfr = v2/dconv3 ;
                   break ;
                }
                case 1: {  // solid balsa
                   dpfr = .074 ;
                   lt.dt.setText(String.valueOf(filter3(dpfr*dconv3)) + outden3) ;
                   break ;
                }
                case 2: { // solid plastic
                   dpfr = .606 ;
                   lt.dt.setText(String.valueOf(filter3(dpfr*dconv3)) + outden3) ;
                   break ;
                }
                case 3: {    // my hollow material
                   V2 = Double.valueOf(lt.dt.getText()) ;
                   v2 = V2.doubleValue() ;
                   dpfr = v2/dconv2 ;
                   break ;
                }
                case 4: {  //  hollow cardboard
                   dpfr = .016 ;
                   lt.dt.setText(String.valueOf(filter3(dpfr*dconv2)) + outden2) ;
                   break ;
                }
                case 5: {  //  hollow plastic
                   dpfr = .03 ;
                   lt.dt.setText(String.valueOf(filter3(dpfr*dconv2)) + outden2) ;
                   break ;
                }
                case 6: {  //  hollow balsa
                   dpfr = .018 ;
                   lt.dt.setText(String.valueOf(filter3(dpfr*dconv2)) + outden2) ;
                   break ;
                }
              }
 
              getGeom() ;

              solve.comPute() ;
           }

           public void handleBar(Event evt) {     // payload tube
             int i1,i2,i3,i4 ;
             double v1,v2,v3,v4 ;
             float fl1,fl2,fl3,fl4 ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;
             i4 = s4.getValue() ;

             vmn1 = plmin;    vmx1 = plmax ;
             vmn2 = pdmin;    vmx2 = pdmax ;
             vmn3 = qlmin;    vmx3 = qlmax ;
             vmn4 = wobmin;   vmx4 = wobmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
             v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
 
             plngd = v1 ;
             plngth = plngd / lconv2 ;
             pdiamd = v2 ;
             pdiam = pdiamd / lconv2 ;
             prad = .5 * pdiam ;
             qlngd = v3 ;
             qlngth = qlngd / lconv2 ;
             wobjd = v4 ;
             wobj = wobjd / fconv ;

             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl3 = filter3(v3) ;
             fl4 = filter3(v4) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f3.setText(String.valueOf(fl3)) ;
             lt.f4.setText(String.valueOf(fl4)) ;
 
             getGeom() ;

         // make nose diameter match payload diameter
             if (plngth >= 0.02 || qlngth >= .02) {
                nrad = prad ;
                ndiam = pdiam ;
                ndiamd = pdiamd ;
                v2 = ndiamd ;
                vmn2 = ndmin;  vmx2 = ndmax ;
                act.inp.nose.lt.f2.setText(String.valueOf(filter3(ndiamd))) ;
                i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                act.inp.nose.rt.s2.setValue(i2) ;
                if (ntype == 3) {
                  nlngth =  nrad;
                  nlngd = v1 = nlngth * lconv2;
                  vmn1 = nlmin;  vmx1 = nlmax ;
                  act.inp.nose.lt.f1.setText(String.valueOf(filter3(nlngd))) ;
                  i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
                  act.inp.nose.rt.s1.setValue(i1) ;
                }
                act.inp.nose.getGeom() ;
             }

             solve.comPute() ;

           }  // end handle
         }  // end right
 
         class Lt extends Panel {
           Rocket outerparent ;
           TextField f1, f2, di, f3, dt, f4 ;
           Label l1, l2, l3, l4, lab1, lab2, lab3 ;
           Button butgo;
  
           Lt (Rocket target) {
              outerparent = target ;
              setLayout(new GridLayout(7,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;

              lab3 = new Label("Object:", Label.RIGHT) ;
              lab3.setForeground(Color.red) ;

              lab2 = new Label("Fairing", Label.CENTER) ;
              lab2.setForeground(Color.red) ;

              lab1 = new Label("Tube", Label.CENTER) ;
              lab1.setForeground(Color.red) ;

              l1 = new Label("Length in", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)plngd),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("Diam in", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)pdiamd),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              di = new TextField(String.valueOf((float)dpay),5) ;
              di.setBackground(Color.black) ;
              di.setForeground(Color.yellow) ;

              l3 = new Label("Length in", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)qlngd),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("Weight oz", Label.CENTER) ;
              f4 = new TextField(String.valueOf((float)qlngd),5) ;
              f4.setBackground(Color.white) ;
              f4.setForeground(Color.black) ;

              dt = new TextField(String.valueOf((float)dpfr),5) ;
              dt.setBackground(Color.black) ;
              dt.setForeground(Color.yellow) ;

              add(butgo) ;
              add(lab3) ;

              add(l4) ;
              add(f4) ;

              add(lab1) ;
              add(di) ;

              add(l1) ;
              add(f1) ;

              add(l2) ;
              add(f2) ;

              add(lab2) ;
              add(dt) ;

              add(l3) ;
              add(f3) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 ides = 1 ;
                 act.con.btm1.setBackground(Color.green) ;
                 act.con.btm1.setForeground(Color.black) ;
                 act.con.btm4.setBackground(Color.white) ;
                 act.con.btm4.setForeground(Color.blue) ;
                 butgo.setBackground(Color.green) ;
                 butgo.setForeground(Color.black) ;
              }
           }

           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4,V5,V6 ;
             double v1,v2,v3,v4,v5,v6 ;
             int i1,i2,i3,i4 ;
             float fl1 ;

      // payload weight
             V6 = Double.valueOf(f4.getText()) ;
             v6 = V6.doubleValue() ;
             wobjd  = v6 ;
             vmn6 = wobmin;   vmx6 = wobmax ;
             if(v6 < vmn6) {
                 wobjd = v6 = vmn6 ;
                 fl1 = (float) v6 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             if(v6 > vmx6) {
                 wobjd =  v6 = vmx6 ;
                 fl1 = (float) v6 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             wobj = wobjd / fconv ;

 // payload tube 
             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
     // tube material
             if (mpay == 0) {
               V4 = Double.valueOf(di.getText()) ;
               v4 = V4.doubleValue() ;
               if (v4 <= wtzero*dconv2) {
                  v4 = wtzero*dconv2 ;
                  di.setText(String.valueOf(filter0(v4*dconv2))) ;
               }
               dpay = v4/dconv2 ;
             }

     // tube length
             plngd  = v1 ;
             vmn1 = plmin;   vmx1 = plmax ;
             if(v1 < vmn1) {
                 plngd = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 plngd =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             plngth = plngd / lconv2 ;

     // tube diameter
             pdiamd  = v2 ;
             vmn2 = pdmin;   vmx2 = pdmax ;
             if(v2 < vmn2) {
                 pdiamd = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 pdiamd =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             pdiam = pdiamd / lconv2 ;
             prad = .5 * pdiam;

     // fairing
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
     // material
             if (mpfr == 0) {
               V5 = Double.valueOf(dt.getText()) ;
               v5 = V5.doubleValue() ;
               if (v5 <= wtzero*dconv3) {
                  v5 = wtzero*dconv3 ;
                  dt.setText(String.valueOf(filter0(v5*dconv3))) ;
               }
               dpfr = v5/dconv3 ;
             }
             if (mpfr == 3) {
               V5 = Double.valueOf(dt.getText()) ;
               v5 = V5.doubleValue() ;
               if (v5 <= wtzero*dconv2) {
                  v5 = wtzero*dconv2 ;
                  dt.setText(String.valueOf(filter0(v5*dconv2))) ;
               }
               dpfr = v5/dconv2 ;
             }
     // length
             qlngd  = v3 ;
             vmn3 = qlmin;   vmx3 = qlmax ;
             if(v3 < vmn3) {
                 qlngd = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 qlngd =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             qlngth = qlngd / lconv2 ;

             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
             i4 = (int) (((v6 - vmn6)/(vmx6-vmn6))*1000.) ;
  
             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;
             rt.s4.setValue(i4) ;

             getGeom() ;

         // make nose diameter match payload diameter
             if (plngth >= 0.02 || qlngth >= .02) {
                nrad = prad ;
                ndiam = pdiam ;
                ndiamd = pdiamd ;
                v2 = ndiamd ;
                vmn2 = ndmin;  vmx2 = ndmax ;
                act.inp.nose.lt.f2.setText(String.valueOf(filter3(ndiamd))) ;
                i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                act.inp.nose.rt.s2.setValue(i2) ;
                if (ntype == 3) {
                  nlngth = nrad;
                  nlngd = v1 = nlngth * lconv2;
                  vmn1 = nlmin;  vmx1 = nlmax ;
                  act.inp.nose.lt.f1.setText(String.valueOf(filter3(nlngd))) ;
                  i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
                  act.inp.nose.rt.s1.setValue(i1) ;
                }
                act.inp.nose.getGeom() ;
              }

             solve.comPute() ;

           }  // end handle
         }  //  end  left

         public void getGeom () {
            vpay = pi * pdiam * plngth ; 
            sapay = pi * pdiam * plngth ;
            papay = pdiam * plngth ;
            cgpay = .5 * plngth ;
            cppay = .5 * plngth ; 
            capay = pi * prad * prad ;
            wpay = sapay * dpay + wobj ;

            vpfr = pi * qlngth * (brad*brad + brad*prad* prad*prad) / 3.0 ;
            sapfr = pi * (brad + prad) * 
                    Math.sqrt(qlngth*qlngth + (brad-prad)*(brad-prad)) ;
            papfr = qlngth * (brad + prad) ;
            cppfr = qlngth * (brad + 2.0 * prad) / (brad + prad) / 3.0 ;

            if (mpfr <=2 ) {  // solid fairing
              cgpfr = qlngth * ((3.0 * prad) + (2.0 * prad * brad) + (brad * brad)) 
                   / ((prad * prad) + (prad * brad) + (brad + brad)) / 4.0 ;
              wpfr = vpfr * dpfr ;
            }
            if (mpfr >= 3) {   // hollow fairing
               cgpfr = qlngth * (brad + 2.0 * prad) / (brad + prad) / 3.0 ;
               wpfr = sapfr * dpfr ;
            }
            return ;
         } // end geom
       }   // end payload

       class Engs extends Panel {  // propulsion panel for stomp rocket
          Rocket outerparent ;
          Lt lt ;
          Rt rt ;
  
          Engs (Rocket target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Rocket outerparent ;
             Scrollbar s1,s2,s3;
             Choice presch;

             Rt (Rocket target) {

               int i1,i2,i3 ;
  
               outerparent = target ;
               setLayout(new GridLayout(7,1,10,5)) ;

               i1 = (int) (((sv1d - sv1min)/(sv1max-sv1min))*1000.) ;
               i2 = (int) (((sv2d - sv2min)/(sv2max-sv2min))*1000.) ;
               i3 = (int) (((sld - slmin)/(slmax-slmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
  
               presch = new Choice() ;
               presch.addItem("<- Computed") ;
               presch.addItem("<- Input") ;
               presch.select(0) ;
 
               add(new Label("Volume", Label.CENTER)) ;
               add(s1) ;
               add(s2) ;
               add(presch) ;
               add(new Label("Launch Tube ", Label.CENTER)) ;
               add(s3) ;
               add(new Label(" ", Label.CENTER)) ;
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleCho(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
          public void handleCho(Event evt) {     // pressure option
              presopt = presch.getSelectedIndex() ;
              if (presopt == 0) {
                lt.op.setBackground(Color.black) ;
                lt.op.setForeground(Color.yellow) ;
              }
              if (presopt == 1) {
                lt.op.setBackground(Color.white) ;
                lt.op.setForeground(Color.black) ;
              }
          }

          public void handleBar(Event evt) {  // stomp launcher 
             int i1,i2,i3 ;
             double v1,v2,v3 ;
             float fl1,fl2,fl3 ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;

             vmn1 = sv1min;   vmx1 = sv1max ;
             vmn2 = sv2min;   vmx2 = sv2max ;
             vmn3 = slmin;    vmx3 = slmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
 
             sv1d = v1 ;
             sv1 = sv1d / vconv ;
             sv2d = v2 ;
             sv2 = sv2d / vconv ;
             sld = v3 ;
             sl = sld / lconv2 ;
 
             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl3 = filter3(v3) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f3.setText(String.valueOf(fl3)) ;
           
             getVexit() ;

        // reset minimum beginning volume
             sv1min = sv2d + .1 ;
             vmn1 = sv1min ;
             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             s1.setValue(i1) ;
 
           }  // end handle
         }  // end right
 
         class Lt extends Panel {
           Rocket outerparent ;
           TextField f1, f2, f3, op, ov ;
           Label l1, l2, l3, l4, lab ;
           Button butgo ;
  
           Lt (Rocket target) {
              outerparent = target ;
              setLayout(new GridLayout(7,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;

              l1 = new Label("Begin in3", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)sv1d),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("End in3", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)sv2d),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              l3 = new Label("Length in", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)sld),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("Pressure psi", Label.CENTER) ;
              op = new TextField(String.valueOf(zero),5) ;
              op.setBackground(Color.black) ;
              op.setForeground(Color.yellow) ;

              ov = new TextField(String.valueOf(zero),5) ;
              ov.setBackground(Color.black) ;
              ov.setForeground(Color.yellow) ;

              add(butgo) ;
              add(new Label(" ", Label.CENTER)) ;

              add(l1) ;
              add(f1) ;

              add(l2) ;
              add(f2) ;

              add(l4) ;
              add(op) ;

              add(new Label(" ", Label.CENTER)) ;
              add(new Label(" ", Label.CENTER)) ;

              add(l3) ;
              add(f3) ;

              add(new Label("Velocity", Label.CENTER)) ;
              add(ov) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 if (vstomp <= zero ) {
                    ifuel = 0 ;
                    act.con.btm2.setBackground(Color.red) ;
                    act.con.btm2.setForeground(Color.white) ;
                 }
                 if (vstomp > zero ) {
                    ifuel = 1 ;
                    act.con.btm2.setBackground(Color.green) ;
                    act.con.btm2.setForeground(Color.black) ;
                    act.con.btm4.setBackground(Color.white) ;
                    act.con.btm4.setForeground(Color.blue) ;
                    butgo.setBackground(Color.green) ;
                    butgo.setForeground(Color.black) ;
                 }
              }
           }

           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4 ;
             double v1,v2,v3,v4;
             int i1,i2,i3 ;
             float fl1 ;

             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
     // initial volume
             sv1d  = v1 ;
             vmn1 = sv1min;   vmx1 = sv1max ;
             if(v1 < vmn1) {
                 sv1d = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 sv1d =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             sv1 = sv1d / vconv ;
     // final volume
             sv2d  = v2 ;
             vmn2 = sv2min;   vmx2 = sv2max ;
             if(v2 < vmn2) {
                 sv2d = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 sv2d =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             sv2 = sv2d / vconv ;
     // tube length
             sld  = v3 ;
             vmn3 = slmin;   vmx3 = slmax ;
             if(v3 < vmn3) {
                 sld = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 sld =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             sl = sld / lconv2 ;
     // input pressure
             if (presopt == 1) {
                V4 = Double.valueOf(op.getText()) ;
                v4 = V4.doubleValue() ;
                lpresd = v4 ;
                vmn4 = lpresmin;   vmx4 = lpresmax ;
                if(v4 < vmn4) {
                    lpresd = v4 = vmn4 ;
                    fl1 = (float) v4 ;
                    op.setText(String.valueOf(fl1)) ;
                }
                if(v4 > vmx4) {
                    lpresd =  v4 = vmx4 ;
                    fl1 = (float) v4 ;
                    op.setText(String.valueOf(fl1)) ;
                }
                lpress = lpresd / pconv ;
             }

             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
  
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;

             getVexit() ;

          // reset minimum beginning volume
             sv1min = sv2d + .1 ;
             vmn1 = sv1min ;
             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             rt.s1.setValue(i1) ;

           }  // end handle
         }  //  end  left
 
         public void getVexit() {
           String outpres,outvel ;
           double pulse,accel,time;

           outvel = " fps" ;
           if (lunits == 1) outvel = " mps" ;

           volrat = (sv1 + vbod) / (sv2 + vbod) ;

           if (presopt == 0) {
              lpress = presin * Math.pow(volrat,1.4) ;
           }

           lt.op.setText(String.valueOf(filter1(lpress * pconv))) ;

           pulse = (lpress - ps0) * caexit ;
           accel = (16.0 * pulse - (weight * wtrat)) * g0 / weight ;
           if (accel <= zero) {
              vstomp = 0.0 ;
              ifuel = 0 ;
              act.con.btm2.setBackground(Color.red) ;
              act.con.btm2.setForeground(Color.white) ;
           }
           if (accel > zero) {
              time = Math.sqrt(2.0 * sl / (12.0 * accel)) ;
              vstomp = accel * time ; 
           }
           lt.ov.setText(String.valueOf(filter3(vstomp * lconv1)) + outvel) ;
         }  //  end velocity calc
       }   // end stomp engine

       class Engb extends Panel {  // propulsion panel for bottle rocket
          Rocket outerparent ;
          Lt lt ;
          Rt rt ;
  
          Engb (Rocket target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Rocket outerparent ;
             Scrollbar s1,s2,s3,s4;

             Rt (Rocket target) {

               int i1,i2,i3,i4 ;
  
               outerparent = target ;
               setLayout(new GridLayout(7,1,10,5)) ;

               i1 = (int) (((watd - watmin)/(watmax-watmin))*1000.) ;
               i2 = (int) (((fpresd - fpresmin)/(fpresmax-fpresmin))*1000.) ;
               i3 = (int) (((nozdiamd - nozdmin)/(nozdmax-nozdmin))*1000.) ;
               i4 = (int) (((ltubd - ltubmin)/(ltubmax-ltubmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
  
               add(new Label("Water", Label.CENTER)) ;
               add(s1) ;
               add(s2) ;
               add(new Label("Nozzle ", Label.CENTER)) ;
               add(s3) ;
               add(new Label("Launch Tube ", Label.CENTER)) ;
               add(s4) ;
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
          public void handleBar(Event evt) {  // bottle launcher 
             int i1,i2,i3,i4 ;
             double v1,v2,v3,v4 ;
             float fl1,fl2,fl3,fl4 ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;
             i4 = s4.getValue() ;

             vmn1 = watmin;   vmx1 = watmax ;
             vmn2 = fpresmin; vmx2 = fpresmax ;
             vmn3 = nozdmin;  vmx3 = nozdmax ;
             vmn4 = ltubmin;  vmx4 = ltubmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
             v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
 
             watd = v1 ;
             wat = watd / vconv ;
             if (wat > volbot) {
                wat = volbot ;
                v1 = watd = wat * vconv ;
                i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
                s1.setValue(i1) ;
             }
             fpresd = v2 ;
             fpres = fpresd / pconv ;
             nozdiamd = v3 ;
             nozdiam = nozdiamd / lconv2 ;
             nozrad = .5 * nozdiam ;
             noza = pi * nozrad * nozrad ;
             ltubd = v4 ;
             ltub = ltubd / lconv2 ;
 
             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl3 = filter3(v3) ;
             fl4 = filter3(v4) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f3.setText(String.valueOf(fl3)) ;
             lt.f4.setText(String.valueOf(fl4)) ;
           
             getGeom() ;

             solve.comPute() ;
           }  // end handle
         }  // end right
 
         class Lt extends Panel {
           Rocket outerparent ;
           TextField f1, f2, f3, f4 ;
           TextField o1,o2 ;
           Label l1, l2, l3, l4, lab ;
           Button butgo ;
  
           Lt (Rocket target) {
              outerparent = target ;
              setLayout(new GridLayout(7,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;

              l1 = new Label("Vol cu in", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)watd),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("Pressure psi", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)fpresd),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              l3 = new Label("Diam in", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)nozdiamd),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("Length in", Label.CENTER) ;
              f4 = new TextField(String.valueOf((float)ltubd),5) ;
              f4.setBackground(Color.white) ;
              f4.setForeground(Color.black) ;

              o1 = new TextField(String.valueOf((float)zero),5) ;
              o1.setBackground(Color.black) ;
              o1.setForeground(Color.green) ;

              o2 = new TextField(String.valueOf((float)zero),5) ;
              o2.setBackground(Color.black) ;
              o2.setForeground(Color.green) ;

              add(butgo) ;
              add(new Label(" ", Label.CENTER)) ;

              add(l1) ;
              add(f1) ;

              add(l2) ;
              add(f2) ;

              add(new Label("Fuel Weight", Label.CENTER)) ;
              add(o1) ;

              add(l3) ;
              add(f3) ;

              add(new Label("LO Thrust", Label.CENTER)) ;
              add(o2) ;

              add(l4) ;
              add(f4) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 if (lothrust > (weight * wtrat)) {
                   ifuel = 1 ;
                   act.con.btm2.setBackground(Color.green) ;
                   act.con.btm2.setForeground(Color.black) ;
                   act.con.btm4.setBackground(Color.white) ;
                   act.con.btm4.setForeground(Color.blue) ;
                   butgo.setBackground(Color.green) ;
                   butgo.setForeground(Color.black) ;
                 }
                 if (lothrust <= (weight * wtrat)) {
                   ifuel = 0 ;
                   act.con.btm2.setBackground(Color.red) ;
                   act.con.btm2.setForeground(Color.white) ;
                   act.con.btm4.setBackground(Color.white) ;
                   act.con.btm4.setForeground(Color.blue) ;
                   butgo.setBackground(Color.white) ;
                   butgo.setForeground(Color.blue) ;
                 }
              }
           }

           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4 ;
             double v1,v2,v3,v4;
             int i1,i2,i3,i4 ;
             float fl1 ;

             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
             V4 = Double.valueOf(f4.getText()) ;
             v4 = V4.doubleValue() ;
     // amount water
             watd  = v1 ;
             vmn1 = watmin;   vmx1 = watmax ;
             if(v1 < vmn1) {
                 watd = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 watd =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             wat = watd / vconv ;
             if (wat > volbot) {
                 wat = volbot ;
                 watd = v1 = wat * vconv;
                 f1.setText(String.valueOf(v1)) ;
             }
     // pressure
             fpresd  = v2 ;
             vmn2 = fpresmin;   vmx2 = fpresmax ;
             if(v2 < vmn2) {
                 fpresd = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 fpresd =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             fpres = fpresd / pconv ;

     // nozzle area
             nozdiamd  = v3 ;
             vmn3 = nozdmin;   vmx3 = nozdmax ;
             if(v3 < vmn3) {
                 nozdiamd = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 nozdiamd =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             nozdiam = nozdiamd / lconv2 ;
             nozrad = .5 * nozdiam ;
             noza = pi * nozrad * nozrad ;

     // tube length
             ltubd  = v4 ;
             vmn4 = ltubmin;   vmx4 = ltubmax ;
             if(v4 < vmn4) {
                 ltubd = v4 = vmn4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             if(v4 > vmx4) {
                 ltubd =  v4 = vmx4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             ltub = ltubd / lconv2 ;

             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
             i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
  
             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;
             rt.s4.setValue(i4) ;

             getGeom() ;

             solve.comPute() ;

           }  // end handle
         }  //  end left

         public void getGeom() {
            String outfor,outpres ;
            double cgfrus ; 

            outfor = " oz" ;
            if (lunits == 1) outfor = " g" ;
            outpres = " psi" ;
            if (lunits == 1) outpres = " kPa" ;

            weng  = .09 ;
            cgeng = .25;

            wfuel = wat  * .578 ;  // .578 oz/cuin = density of water

            lt.o1.setText(String.valueOf(filter1(wfuel*fconv)) + outfor) ;
 
            if (wat < 1.178) {
               watrad = .5 ;
               hwat = wat / (pi * .25) ;
               cgfuel = .5 * hwat ;
            }
            if ((wat >= 1.178) && (wat <= 14.922)) {
               getHt() ;
               cgfrus = (hwat - 1.5)*(.5 + brad * watrad)/ (.5 + watrad) / 3.0 ; 
               cgfuel = ((1.178 * .75) 
                       + (wat - 1.178) * (cgfrus + 1.5)
                        )/ wat ;
            }
            if (wat > 14.922) {
               watrad = brad ;
               hwat = ((wat - 14.922) / cabod) + 4.0 ;
               cgfrus = 1.5 ;
               cgfuel = ((1.178 * .75) 
                       + (13.744 * (cgfrus + 1.5))
                       + ((wat-14.922) * ((hwat - 4.0)/watrad + 4.0))
                        )/ wat ;
            }
 
            volair = volbot - wat;

            lothrust = (fpres - ps0)  * noza * 16.0 ;
            lt.o2.setText(String.valueOf(filter1(lothrust*fconv)) + outfor) ;
            act.inp.lnch.o11.setText(String.valueOf(filter1(fpres) + outpres)) ;
            act.inp.lnch.o12.setText(String.valueOf(filter3(wfuel * wtrat * fconv) + outfor)) ;

         }  //  end geom  

         public void getHt() {
            int iter ;
            double deriv,fnew,hold,hnew ;

            hold = 1.5 ;
            fnew = wat - 1.178 ;
            iter = 1;
            hnew = 1.551;

            while (Math.abs(fnew) >= .0001 && iter <25) {
               ++ iter ;
               watrad = .6 * hnew- .4 ;
               fnew = wat - 1.178 - 1.047 * (hnew - 1.5) *
                     (.25 + .5 * watrad + watrad*watrad) ;
               deriv = 1.047 * ((.25 + .5*watrad + watrad*watrad)
                       + .6 * (hnew - 1.5)*(.5 + watrad)) ;
               hold = hnew ;
               hnew = hold + .5 * fnew / deriv ;
            }
            hwat = hnew ;
            return ;
         }  //  end height  
       }   // end bottle engine

       class Enge extends Panel {  // propulsion panel for solid rocket
          Rocket outerparent ;
          Up up ;
          M m ;
  
          Enge (Rocket target) {
  
            outerparent = target ;
            setLayout(new GridLayout(2,1,5,5)) ;

            up  = new Up(outerparent) ;
            m = new M(outerparent) ;
            
            add(up) ;
            add(m) ;
          }

          class Up extends Panel {
             Rocket outerparent ;
             Label lab1, lab2, l1, l2, l3, l4;
             Choice engch,eng2;
             TextField o1,o2,o3,o4;
             Button butgo ;

             Up (Rocket target) {

                outerparent = target ;
                setLayout(new GridLayout(3,4,5,5)) ;

                butgo = new Button("GO") ;
                butgo.setBackground(Color.white) ;
                butgo.setForeground(Color.blue) ;
 
                lab1 = new Label("Engine", Label.CENTER) ;
                lab1.setForeground(Color.red) ;
                lab2 = new Label("Config:", Label.RIGHT) ;

                engch = new Choice() ;
                engch.addItem("1 Stage") ;
                engch.addItem("2 Stage") ;
                engch.addItem("Cluster");
                engch.select(0) ;
 
                eng2 = new Choice() ;
                eng2.setBackground(Color.white) ;
                eng2.setForeground(Color.red) ;
                eng2.addItem("1/2 A6-2") ;
                eng2.addItem("A8-3") ;
                eng2.addItem("A8-5") ;
                eng2.addItem("B6-2") ;
                eng2.addItem("B6-4") ;
                eng2.addItem("B6-6") ;
                eng2.addItem("C6-3") ;
                eng2.addItem("C6-5") ;
                eng2.addItem("C6-7") ;
                eng2.addItem("D12-3") ;
                eng2.addItem("D12-5") ;
                eng2.addItem("D12-7") ;
                eng2.select(1) ;
 
                l1 = new Label("Diameter", Label.RIGHT) ;
                o1 = new TextField(String.valueOf((float)zero),5) ;
                o1.setBackground(Color.black) ;
                o1.setForeground(Color.green) ;

                l2 = new Label("LO Thrust", Label.CENTER) ;
                o2 = new TextField(String.valueOf((float)zero),5) ;
                o2.setBackground(Color.black) ;
                o2.setForeground(Color.green) ;

                l3 = new Label("Case Weight", Label.CENTER) ;
                o3 = new TextField(String.valueOf((float)zero),5) ;
                o3.setBackground(Color.black) ;
                o3.setForeground(Color.green) ;

                l4 = new Label("Fuel Weight", Label.CENTER) ;
                o4 = new TextField(String.valueOf((float)zero),5) ;
                o4.setBackground(Color.black) ;
                o4.setForeground(Color.green) ;

                add(butgo) ;
                add(eng2) ;
                add(lab2) ;
                add(engch) ;
    
                add(l1) ;
                add(o1) ;
                add(l2) ;
                add(o2) ;

                add(l3) ;
                add(o3) ;
                add(l4) ;
                add(o4) ;
             }

             public boolean action(Event evt, Object arg) {
               if(evt.target instanceof Choice) {
                   enge.getModThrst() ;
                   return true ;
               }
               if(evt.target instanceof Button) {
                  this.handleBut(evt,arg) ;
                  return true ;
               }
               else return false ;
             }
  
             public void handleBut(Event evt, Object arg) {
                String label = (String)arg ;
  
                if(label.equals("GO")) {
                   if (nstage ==1) {
                      if ((16.0*th1) > (weight * wtrat)) {
                         ifuel = 1 ;
                         act.con.btm2.setBackground(Color.green) ;
                         act.con.btm2.setForeground(Color.black) ;
                         act.con.btm4.setBackground(Color.white) ;
                         act.con.btm4.setForeground(Color.blue) ;
                         butgo.setBackground(Color.green) ;
                         butgo.setForeground(Color.black) ;
                      }
                      if ((16.0*th1) <= (weight * wtrat)) {
                         ifuel = 0 ;
                         act.con.btm2.setBackground(Color.red) ;
                         act.con.btm2.setForeground(Color.white) ;
                         act.con.btm4.setBackground(Color.white) ;
                         act.con.btm4.setForeground(Color.blue) ;
                         butgo.setBackground(Color.white) ;
                         butgo.setForeground(Color.blue) ;
                      }
                   }
                   if (nstage ==2) {
                      if ((16.0*th1b1) > (weight * wtrat)) {
                         ifuel = 1 ;
                         act.con.btm2.setBackground(Color.green) ;
                         act.con.btm2.setForeground(Color.black) ;
                         act.con.btm4.setBackground(Color.white) ;
                         act.con.btm4.setForeground(Color.blue) ;
                         butgo.setBackground(Color.green) ;
                         butgo.setForeground(Color.black) ;
                      }
                      if ((16.0*th1b1) <= (weight * wtrat)) {
                         ifuel = 0 ;
                         act.con.btm2.setBackground(Color.red) ;
                         act.con.btm2.setForeground(Color.white) ;
                         act.con.btm4.setBackground(Color.white) ;
                         act.con.btm4.setForeground(Color.blue) ;
                         butgo.setBackground(Color.white) ;
                         butgo.setForeground(Color.blue) ;
                      }
                   }
                }
             }
          }  // end up

          class M extends Panel {
             Rocket outerparent ;
             B b ;
             S s;
             C c;

             M (Rocket target) {

                outerparent = target ;
                layen1 = new CardLayout() ;
                setLayout(layen1) ;

                b = new B(outerparent) ;
                s = new S(outerparent) ;
                c = new C(outerparent) ;

                add ("first", b) ;
                add ("second", s) ;
                add ("third", c) ;
             }

             class B extends Panel {
                Rocket outerparent ;

                B (Rocket target) {

                   outerparent = target ;
                   setLayout(new GridLayout(1,1,5,5)) ;

                   add(new Label(" ", Label.CENTER)) ;
                }
             }  // end blnk

             class S extends Panel {
                Rocket outerparent ;
                Label lab1, lab2, l1, l2, l3, l4, l5;
                TextField o1, o2, o3, o4, o5;
                Choice eng1;

                S (Rocket target) {
   
                   outerparent = target ;
                   setLayout(new GridLayout(3,4,5,5)) ;
   
                   lab1 = new Label("Booster", Label.CENTER) ;
                   lab1.setForeground(Color.red) ;
   
                   eng1 = new Choice() ;
                   eng1.setBackground(Color.white) ;
                   eng1.setForeground(Color.red) ;
                   eng1.addItem("A8-0") ;
                   eng1.addItem("B6-0") ;
                   eng1.addItem("C6-0") ;
                   eng1.addItem("D12-0") ;
                   eng1.select(0) ;
    
                   l1 = new Label("Fin Length", Label.RIGHT) ;
                   o1 = new TextField(String.valueOf((float)zero),5) ;
                   o1.setBackground(Color.white) ;
                   o1.setForeground(Color.black) ;

                   l2 = new Label("Fin LE Ang", Label.RIGHT) ;
                   o2 = new TextField(String.valueOf((float)zero),5) ;
                   o2.setBackground(Color.white) ;
                   o2.setForeground(Color.black) ;

                   l3 = new Label("Tube Lngth", Label.RIGHT) ;
                   o3 = new TextField(String.valueOf((float)zero),5) ;
                   o3.setBackground(Color.white) ;
                   o3.setForeground(Color.black) ;

                   l4 = new Label("Fin Width", Label.RIGHT) ;
                   o4 = new TextField(String.valueOf((float)zero),5) ;
                   o4.setBackground(Color.white) ;
                   o4.setForeground(Color.black) ;

                   l5 = new Label("Fin TE Ang", Label.RIGHT) ;
                   o5 = new TextField(String.valueOf((float)zero),5) ;
                   o5.setBackground(Color.white) ;
                   o5.setForeground(Color.black) ;

                   add(lab1) ;
                   add(eng1) ;
                   add(l3) ;
                   add(o3) ;
 
                   add(l1) ;
                   add(o1) ;
                   add(l4) ;
                   add(o4) ;

                   add(l2) ;
                   add(o2) ;
                   add(l5) ;
                   add(o5) ;
                }

                public boolean handleEvent(Event evt) {
                   if(evt.id == Event.ACTION_EVENT) {
                      enge.getModThrst() ;
                      return true ;
                   }
                   else return false ;
                } // end handler
             }  // end stg2

             class C extends Panel {
                Rocket outerparent ;
                Label l1;
                TextField o1,o2 ;

                C (Rocket target) {
   
                   outerparent = target ;
                   setLayout(new GridLayout(3,4,5,5)) ;
   
                   l1 = new Label("Number", Label.RIGHT) ;
   
                   o1 = new TextField(String.valueOf((float)zero),5) ;
                   o1.setBackground(Color.white) ;
                   o1.setForeground(Color.black) ;

                   o2 = new TextField(String.valueOf((float)zero),5) ;
                   o2.setBackground(Color.black) ;
                   o2.setForeground(Color.green) ;

                   add(l1) ;
                   add(o1) ;
                   add(new Label("Min Diam", Label.CENTER)) ;
                   add(o2) ;

                   add(new Label(" ", Label.CENTER)) ;
                   add(new Label(" ", Label.CENTER)) ;
                   add(new Label(" ", Label.CENTER)) ;
                   add(new Label(" ", Label.CENTER)) ;

                   add(new Label(" ", Label.CENTER)) ;
                   add(new Label(" ", Label.CENTER)) ;
                   add(new Label(" ", Label.CENTER)) ;
                   add(new Label(" ", Label.CENTER)) ;
                }

                public boolean handleEvent(Event evt) {
                   if(evt.id == Event.ACTION_EVENT) {
                      enge.getModThrst() ;
                      return true ;
                   }
                   else return false ;
                } // end handler
             }  // end clus
          }  // end mid

          public void getModThrst() {
             String outlng,outfor ;
             Double V1,V2 ;
             double v1,v2 ;
             int con,sus,bos ;

             outlng = " in" ;
             if (lunits == 1) outlng = " cm" ;
             outfor = " oz" ;
             if (lunits == 1) outfor = " g" ;

      // configuration
             con = up.engch.getSelectedIndex() ;

             numeng = 1 ;
             switch (con) {
                case 0: {  // 1 stage
                   nstage = 1 ;
                   nclust = 0 ;
                   layen1.show(m, "first")  ;
                   break ;
                }
                case 1: {  //  2 stage
                   nstage = 2 ;
                   nclust = 0 ;
                   layen1.show(m, "second")  ;
                   break ;
                }
                case 2: {  // cluster
                   nstage = 1;
                   nclust = 1 ;
                   layen1.show(m, "third")  ;
                   break ;
                }
             }

             if (nstage == 2) {
      // booster engine
                bos = m.s.eng1.getSelectedIndex() ;

                switch (bos) {
                   case 0: { // A8-0
                      th1b1 = 2.25; tim1b1 = .25; th2b1 = 0.0; tim2b1 = .26;
                      b1ediam = .75 ; b1elngth = 2.75 ; 
                      wengb1 = .354 ; wfuelb1 = .116 ;
                      break ;
                   }
                   case 1:  { // B6-0
                      th1b1 = 5.62; tim1b1 = .40; th2b1 = 1.35;tim2b1 = .85; 
                      b1ediam = .75 ; b1elngth = 2.75 ; 
                      wengb1 = .354 ; wfuelb1 = .198 ;
                      break ;
                   }
                   case 2:  { // C6-0
                      th1b1 = 5.62; tim1b1 = .40; th2b1 = 1.35;tim2b1 = 1.70 ;
                      b1ediam = .75 ; b1elngth = 2.75 ; 
                      wengb1 = .354 ; wfuelb1 = .382 ;
                      break ;
                   }
                   case 3: { // D12-0
                      th1b1 = 5.62; tim1b1 = .60; th2b1 = 2.25;tim2b1 = 1.75; 
                      b1ediam = 1.0 ; b1elngth = 2.75 ; 
                      wengb1 = .850 ; wfuelb1 = .747 ;
                      break ;
                   }
                }
                b1erad = .5 * b1ediam ;

         // body
                V1 = Double.valueOf(m.s.o3.getText()) ;
                v1 = V1.doubleValue() ;
                b1lngd  = v1 ;
                if(v1 < (b1elngth * lconv2) ) {
                    b1lngd = b1elngth * lconv2 ;
                    m.s.o3.setText(String.valueOf(filter3(b1lngd))) ;
                }
                if(v1 > b1lmax) {
                    b1lngd =  b1lmax ;
                    m.s.o3.setText(String.valueOf(filter3(b1lngd))) ;
                }
                b1lngth = b1lngd / lconv2 ;

                if (bdiam < b1ediam) bdiam = b1ediam ;

                sab1 = pi * bdiam * b1lngth ;
                pab1 = b1lngth * bdiam ;
                cgb1 = .5 * b1lngth ;
                cpb1 = .5 * b1lngth ;
                wengb1 = wengb1 + sab1 * dbod ;
                
                getFinGeom() ;
             }

      // sustainer engine
             sus = up.eng2.getSelectedIndex() ;

             switch (sus) {
                case 0: {  // 1/2 A6-2
                   th1 = 1.35; tim1 = .20; th2 = 0.0; tim2 = .21; timd = 2.2;
                   ediam = .50 ; elngth = 1.75 ; weng = .177 ; wfuel = .071 ;
                   break ;
                }
                case 1: { // A8-3
                   th1 = 2.25; tim1 = .25; th2 = 0.0; tim2 = .26; timd = 3.25;
                   ediam = .75 ; elngth = 2.75 ; weng = .354 ; wfuel = .116 ;
                   break ;
                }
                case 2:  { // A8-5
                   th1 = 2.25; tim1 = .25; th2 = 0.0; tim2 = .26; timd = 5.25;
                   ediam = .75 ; elngth = 2.75 ; weng = .354 ; wfuel = .116 ;
                   break ;
                }
                case 3:  { // B6-2
                   th1 = 5.62; tim1 = .40; th2 = 1.35;tim2 = .85; timd = 2.85;
                   ediam = .75 ; elngth = 2.75 ; weng = .354 ; wfuel = .198 ;
                   break ;
                }
                case 4:  {  // B6-4
                   th1 = 5.62; tim1 = .40; th2 = 1.35;tim2 = .85; timd = 4.85;
                   ediam = .75 ; elngth = 2.75 ; weng = .354 ; wfuel = .198 ;
                   break ;
                }
                case 5:  { // B6-6
                   th1 = 5.62; tim1 = .40; th2 = 1.35;tim2 = .85; timd = 6.85;
                   ediam = .75 ; elngth = 2.75 ; weng = .354 ; wfuel = .198 ;
                   break ;
                }
                case 6:  { // C6-3
                   th1 = 5.62; tim1 = .40; th2 = 1.35;tim2 =1.70; timd = 4.70;
                   ediam = .75 ; elngth = 2.75 ; weng = .354 ; wfuel = .382 ;
                   break ;
                }
                case 7:  {  // C6-5
                   th1 = 5.62; tim1 = .40; th2 = 1.35;tim2 =1.70; timd = 6.70;
                   ediam = .75 ; elngth = 2.75 ; weng = .354 ; wfuel = .382 ;
                   break ;
                }
                case 8:  {  // C6-7
                   th1 = 5.62; tim1 = .40; th2 = 1.35;tim2 =1.70; timd = 8.70;
                   ediam = .75 ; elngth = 2.75 ; weng = .354 ; wfuel = .382 ;
                   break ;
                }
                case 9: { // D12-3
                   th1 = 5.62; tim1 = .60; th2 = 2.25;tim2 =1.75; timd = 4.75;
                   ediam = 1.0 ; elngth = 2.75 ; weng = .850 ; wfuel = .747 ;
                   break ;
                }
                case 10:  { // D12-5
                   th1 = 5.62; tim1 = .60; th2 = 2.25;tim2 =1.75; timd = 6.75;
                   ediam = 1.0 ; elngth = 2.75 ; weng = .850 ; wfuel = .747 ;
                   break ;
                }
                case 11:  {  // D12-7
                   th1 = 5.62; tim1 = .60; th2 = 2.25;tim2 =1.75; timd = 8.75;
                   ediam = 1.0 ; elngth = 2.75 ; weng = .850 ; wfuel = .747 ;
                   break ;
                }
             }
             erad = .5 * ediam ;
             cgeng = cgfuel = .5 * elngth ;
 
             if (nclust == 1) {
                V1 = Double.valueOf(m.c.o1.getText()) ;
                v1 = V1.doubleValue() ;
                numeng  = (int) v1 ;
                if(numeng < 1) {
                    numeng = 1 ;
                    m.c.o1.setText(String.valueOf(filter0(numeng))) ;
                }
                if(numeng > 4) {
                    numeng =  4 ;
                    m.c.o1.setText(String.valueOf(filter0(numeng))) ;
                }
       // determine minimum body tube diameter
                mediam = ediam ;
                if (numeng == 2) mediam = 2.0 * ediam ;
                if (numeng == 3) mediam = 2.154 * ediam ;
                if (numeng == 4) mediam = 2.414 * ediam ;
                merad = .5 * mediam ;
                up.o1.setText(String.valueOf(filter3(ediam * lconv2)) + outlng) ;
                m.c.o2.setText(String.valueOf(filter3(mediam * lconv2)) + outlng) ;
       // adjust thrust and weights
                th1 = numeng * th1 ;
                th2 = numeng * th2 ;
                weng = numeng * weng ;
                wfuel = numeng * wfuel ;
                up.o2.setText(String.valueOf(filter3(16.0 * th1*fconv)) + outfor) ;
                up.o3.setText(String.valueOf(filter3(weng*fconv)) + outfor) ;
                up.o4.setText(String.valueOf(filter3(wfuel*fconv)) + outfor) ;
             }
 
             if (nclust == 0) {
       // adjust times for multistage
                if (nstage == 2) {
                   tim1 = tim1 + tim2b1 ;
                   tim2 = tim2 + tim2b1 ;
                   timd = timd + tim2b1 ;
                }
 
                mediam = ediam ;
                if (b1ediam > mediam) mediam = b1ediam ;
                merad = .5 * mediam ;

                up.o1.setText(String.valueOf(filter3(mediam * lconv2)) + outlng) ;
                up.o3.setText(String.valueOf(filter3(weng*fconv)) + outfor) ;
                up.o4.setText(String.valueOf(filter3(wfuel*fconv)) + outfor) ;
                numeng = 1 ;
                m.c.o1.setText(String.valueOf(filter0(numeng))) ;
                if (nstage == 1) {
                   up.o2.setText(String.valueOf(filter3(16.0 * th1*fconv)) + outfor) ;
                }
                if (nstage == 2) {
                   up.o2.setText(String.valueOf(filter3(16.0 * th1b1*fconv)) + outfor) ;
                }
             }

             fixBodyGeom() ;

             solve.comPute() ;
          }  // end model rocket thrust

          public void getFinGeom() {
             Double V1,V2 ;
             double v1,v2 ;

             V1 = Double.valueOf(m.s.o5.getText()) ;
             v1 = V1.doubleValue() ;
             b1fteang  = v1 ;
             if(v1 < ftemin) {
                 b1fteang = ftemin ;
                 m.s.o5.setText(String.valueOf(filter3(b1fteang))) ;
             }
             if(v1 >= ftemax) {
                 b1fteang = ftemax ;
                 m.s.o5.setText(String.valueOf(filter3(b1fteang))) ;
             }

             V2 = Double.valueOf(m.s.o2.getText()) ;
             v2 = V2.doubleValue() ;
             b1fleang  = v2 ;
             if(v2 < 0.0) {
                 b1fleang = 0.0 ;
                 m.s.o2.setText(String.valueOf(filter3(b1fleang))) ;
             }
             if(v2 >= flemax) {
                 b1fleang = flemax ;
                 m.s.o2.setText(String.valueOf(filter3(b1fleang))) ;
             }
             b1ftanle = Math.tan(convdr*b1fleang) ;
             b1ftante = Math.tan(convdr*b1fteang) ;

             V1 = Double.valueOf(m.s.o1.getText()) ;
             v1 = V1.doubleValue() ;
             b1flngd  = v1 ;
             if(v1 < .1) {
                 b1flngd = .1 ;
                 m.s.o1.setText(String.valueOf(filter3(b1flngd))) ;
             }
             if(v1 > b1lngd) {
                 b1flngd =  b1lngd ;
                 m.s.o1.setText(String.valueOf(filter3(b1flngd))) ;
             }
             b1flngth = b1flngd / lconv2 ;

             if ((b1ftanle - b1ftante) >= .02) {
               b1fwmax = b1flngd / (b1ftanle - b1ftante) ;
               if (b1fwmax >= fwex * lconv2 ) b1fwmax = fwex * lconv2 ;
             }

             V1 = Double.valueOf(m.s.o4.getText()) ;
             v1 = V1.doubleValue() ;
             b1fwd  = v1 ;
             if(v1 < .1) {
                 b1fwd = .1 ;
                 m.s.o4.setText(String.valueOf(filter3(b1fw))) ;
             }
             if(v1 > b1fwmax) {
                 b1fwd =  b1fwmax ;
                 m.s.o4.setText(String.valueOf(filter3(b1fw))) ;
             }
             b1fw = b1fwd / lconv2 ;

             if (fintype == 0) {  // trapezoidal
               finx[1][3] = 0.0 ;
               finy[1][3] = -tlngth -b1lngth ;
               finx[1][2] = b1fw ;
               finy[1][2] = -tlngth -b1lngth - b1fw * b1ftante ;
               finx[1][1] = b1fw ;
               finy[1][1] = -tlngth -b1lngth + b1flngth - b1fw * b1ftanle ;
               finx[1][0] = 0.0 ;
               finy[1][0] = -tlngth -b1lngth + b1flngth;

               safb1 = b1fw*b1flngth - .5 *b1fw*b1fw * (b1ftanle - b1ftante);
               cgfb1 = (b1fw * b1flngth * b1flngth
                 - b1fw * b1fw * b1flngth * b1ftanle
                 + (b1fw*b1fw*b1fw*((b1ftanle*b1ftanle)-(b1ftante*b1ftante)))/3.0
                 ) / (2.0 * safb1) ;
               cpfb1 = cgfb1 ;
             }

             if (fintype == 1) {     // elliptical
               finx[1][0] = -b1fw ;
               finy[1][0] = -tlngth - b1lngth + b1flngth  ;
               finx[1][1] = 2.0 * b1fw ;
               finy[1][1] = b1flngth  ;
  
               safb1 = .5 * pi * b1fw * b1flngth ;
               cgfb1 = .5 * b1flngth ;
               cpfb1 = cgfb1 ;
             }
   
             delt = 360. / (double) numfin ;
             ap   = 0.0 ;
             thet = 0.0 ;
             while (thet <= 180.) {
                ap = ap + safb1 * Math.sin(thet*convdr) ;
                thet = thet + delt ;
             }
             pafb1 = 2.0 * ap ;
   
             wfinb1 = dfin * safin * numfin ;
          }

          public void fixBodyGeom() {
             int i2 ;

       // insure that body tube is large enough for the engine
             blmin = elngth ;
             bdmin = mediam ;
             tdmin = mediam ;
             if (blngth <= elngth) {
               blngth = elngth ; 
               blngd = blngth * lconv2 ;
               act.inp.body.lt.f1.setText(String.valueOf(filter3(blngd))) ;
             }
             i2 = (int) (((blngd - blmin)/(blmax-blmin))*1000.) ;
             act.inp.body.rt.s1.setValue(i2) ;
             if (bdiam <= mediam) {
               bdiam = mediam ; brad = merad ;
               bdiamd = bdiam * lconv2 ;
               act.inp.body.lt.f2.setText(String.valueOf(filter3(bdiamd))) ;
             }
             i2 = (int) (((bdiamd - bdmin)/(bdmax-bdmin))*1000.) ;
             act.inp.body.rt.s2.setValue(i2) ;
             if (tdiam <= mediam) {
               tdiam = mediam ; trad = merad ;
               tdiamd = tdiam * lconv2 ;
               act.inp.body.lt.f4.setText(String.valueOf(filter3(tdiamd))) ;
             }
             i2 = (int) (((tdiamd - tdmin)/(tdmax-tdmin))*1000.) ;
             act.inp.body.rt.s4.setValue(i2) ;

             act.inp.body.getGeom() ;

             return ;
          }  // end fix geom
       }   // end solid engine

       class Bali extends Panel {
          Rocket outerparent ;
          Lt lt ;
          Rt rt ;
  
          Bali (Rocket target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Rocket outerparent ;
             Scrollbar s1,s2,s3,s4;
             Choice obch ;

             Rt (Rocket target) {

               int i1,i2,i3,i4 ;
  
               outerparent = target ;
               setLayout(new GridLayout(7,1,10,5)) ;

               i1 = (int) (((wtd - wtmin)/(wtmax-wtmin))*1000.) ;
               i2 = (int) (((cd - cdmin)/(cdmax-cdmin))*1000.) ;
               i3 = (int) (((catd - camin)/(camax-camin))*1000.) ;
               i4 = (int) (((vmuzld - vmmin)/(vmmax-vmmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
  
               obch = new Choice() ;
               obch.addItem("Rocket") ;
               obch.addItem("Ideal Shell (Drag=0)") ;
               obch.addItem("Baseball") ;
               obch.select(0) ;
 
               add(obch) ;
               add(s2) ;
               add(s3) ;
               add(new Label(" ", Label.CENTER)) ;
               add(s4) ;
               add(s1) ;
               add(new Label(" ", Label.CENTER)) ;
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleCho(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
          public void handleCho(Event evt) {
             int i1,i2,i3 ;
             double v1,v2,v3 ;
             float fl1,fl2,fl3 ;

             balob = obch.getSelectedIndex() ;

             vmn1 = wtmin;    vmx1 = wtmax ;
             vmn2 = cdmin;    vmx2 = cdmax ;
             vmn3 = camin;    vmx3 = camax ;

             switch (balob) {
                 case 0:{              /* Rocket */
                     ldisplay = 0 ;
                     v2 = cd = 0.7 ;
                     i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                     fl2 = filter3(v2) ;
                     lt.f2.setText(String.valueOf(fl2)) ;
                     rt.s2.setValue(i2) ;
                     break;
                 }
                 case 1:{              /* Shell */
                     ldisplay = 1 ;
                     v2 = cd = 0.0 ;
                     i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                     fl2 = filter3(v2) ;
                     lt.f2.setText(String.valueOf(fl2)) ;
                     rt.s2.setValue(i2) ;
                     break;
                 }
                 case 2:{              /* Baseball */
                     ldisplay = 2 ;
                     v2 = cd = 0.4 ;
                     i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                     fl2 = filter3(v2) ;
                     lt.f2.setText(String.valueOf(fl2)) ;
                     rt.s2.setValue(i2) ;
                     weight = 5.0 ;
                     v1  = wtd = weight * fconv ;
                     i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
                     fl1 = filter3(v1) ;
                     lt.f1.setText(String.valueOf(fl1)) ;
                     rt.s1.setValue(i1) ;
                     catot = 6.45 ;
                     v3 = catd = catot * aconv ;
                     i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
                     fl3 = filter3(v3) ;
                     lt.f3.setText(String.valueOf(fl3)) ;
                     rt.s3.setValue(i3) ;
                     break;
                 }
             }
             solve.comPute() ;
          }

          public void handleBar(Event evt) {     // ballistic shell
             int i1,i2,i3,i4;
             double v1,v2,v3,v4 ;
             float fl1,fl2,fl3,fl4 ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;
             i4 = s4.getValue() ;

             vmn1 = wtmin;    vmx1 = wtmax ;
             vmn2 = cdmin;    vmx2 = cdmax ;
             vmn3 = camin;    vmx3 = camax ;
             vmn4 = vmmin;    vmx4 = vmmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
             v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
 
             wtd = v1 ;
             weight = wtd / fconv ;
             cd = v2 ;
             cg = 0.0 ;
             cp = 0.0 ;
             catd = v3 ;
             catot = catd / aconv ;
             vmuzld = v4 ;
             vmuzl = vmuzld / lconv1 ;
 
             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl3 = filter3(v3) ;
             fl4 = filter3(v4) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f3.setText(String.valueOf(fl3)) ;
             lt.f4.setText(String.valueOf(fl4)) ;

             solve.comPute() ;

           }  // end handle
         }  // end right
 
         class Lt extends Panel {
           Rocket outerparent ;
           TextField f1, f2, f3, f4 ;
           Label l1, l2, l3, l4, lab ;
           Button butgo ;
  
           Lt (Rocket target) {
              outerparent = target ;
              setLayout(new GridLayout(7,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;

              l1 = new Label("Weight oz", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)wtd),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("Drag Coeff", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)cd),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              l3 = new Label("Area sq in", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)catd),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("Speed fps", Label.CENTER) ;
              f4 = new TextField(String.valueOf((float)vmuzld),5) ;
              f4.setBackground(Color.white) ;
              f4.setForeground(Color.black) ;

              add(butgo) ;
              add(new Label("Object:", Label.RIGHT)) ;

              add(l2) ;
              add(f2) ;

              add(l3) ;
              add(f3) ;

              add(new Label(" ", Label.CENTER)) ;
              add(new Label(" ", Label.CENTER)) ;

              add(l4) ;
              add(f4) ;

              add(l1) ;
              add(f1) ;

              add(new Label("on Earth", Label.CENTER)) ;
              add(new Label(" ", Label.CENTER)) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 ifuel = 1 ;
                 act.con.btm2.setBackground(Color.green) ;
                 act.con.btm2.setForeground(Color.black) ;
                 ides = 1;
                 act.con.btm1.setBackground(Color.green) ;
                 act.con.btm1.setForeground(Color.black) ;
                 act.con.btm4.setBackground(Color.white) ;
                 act.con.btm4.setForeground(Color.blue) ;
                 butgo.setBackground(Color.green) ;
                 butgo.setForeground(Color.black) ;
                 weight = wtd / fconv ;
                 loadOut() ;
              }
           }
  
           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4 ;
             double v1,v2,v3,v4 ;
             int i1,i2,i3,i4 ;
             float fl1 ;

             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
             V4 = Double.valueOf(f4.getText()) ;
             v4 = V4.doubleValue() ;

     // weight
             wtd  = v1 ;
             vmn1 = wtmin;   vmx1 = wtmax ;
             if(v1 < vmn1) {
                 wtd = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 wtd =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             weight = wtd / fconv ;

     // drag coefficient
             cd  = v2 ;
             vmn2 = cdmin;   vmx2 = cdmax ;
             if(v2 < vmn2) {
                 cd = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 cd =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }

     // cross-sectional area
             catd  = v3 ;
             vmn3 = camin;   vmx3 = camax ;
             if(v3 < vmn3) {
                 catd = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 catd =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             catot = catd / aconv ;

     // muzzle velocity
             vmuzld  = v4 ;
             vmn4 = vmmin;   vmx4 = vmmax ;
             if(v4 < vmn4) {
                 vmuzld = v4 = vmn4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             if(v4 > vmx4) {
                 vmuzld =  v4 = vmx4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             vmuzl = vmuzld / lconv1 ;

             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
             i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
  
             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;
             rt.s4.setValue(i4) ;

             cg = 0.0 ;
             cp = 0.0 ;

             solve.comPute() ;

           }  // end handle
         }  //  end  left
       }   // end ballistic shell
    }  // end  Inp

  } // end of Act

  class View extends Canvas  
         implements Runnable{
     Rocket outerparent ;
     Thread runner ;
     Point locate,anchor;
   
     View (Rocket target) {
         setBackground(Color.white) ;
         runner = null ;
     } 

     public Insets insets() {
        return new Insets(0,5,0,5) ;
     }
 
     public boolean mouseDown(Event evt, int x, int y) {
        anchor = new Point(x,y) ;
        return true;
     }

     public boolean mouseUp(Event evt, int x, int y) {
        handleb(x,y) ;
        return true;
     }

     public boolean mouseDrag(Event evt, int x, int y) {
        handle(x,y) ;
        return true;
     }

     public void handle(int x, int y) {  // slider widgets
       // determine location
       if (y >= 20 && y <= 375) {
         if (x <= 35 ) {   // zoom widget
           if (y >= 45 && y <= 375) {
             sldloc = y ;
             if (sldloc < 50) sldloc = 50;
             if (sldloc > 350) sldloc = 350;
             fact = facmin + (350 - sldloc) * facrat;
             if (viewflg == 0) {
               if (fact < 5.0) fact = 5.0 ;
             }
           }
         }
         if (x >= 36 ) {   // translate
           locate = new Point(x,y) ;
           yt =  yt + (int) (.2*(locate.y - anchor.y)) ;
           xt =  xt + (int) (.4*(locate.x - anchor.x))  ;
           if (xt > 50000) xt = 50000 ;
           if (xt < -50000) xt = -50000 ;
           if (yt > 50000) yt = 50000 ;
           if (yt <-50000) yt = -50000 ;
         }
       }
       if (viewflg == 2) {
         factc = fact ;
         xtc = xt ;
         ytc = yt ;
         sldc = sldloc ;
       }
       if (viewflg == 1) {
         facts = fact ;
         xts = xt ;
         yts = yt ;
         slds = sldloc ;
       }
       if (viewflg == 0) {
         facto = fact ;
         xto = xt ;
         yto = yt ;
         sldo = sldloc ;
       }
     }

     public void handleb(int x, int y) { // view buttons
       float fl3 ;
       int i3 ;

       if (x <= 30) { 
          if (y >=31 && y <= 45) {  // grid switch
             gridon = -gridon ;
          }
          if (y >= 425) { // save plot
             if (viewflg == 1) {
                npts[nsav] = npt ;
                nsav = nsav + 1 ;
                if (nsav == 5) nsav = 4 ;
             }
          }
       }
 
       if (y > 415) {
          if (x >= 100 && x <= 150) { // pad switch 
             if (viewflg == 0) setDesignView() ;
             if (viewflg == 1) setRangeView() ;
             if (viewflg == 2) setGraphView() ;
          }
          if (x >= 200 && x <= 250) { // trak switch  
             trakon = -trakon ;
          }
       }

       if (y < 25) {
          if (viewflg == 0 && lnchgrf == 0) {
             if (x >=35 && x <= 95) {  // nose design
               part = 1 ;
               layin.show(act.inp, "nos")  ;
               act.inp.nose.lt.butgo.setBackground(Color.white) ;
               act.inp.nose.lt.butgo.setForeground(Color.blue) ;
             }
             if (x >=100 && x <= 160) {  // payload design
               part = 2 ;
               layin.show(act.inp, "pay")  ;
               act.inp.payl.lt.butgo.setBackground(Color.white) ;
               act.inp.payl.lt.butgo.setForeground(Color.blue) ;
             }
             if (x >=165 && x <= 225) {  // body design
               part = 3 ;
               if (rktype < 2 || rktype > 2){
                  layin.show(act.inp, "bod")  ;
                  act.inp.body.lt.butgo.setBackground(Color.white) ;
                  act.inp.body.lt.butgo.setForeground(Color.blue) ;
               }
               if (rktype == 2){
                  layin.show(act.inp, "bot")  ;
                  act.inp.boti.lt.butgo.setBackground(Color.white) ;
                  act.inp.boti.lt.butgo.setForeground(Color.blue) ;
               }
             }
             if (x >=230 && x <= 295) {  // fins design
               part = 4 ;
               layin.show(act.inp, "fin")  ;
               act.inp.fins.lt.butgo.setBackground(Color.white) ;
               act.inp.fins.lt.butgo.setForeground(Color.blue) ;
             }
             ides = 0 ;
             act.con.btm1.setBackground(Color.yellow) ;
             act.con.btm1.setForeground(Color.black) ;
             act.con.btm4.setBackground(Color.white) ;
             act.con.btm4.setForeground(Color.blue) ;
          }
       }
       view.repaint() ;
     }

     public void start() {
        if (runner == null) {
           runner = new Thread(this) ;
           runner.start() ;
        }
     }

     public void run() {
       int timer,i ;
       double vvld,hvld,angle,deltmx,oldmass,newmass;
       double vald,hald;
       String outht,outspd,outfor,outpres ;
   
       timer = 100 ;
       deltim  = .2 ;
       angle = pid2 ;
       oldmass = volbot * .00237 /1728. ;
       while (true) {
          try { Thread.sleep(timer); }
          catch (InterruptedException e) {}
          outht = " ft" ;
          if (lunits == 1) outht = " m" ;
          outspd = " fps" ;
          if (lunits == 1) outspd = " mps" ;
          outfor = " oz" ;
          if (lunits == 1) outfor = " g" ;
          outpres = " psi" ;
          if (lunits == 1) outpres = " kPa" ;
          posa[0] = (90.0 - lnchang) * convdr ;
          if (fire == 1) {  // launch sequence
             if (comp == 1 && istab == 1 && 
               irange == 1 && ifuel == 1 && ides == 1) {
               fltim = fltim + deltim ;
               if (planet == 2) wind = 0.0 ;  // no wind on the moon
      // countdown
               if (fltim < 0.0) {
                  act.inp.lnch.o1.setText(String.valueOf(filter0(fltim))) ;
               }
      // flight
               if (fltim >= 0.0) {
                  act.inp.lnch.o1.setForeground(Color.green) ;
                  act.inp.lnch.bt5.setBackground(Color.green) ;
                  act.inp.lnch.bt5.setForeground(Color.black) ;
      // thrust
                  if (rktype == 10) {  // ballistic-no thrust or recovery
                      rtype = 0 ;
                      wtflt = weight * wtrat ;
                      thrust = 0.0 ;
                      deltim = .05 ;
                  }
                  if (rktype == 1) {  // stomp rocket-no thrust or recovery
                      rtype = 0 ;
                      wtflt = weight * wtrat ;
                      thrust = 0.0 ;
                      deltim = .05 ;
                  }
                  if (rktype == 2) {  // bottle rocket-thrust or recovery
                      rtype = act.inp.nose.rt.rcho.getSelectedIndex() ;
                      if (vloc <= llaunch &&
                            fltim <= (timrail + .15) 
                           ) { // launch tube-constant weight-constant vol
                         wtflt = weight * wtrat ;
                         thrust = (fpres - ps0)  * noza * 16.0 ;
                         instwat = wat ;
                         instair = volair ;
                         instpres = fpres ;
                         deltim = .01 ;
                         tim2 = fltim ;
                         oldmass = instair * .00237 /1728. ;
                      }
                      if (vloc >= llaunch && 
                                   instwat >= 0.01 && 
                                   instpres >= ps0) { // water expulsion
                         deltim = .01 ;
                         volrat = volair / instair ;
                         instpres = fpres * Math.pow(volrat,1.4) ;
                                // 1.94 slug/cu ft = density water
                         if (instpres >= ps0) {
                           uexit = Math.sqrt(2.0 * (instpres - ps0) * 144 / 1.94) ; // ft/sec
                         }
                         if (instpres <= ps0) {
                           uexit = 0.0 ;
                         }
                         mdot = 1.94 * uexit * noza / 144. ;  //   slug/sec
                         thrust = mdot * uexit * 16.0 ;  //  oz
                         instwat = instwat - mdot * deltim * 1728. / 1.94 ;  // cu in
                         instair = volbot - instwat ;
                         oldmass = instair * .00237 /1728. ;
                         wtflt = (weight - wfuel + instwat * .578) * wtrat ; // oz
                         tim2 = fltim ;
                      }
                      if (instwat <= 0.0 ) instwat = 0.0 ;
                      if (vloc >= llaunch && 
                                   instwat <=  0.05 &&
                                   instpres <= ps0 ) {  // out of fuel-thrust =  0
                         wtflt = (weight - wfuel) * wtrat ;
                         thrust = 0.0 ;
                         deltim = .2 ;
                      }
                      if (vloc >= llaunch && 
                                   instwat <= 0.0 && 
                                   instpres >= ps0) { //out of fuel .. pressure pop 
                         wtflt = (weight - wfuel) * wtrat ;
                         uexit = Math.sqrt(1.4 * rgas * ts0) ;
                         mdot = .34346 * noza * (instpres/14.7) / 32.2 ;
                         newmass = oldmass - mdot * deltim ;
                         if (newmass >= 0.0 ) {
                             thrust = mdot * uexit * 16.0 
                                  + (instpres - ps0) * noza * 16.0 ; 
                             instpres = instpres * Math.pow(newmass/oldmass,1.4) ;
                             oldmass = newmass ;
                         }
                         if (newmass < 0.0) {
                             thrust = 0.0 ;
                             instpres = 0.0 ;
                         }
                         if (instpres <= ps0) instpres = ps0 -.05 ;
                      }
/*
 act.con.diag4.setText(String.valueOf(instpres)) ;
 act.con.diag3.setText(String.valueOf(instpres)) ;
 act.con.diag2.setText(String.valueOf(instpres)) ;
 act.con.diag1.setText(String.valueOf(filter0(wher1))) ;
*/
                      if (instpres <= ps0) { 
                         wtflt = (weight - wfuel) * wtrat ;
                         thrust = 0.0 ;
                         deltim = .2 ;
                      }
                      act.inp.lnch.o11.setText(String.valueOf(filter1(instpres * pconv) + outpres)) ;
                      act.inp.lnch.o12.setText(String.valueOf(filter3(instwat * .578 * wtrat * fconv) + outfor)) ;
                  }
                  if (rktype == 3) {  // model rocket - thrust and recovery system
                      rtype = act.inp.nose.rt.rcho.getSelectedIndex() ;
                      if (nstage == 1) {
                         wtflt = (weight - (fltim/tim2)*wfuel) * wtrat ;
                         if (fltim > tim2) wtflt = (weight - wfuel) * wtrat ;
                         if(fltim <= tim1) {
                            thrust = 16.0*th1 ;
                            deltim = tim1 / 10.0 ;
                         }
                      }
                      if (nstage == 2) {
                         if (fltim < tim1) deltim = tim1 / 30.0 ;
                         if (fltim < tim2b1) {
                           wtflt = (weight - (fltim/tim2b1)*wfuelb1) * wtrat ;
                           if(fltim <= tim1b1) thrust = 16.0*th1b1 ;
                           if(fltim >= tim1b1) thrust = 16.0*th2b1 ; 
                         }
                         if ((fltim >= tim2b1) && (fltim < tim2)) {
                           wtflt = (weight - wfuelb1 - wengb1 - 
                              ((fltim - tim2b1)/(tim2 - tim2b1))*wfuel) * wtrat ;
                           thrust = 16.0*th1 ;
                         }
                         if (fltim > tim2) {
                           wtflt = (weight - wfuelb1 - wengb1 -wfuel) * wtrat ;
                         }
                      }
                      if((fltim >= tim1) && (fltim < tim2)) {
                          thrust = 16.0*th2 ;
                      }
                      if((fltim >= tim2) && (fltim < timd)) {
                          thrust = 0.0 ;
                          deltim = .2 ;
                      }
                  }
                  vvld = vvel ;
                  hvld = hvel ;
                  vald = vacc ;
                  hald = hacc ;
        // powered  and coasting
                  if (fltim < timd || rtype == 0 || planet == 1 || planet == 2) {
                     angle = Math.atan2(vvel,hvel) ;
                     if (vloc < llaunch && fltim < timd) {
                        angle = (90.0 - lnchang) * convdr ;
                     }
                     if (cockflg == 1 && cockcal == 1) {
                        angle = pid2 + Math.atan2(wind-hvel,vvel) ;
                     }

                     vacc = ((thrust-drag)*Math.sin(angle)-wtflt)/(wtflt/(g0 * wtrat)) ;
                     hacc = (thrust-drag)*Math.cos(angle) / (wtflt/(g0 * wtrat))  ;
                     vvel = vvld + .5 * (vacc + vald) * deltim ;
                     hvel = hvld + .5 * (hacc + hald) * deltim ;
                     spd = Math.sqrt(vvel*vvel + hvel*hvel) ;
                     drag = (16.0 * cd * .5 * rho * catot * spd * spd / 144.) ; 
                  }

        // recovery
                  if (fltim >= timd && rtype >= 1 && (planet == 0 || planet == 3)) {
                     vvel = -Math.sqrt((2.0 * wtflt * 144.)/
                                       (16.0 * cdrec * rho * carec));
                     spd = -vvel ;
                     angle = -pid2 ;
                     hvel = -hvld ;
                     deltmx = 1.0 ;
                     if (vmax > 500.) deltmx = 2.0 ;
                     if (vmax > 700.) deltmx = 3.0 ;
                     if (vmax > 1000.) deltmx = 5.0 ;
                     deltim = deltim + .2 ;
                     if (deltim > deltmx) deltim = deltmx ;
                     drag = wtflt ;
                     act.con.o2.setText(String.valueOf(filter3(cdrec))) ;
                  }

                  vloc = vloc + .5 * (vvel + vvld) * deltim ;
                  hloc = hloc + .5 * (hvel + hvld) * deltim ;

                  npt = npt + 1 ;
          // determine if on or off rail ..
                  posx[nsav][npt] = hloc + wind * (fltim - timrail) ;
                  if (vloc < llaunch && fltim < tim1) {
                     timrail = fltim ;
                     posx[nsav][npt] = hloc ;
                  }
                  posy[nsav][npt] = vloc ;
                  posa[npt] = angle ;

          // determine if engine burning        
                  if (rktype == 3 || rktype == 2) {    
                    if (fltim <= tim2) nburn = npt ;
          // discarded 1st stage
                    if (nstage == 2) {
                      if (fltim <= tim2b1) posb1 = posy[nsav][npt] ;
                      if (fltim > tim2b1) posb1 = vloc - 100.0 * (fltim - tim2b1) ;
                    }
                  }

                  cockcal = 0 ;
                  if (fltim > timrail && fltim < tim2) cockcal = 1;
         // deploy parachute for bottle rocket at apogee
                  if (rktype == 2 && rtype >= 1 && fltim < timd) {
                     if (vvel < 0.0) timd = fltim ;
                  }

                  act.inp.lnch.o1.setText(String.valueOf(filter3(fltim))) ;
               }
     // update maximums
               act.inp.lnch.o2.setText(String.valueOf(filter0(vloc*lconv1))+outht) ;
               act.inp.lnch.o3.setText(String.valueOf(filter0(spd*lconv1))+outspd) ;
               act.inp.lnch.o4.setText(String.valueOf(filter0(posx[nsav][npt] * lconv1))+outht);
               if (vloc > vmax) {
                  vmax = vloc ;
                  act.inp.lnch.o5.setText(String.valueOf(filter0(vmax*lconv1))+outht) ;
               }
               if (Math.abs(posx[nsav][npt]) > Math.abs(hmax)) {
                  hmax = posx[nsav][npt] ;
                  act.inp.lnch.o7.setText(String.valueOf(filter0(hmax*lconv1))+outht) ;
               }
               if (spd > spdmax) {
                  spdmax = spd;
                  act.inp.lnch.o6.setText(String.valueOf(filter0(spdmax*lconv1))+outspd) ;
               }
     // shutdown .. hit the ground
               if (vloc < 0.0 ) {  
                  posa[npt] = 0.0 ;
                  comp = 0 ;
                  vloc = 0.0 ;
                  act.inp.lnch.o2.setText(String.valueOf(filter0(vloc*lconv1))+outht) ;
                  irange = 0 ;
                  act.con.btm3.setBackground(Color.white) ;
                  act.con.btm3.setForeground(Color.blue) ;
                  ifuel = 0 ;
                  act.con.btm2.setBackground(Color.white) ;
                  act.con.btm2.setForeground(Color.blue) ;
                  act.con.btm4.setBackground(Color.white) ;
                  act.con.btm4.setForeground(Color.blue) ;
                  act.inp.lnch.bt5.setBackground(Color.red) ;
                  act.inp.lnch.bt5.setForeground(Color.white) ;
               }
             }
             act.inp.lnch.o8.setText(String.valueOf(filter3(thrust*fconv)) + outfor) ;
             act.inp.lnch.o9.setText(String.valueOf(filter3(drag*fconv)) + outfor) ;
             act.inp.lnch.o10.setText(String.valueOf(filter3(wtflt*fconv)) + outfor) ;
 
     // strip charts
             posx[5][npt] = 10.0*fltim ;
             posy[5][npt] = thrust ;
             posx[6][npt] = 10.0*fltim ;
             posy[6][npt] = wtflt ;
             posx[7][npt] = 10.0*fltim ;
             posy[7][npt] = drag ;
             posx[8][npt] = 10.0*fltim ;
             posy[8][npt] = vvel ;
             posx[9][npt] = 10.0*fltim ;
             posy[9][npt] = vloc ;

             if (stepon == 1) {
                comp = 0 ;
                if (step == 1) {
                  comp = 1;
                  step = 0 ;
                } 
             }
          }
     // reset integration
          if (fire == 0) {
             wtflt = weight * wtrat ;
             thrust = 0.0 ;
             timrail = 0.0 ;
             deltim = .2 ;
             fltim = 0.0 ;
             hloc = 0.0 ;
             vloc = 0.0 ;
             vvel = 0.0 ;
             hvel = 0.0 ;
             vmax = 0.0 ;
             hmax = 0.0 ;
             spdmax = 0.0 ;
             npt = 0 ;
             nburn = 0 ;
  
             act.inp.lnch.o1.setText(String.valueOf(filter0(fltim))) ;
             act.inp.lnch.o2.setText(String.valueOf(filter0(vloc*lconv1))+outht) ;
             act.inp.lnch.o3.setText(String.valueOf(filter0(vvel*lconv1))+outspd) ;
             act.inp.lnch.o4.setText(String.valueOf(filter0(hloc*lconv1))+outht) ;
             act.inp.lnch.o5.setText(String.valueOf(filter0(vmax*lconv1))+outht) ;
             act.inp.lnch.o6.setText(String.valueOf(filter0(spdmax*lconv1))+outspd) ;
             act.inp.lnch.o7.setText(String.valueOf(filter0(hmax*lconv1))+outht) ;
             act.inp.lnch.o8.setText(String.valueOf(filter3(thrust*fconv)) + outfor) ;
             act.inp.lnch.o9.setText(String.valueOf(filter3(drag*fconv)) + outfor) ;
             act.inp.lnch.o10.setText(String.valueOf(filter3(wtflt*fconv)) + outfor) ;
             act.con.o2.setText(String.valueOf(filter3(cd))) ;
/*
             if (rktype == 2) {
               act.inp.lnch.o11.setText(String.valueOf(filter1(fpres) + outpres)) ;
               act.inp.lnch.o12.setText(String.valueOf(filter3(wfuel * wtrat * fconv) + outfor)) ;
             }
*/
          }
          if (trakon > 0 && viewflg == 1) {  // tracking view
             fact = 2.5 ;
             if (planet == 2) fact = .06 ;
             if (planet == 3) fact = .11 ;
             xt = 160 - (int)(fact * posx[nsav][npt]) ;
             yt = 260 + (int)(fact * posy[nsav][npt]) ;
          }
          view.repaint() ;
 
       }
     }

     public void update(Graphics g) {
           view.paint(g) ;
     }
 
     public void paint(Graphics g) {
        int i,j,k,n ;
        int nump ;
        int exes[] = new int[9] ;
        int whys[] = new int[9] ;
        int ylabel,ylabel2,xlabel,xlabel2;
        double yval,xval,scale,btbase;
        double cpa,spa,nosx,nosy,hstg,pumph;
        double factm ;
        String words,outlng ;
        Color col1,col2 ;

        col1 = new Color(0,121,0) ;   // dark green
        col2 = new Color(254,121,0) ; // dark orange
 
 // design view
        if (viewflg == 0) {
           offsGg.setColor(Color.white) ;
           offsGg.fillRect(0,0,600,600) ;
           if (gridon >= 0) {       // Grid paper background
             if (lunits == 0) {
                for (j=0; j<=60; ++j) {
                  offsGg.setColor(Color.cyan) ;
                  if ((j/12) * 12 == j) offsGg.setColor(Color.blue) ;
                  whys[0] = 0 ; whys[1] = 500 ;
                  exes[0] = exes[1] = (int) (fact*(j)) + xt  ;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  exes[0] = exes[1] = (int) (-fact*(j)) + xt  ;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                }
                for (j=0; j<=60; ++j) {
                  offsGg.setColor(Color.cyan) ;
                  if ((j/12) * 12 == j) offsGg.setColor(Color.blue) ;
                  exes[0] = 0 ; 
                  exes[1] = 500 ;
                  whys[0] = whys[1] = (int) (fact*(j)) + yt;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  whys[0] = whys[1] = (int) (-fact*(j)) + yt;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  if (j == 1) {
                     whys[0] = (int) (-fact*(j)) + yt;
                     offsGg.setColor(Color.black) ;
                     offsGg.drawString("1 inch",230,whys[0]+5) ; 
                  }
                  if (j == 12) {
                     whys[0] = (int) (-fact*(j)) + yt;
                     offsGg.setColor(Color.blue) ;
                     offsGg.drawString("1 foot",230,whys[0]+5) ; 
                  }
                }
             }
             if (lunits == 1) {
                for (j=0; j<=60; ++j) {
                  offsGg.setColor(Color.cyan) ;
                  if ((j/12) * 12 == j) offsGg.setColor(Color.blue) ;
                  whys[0] = 0 ; whys[1] = 500 ;
                  exes[0] = exes[1] = (int) (fact*(j* 10.0 / lconv2)) + xt  ;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  exes[0] = exes[1] = (int) (-fact*(j* 10.0 / lconv2)) + xt  ;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                }
                for (j=0; j<=60; ++j) {
                  offsGg.setColor(Color.cyan) ;
                  if ((j/10) * 10 == j) offsGg.setColor(Color.blue) ;
                  exes[0] = 0 ; 
                  exes[1] = 500 ;
                  whys[0] = whys[1] = (int) (fact*(j *10.0 / lconv2)) + yt;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  whys[0] = whys[1] = (int) (-fact*(j * 10.0 / lconv2)) + yt;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  if (j == 1) {
                     whys[0] = (int) (-fact*(j* 10.0 / lconv2)) + yt;
                     offsGg.setColor(Color.black) ;
                     offsGg.drawString("10 cm",230,whys[0]+5) ; 
                  }
                  if (j == 10) {
                     whys[0] = (int) (-fact*(j* 10.0 / lconv2)) + yt;
                     offsGg.setColor(Color.blue) ;
                     offsGg.drawString("1 meter",230,whys[0]+5) ; 
                  }
                }
             }
           }
   
           if (rktype < 2 || rktype > 2) {
         // tail fairing
              exes[0] = (int) (fact*(-brad)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(-trad)) + xt ;
              whys[1] = (int) (fact*(tlngth)) + yt ;
              exes[2] = (int) (fact*(trad)) + xt ;
              whys[2] = (int) (fact*(tlngth)) + yt ;
              exes[3] = (int) (fact*(brad)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(-brad)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,4) ;
        // body tube
              exes[0] = (int) (fact*(-brad)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(-brad)) + xt ;
              whys[1] = (int) (fact*(-blngth)) + yt ;
              exes[2] = (int) (fact*(brad)) + xt ;
              whys[2] = (int) (fact*(-blngth)) + yt ;
              exes[3] = (int) (fact*(brad)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(-brad)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.green) ;
              offsGg.fillPolygon(exes,whys,4) ;
           }
      // bottle rocket
           if (rktype ==  2) {
         // tail fairing
              if (btfair == 1) {
                 exes[0] = (int) (fact*(-brad)) + xt ;
                 whys[0] = (int) (fact*(-4.0)) + yt ;
                 exes[1] = (int) (fact*(-btrad)) + xt ;
                 whys[1] = (int) (fact*(-(4.0 - btlngth))) + yt ;
                 exes[2] = (int) (fact*(btrad)) + xt ;
                 whys[2] = (int) (fact*(-(4.0 - btlngth))) + yt ;
                 exes[3] = (int) (fact*(brad)) + xt ;
                 whys[3] = (int) (fact*(-4.0)) + yt ;
                 exes[4] = (int) (fact*(-brad)) + xt ;
                 whys[4] = (int) (fact*(-4.0)) + yt ;
                 offsGg.setColor(Color.red) ;
                 offsGg.fillPolygon(exes,whys,4) ;
              }
         // body
              exes[0] = (int) (fact*(-brad)) + xt ;
              whys[0] = (int) (fact*(-4.0)) + yt ;
              exes[1] = (int) (fact*(-brad)) + xt ;
              whys[1] = (int) (fact*(-blngth)) + yt ;
              exes[2] = (int) (fact*(brad)) + xt ;
              whys[2] = (int) (fact*(-blngth)) + yt ;
              exes[3] = (int) (fact*(brad)) + xt ;
              whys[3] = (int) (fact*(-4.0)) + yt ;
              exes[4] = (int) (fact*(-brad)) + xt ;
              whys[4] = (int) (fact*(-4.0)) + yt ;
              offsGg.setColor(Color.green) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(-.5)) + xt ;
              whys[0] = (int) (fact*(-1.5)) + yt ;
              exes[1] = (int) (fact*(-brad)) + xt ;
              whys[1] = (int) (fact*(-4.0)) + yt ;
              exes[2] = (int) (fact*(brad)) + xt ;
              whys[2] = (int) (fact*(-4.0)) + yt ;
              exes[3] = (int) (fact*(.5)) + xt ;
              whys[3] = (int) (fact*(-1.5)) + yt ;
              exes[4] = (int) (fact*(-.5)) + xt ;
              whys[4] = (int) (fact*(-1.5)) + yt ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(-.5)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(-.5)) + xt ;
              whys[1] = (int) (fact*(-1.5)) + yt ;
              exes[2] = (int) (fact*(.5)) + xt ;
              whys[2] = (int) (fact*(-1.5)) + yt ;
              exes[3] = (int) (fact*(.5)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(-.5)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.fillPolygon(exes,whys,4) ;
           }
        // payload fairing
           exes[0] = (int) (fact*(-brad)) + xt ;
           whys[0] = (int) (fact*(-blngth)) + yt ;
           exes[1] = (int) (fact*(-prad)) + xt ;
           whys[1] = (int) (fact*(-(blngth + qlngth))) + yt ;
           exes[2] = (int) (fact*(prad)) + xt ;
           whys[2] = (int) (fact*(-(blngth + qlngth))) + yt ;
           exes[3] = (int) (fact*(brad)) + xt ;
           whys[3] = (int) (fact*(-blngth)) + yt ;
           exes[4] = (int) (fact*(-brad)) + xt ;
           whys[4] = (int) (fact*(-blngth)) + yt ;
           offsGg.setColor(Color.blue) ;
           offsGg.fillPolygon(exes,whys,4) ;
        // payload tube
           exes[0] = (int) (fact*(-prad)) + xt ;
           whys[0] = (int) (fact*(-(blngth + qlngth))) + yt ;
           exes[1] = (int) (fact*(-prad)) + xt ;
           whys[1] = (int) (fact*(-(blngth + qlngth + plngth))) + yt ;
           exes[2] = (int) (fact*(prad)) + xt ;
           whys[2] = (int) (fact*(-(blngth + qlngth + plngth))) + yt ;
           exes[3] = (int) (fact*(prad)) + xt ;
           whys[3] = (int) (fact*(-(blngth + qlngth))) + yt ;
           exes[4] = (int) (fact*(-prad)) + xt ;
           whys[4] = (int) (fact*(-(blngth + qlngth))) + yt ;
           offsGg.setColor(Color.green) ;
           offsGg.fillPolygon(exes,whys,4) ;
        // nose
           if (ntype == 0) {   // cone
              exes[0] = (int) (fact*(-nrad)) + xt ;
              whys[0] = (int) (fact*(-(blngth + qlngth + plngth))) + yt ;
              exes[1] = (int) (fact*(0.0)) + xt ;
              whys[1] = (int) (fact*(-(blngth + qlngth + plngth + nlngth))) + yt ;
              exes[2] = (int) (fact*(nrad)) + xt ;
              whys[2] = (int) (fact*(-(blngth + qlngth + plngth))) + yt ;
              exes[3] = (int) (fact*(-nrad)) + xt ;
              whys[3] = (int) (fact*(-(blngth + qlngth + plngth))) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,3) ;
           }
           if (ntype == 2 ) {   // parabola 
              for (j=1; j<=8; ++j) {
                yval = (j-1) * nlngth / 7.0 ;
                xval = nrad * (1.0 - (yval*yval/nlngth/nlngth));
                whys[j] = (int) (fact*(-(blngth + qlngth + plngth + yval)))+yt;
                exes[j] = (int) (fact*(xval)) + xt ;
              }
              exes[0] = (int) (fact*(0.0)) + xt ;
              whys[0] = (int) (fact*(-(blngth + qlngth + plngth)))+yt;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,9) ;
              for (j=1; j<=8; ++j) {
                yval = (j-1) * nlngth / 7.0 ;
                xval = nrad * (1.0 - (yval*yval/nlngth/nlngth));
                whys[j] = (int) (fact*(-(blngth + qlngth + plngth + yval)))+yt;
                exes[j] = (int) (fact*(-xval)) + xt ;
              }
              offsGg.fillPolygon(exes,whys,9) ;
           }
           if (ntype == 1 || ntype == 3) {   // ellipse 
              exes[0] = (int) (fact*(-nrad)) + xt ;
              whys[0] = (int) (fact*(-(blngth + qlngth + plngth + nlngth))) + yt ;
              exes[1] = (int) (fact*(2.0*nrad));
              whys[1] = (int) (fact*(2.0*nlngth));
              offsGg.setColor(Color.red) ;
              offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],0,180) ;
           }
        //  fins
           if (rktype < 2 || rktype > 2) {
              if (fintype == 0) {   // trapezoidal
                 exes[0] = (int) (fact*(-(brad + finx[0][0]))) + xt ;
                 whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                 exes[1] = (int) (fact*(-(brad + finx[0][1]))) + xt ;
                 whys[1] = (int) (fact*(-finy[0][1])) + yt ;
                 exes[2] = (int) (fact*(-(brad + finx[0][2]))) + xt ;
                 whys[2] = (int) (fact*(-finy[0][2])) + yt ;
                 exes[3] = (int) (fact*(-(brad + finx[0][3]))) + xt ;
                 whys[3] = (int) (fact*(-finy[0][3])) + yt ;
                 exes[4] = (int) (fact*(-(brad + finx[0][0]))) + xt ;
                 whys[4] = (int) (fact*(-finy[0][0])) + yt ;
                 offsGg.setColor(Color.black) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(brad + finx[0][0])) + xt ;
                 exes[1] = (int) (fact*(brad + finx[0][1])) + xt ;
                 exes[2] = (int) (fact*(brad + finx[0][2])) + xt ;
                 exes[3] = (int) (fact*(brad + finx[0][3])) + xt ;
                 exes[4] = (int) (fact*(brad + finx[0][0])) + xt ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(0.0)) + xt ;
                 offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                 offsGg.drawLine(exes[0],whys[1],exes[0],whys[2]) ;
                 offsGg.drawLine(exes[0],whys[2],exes[0],whys[3]) ;
              }
              if (fintype == 1) {  // elliptical
                 exes[0] = (int) (fact*(brad + finx[0][0])) + xt ;
                 whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                 exes[1] = (int) (fact*(finx[0][1]));
                 whys[1] = (int) (fact*(finy[0][1]));
                 offsGg.setColor(Color.black) ;
                 offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,-180) ;
                 exes[0] = (int) (fact*(-brad + finx[0][0])) + xt ;
                 offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,180) ;
                 exes[0] = (int) (fact*(0.0)) + xt ;
                 whys[0] = (int) (fact*(-floc)) + yt ;
                 whys[1] = (int) (fact*(-(floc + flngth))) + yt ;
                 offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
              }
           }
       // bottle rocket
           if (rktype == 2) {
              if (floc <= 1.5) {
                 btbase = btrad ;
                 if (btfair == 0) btbase = .5 ;
                 if (fintype == 0) {   // trapezoidal
                    exes[0] = (int) (fact*(-(btbase + finx[0][0]))) + xt ;
                    whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                    exes[1] = (int) (fact*(-(btbase+ finx[0][1]))) + xt ;
                    whys[1] = (int) (fact*(-finy[0][1])) + yt ;
                    exes[2] = (int) (fact*(-(btbase + finx[0][2]))) + xt ;
                    whys[2] = (int) (fact*(-finy[0][2])) + yt ;
                    exes[3] = (int) (fact*(-(btbase + finx[0][3]))) + xt ;
                    whys[3] = (int) (fact*(-finy[0][3])) + yt ;
                    exes[4] = (int) (fact*(-(btbase + finx[0][0]))) + xt ;
                    whys[4] = (int) (fact*(-finy[0][0])) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(btbase + finx[0][0])) + xt ;
                    exes[1] = (int) (fact*(btbase + finx[0][1])) + xt ;
                    exes[2] = (int) (fact*(btbase + finx[0][2])) + xt ;
                    exes[3] = (int) (fact*(btbase + finx[0][3])) + xt ;
                    exes[4] = (int) (fact*(btbase + finx[0][0])) + xt ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(0.0)) + xt ;
                    offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                    offsGg.drawLine(exes[0],whys[1],exes[0],whys[2]) ;
                    offsGg.drawLine(exes[0],whys[2],exes[0],whys[3]) ;
                 }
                 if (fintype == 1) {  // elliptical
                    exes[0] = (int) (fact*(btbase + finx[0][0])) + xt ;
                    whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                    exes[1] = (int) (fact*(finx[0][1]));
                    whys[1] = (int) (fact*(finy[0][1]));
                    offsGg.setColor(Color.black) ;
                    offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,-180) ;
                    exes[0] = (int) (fact*(-btbase + finx[0][0])) + xt ;
                    offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,180) ;
                    exes[0] = (int) (fact*(0.0)) + xt ;
                    whys[0] = (int) (fact*(-floc)) + yt ;
                    whys[1] = (int) (fact*(-(floc + flngth))) + yt ;
                    offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                 }
              }
              else {
                 if (fintype == 0) {   // trapezoidal
                    exes[0] = (int) (fact*(-(brad + finx[0][0]))) + xt ;
                    whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                    exes[1] = (int) (fact*(-(brad + finx[0][1]))) + xt ;
                    whys[1] = (int) (fact*(-finy[0][1])) + yt ;
                    exes[2] = (int) (fact*(-(brad + finx[0][2]))) + xt ;
                    whys[2] = (int) (fact*(-finy[0][2])) + yt ;
                    exes[3] = (int) (fact*(-(brad + finx[0][3]))) + xt ;
                    whys[3] = (int) (fact*(-finy[0][3])) + yt ;
                    exes[4] = (int) (fact*(-(brad + finx[0][0]))) + xt ;
                    whys[4] = (int) (fact*(-finy[0][0])) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(brad + finx[0][0])) + xt ;
                    exes[1] = (int) (fact*(brad + finx[0][1])) + xt ;
                    exes[2] = (int) (fact*(brad + finx[0][2])) + xt ;
                    exes[3] = (int) (fact*(brad + finx[0][3])) + xt ;
                    exes[4] = (int) (fact*(brad + finx[0][0])) + xt ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(0.0)) + xt ;
                    offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                    offsGg.drawLine(exes[0],whys[1],exes[0],whys[2]) ;
                    offsGg.drawLine(exes[0],whys[2],exes[0],whys[3]) ;
                 }
                 if (fintype == 1) {  // elliptical
                    exes[0] = (int) (fact*(brad + finx[0][0])) + xt ;
                    whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                    exes[1] = (int) (fact*(finx[0][1]));
                    whys[1] = (int) (fact*(finy[0][1]));
                    offsGg.setColor(Color.black) ;
                    offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,-180) ;
                    exes[0] = (int) (fact*(-brad + finx[0][0])) + xt ;
                    offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,180) ;
                    exes[0] = (int) (fact*(0.0)) + xt ;
                    whys[0] = (int) (fact*(-floc)) + yt ;
                    whys[1] = (int) (fact*(-(floc + flngth))) + yt ;
                    offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                 }
              }
           }
           if (nstage == 2) {
          // booster 1 tube
              exes[0] = (int) (fact*(-brad)) + xt ;
              whys[0] = (int) (fact*(tlngth)) + yt ;
              exes[1] = (int) (fact*(-brad)) + xt ;
              whys[1] = (int) (fact*(tlngth + b1lngth)) + yt ;
              exes[2] = (int) (fact*(brad)) + xt ;
              whys[2] = (int) (fact*(tlngth + b1lngth)) + yt ;
              exes[3] = (int) (fact*(brad)) + xt ;
              whys[3] = (int) (fact*(tlngth)) + yt ;
              exes[4] = (int) (fact*(-brad)) + xt ;
              whys[4] = (int) (fact*(tlngth)) + yt ;
              offsGg.setColor(Color.green) ;
              offsGg.fillPolygon(exes,whys,4) ;
        //  booster fins
              if (fintype == 0) {   // trapezoidal
                 exes[0] = (int) (fact*(-(brad + finx[1][0]))) + xt ;
                 whys[0] = (int) (fact*(-finy[1][0])) + yt ;
                 exes[1] = (int) (fact*(-(brad + finx[1][1]))) + xt ;
                 whys[1] = (int) (fact*(-finy[1][1])) + yt ;
                 exes[2] = (int) (fact*(-(brad + finx[1][2]))) + xt ;
                 whys[2] = (int) (fact*(-finy[1][2])) + yt ;
                 exes[3] = (int) (fact*(-(brad + finx[1][3]))) + xt ;
                 whys[3] = (int) (fact*(-finy[1][3])) + yt ;
                 exes[4] = (int) (fact*(-(brad + finx[1][0]))) + xt ;
                 whys[4] = (int) (fact*(-finy[1][0])) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(brad + finx[1][0])) + xt ;
                 exes[1] = (int) (fact*(brad + finx[1][1])) + xt ;
                 exes[2] = (int) (fact*(brad + finx[1][2])) + xt ;
                 exes[3] = (int) (fact*(brad + finx[1][3])) + xt ;
                 exes[4] = (int) (fact*(brad + finx[1][0])) + xt ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(0.0)) + xt ;
                 offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                 offsGg.drawLine(exes[0],whys[1],exes[0],whys[2]) ;
                 offsGg.drawLine(exes[0],whys[2],exes[0],whys[3]) ;
              }
              if (fintype == 1) {  // elliptical
                 exes[0] = (int) (fact*(brad + finx[1][0])) + xt ;
                 whys[0] = (int) (fact*(-finy[1][0])) + yt ;
                 exes[1] = (int) (fact*(finx[1][1]));
                 whys[1] = (int) (fact*(finy[1][1]));
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,-180) ;
                 exes[0] = (int) (fact*(-brad + finx[1][0])) + xt ;
                 offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,180) ;
                 exes[0] = (int) (fact*(0.0)) + xt ;
                 whys[0] = (int) (fact*(-floc)) + yt ;
                 whys[1] = (int) (fact*(-(floc + flngth))) + yt ;
                 offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
              }
           }
   // labels
           exes[0] = (int) (fact*(-brad -3.0)) + xt ;
           whys[0] = (int) (fact*(-(blngth + qlngth + plngth +.5*nlngth))) + yt;
           offsGg.setColor(Color.black) ;
           if (part == 1) offsGg.setColor(Color.red) ;
           offsGg.drawString("Nose",exes[0],whys[0]) ;
           if (plngth > 0.0) {
             exes[0] = (int) (fact*(-brad -4.0)) + xt ;
             whys[0] = (int) (fact*(-(blngth + qlngth + .5*plngth))) + yt ;
             offsGg.setColor(Color.black) ;
             if (part == 2) offsGg.setColor(Color.red) ;
             offsGg.drawString("Payload",exes[0],whys[0]) ;
           }
           if (qlngth > 0.0) {
             exes[0] = (int) (fact*(-brad -4.0)) + xt ;
             whys[0] = (int) (fact*(-(blngth + .5*qlngth))) + yt ;
             offsGg.setColor(Color.black) ;
             if (part == 2) offsGg.setColor(Color.red) ;
             offsGg.drawString("Fairing",exes[0],whys[0]) ;
           }
           exes[0] = (int) (fact*(-brad -3.0)) + xt ;
           whys[0] = (int) (fact*(-.5*blngth)) + yt ;
           offsGg.setColor(Color.black) ;
           if (part == 3) offsGg.setColor(Color.red) ;
           offsGg.drawString("Body",exes[0],whys[0]) ;
           if (tlngth > 0.0) {
             exes[0] = (int) (fact*(-brad -4.0)) + xt ;
             whys[0] = (int) (fact*( .5*tlngth)) + yt ;
             offsGg.setColor(Color.black) ;
             if (part == 3) offsGg.setColor(Color.red) ;
             offsGg.drawString("Fairing",exes[0],whys[0]) ;
           }
           exes[0] = (int) (fact*(-(brad + finx[0][1] + 2.0))) + xt ;
           whys[0] = (int) (fact*(-finy[0][1])) + yt ;
           offsGg.setColor(Color.black) ;
           if (part == 4) offsGg.setColor(Color.red) ;
           offsGg.drawString("Fins",exes[0],whys[0]) ;

           if (lnchgrf == 1) {   // stomp launcher
                  //  launch tube
              exes[0] = (int) (fact*(-trad +.1)) + xt ;
              whys[0] = (int) (fact*(-sl+ tlngth)) + yt ;
              exes[1] = (int) (fact*(-trad +.1)) + xt ;
              whys[1] = (int) (fact*(0.0+ tlngth)) + yt ;
              exes[2] = (int) (fact*(trad - .1)) + xt ;
              whys[2] = (int) (fact*(0.0+ tlngth)) + yt ;
              exes[3] = (int) (fact*(trad - .1)) + xt ;
              whys[3] = (int) (fact*(-sl+ tlngth)) + yt ;
              exes[4] = (int) (fact*(-trad + .1)) + xt ;
              whys[4] = (int) (fact*(-sl+ tlngth)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
                       // feed lines
              exes[0] = (int) (fact*(.2)) + xt ;
              whys[0] = (int) (fact*(.6+ tlngth)) + yt ;
              exes[1] = (int) (fact*(-.2)) + xt ;
              whys[1] = (int) (fact*(.6+ tlngth)) + yt ;
              exes[2] = (int) (fact*(-.2)) + xt ;
              whys[2] = (int) (fact*(0.0+ tlngth)) + yt ;
              exes[3] = (int) (fact*(.2)) + xt ;
              whys[3] = (int) (fact*(0.0+ tlngth)) + yt ;
              exes[4] = (int) (fact*(.2)) + xt ;
              whys[4] = (int) (fact*(.6+ tlngth)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(6.2)) + xt ;
              whys[0] = (int) (fact*(.4+ tlngth)) + yt ;
              exes[1] = (int) (fact*(0.0)) + xt ;
              whys[1] = (int) (fact*(.4+ tlngth)) + yt ;
              exes[2] = (int) (fact*(0.0)) + xt ;
              whys[2] = (int) (fact*(.6+ tlngth)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(.6+ tlngth)) + yt ;
              exes[4] = (int) (fact*(6.2)) + xt ;
              whys[4] = (int) (fact*(.4+ tlngth)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(5.8)) + xt ;
              whys[0] = (int) (fact*(.4+ tlngth)) + yt ;
              exes[1] = (int) (fact*(5.8)) + xt ;
              whys[1] = (int) (fact*(0.0)) + yt ;
              exes[2] = (int) (fact*(6.2)) + xt ;
              whys[2] = (int) (fact*(0.0)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(.4+ tlngth)) + yt ;
              exes[4] = (int) (fact*(5.8)) + xt ;
              whys[4] = (int) (fact*(.4+ tlngth)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
                    // resevoir
              pumph = Math.sqrt(sv1) ;
              exes[0] = (int) (fact*(4.0)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(8.0)) + xt ;
              whys[1] = (int) (fact*(0.0)) + yt ;
              exes[2] = (int) (fact*(8.0)) + xt ;
              whys[2] = (int) (fact*(-pumph)) + yt ;
              exes[3] = (int) (fact*(4.0)) + xt ;
              whys[3] = (int) (fact*(-pumph)) + yt ;
              exes[4] = (int) (fact*(4.0)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(4.1)) + xt ;
              whys[0] = (int) (fact*(-(sv2/sv1) * pumph )) + yt ;
              exes[1] = (int) (fact*(7.9)) + xt ;
              whys[1] = (int) (fact*(-(sv2/sv1) * pumph )) + yt ;
              exes[2] = (int) (fact*(7.9)) + xt ;
              whys[2] = (int) (fact*(-pumph +.1)) + yt ;
              exes[3] = (int) (fact*(4.1)) + xt ;
              whys[3] = (int) (fact*(-pumph +.1)) + yt ;
              exes[4] = (int) (fact*(4.1)) + xt ;
              whys[4] = (int) (fact*(-(sv2/sv1) * pumph )) + yt ;
              offsGg.setColor(Color.yellow) ;
              offsGg.fillPolygon(exes,whys,4) ;
                   // plunger
              exes[0] = (int) (fact*(5.8)) + xt ;
              whys[0] = (int) (fact*(-pumph)) + yt ;
              exes[1] = (int) (fact*(5.8)) + xt ;
              whys[1] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[2] = (int) (fact*(6.2)) + xt ;
              whys[2] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(-pumph)) + yt ;
              exes[4] = (int) (fact*(5.8)) + xt ;
              whys[4] = (int) (fact*(-pumph)) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(5.0)) + xt ;
              whys[0] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[1] = (int) (fact*(7.0)) + xt ;
              whys[1] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[2] = (int) (fact*(7.0)) + xt ;
              whys[2] = (int) (fact*(-pumph - 1.2)) + yt ;
              exes[3] = (int) (fact*(5.0)) + xt ;
              whys[3] = (int) (fact*(-pumph - 1.2)) + yt ;
              exes[4] = (int) (fact*(5.0)) + xt ;
              whys[4] = (int) (fact*(-pumph - 1.0)) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,4) ;
                 // labels
              exes[0] = (int) (fact*(4.0)) + xt ;
              whys[0] = (int) (fact*(1.5+ tlngth)) + yt;
              offsGg.setColor(Color.black) ;
              offsGg.drawString("Propulsion",exes[0],whys[0]) ;
              exes[0] = (int) (fact*(trad + 1.5)) + xt ;
              whys[0] = (int) (fact*(- .5+ tlngth)) + yt ;
              offsGg.drawString("Length",exes[0],whys[0]) ;
           }
           if (lnchgrf == 2) {   // bottle rocket
                  // fuel 
              if (wat < 1.178) {
                 exes[0] = (int) (fact*(-.5)) + xt ;
                 whys[0] = (int) (fact*(0.0)) + yt ;
                 exes[1] = (int) (fact*(-.5)) + xt ;
                 whys[1] = (int) (fact*(-hwat)) + yt ;
                 exes[2] = (int) (fact*(.5)) + xt ;
                 whys[2] = (int) (fact*(-hwat)) + yt ;
                 exes[3] = (int) (fact*(.5)) + xt ;
                 whys[3] = (int) (fact*(0.0)) + yt ;
                 exes[4] = (int) (fact*(-.5)) + xt ;
                 whys[4] = (int) (fact*(0.0)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
              }
              if ((wat >= 1.178) && (wat <= 14.922)) {
                 exes[0] = (int) (fact*(-.5)) + xt ;
                 whys[0] = (int) (fact*(0.0)) + yt ;
                 exes[1] = (int) (fact*(-.5)) + xt ;
                 whys[1] = (int) (fact*(-1.5)) + yt ;
                 exes[2] = (int) (fact*(.5)) + xt ;
                 whys[2] = (int) (fact*(-1.5)) + yt ;
                 exes[3] = (int) (fact*(.5)) + xt ;
                 whys[3] = (int) (fact*(0.0)) + yt ;
                 exes[4] = (int) (fact*(-.5)) + xt ;
                 whys[4] = (int) (fact*(0.0)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(-.5)) + xt ;
                 whys[0] = (int) (fact*(-1.5)) + yt ;
                 exes[1] = (int) (fact*(-watrad)) + xt ;
                 whys[1] = (int) (fact*(-hwat)) + yt ;
                 exes[2] = (int) (fact*(watrad)) + xt ;
                 whys[2] = (int) (fact*(-hwat)) + yt ;
                 exes[3] = (int) (fact*(.5)) + xt ;
                 whys[3] = (int) (fact*(-1.5)) + yt ;
                 exes[4] = (int) (fact*(-.5)) + xt ;
                 whys[4] = (int) (fact*(-1.5)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
              }
              if (wat > 14.922) {
                 exes[0] = (int) (fact*(-.5)) + xt ;
                 whys[0] = (int) (fact*(0.0)) + yt ;
                 exes[1] = (int) (fact*(-.5)) + xt ;
                 whys[1] = (int) (fact*(-1.5)) + yt ;
                 exes[2] = (int) (fact*(.5)) + xt ;
                 whys[2] = (int) (fact*(-1.5)) + yt ;
                 exes[3] = (int) (fact*(.5)) + xt ;
                 whys[3] = (int) (fact*(0.0)) + yt ;
                 exes[4] = (int) (fact*(-.5)) + xt ;
                 whys[4] = (int) (fact*(0.0)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(-.5)) + xt ;
                 whys[0] = (int) (fact*(-1.5)) + yt ;
                 exes[1] = (int) (fact*(-watrad)) + xt ;
                 whys[1] = (int) (fact*(-4.0)) + yt ;
                 exes[2] = (int) (fact*(watrad)) + xt ;
                 whys[2] = (int) (fact*(-4.0)) + yt ;
                 exes[3] = (int) (fact*(.5)) + xt ;
                 whys[3] = (int) (fact*(-1.5)) + yt ;
                 exes[4] = (int) (fact*(-.5)) + xt ;
                 whys[4] = (int) (fact*(-1.5)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(-watrad)) + xt ;
                 whys[0] = (int) (fact*(-4.0)) + yt ;
                 exes[1] = (int) (fact*(-watrad)) + xt ;
                 whys[1] = (int) (fact*(-hwat)) + yt ;
                 exes[2] = (int) (fact*(watrad)) + xt ;
                 whys[2] = (int) (fact*(-hwat)) + yt ;
                 exes[3] = (int) (fact*(watrad)) + xt ;
                 whys[3] = (int) (fact*(-4.0)) + yt ;
                 exes[4] = (int) (fact*(-watrad)) + xt ;
                 whys[4] = (int) (fact*(-4.0)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
              }
                  //  nozzle cap
              exes[0] = (int) (fact*(-.5)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(-.5)) + xt ;
              whys[1] = (int) (fact*(-.5)) + yt ;
              exes[2] = (int) (fact*(.5)) + xt ;
              whys[2] = (int) (fact*(-.5)) + yt ;
              exes[3] = (int) (fact*(.5)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(-.5)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.black) ;
              offsGg.fillPolygon(exes,whys,4) ;
                  //  launch tube
              exes[0] = (int) (fact*(-nozrad)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(-nozrad)) + xt ;
              whys[1] = (int) (fact*(-ltub)) + yt ;
              exes[2] = (int) (fact*(nozrad)) + xt ;
              whys[2] = (int) (fact*(-ltub)) + yt ;
              exes[3] = (int) (fact*(nozrad)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(-nozrad)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.yellow) ;
              offsGg.fillPolygon(exes,whys,4) ;
                       // feed lines
              exes[0] = (int) (fact*(.2)) + xt ;
              whys[0] = (int) (fact*(.6)) + yt ;
              exes[1] = (int) (fact*(-.2)) + xt ;
              whys[1] = (int) (fact*(.6)) + yt ;
              exes[2] = (int) (fact*(-.2)) + xt ;
              whys[2] = (int) (fact*(0.0)) + yt ;
              exes[3] = (int) (fact*(.2)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(.2)) + xt ;
              whys[4] = (int) (fact*(.6)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(6.2)) + xt ;
              whys[0] = (int) (fact*(.4)) + yt ;
              exes[1] = (int) (fact*(0.0)) + xt ;
              whys[1] = (int) (fact*(.4)) + yt ;
              exes[2] = (int) (fact*(0.0)) + xt ;
              whys[2] = (int) (fact*(.6)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(.6)) + yt ;
              exes[4] = (int) (fact*(6.2)) + xt ;
              whys[4] = (int) (fact*(.4)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(5.8)) + xt ;
              whys[0] = (int) (fact*(.4)) + yt ;
              exes[1] = (int) (fact*(5.8)) + xt ;
              whys[1] = (int) (fact*(0.0)) + yt ;
              exes[2] = (int) (fact*(6.2)) + xt ;
              whys[2] = (int) (fact*(0.0)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(.4)) + yt ;
              exes[4] = (int) (fact*(5.8)) + xt ;
              whys[4] = (int) (fact*(.4)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
                    // resevoir
              pumph = Math.sqrt(8.0) ;
              exes[0] = (int) (fact*(4.0)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(8.0)) + xt ;
              whys[1] = (int) (fact*(0.0)) + yt ;
              exes[2] = (int) (fact*(8.0)) + xt ;
              whys[2] = (int) (fact*(-pumph)) + yt ;
              exes[3] = (int) (fact*(4.0)) + xt ;
              whys[3] = (int) (fact*(-pumph)) + yt ;
              exes[4] = (int) (fact*(4.0)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(4.1)) + xt ;
              whys[0] = (int) (fact*(-(.25) * pumph )) + yt ;
              exes[1] = (int) (fact*(7.9)) + xt ;
              whys[1] = (int) (fact*(-(.25) * pumph )) + yt ;
              exes[2] = (int) (fact*(7.9)) + xt ;
              whys[2] = (int) (fact*(-pumph +.1)) + yt ;
              exes[3] = (int) (fact*(4.1)) + xt ;
              whys[3] = (int) (fact*(-pumph +.1)) + yt ;
              exes[4] = (int) (fact*(4.1)) + xt ;
              whys[4] = (int) (fact*(-(.25) * pumph )) + yt ;
              offsGg.setColor(Color.yellow) ;
              offsGg.fillPolygon(exes,whys,4) ;
                   // plunger
              exes[0] = (int) (fact*(5.8)) + xt ;
              whys[0] = (int) (fact*(-pumph)) + yt ;
              exes[1] = (int) (fact*(5.8)) + xt ;
              whys[1] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[2] = (int) (fact*(6.2)) + xt ;
              whys[2] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(-pumph)) + yt ;
              exes[4] = (int) (fact*(5.8)) + xt ;
              whys[4] = (int) (fact*(-pumph)) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(5.0)) + xt ;
              whys[0] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[1] = (int) (fact*(7.0)) + xt ;
              whys[1] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[2] = (int) (fact*(7.0)) + xt ;
              whys[2] = (int) (fact*(-pumph - 1.2)) + yt ;
              exes[3] = (int) (fact*(5.0)) + xt ;
              whys[3] = (int) (fact*(-pumph - 1.2)) + yt ;
              exes[4] = (int) (fact*(5.0)) + xt ;
              whys[4] = (int) (fact*(-pumph - 1.0)) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,4) ;
                 // labels
              exes[0] = (int) (fact*(4.0)) + xt ;
              whys[0] = (int) (fact*(1.5)) + yt;
              offsGg.setColor(Color.black) ;
              offsGg.drawString("Propulsion",exes[0],whys[0]) ;
              exes[0] = (int) (fact*(btrad + 1.5)) + xt ;
              whys[0] = (int) (fact*(- .5)) + yt ;
              offsGg.drawString("Length",exes[0],whys[0]) ;
           }
           if (lnchgrf == 3) {   // solid rocket
              if (nclust == 0) {
                 exes[0] = (int) (fact*(erad)) + xt ;
                 whys[0] = (int) (fact*(-elngth + tlngth)) + yt ;
                 exes[1] = (int) (fact*(-erad)) + xt ;
                 whys[1] = (int) (fact*(-elngth + tlngth)) + yt ;
                 exes[2] = (int) (fact*(-erad)) + xt ;
                 whys[2] = (int) (fact*(tlngth)) + yt ;
                 exes[3] = (int) (fact*(erad)) + xt ;
                 whys[3] = (int) (fact*(tlngth)) + yt ;
                 exes[4] = (int) (fact*(erad)) + xt ;
                 whys[4] = (int) (fact*(-elngth + tlngth)) + yt ;
                 offsGg.setColor(Color.orange) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(erad)) + xt ;
                 whys[0] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                 exes[1] = (int) (fact*(-erad)) + xt ;
                 whys[1] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                 exes[2] = (int) (fact*(-erad)) + xt ;
                 whys[2] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                 exes[3] = (int) (fact*(erad)) + xt ;
                 whys[3] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                 exes[4] = (int) (fact*(erad)) + xt ;
                 whys[4] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                 offsGg.setColor(Color.black) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(erad)) + xt ;
                 whys[0] = (int) (fact*(-.2 + tlngth)) + yt ;
                 exes[1] = (int) (fact*(-erad)) + xt ;
                 whys[1] = (int) (fact*(-.2 + tlngth)) + yt ;
                 exes[2] = (int) (fact*(-erad)) + xt ;
                 whys[2] = (int) (fact*(-.3 + tlngth)) + yt ;
                 exes[3] = (int) (fact*(erad)) + xt ;
                 whys[3] = (int) (fact*(-.3 + tlngth)) + yt ;
                 exes[4] = (int) (fact*(erad)) + xt ;
                 whys[4] = (int) (fact*(-.2 + tlngth)) + yt ;
                 offsGg.setColor(Color.black) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 if (nstage == 2) {
                    exes[0] = (int) (fact*(b1erad)) + xt ;
                    whys[0] = (int) (fact*(b1lngth -b1elngth + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-b1erad)) + xt ;
                    whys[1] = (int) (fact*(b1lngth -b1elngth + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-b1erad)) + xt ;
                    whys[2] = (int) (fact*(b1lngth + tlngth)) + yt ;
                    exes[3] = (int) (fact*(b1erad)) + xt ;
                    whys[3] = (int) (fact*(b1lngth + tlngth)) + yt ;
                    exes[4] = (int) (fact*(b1erad)) + xt ;
                    whys[4] = (int) (fact*(b1lngth  -b1elngth + tlngth)) + yt ;
                    offsGg.setColor(Color.orange) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(b1erad)) + xt ;
                    whys[0] = (int) (fact*(b1lngth -b1elngth + .2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-b1erad)) + xt ;
                    whys[1] = (int) (fact*(b1lngth -b1elngth + .2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-b1erad)) + xt ;
                    whys[2] = (int) (fact*(b1lngth -b1elngth + .3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(b1erad)) + xt ;
                    whys[3] = (int) (fact*(b1lngth -b1elngth + .3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(b1erad)) + xt ;
                    whys[4] = (int) (fact*(b1lngth -b1elngth + .2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(b1erad)) + xt ;
                    whys[0] = (int) (fact*(b1lngth -.2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-b1erad)) + xt ;
                    whys[1] = (int) (fact*(b1lngth -.2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-b1erad)) + xt ;
                    whys[2] = (int) (fact*(b1lngth -.3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(b1erad)) + xt ;
                    whys[3] = (int) (fact*(b1lngth -.3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(b1erad)) + xt ;
                    whys[4] = (int) (fact*(b1lngth -.2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                 }
              }
              if (nclust == 1) {
                 if (numeng == 1) {
                    exes[0] = (int) (fact*(erad)) + xt ;
                    whys[0] = (int) (fact*(-elngth + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-erad)) + xt ;
                    whys[1] = (int) (fact*(-elngth + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-erad)) + xt ;
                    whys[2] = (int) (fact*(tlngth)) + yt ;
                    exes[3] = (int) (fact*(erad)) + xt ;
                    whys[3] = (int) (fact*(tlngth)) + yt ;
                    exes[4] = (int) (fact*(erad)) + xt ;
                    whys[4] = (int) (fact*(-elngth + tlngth)) + yt ;
                    offsGg.setColor(Color.orange) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(erad)) + xt ;
                    whys[0] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-erad)) + xt ;
                    whys[1] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-erad)) + xt ;
                    whys[2] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(erad)) + xt ;
                    whys[3] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(erad)) + xt ;
                    whys[4] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(erad)) + xt ;
                    whys[0] = (int) (fact*(-.2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-erad)) + xt ;
                    whys[1] = (int) (fact*(-.2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-erad)) + xt ;
                    whys[2] = (int) (fact*(-.3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(erad)) + xt ;
                    whys[3] = (int) (fact*(-.3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(erad)) + xt ;
                    whys[4] = (int) (fact*(-.2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                 }
                 if (numeng > 1) {
                    exes[0] = (int) (fact*(-ediam)) + xt ;
                    whys[0] = (int) (fact*(-elngth + tlngth)) + yt ;
                    exes[1] = (int) (fact*(ediam)) + xt ;
                    whys[1] = (int) (fact*(-elngth + tlngth)) + yt ;
                    exes[2] = (int) (fact*(ediam)) + xt ;
                    whys[2] = (int) (fact*(tlngth)) + yt ;
                    exes[3] = (int) (fact*(-ediam)) + xt ;
                    whys[3] = (int) (fact*(tlngth)) + yt ;
                    exes[4] = (int) (fact*(-ediam)) + xt ;
                    whys[4] = (int) (fact*(-elngth + tlngth)) + yt ;
                    offsGg.setColor(Color.orange) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(-ediam)) + xt ;
                    whys[0] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(ediam)) + xt ;
                    whys[1] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(ediam)) + xt ;
                    whys[2] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(-ediam)) + xt ;
                    whys[3] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(-ediam)) + xt ;
                    whys[4] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(-ediam)) + xt ;
                    whys[0] = (int) (fact*(-.2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(ediam)) + xt ;
                    whys[1] = (int) (fact*(-.2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(ediam)) + xt ;
                    whys[2] = (int) (fact*(-.3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(-ediam)) + xt ;
                    whys[3] = (int) (fact*(-.3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(-ediam)) + xt ;
                    whys[4] = (int) (fact*(-.2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;

                    exes[0] = (int) (fact*(0.0)) + xt ;
                    whys[0] = (int) (fact*(-elngth + tlngth)) + yt ;
                    whys[1] = (int) (fact*(tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                 }
              }
           }
   // cg-cp
           exes[0] = (int) (fact*(0.0)) - 5 + xt ;
           whys[0] = (int) (fact*(-cg)) - 5 + yt;
           offsGg.setColor(Color.red) ;
           offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
           offsGg.setColor(Color.yellow) ;
           offsGg.fillArc(exes[0]+1,whys[0]+1,8,8,0,360) ;
           exes[0] = (int) (fact*(brad)) + 5 + xt ;
           offsGg.setColor(Color.blue) ;
           offsGg.drawString("Cg-Center of Gravity",exes[0],whys[0] + 10) ;

           exes[0] = (int) (fact*(0.0)) - 5 + xt ;
           whys[0] = (int) (fact*(-cp)) - 5 + yt;
           offsGg.setColor(Color.black) ;
           offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
           exes[0] = (int) (fact*(brad)) + 5 + xt ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Cp-Center of Pressure",exes[0],whys[0] + 10) ;
        }

 // flight view
        if (viewflg == 1) {
          if (planet <= 1) offsGg.setColor(Color.cyan) ;
          if (planet == 2) offsGg.setColor(Color.black) ;
          if (planet == 3) offsGg.setColor(Color.pink) ;
          offsGg.fillRect(0,0,600,600) ;
                // hills
          exes[0] = (int) (fact*(0.0)) + xt ;
          whys[0] = (int) (fact*(200.0)) + yt ;
          exes[1] = (int) (fact*(2000.0)) + xt ;
          whys[1] = (int) (fact*(-100.)) + yt ;
          exes[2] = (int) (fact*(4200)) + xt ;
          whys[2] = (int) (fact*(100.0)) + yt  ;
          exes[3] = (int) (fact*(7000.)) + xt ;
          whys[3] = (int) (fact*(-200.0)) + yt ;
          exes[4] = (int) (fact*(9000.)) + xt ;
          whys[4] = (int) (fact*(100.0)) + yt ;
          exes[5] = (int) (fact*(10000.)) + xt ;
          whys[5] = (int) (fact*(-100.0)) + yt ;
          exes[6] = (int) (fact*(12000.)) + xt ;
          whys[6] = (int) (fact*(200.0)) + yt ;
          exes[7] = (int) (fact*(0.0)) + xt ;
          whys[7] = (int) (fact*(200.0)) + yt ;
          if (planet <= 1) offsGg.setColor(col1) ;
          if (planet == 2) offsGg.setColor(Color.darkGray) ;
          if (planet == 3) offsGg.setColor(col2) ;
          offsGg.fillPolygon(exes,whys,7) ;
          exes[0] = (int) (fact*(-250.0)) + xt ;
          whys[0] = (int) (fact*(0.0)) + yt ;
          exes[1] = (int) (fact*(-2000.0)) + xt ;
          whys[1] = (int) (fact*(-100.)) + yt ;
          exes[2] = (int) (fact*(-4200)) + xt ;
          whys[2] = (int) (fact*(100.0)) + yt  ;
          exes[3] = (int) (fact*(-7000.)) + xt ;
          whys[3] = (int) (fact*(-200.0)) + yt ;
          exes[4] = (int) (fact*(-9000.)) + xt ;
          whys[4] = (int) (fact*(100.0)) + yt ;
          exes[5] = (int) (fact*(-15000.)) + xt ;
          whys[5] = (int) (fact*(-100.0)) + yt ;
          exes[6] = (int) (fact*(-22000.)) + xt ;
          whys[6] = (int) (fact*(100.0)) + yt ;
          exes[7] = (int) (fact*(-250.)) + xt ;
          whys[7] = (int) (fact*(0.0)) + yt ;
          if (planet <= 1) offsGg.setColor(col1) ;
          if (planet == 2) offsGg.setColor(Color.darkGray) ;
          if (planet == 3) offsGg.setColor(col2) ;
          offsGg.fillPolygon(exes,whys,8) ;
                // ground plane
          exes[0] = 0 ;
          whys[0] = (int) (fact*(-5.0)) + yt ;
          exes[1] = 500 ;
          whys[1] = (int) (fact*(-5.)) + yt ;
          exes[2] = 500 ;
          whys[2] = 500 ;
          exes[3] = 0 ;
          whys[3] = 500 ;
          exes[4] = 0 ;
          whys[4] = (int) (fact*(-5.0)) + yt ;
          if (planet <= 1) offsGg.setColor(Color.green) ;
          if (planet == 2) offsGg.setColor(Color.gray) ;
          if (planet == 3) offsGg.setColor(Color.orange) ;
          offsGg.fillPolygon(exes,whys,5) ;
                // wall
          exes[0] = (int) (fact*(350.0)) + xt ;
          whys[0] = (int) (fact*(5.0)) + yt ;
          exes[1] = (int) (fact*(350.0)) + xt ;
          whys[1] = (int) (fact*(-15.)) + yt ;
          exes[2] = (int) (fact*(352.0)) + xt ;
          whys[2] = (int) (fact*(-15.)) + yt ;
          exes[3] = (int) (fact*(352.0)) + xt ;
          whys[3] = (int) (fact*(5.0)) + yt ;
          exes[4] = (int) (fact*(350.0)) + xt ;
          whys[4] = (int) (fact*(5.0)) + yt ;
          offsGg.setColor(Color.red) ;
          offsGg.fillPolygon(exes,whys,5) ;
          exes[0] = (int) (fact*(-350.0)) + xt ;
          exes[1] = (int) (fact*(-350.0)) + xt ;
          exes[2] = (int) (fact*(-352.0)) + xt ;
          exes[3] = (int) (fact*(-352.0)) + xt ;
          exes[4] = (int) (fact*(-350.0)) + xt ;
          offsGg.fillPolygon(exes,whys,5) ;
          if (planet <= 1) {
                // building  #1
             exes[0] = (int) (fact*(650.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(680.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(680.0)) + xt ;
             whys[2] = (int) (fact*(-50.)) + yt ;
             exes[3] = (int) (fact*(660.0)) + xt ;
             whys[3] = (int) (fact*(-50.0)) + yt ;
             exes[4] = (int) (fact*(660.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(650.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(650.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #2
             exes[0] = (int) (fact*(1550.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(1580.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(1580.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(1560.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(1560.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(1550.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(1550.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #3
             exes[0] = (int) (fact*(2350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(2390.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(2390.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(2370.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(2370.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(2350.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(2350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #4
             exes[0] = (int) (fact*(3250.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(3290.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(3290.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(3270.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(3270.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(3250.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(3250.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #5
             exes[0] = (int) (fact*(4450.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(4490.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(4490.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(4470.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(4470.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(4450.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(4450.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #6
             exes[0] = (int) (fact*(-750.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-790.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-790.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(-770.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(-770.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(-750.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(-750.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                // building  #7
             exes[0] = (int) (fact*(-1250.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-1290.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-1290.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(-1270.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(-1270.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(-1250.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(-1250.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #8
             exes[0] = (int) (fact*(-2350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-2390.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-2390.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-2370.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-2370.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(-2350.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(-2350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #9
             exes[0] = (int) (fact*(-3550.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-3580.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-3580.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-3560.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-3560.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(-3550.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(-3550.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #10
             exes[0] = (int) (fact*(-4350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-4380.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-4380.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-4360.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-4360.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(-4350.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(-4350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
          }
                // Grid paper background
          if (gridon >= 0) {  
            factm = 50. ;
            if (fact < 2.5 && fact >= .5) factm = 100. ;
            if (fact < .5 && fact >= .25) factm = 500. ;
            if (fact < .25 && fact >= .1) factm = 1000. ;
            if (fact < .1 && fact >= .05) factm = 5000. ;
            if (fact < .05 && fact >= .001) factm = 10000. ;

            outlng = " ft" ;
            if (lunits == 1) {
               outlng = " m" ;
               factm = .5 * factm ;
            }
            for (j=0; j<=50; ++j) {
               exes[0] = 0 ; 
               exes[1] = 500 ;
               whys[0] = whys[1] = (int) (-fact*(factm*j / lconv1)) + yt;
               offsGg.setColor(Color.red) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.drawString(words,232,whys[0]+5) ; 
            }
            for (j=0; j<=50; ++j) {
               whys[0] = (int) (-fact*(0.0)) + yt;
               whys[1] = 0;
               exes[0] = exes[1] = (int) (fact*(factm*j / lconv1)) + xt  ;
               offsGg.setColor(Color.red) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.setColor(Color.black) ;
               if (planet == 2) offsGg.setColor(Color.white) ;
               offsGg.drawString(words,exes[0]-5,350) ;

               exes[0] = exes[1] = (int) (-fact*(factm*j / lconv1)) + xt  ;
               offsGg.setColor(Color.red) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.setColor(Color.black) ;
               if (planet == 2) offsGg.setColor(Color.white) ;
               offsGg.drawString(words,exes[0]-5,350) ;
            }
          }
       // labels 
               // saved flights
          if (nsav >= 1) {
            for (i=0; i<= nsav-1; ++ i) {
              exes[0] = (int) (fact*(0.0)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              nump = npts[i] ;
              for (j=0; j<=nump; ++j){
                exes[1] = exes[0] ;
                whys[1] = whys[0] ;
                exes[0] = (int) (fact*(posx[i][j])) + xt ;
                whys[0] = (int) (fact*(-posy[i][j])) + yt ;
                offsGg.setColor(Color.white) ;
                offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                if(i==0) offsGg.setColor(Color.blue) ;
                if(i==1) offsGg.setColor(Color.white) ;
                if(i==2) offsGg.setColor(Color.magenta) ;
                if(i==3) offsGg.setColor(Color.orange) ;
                offsGg.drawString("*",exes[0]-3,whys[0]+5) ;
              }
            }
          }
               // flight trajectory
          exes[0] = (int) (fact*(0.0)) + xt ;
          whys[0] = (int) (fact*(0.0)) + yt ;
          for (j=0; j<=npt; ++j){
            exes[1] = exes[0] ;
            whys[1] = whys[0] ;
            exes[0] = (int) (fact*(posx[nsav][j])) + xt ;
            whys[0] = (int) (fact*(-posy[nsav][j])) + yt ;
            if (planet <= 1) offsGg.setColor(Color.black) ;
            if (planet == 2) offsGg.setColor(Color.white) ;
            if (planet == 3) offsGg.setColor(Color.black) ;
            if (j < nburn) offsGg.setColor(Color.red) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            offsGg.setColor(Color.red) ;
            if ((rktype < 3) || (rktype == 10)) {
              offsGg.drawString("*",exes[0]-3,whys[0]+5) ;
            }
            if (rktype == 3 ) {
               if (j < nburn) offsGg.drawString("*",exes[0]-3,whys[0]+5) ;
            }
          }
     // flight rocket
          if (ldisplay == 0) {
            cpa = Math.cos(posa[npt]) ;
            spa = Math.sin(posa[npt]) ;
            if (rktype >= 2 && fltim >= timd && rtype >= 1) {
               cpa = Math.cos(pid2) ;
               spa = Math.sin(pid2) ;
               if (vloc == 0.0) {
                 cpa = Math.cos(0.0) ;
                 spa = Math.sin(0.0) ;
               }
            }
        // fins
            exes[0] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0. * cpa + 8.0 * spa) + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (0. * spa - 8.0 * cpa) + yt ;
            exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0. * cpa - 8.0 * spa) + xt ;
            whys[1] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (0. * spa + 8.0 * cpa) + yt ;
            exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (15. * cpa - 0.0 * spa) + xt ;
            whys[2] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (15. * spa + 0.0 * cpa)+ yt ;
            exes[3] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0. * cpa + 8.0 * spa) + xt ;
            whys[3] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (0. * spa - 8.0 * cpa) + yt ;
            offsGg.setColor(Color.blue) ;
            offsGg.fillPolygon(exes,whys,3) ;
        // body
            exes[0] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa - 3.0 * spa) + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (0.0 * spa + 3.0 * cpa) + yt ;
            exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa + 3.0 * spa) + xt ;
            whys[1] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (0.0 * spa - 3.0 * cpa)+ yt ;
            exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (40. * cpa + 3.0 * spa) + xt ;
            whys[2] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (40. * spa - 3.0 * cpa)+ yt ;
            exes[3] = (int) (fact*(posx[nsav][npt]))
                    + (int) (40. * cpa - 3.0 * spa) + xt ;
            whys[3] = (int) (fact*(-posy[nsav][npt]))
                  - (int) (40. * spa + 3.0 * cpa)+ yt ;
            exes[4] = (int) (fact*(posx[nsav][npt]))
                    + (int) (0.0 * cpa - 3.0 * spa) + xt ;
            whys[4] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (0.0 * spa + 3.0 * cpa)+ yt ;
            offsGg.setColor(Color.white) ;
            offsGg.fillPolygon(exes,whys,4) ;
        // nose
            nosx = 0.0 ;
            nosy = 40.0 ;
            if (rktype >= 2 && fltim >= timd && rtype >= 1) {
               nosx = 5.0 ;
               nosy = 20.0 ;
            }
            exes[0] = (int) (fact*(posx[nsav][npt]))
                  + (int) (nosy * cpa + (nosx +3.0) * spa) + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (nosy * spa - (nosx + 3.0) * cpa)+ yt ;
            exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) ((nosy + 15.) * cpa - nosx * spa) + xt ;
            whys[1] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) ((nosy + 15.) * spa + nosx * cpa) + yt ;
            exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (nosy * cpa + (nosx - 3.0) * spa) + xt ;
            whys[2] = (int) (fact*(-posy[nsav][npt]))
                  - (int) (nosy * spa - (nosx - 3.0) * cpa)+ yt ;
            exes[3] = (int) (fact*(posx[nsav][npt]))
                    + (int) (nosy * cpa + (nosx + 3.0) * spa) + xt ;
            whys[3] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (nosy * spa - (nosx + 3.0) * cpa)+ yt ;
            offsGg.setColor(Color.red) ;
            offsGg.fillPolygon(exes,whys,3) ;
        // booster stage
            hstg = 0.0 ;
            if (rktype == 3 && nstage == 2) {
               hstg = 10.0 ;
           // fins
               exes[0] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa - 8.0 * spa) + xt ;
               whys[0] = (int) (fact*(-posb1)) 
                    - (int) (0.0 * spa + 8.0 * cpa) + yt ;
               exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa + 8.0 * spa) + xt ;
               whys[1] = (int) (fact*(-posb1))
                    - (int) (0.0 * spa - 8.0 * cpa)+ yt ;
               exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (-hstg * cpa + 8.0 * spa) + xt ;
               whys[2] = (int) (fact*(-posb1))
                    - (int) (-hstg * spa - 8.0 * cpa)+ yt ;
               exes[3] = (int) (fact*(posx[nsav][npt]))
                    + (int) (-hstg * cpa - 8.0 * spa) + xt ;
               whys[3] = (int) (fact*(-posb1))
                    - (int) (-hstg * spa + 8.0 * cpa)+ yt ;
               exes[4] = (int) (fact*(posx[nsav][npt]))
                    + (int) (0.0 * cpa - 8.0 * spa) + xt ;
               whys[4] = (int) (fact*(-posb1))
                  - (int) (0.0 * spa + 8.0 * cpa)+ yt ;
               offsGg.setColor(Color.blue) ;
               offsGg.fillPolygon(exes,whys,4) ;
          //  body
               exes[0] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa - 3.0 * spa) + xt ;
               whys[0] = (int) (fact*(-posb1)) 
                    - (int) (0.0 * spa + 3.0 * cpa) + yt ;
               exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa + 3.0 * spa) + xt ;
               whys[1] = (int) (fact*(-posb1))
                    - (int) (0.0 * spa - 3.0 * cpa)+ yt ;
               exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (-hstg * cpa + 3.0 * spa) + xt ;
               whys[2] = (int) (fact*(-posb1))
                    - (int) (-hstg * spa - 3.0 * cpa)+ yt ;
               exes[3] = (int) (fact*(posx[nsav][npt]))
                    + (int) (-hstg * cpa - 3.0 * spa) + xt ;
               whys[3] = (int) (fact*(-posb1))
                    - (int) (-hstg * spa + 3.0 * cpa)+ yt ;
               exes[4] = (int) (fact*(posx[nsav][npt]))
                    + (int) (0.0 * cpa - 3.0 * spa) + xt ;
               whys[4] = (int) (fact*(-posb1))
                    - (int) (0.0 * spa + 3.0 * cpa)+ yt ;
               offsGg.setColor(Color.magenta) ;
               offsGg.fillPolygon(exes,whys,4) ;
               if (fltim >= tim2b1) hstg = 0.0 ;
            }
        // plume
            if ((rktype == 3 || rktype == 2) && fltim >= 0.0 && fltim <= tim2 && nburn >= 1) {
               exes[0] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (-hstg * cpa + 0.0 * spa) + xt ;
               whys[0] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (-hstg * spa - 0.0 * cpa) + yt ;
               exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (-(hstg + 10.0) * cpa - 5.0 * spa) + xt ;
               whys[1] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (-(hstg + 10.0) * spa + 5.0 * cpa) + yt ;
               exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (-(hstg + 25.) * cpa + 0.0 * spa) + xt ;
               whys[2] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (-(hstg + 25.) * spa - 0.0 * cpa)+ yt ;
               exes[3] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (-(hstg + 10.) * cpa + 5.0 * spa) + xt ;
               whys[3] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (-(hstg + 10.) * spa - 5.0 * cpa) + yt ;
               exes[4] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (-hstg * cpa + 0.0 * spa) + xt ;
               whys[4] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (-hstg * spa - 0.0 * cpa) + yt ;
               if (rktype == 3) offsGg.setColor(Color.orange) ;
               if (rktype == 2) offsGg.setColor(Color.blue) ;
               offsGg.fillPolygon(exes,whys,4) ;
            }
        // parachute
            if (rktype >= 2 && fltim >= timd && rtype >= 1 && vloc > 0.0) {
              exes[0] = (int) (fact*(posx[nsav][npt])) + xt ;
              whys[0] = (int) (fact*(-posy[nsav][npt])) + yt ;
              offsGg.setColor(Color.black) ;
              offsGg.fillArc(exes[0]-20,whys[0]-70,40,15,20,140) ;
              exes[0] = (int) (fact*(posx[nsav][npt])) + xt ;
              whys[0] = (int) (fact*(-posy[nsav][npt])) - 40 + yt ;
              exes[1] = (int) (fact*(posx[nsav][npt])) + 15 + xt ;
              whys[1] = (int) (fact*(-posy[nsav][npt])) - 65 + yt ;
              offsGg.setColor(Color.black) ;
              offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
              exes[1] = (int) (fact*(posx[nsav][npt])) - 15 + xt ;
              whys[1] = (int) (fact*(-posy[nsav][npt])) - 65 + yt ;
              offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            }
               // launch rail
            exes[0] = (int) (5.0 * Math.sin((90.0 - lnchang) * convdr)) + xt ;
            whys[0] = -(int) (- 5.0 * Math.cos((90.0 -lnchang) * convdr)) + yt ;
            exes[1] = (int) (56. * Math.cos((90.0 - lnchang) * convdr) 
                         + 5.0 * Math.sin((90.0 - lnchang) * convdr)) + xt - 1; 
            whys[1] = -(int) (56. * Math.sin((90.0 - lnchang) * convdr)
                           - 5.0 * Math.cos((90.0 - lnchang) * convdr)) + yt ;
            offsGg.setColor(Color.black) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
          }
     // ballistic shell
          if (ldisplay == 1) {
            cpa = Math.cos((90.0 - lnchang)*convdr) ;
            spa = Math.sin((90.0 - lnchang)*convdr) ;
               // cannon
            exes[0] = (int) (5.0 * spa) + xt ;
            whys[0] = -(int) (- 5.0 * cpa) + yt ;
            exes[1] = (int) (20. * cpa + 5.0 * spa) + xt - 1; 
            whys[1] = -(int) (20. * spa - 5.0 * cpa) + yt ;
            offsGg.setColor(Color.blue) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            exes[0] = (int) (-5.0 * spa) + xt ;
            whys[0] = -(int) (+ 5.0 * cpa) + yt ;
            exes[1] = (int) (20. * cpa - 5.0 * spa) + xt ;
            whys[1] = -(int) (20. * spa + 5.0 * cpa) + yt ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            exes[0] = (int) (fact*(posx[nsav][npt])) - 5 + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt])) - 5 + yt;
            offsGg.setColor(Color.blue) ;
            offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
          }
     // baseball
          if (ldisplay == 2) {
            cpa = Math.cos((90.0 - lnchang)*convdr) ;
            spa = Math.sin((90.0 - lnchang)*convdr) ;
            exes[0] = (int) (0.0) + xt ;
            whys[0] = -(int) (0.0) + yt ;
            exes[1] = (int) (20. * cpa) + xt ; 
            whys[1] = -(int) (20. * spa) + yt ;
            offsGg.setColor(Color.black) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            exes[0] = (int) (fact*(posx[nsav][npt])) - 5 + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt])) - 5 + yt;
            offsGg.setColor(Color.white) ;
            offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
          }
 
   // wind vector
          exes[0] = 140 ;
          whys[0] = 75;
          exes[1] = 140 + (int) (5.*wind) ;
          whys[1] = 75 ;
          offsGg.setColor(Color.black) ;
          offsGg.drawString("Wind",exes[0]-15,whys[0]+15) ;
          offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
          if (wind >= 0.0) {
            exes[0] = exes[1] - 5 ;
            whys[0] = whys[1] - 3 ;
            exes[2] = exes[1] - 5 ;
            whys[2] = whys[1] + 3 ;
            exes[3] = exes[1] - 5 ;
            whys[3] = whys[1] - 3 ;
          }
          if (wind < 0.0) {
            exes[0] = exes[1] + 5 ;
            whys[0] = whys[1] - 3 ;
            exes[2] = exes[1] + 5 ;
            whys[2] = whys[1] + 3 ;
            exes[3] = exes[1] + 5 ;
            whys[3] = whys[1] - 3 ;
          }
          offsGg.fillPolygon(exes,whys,4) ;

          if (trakon > 0) {
            offsGg.setColor(Color.black) ;
            if (planet == 2) offsGg.setColor(Color.white) ;
            offsGg.drawString("TRACKING  MODE",120,415) ;
          }
        }
 
        if (viewflg == 2) {   // data traces
           offsGg.setColor(Color.white) ;
           offsGg.fillRect(0,0,600,600) ;
           if (gridon >= 0) {       // Grid paper background
             for (j=0; j<=50; ++j) {
               offsGg.setColor(Color.cyan) ;
               exes[0] = 0 ; 
               exes[1] = 500 ;
               whys[0] = whys[1] = (int) (fact*(10.*j)) + yt;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               whys[0] = whys[1] = (int) (-fact*(10.*j)) + yt;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
             }
             for (j=0; j<=60; ++j) {
               offsGg.setColor(Color.cyan) ;
               whys[0] = 0 ; whys[1] = 500 ;
               exes[0] = exes[1] = (int) (fact*(10.0*j)) + xt  ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               exes[0] = exes[1] = (int) (-fact*(10.0*j)) + xt  ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
             }
          }
          for (i=5; i<= 9; ++ i) {
            exes[0] = (int) (fact*(0.0)) + xt ;
            whys[0] = (int) (fact*((i-4) * 50.0 - posy[i][0])) + yt ;
            scale = 1.0 ;
            if (i == 5) {
               offsGg.setColor(Color.black) ;
               offsGg.drawString("Thrust",exes[0]-50,whys[0]) ;
            }
            if (i == 6) {
               offsGg.setColor(Color.blue) ;
               ylabel = (int) (fact*((i-4) * 50.0)) + yt ;
               offsGg.drawString("Weight",exes[0]-50,ylabel) ;
            }
            if (i == 7) {
               offsGg.setColor(Color.red) ;
               offsGg.drawString("Drag",exes[0]-50,whys[0]) ;
            }
            if (i == 8) {
               offsGg.setColor(Color.magenta) ;
               if (spdmax > 0.0) {
                 scale = 50.0 /spdmax ;
                 whys[0] = (int) (fact*((i-4) * 50.0 - scale * posy[i][0])) + yt ;
               }
               ylabel = (int) (fact*((i-4) * 50.0)) + yt ;
               offsGg.drawString("Velocity",exes[0]-50,ylabel) ;
            }
            if (i == 9) {
               offsGg.setColor(Color.green) ;
               if (vmax > 0.0) {
                 scale = 50.0 / vmax ;
                 whys[0] = (int) (fact*((i-4) * 50.0 - scale * posy[i][0])) + yt ;
               }
               offsGg.drawString("Height",exes[0]-50,whys[0]) ;
            }
            for (j=1; j<=npt; ++j){
              exes[1] = exes[0] ;
              whys[1] = whys[0] ;
              exes[0] = (int) (fact*(posx[i][j])) + xt ;
              whys[0] = (int) (fact*((i-4) * 50.0 - scale * posy[i][j])) + yt ;
              offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            }
          }
          offsGg.setColor(Color.black) ;
          exes[0] = (int) (fact*(50.0)) + xt ;
          whys[0] = (int) (fact*(260.0)) + yt ;
          offsGg.drawString("Time",exes[0],whys[0]) ;
        }
 // border 
 // side zoom widget
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(0,0,35,450) ;
        offsGg.setColor(Color.black) ;
        offsGg.drawString("Zoom",2,365) ;
        offsGg.drawLine(15,50,15,350) ;
        offsGg.fillRect(5,sldloc,20,5) ;

        if (gridon < 0) {     // Grid button
           offsGg.setColor(Color.blue) ;
           offsGg.fillRect(0,30,30,15) ;
           offsGg.setColor(Color.white) ;
           offsGg.drawString("Grid",2,42) ;
        }
        if (gridon >= 0) {
           offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(0,30,30,15) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Grid",2,42) ;
        }
 // bottom
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(34,415,400,40) ;
        offsGg.setColor(Color.blue) ;
        offsGg.fillRect(100,420,40,20) ;
        offsGg.setColor(Color.white) ;
        offsGg.drawString("Find",108,435) ;
        if (trakon < 0) {  // Track button
           offsGg.setColor(Color.blue) ;
           offsGg.fillRect(200,420,40,20) ;
           offsGg.setColor(Color.white) ;
           offsGg.drawString("Track",205,435) ;
        }
        if (trakon >= 0) {
           offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(200,420,40,20) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Track",205,435) ;
        }
        if (viewflg == 1) {
           offsGg.setColor(Color.blue) ;
           offsGg.fillRect(0,425,30,15) ;
           offsGg.setColor(Color.white) ;
           offsGg.drawString("Save",2,437) ;
        }
 // top
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(34,0,300,25) ;
        if (viewflg == 0) {
           if (lnchgrf == 0) {
             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(35,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Nose",45,15) ;

             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(100,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Payload",105,15) ;

             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(165,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Body",175,15) ;

             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(230,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Fins",240,15) ;

             if (part == 1) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(35,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Nose",45,15) ;
             }

             if (part == 2) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(100,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Payload",105,15) ;
             }

             if (part == 3) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(165,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Body",175,15) ;
             }

             if (part == 4) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(230,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Fins",240,15) ;
             }
           }
        }
        if (viewflg == 1) {
               // time-height boxes
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Time",50,15) ;
           offsGg.drawString("Height",170,15) ;
           offsGg.fillRect(90,2,50,20) ;
           offsGg.fillRect(220,2,70,20) ;
           if (fltim <= 0.0) {
             offsGg.setColor(Color.green) ;
             offsGg.drawString(String.valueOf(filter0(fltim)),100,15) ;
           }
           if (fltim > 0.0) {
             offsGg.setColor(Color.yellow) ;
             offsGg.drawString(String.valueOf(filter1(fltim)),100,15) ;
           }
           offsGg.setColor(Color.yellow) ;
           offsGg.drawString(String.valueOf(filter0(vmax*lconv1)),225,15) ;
        }
 // right 
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(334,0,30,450) ;
 
        g.drawImage(offImg,0,0,this) ;   

     }  // end Paint
  }  // End View

} // end RocketModeler
