/*
                             HitModeler
                 Kiosk  Version  -- some buttons disabled
   
                           A Java Applet
                  to study the flight of hit baseball
                     Derived from RocketModeler II

                        Version 1.1c  - 10 Feb 07

                         Written by Tom Benson
                       NASA Glenn Research Center

>                              NOTICE
>This software is in the Public Domain.  It may be freely copied and used in
>non-commercial products, assuming proper credit to the author is given.  IT
>MAY NOT BE RESOLD.  If you want to use the software for commercial
>products, contact the author.
>No copyright is claimed in the United States under Title 17, U. S. Code.
>This software is provided "as is" without any warranty of any kind, either
>express, implied, or statutory, including, but not limited to, any warranty
>that the software will conform to specifications, any implied warranties of
>merchantability, fitness for a particular purpose, and freedom from
>infringement, and any warranty that the documentation will conform to the
>program, or any warranty that the software will be error free.
>In no event shall NASA be liable for any damages, including, but not
>limited to direct, indirect, special or consequential damages, arising out
>of, resulting from, or in any way connected with this software, whether or
>not based on warranty, contract, tort or otherwise, whether or not injury
>was sustained by persons or property or otherwise, and whether or not loss
>was sustained from, or arose out of the results of, or use of, the software
>or services provided hereunder.
 
  New test -
               
                     cleanup


                                           TJB  10 Feb 07

*/

import java.awt.*;
import java.lang.Math ;

public class Hit extends java.applet.Applet {
 
   static double convdr = 3.1415926/180. ;
   static double pid2 = 3.1415926/2.0 ;
   static double pi = 3.1415926 ;
   static double zero = 0.0 ;
   static double wtzero = 0.00001 ;
 
   int rktype,ntype,part,rtype,fintype,numfin,lunits,planet,wthopt,place ;
   int nstage,numeng,nclust,btfair,balob ;
   int istab,ifuel,ides,irange ;
   int conflag ;
            // body geometry
   static double blngth,blngd,blmax,blmin,bdiam,bdiamd,bdmax,bdmin,brad ;
            // tail fairing geometry
   static double tlngth,tlngd,tlmax,tlmin,tdiam,tdiamd,tdmax,tdmin,trad ;
            // bottle tail fairing
   static double btlngth,btlngd,btlmax,btlmin;
   static double btdiam,btdiamd,btdmax,btdmin,btrad;
            // payload geometry
   static double plngth,plngd,plmax,plmin,pdiam,pdiamd,pdmax,pdmin,prad ;
            // payload fairing geometry
   static double qlngth,qlngd,qlmax,qlmin ;
            // nose geometry
   static double nlngth,nlngd,nlmax,nlmin,ndiam,ndiamd,ndmax,ndmin,nrad ;
   static double nfact,nfact2 ;
            // fin geometry
   static double flngth,flngd,flmax,flmin,fwidth,fwid,fwmax,fwmin,fwex ;
   static double fleang,flemax,flemin,fteang,ftemax,ftemin ;
   static double ftanle,ftante ;
   static double floc,flocd,flcmax,flcmin ;
   static double delt,ap,thet;
   static double[][] finx = new double[3][4] ;
   static double[][] finy = new double[3][4] ;

   static double vmn1,vmn2,vmn3,vmn4,vmn5,vmx1,vmx2,vmx3,vmx4,vmx5 ;
   static double lconv1,lconv2,fconv,pconv ;
   static double aconv,dconv2,dconv3,vconv ;
               // weight and materials
   static int mbod,mtfr,mnose,mfin,mpay,mpfr,mbtfr ;
   static double wbod,wtfr,wnose,wpar,wfin,wpay,wpfr,wbtfr,weng,wfuel ;
   static double wbal,wbald,wmax,wmin ;
   static double sabod,satfr,sanose,sapay,sapfr,safin,sabtfr,satot;
   static double pabod,patfr,panose,papay,papfr,pafin,pabtfr,patot;
   static double cabod,canose,capay,catot,carec,caexit,cabexit ;
   static double vbod,vtfr,vnose,vpay,vpfr;
   static double dbod,dtfr,dnose,dfin,dpay,dpfr,dbtfr ;
   static double cgbod,cgtfr,cgnose,cgfin,cgpay,cgpfr,cgbtfr,cgeng,cgfuel ;
   static double cpbod,cptfr,cpnose,cpfin,cppay,cppfr,cpbtfr ;
               // ballistic 
   static double wtd, wtmax,wtmin,cdmin,cdmax,catd,camin,camax ;
   static double vmuzl,vmuzld,vmmax,vmmin ;
               // stomp launcher
   static double sv1,sv1d,sv1min,sv1max,sv2,sv2d,sv2min,sv2max ;
   static double sl,sld,slmin,slmax ;
   static double lpress,volrat,vstomp,presin ;
   static double lpresd,lpresmax,lpresmin ;
              // solid rocket thrust
   static double th1,th2,tim1,tim2,timd;
   static double th1b1,th2b1,tim1b1,tim2b1 ;
            // engine geometry
   static double elngth,ediam,erad,mediam,merad;
   static double b1elngth,b1ediam,b1erad;
            // booster 1 geometry
   static double b1fw,b1fwd,b1fwmax,b1fleang,b1fteang,b1ftanle,b1ftante;
   static double b1lngth,b1lngd,b1lmax,b1flngth,b1flngd;
   static double wengb1,wfuelb1,sab1,pab1,cgb1,cpb1;
   static double wfinb1,safb1,pafb1,cgfb1,cpfb1;
              // bottle rocket thrust
   static double wat,watd,watmin,watmax,fpres,fpresd,fpresmin,fpresmax ;
   static double nozdiam,nozdiamd,nozdmin,nozdmax ;
   static double nozrad,noza,hwat,watrad ;
   static double ltub,ltubd,ltubmin,ltubmax ;
   static double volair,instair,instwat,instpres,mdot,uexit,lothrust ;
               // flight
   int fire,comp,npt,nsav,nburn,cockflg,cockcal,stepon,step,presopt;
   static int[] npts = new int[5];
   static double weight,drag,thrust,wtflt ;
   static double cg,cp,cd,cdrec ;
   static double g0,q0,ps0,pt0,ts0,rho,rlhum,temf,presm,gama,wtrat,rgas ;
   static double alt,altd,altmax,altmin ;
   static double wind,windd,wndmax,wndmin ;
   static double lnchang,langmax,langmin;
   static double rail,raild,railmin,railmax ;
   static double llaunch,timrail ;
   static double deltim,fltim,vacc,vvel,vloc,hacc,hvel,grspd,hloc,spd ;
   static double vmax,hmax,spdmax ;
   static double[][] posx = new double[10][5000] ;
   static double[][] posy = new double[10][5000] ;
   static double[] posa = new double [5000] ;
   static double posb1 ;
       /*  plot & probe data */
   static double fact,facmin,facrat;
   static double facts,facto,factc;
   static int xt,yt,sldloc,viewflg,gridon,lnchgrf,trakon,ldisplay;
   static int xts,yts,slds;
   static int xto,yto,sldo;
   static int xtc,ytc,sldc;

   Solver solve ;
   View view ;
   Act act ;
   CardLayout layin,layen1,layen2 ;
   Image offImg ;
   Graphics offsGg ;

   public void init() {
     solve = new Solver() ;

     offImg = createImage(this.size().width,
                      this.size().height) ;
     offsGg = offImg.getGraphics() ;

     setLayout(new GridLayout(2,1,5,5)) ;

     view = new View(this) ;
     act = new Act(this) ;

     add(view) ;
     add(act) ;

     solve.setDefaults () ;
     loadInput() ;

     solve.comPute () ;

     view.start() ;
  }
 
  public Insets insets() {
     return new Insets(5,5,5,5) ;
  }

  public int filter0(double inumbr) {
        //  output only to .
       int number ;
       int intermed ;
 
       number = (int) (inumbr);
       return number ;
  }

  public float filter1(double inumbr) {
     //  output only to .1
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 10.) ;
       number = (float) (intermed / 10. );
       return number ;
  }
 
  public float filter3(double inumbr) {
     //  output only to .001
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 1000.) ;
       number = (float) (intermed / 1000. );
       return number ;
  }
 
  public float filter5(double inumbr) {
     //  output only to .00001
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 100000.) ;
       number = (float) (intermed / 100000. );
       return number ;
  }

  public void setRangeView() {   // initial range view
       viewflg = 1 ;
       facts = fact = 1.25;
       facmin = .5 ;
       facrat = .005 ;
       xts = xt = 100; 
       yts = yt = 240 ;
       slds = sldloc= 125;
  }
 
  public void restRangeView() {   // restore range view
       viewflg = 1 ;
       fact = facts ;
       facmin = .01 ;
       facrat = .02 ;
       xt = xts ; 
       yt = yts ;
       sldloc = slds ;
  }
 
  public void setGraphView() {   // initial graph view
       viewflg = 2 ;
       factc = fact = 1.25;
       facmin = .01 ;
       facrat = .02 ;
       xtc = xt = 100; 
       ytc = yt = 40 ;
       sldc = sldloc= 288;
  }
 
  public void restGraphView() {   // restore graph view
       viewflg = 2 ;
       fact = factc ;
       facmin = .01 ;
       facrat = .02 ;
       xt = xtc ; 
       yt = ytc ;
       sldloc = sldc ;
  }
 
  public void loadBallistic() {   // load Ballistic info
    // ballisitic shell
       rktype = 10 ;
       fire = 0 ;
       comp = 0 ;
       tim1 = .2 ;
       weng = 0.0;
       wfuel = 0.0 ;
       nstage = 1; 
       cg = 0.0 ;
       cp = 0.0 ;
       balob = 0 ;
       weight = 5.0 ;
       wtd = weight * fconv;
       wtmin = 0.1 * fconv ;  wtmax = 100 * fconv ;
       cd = .3 ;
       cdmin = 0.0 ;  cdmax = .5 ;
//       catot = 6.45 ;
       catot = 6.514 ;
       catd = catot * aconv ;
       camin = 0.0 ;  camax = 10.0 * aconv ;
       vmuzl = 146.7 ; 
       vmuzld = vmuzl * lconv1 * 60.0 / 88.0 ; 
       vmmin = 50.0 * 60.0 / 88.0 ;  vmmax = 175. * lconv1 * 60.0 / 88.0 ;
  }

  public void loadInput() {   // load the input panels
       String outden2,outden3,outlng,outfor ;
       String outht,outpres,outtemp,outhum,outspd,outang ;
       int i1,i2,i3,i4,i5,i6 ;
       double v1,v2,v3,v4,v5,v6 ;
       float fl1,fl2,fl3,fl4,fl5,fl6 ;

       outden2 = " oz/in2" ;
       if (lunits == 1) outden2 = " g/cs" ;
       outden3 = " oz/in3" ;
       if (lunits == 1) outden3 = " g/cc" ;
       outlng = " in" ;
       if (lunits == 1) outlng = " cm" ;
       outfor = " oz" ;
       if (lunits == 1) outfor = " g" ;

     // ballisitic shell
       v1 = wtd ;
       vmn1 = wtmin; vmx1 = wtmax ;
       v2 = cd ;
       vmn2 = cdmin; vmx2 = cdmax ;
       v3 = catd ;
       vmn3 = camin; vmx3 = camax ;
       v4 = vmuzld ;
       vmn4 = vmmin; vmx4 = vmmax ;

       act.inp.bali.lt.f1.setText(String.valueOf(filter3(wtd))) ;
       act.inp.bali.lt.f2.setText(String.valueOf(filter3(cd))) ;
       act.inp.bali.lt.f3.setText(String.valueOf(filter3(catd))) ;
       act.inp.bali.lt.f4.setText(String.valueOf(filter3(vmuzld))) ;
       act.inp.bali.rt.obch.select(balob) ;

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;

       act.inp.bali.rt.s1.setValue(i1) ;
       act.inp.bali.rt.s2.setValue(i2) ;
       act.inp.bali.rt.s3.setValue(i3) ;
       act.inp.bali.rt.s4.setValue(i4) ;

     // baseball
       v1 = vmuzld ;
       vmn1 = vmmin; vmx1 = vmmax ;
       v2 = windd ;
       vmn2 = wndmin;  vmx2 = wndmax ;
       v3 = lnchang ;
       vmn3 = langmin;  vmx3 = langmax ;
       v4 = cd ;
       vmn4 = cdmin;  vmx4 = cdmax ;

       outspd = " mph" ;
       outang = " degrees" ;

       act.inp.basi.lt.f1.setText(String.valueOf(filter0(vmuzld)) + outspd) ;
       act.inp.basi.lt.f2.setText(String.valueOf(filter0(windd)) + outspd) ;
       act.inp.basi.lt.f3.setText(String.valueOf(filter3(lnchang)) + outang) ;
       act.inp.basi.lt.f4.setText(String.valueOf(filter3(cd))) ;

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;

       act.inp.basi.rt.s1.setValue(i1) ;
       act.inp.basi.rt.s2.setValue(i2) ;
       act.inp.basi.rt.s3.setValue(i3) ;
       act.inp.basi.rt.s4.setValue(i4) ;

     // baseball control 
       v1 = presm ;
       v2 = temf ;
       v3 = rlhum ;
       v4 = alt ;

       outht = " feet" ;
       outpres = " inches Hg" ;
       outtemp = " degrees F" ;
       outhum = " %" ;

       act.conb.o1.setText(String.valueOf(filter3(presm)) + outpres) ;
       act.conb.o2.setText(String.valueOf(filter0(temf)) + outtemp) ;
       act.conb.o3.setText(String.valueOf(filter3(100.0 * rlhum)) + outhum) ;
       act.conb.o4.setText(String.valueOf(filter0(alt)) + outht) ;

       return ;
  }

  public void loadOut() {   // output routine
     String outfor,outvel,outlng,outhi ;

     outfor = " oz" ;
     if (lunits == 1) outfor = " g" ;
     outlng = " in" ;
     if (lunits == 1) outlng = " cm" ;
     outhi = " ft" ;
     if (lunits == 1) outhi = " m" ;
     outvel = " ft/s" ;
     if (lunits == 1) outvel = " m/s" ;

     return ;
  }
 
  class Solver {
 
     Solver () {
     }

     public void setDefaults() {
 
    // units
       conflag = 0 ;
       lunits = 0 ;
       dconv2 = 1.0 ;
       dconv3 = 1.0 ;
       lconv1 = 1.0 ;
       lconv2 = 1.0 ;
       aconv = 1.0 ;
       vconv = 1.0 ;
       fconv = 1.0 ;
       pconv = 1.0 ;

       nsav = 0 ;
       wtrat = 1.0 ;

       planet = 0 ;
       wthopt = 0 ;
       place = 0;
       g0 = 32.2 ;
       altd = alt = 700.0 ;
       altmin = 0.0;  altmax = 50000. ;
       ps0 = 14.7 ;
       rgas = 1718. ;
       getFreeStream() ;

       presin = 14.7 ;
       loadBallistic() ;

       part = 3 ;
       istab = 1 ;
       ifuel = 0 ;
       ides = 0 ;
       irange = 0 ;
       stepon = 0 ;
       step = 0 ;

    // launch
       windd = wind = 0.0 ;
       wndmin = -20.0 ; wndmax = 20.0 ;
       lnchang = 45.0 ;
       langmin = 0.0 ;  langmax = 80.0 ;
       raild = rail = 3.0 ;
       railmin = 1.0; railmax = 5.0 ;
       cockflg = 0 ;
       presopt = 0 ;

       posa[0] = pid2 ;

       fire = 0 ;
       comp = 0 ;
       vacc = 0.0 ; vvel = 0.0 ; vloc = 0.0 ;
       hacc = 0.0 ; hvel = 0.0 ; grspd = 0.0; hloc = 0.0 ;
       vmax = 0.0 ; hmax = 0.0 ; 
       spd = 0.0 ; spdmax = 0.0 ;

         // graphics
       setGraphView() ;
       gridon = 1 ;
       trakon = 0 ;
       setRangeView() ;

       ldisplay = 2 ;
       cd = 0.3 ;
       cdmin = 0.0 ;  cdmax = 0.5;
       weight = 5.0 ;
       wtd  = weight * fconv ;
//       catot = 6.45 ;
       catot = 6.514 ;
       catd = catot * aconv ;
       istab = 1;
       loadInput() ;
       return ;
     }

     public void getFreeStream() {    //  free stream conditions
     double hite,pvap ;       /* MODS  19 Jan 00  whole routine*/

       g0 = 32.2 ;
       rgas = 1718. ;                /* ft2/sec2 R */
       gama = 1.4 ;
       hite = alt ;
       wtrat = 1.0 ;
       if (planet <= 1) {    // Earth  standard day
          if (conflag == 0) {
             // Earth  standard day
             if (hite <= 36152.) {           // Troposphere
                ts0 = 518.6 - 3.56 * hite/1000. ;
                ps0 = 2116. * Math.pow(ts0/518.6,5.256) ;
             }
             if (hite >= 36152. && hite <= 82345.) {   // Stratosphere
                ts0 = 389.98 ;
                ps0 = 2116. * .2236 *
                     Math.exp((36000.-hite)/(53.35*389.98)) ;
             }
             if (place == 0) {
                if (wthopt == 0) {
                    ts0 = 519.6;
                    rlhum = 0.0 ;
                }
                if (wthopt == 1) {
                    ts0 = 549.6;
                    rlhum = 0.0 ;
                }
                if (wthopt == 2) {
                    ts0 = 494.6;
                    rlhum = 0.0 ;
                }
                if (wthopt == 3) {
                    ts0 = 549.6;
                    rlhum = 1.0 ;
                }
             }
             temf = ts0 - 459.6 ;
             if (temf <= 0.0) temf = 0.0;
             presm = ps0 * 29.92 / 2116. ;
          }
          if (conflag == 1) {
             ts0 = temf + 459.6 ;
             if (temf < 0.0) {
                  temf = 0.0 ;
                  rlhum = 0.0 ;
             }
             ps0 = presm * 2116. / 29.92 ;
          }
          pvap = rlhum*(2.685+.00353*Math.pow(temf,2.245));/* Eq 1:6A  Domasch */
          rho = (ps0 - .379*pvap)/(rgas * ts0) ;  /* effect of humidty */
       }
       if (planet == 3) {   // Mars - curve fit of orbiter data
         rgas = 1149. ;                /* ft2/sec2 R */
         gama = 1.29 ;
         wtrat = .38 ;

         if (hite <= 22960.) {
            ts0 = 434.02 - .548 * hite/1000. ;
            ps0 = 14.62 * Math.pow(2.71828,-.00003 * hite) ;
         }
         if (hite > 22960.) {
            ts0 = 449.36 - 1.217 * hite/1000. ;
            ps0 = 14.62 * Math.pow(2.71828,-.00003 * hite) ;
         }
         rlhum = 0.0 ;
         temf = ts0 - 459.6 ;
         presm = ps0 * 29.92 / 2116. ;
         rho = ps0/(rgas * ts0) ;
       }

       if (planet == 1) rho = 0.0 ;   // Earth no drag
       ps0 = ps0 / 144. ;   // psi

       if (planet == 2) {     // Moon
          wtrat = .1667 ;
          gama = 1.4 ;
          ps0 = 0.0 ;
          rho = 0.0 ;
          rlhum = 0.0 ;
          temf = -250. ;
          presm = 0.0 ;
       }
       fpresmin = ps0 * pconv ;
       lpresmin = ps0 * pconv ;

       loadInput() ;

       return ;
     }

     public void comPute() {
 
       loadOut() ;

       return ;
     }
  }

  class Act extends Panel {
     Hit outerparent ;
     Conb conb ;
     Inp inp ;

     Act (Hit target) {

       outerparent = target ;
       setLayout(new GridLayout(1,2,5,5)) ;

       conb = new Conb(outerparent) ;
       inp = new Inp(outerparent) ;

       add(conb) ;
       add(inp) ;
    }

    class Conb extends Panel {  // baseball control
       Hit outerparent ;
       Label lab1 ;
       TextField o1,o2,o3,o4 ;
       Label l1,l2,l3,l4 ;
       Label la1,la2,la3,la4 ;
       Choice placeh,weatch ;
       Button rest ;

       Conb (Hit target) {
          outerparent = target ;
          setLayout(new GridLayout(8,2,5,5)) ;

          lab1 = new Label("Batter Up!", Label.RIGHT) ;
          lab1.setForeground(Color.blue) ;

          la1 = new Label("Set Stadium Location:", Label.RIGHT) ;
          la1.setForeground(Color.red) ;

          la2 = new Label("Set Weather Conditions:", Label.RIGHT) ;
          la2.setForeground(Color.red) ;

          placeh = new Choice() ;
          placeh.setForeground(Color.red) ;
          placeh.addItem("Cleveland") ;
          placeh.addItem("Denver") ;
          placeh.addItem("New York") ;
          placeh.addItem("Chicago") ;
          placeh.addItem("Mt.Everest") ;
          placeh.addItem("Mars");
          placeh.addItem("Moon");
          placeh.select(0) ;

          weatch = new Choice() ;
          weatch.setForeground(Color.red) ;
          weatch.addItem("Average Day") ;
          weatch.addItem("Hot Day") ;
          weatch.addItem("Cold Day") ;
          weatch.addItem("Hot,Humid Day") ;
          weatch.select(0) ;

          l1 = new Label("Pressure", Label.CENTER) ;
          o1 = new TextField("29.172",5) ;
          l2 = new Label("Temperature ", Label.CENTER) ;
          o2 = new TextField("56",5) ;
          l3 = new Label("Rel. Humidity ", Label.CENTER) ;
          o3 = new TextField("0.0",5) ;
          l4 = new Label("Altitude", Label.CENTER) ;
          o4 = new TextField("700.0",5) ;

          rest = new Button("Reset") ;
          rest.setBackground(Color.orange) ;
          rest.setForeground(Color.black) ;
 
          add(lab1) ;
          add(new Label(" ", Label.CENTER)) ;

          add(la1) ;
          add(placeh) ;

          add(la2) ;
          add(weatch) ;

          add(l4) ;
          add(o4) ;

          add(l1) ;
          add(o1) ;

          add(l2) ;
          add(o2) ;

          add(l3) ;
          add(o3) ;

          add(rest) ;
          add(new Label(" ", Label.CENTER)) ;

       }

       public boolean action(Event evt, Object arg) {
          if(evt.target instanceof Choice) {
               this.handleProb(arg) ;
               return true ;
          }
          if(evt.target instanceof Button) {
              this.handleBut(evt,arg) ;
             return true ;
          }
          if(evt.target instanceof TextField) {
              this.handleText(evt,arg) ;
             return true ;
          }
          else return false ;
       }

       public void handleProb(Object obj) {
          int i2,i1 ;

          planet  = 0 ;
          wthopt  = weatch.getSelectedIndex() ;
          i1  = 0;
          i2  = placeh.getSelectedIndex() ;
          switch (i2) {
             case 0:{                            /* Cleveland */
                    place = 0 ;
                    alt = 700.0 * lconv1 ;
                    break ;
             }
             case 1:{                            /* Denver */
                    alt = 5280.0 * lconv1 ;
                    place = 0 ;
                    break ;
             }
             case 2:{                            /* New York */
                    place = 0 ;
                    alt = 0. * lconv1 ;
                    break ;
             }
             case 3:{                            /* Chicago */
                    place = 0 ;
                    alt = 586. * lconv1 ;
                    break ;
             }
             case 4:{                            /* Mt. Everest */
                    place = 1 ;
                    alt = 29028. * lconv1 ;
                    break ;
             }
             case 5:{                            /* Mars */
                    planet = 3 ;
                    alt = 0.0 * lconv1 ;
                    break ;
             }
             case 6:{                            /* Moon */
                    planet = 2 ;
                    alt = 0.0 * lconv1 ;
                    break ;
             }
          }
          switch (i1) {
             case 0:{                            /* Standard Day */
                    conflag = 0 ;
                    break ;
             }
             case 1:{                            /* Set Conditions */
                    conflag = 1 ;
                    break ;
             }
          }

          solve.getFreeStream() ;
       }

       public void handleBut(Event evt, Object obj) {
         String label = (String)obj ;
         int j, i ;

         if(label.equals("Reset")) {
            solve.setDefaults () ;
            placeh.select(0) ;
            weatch.select(0) ;
            fire = 0 ;
            comp = 0 ;
            nsav = 0 ;
            for (j=0; j<=4; ++j) {
               for (i=0; i<=npts[j]; ++i){
                  posx[j][i] = 0.0 ;  
                  posy[j][i] = 0.0 ;  
                  posa[i] = pid2 ;
                  posb1 = 0.0 ;
               }
               npts[j] = 0 ;
            }
         }
       }

       public void handleText(Event evt, Object obj) {
          Double V1,V2,V3 ;
          double v1,v2,v3 ;
          float fl1 ;

          V1 = Double.valueOf(o1.getText()) ;
          v1 = V1.doubleValue() ;
          V2 = Double.valueOf(o2.getText()) ;
          v2 = V2.doubleValue() ;
          V3 = Double.valueOf(o3.getText()) ;
          v3 = V3.doubleValue() ;

          if (conflag == 1) {
             if(v1 < 5.0) {
                v1 = 5.0 ;
                fl1 = (float) v1 ;
                o1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > 50.0) {
                v1 = 50.0 ;
                fl1 = (float) v1 ;
                o1.setText(String.valueOf(fl1)) ;
             }
             presm = v1 ;
             temf = v2 ;
             if(v3 < 1.0) {
                v3 = 0.0 ;
                fl1 = (float) v3 ;
                o3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > 100.0) {
                v3 = 100.0 ;
                fl1 = (float) v3 ;
                o3.setText(String.valueOf(fl1)) ;
             }
             rlhum = v3 /100. ;

             solve.getFreeStream() ;
          }
       }
    }

    class Inp extends Panel {
       Hit outerparent ;
       Bali bali ;
       Basi basi ;

       Inp (Hit target) {

          outerparent = target ;
          layin = new CardLayout() ;
          setLayout(layin) ;

          bali = new Bali(outerparent) ;
          basi = new Basi(outerparent) ;

          add ("bas", basi) ;
          add ("bal", bali) ;
       }

       class Bali extends Panel {
          Hit outerparent ;
          Lt lt ;
          Rt rt ;
  
          Bali (Hit target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Hit outerparent ;
             Scrollbar s1,s2,s3,s4;
             Choice obch ;

             Rt (Hit target) {

               int i1,i2,i3,i4 ;
  
               outerparent = target ;
               setLayout(new GridLayout(7,1,10,5)) ;

               i1 = (int) (((wtd - wtmin)/(wtmax-wtmin))*1000.) ;
               i2 = (int) (((cd - cdmin)/(cdmax-cdmin))*1000.) ;
               i3 = (int) (((catd - camin)/(camax-camin))*1000.) ;
               i4 = (int) (((vmuzld - vmmin)/(vmmax-vmmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
  
               obch = new Choice() ;
               obch.addItem("Rocket") ;
               obch.addItem("Ideal Shell (Drag=0)") ;
               obch.addItem("Baseball") ;
               obch.select(0) ;
 
               add(obch) ;
               add(s2) ;
               add(s3) ;
               add(new Label(" ", Label.CENTER)) ;
               add(s4) ;
               add(s1) ;
               add(new Label(" ", Label.CENTER)) ;
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleCho(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
          public void handleCho(Event evt) {
             int i1,i2,i3 ;
             double v1,v2,v3 ;
             float fl1,fl2,fl3 ;

             balob = obch.getSelectedIndex() ;

             vmn1 = wtmin;    vmx1 = wtmax ;
             vmn2 = cdmin;    vmx2 = cdmax ;
             vmn3 = camin;    vmx3 = camax ;

             switch (balob) {
                 case 0:{              /* Rocket */
                     ldisplay = 0 ;
                     v2 = cd = 0.7 ;
                     i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                     fl2 = filter3(v2) ;
                     lt.f2.setText(String.valueOf(fl2)) ;
                     rt.s2.setValue(i2) ;
                     break;
                 }
                 case 1:{              /* Shell */
                     ldisplay = 1 ;
                     v2 = cd = 0.0 ;
                     i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                     fl2 = filter3(v2) ;
                     lt.f2.setText(String.valueOf(fl2)) ;
                     rt.s2.setValue(i2) ;
                     break;
                 }
                 case 2:{              /* Baseball */
                     ldisplay = 2 ;
                     v2 = cd = 0.07 ;
                     i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                     fl2 = filter3(v2) ;
                     lt.f2.setText(String.valueOf(fl2)) ;
                     rt.s2.setValue(i2) ;
                     weight = 5.0 ;
                     v1  = wtd = weight * fconv ;
                     i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
                     fl1 = filter3(v1) ;
                     lt.f1.setText(String.valueOf(fl1)) ;
                     rt.s1.setValue(i1) ;
//                     catot = 6.45 ;
                     catot = 6.514 ;
                     v3 = catd = catot * aconv ;
                     i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
                     fl3 = filter3(v3) ;
                     lt.f3.setText(String.valueOf(fl3)) ;
                     rt.s3.setValue(i3) ;
                     break;
                 }
             }
             solve.comPute() ;
          }

          public void handleBar(Event evt) {     // ballistic shell
             int i1,i2,i3,i4;
             double v1,v2,v3,v4 ;
             float fl1,fl2,fl3,fl4 ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;
             i4 = s4.getValue() ;

             vmn1 = wtmin;    vmx1 = wtmax ;
             vmn2 = cdmin;    vmx2 = cdmax ;
             vmn3 = camin;    vmx3 = camax ;
             vmn4 = vmmin;    vmx4 = vmmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
             v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
 
             wtd = v1 ;
             weight = wtd / fconv ;
             cd = v2 ;
             cg = 0.0 ;
             cp = 0.0 ;
             catd = v3 ;
             catot = catd / aconv ;
             vmuzld = v4 ;
             vmuzl = vmuzld / lconv1 * 88.0 / 60.0 ;
 
             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl3 = filter3(v3) ;
             fl4 = filter3(v4) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f3.setText(String.valueOf(fl3)) ;
             lt.f4.setText(String.valueOf(fl4)) ;

             solve.comPute() ;

           }  // end handle
         }  // end right
 
         class Lt extends Panel {
           Hit outerparent ;
           TextField f1, f2, f3, f4 ;
           Label l1, l2, l3, l4, lab ;
           Button butgo ;
  
           Lt (Hit target) {
              outerparent = target ;
              setLayout(new GridLayout(7,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;

              l1 = new Label("Weight oz", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)wtd),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("Drag Coeff", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)cd),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              l3 = new Label("Area sq in", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)catd),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("Speed fps", Label.CENTER) ;
              f4 = new TextField(String.valueOf((float)vmuzld),5) ;
              f4.setBackground(Color.white) ;
              f4.setForeground(Color.black) ;

              add(butgo) ;
              add(new Label("Object:", Label.RIGHT)) ;

              add(l2) ;
              add(f2) ;

              add(l3) ;
              add(f3) ;

              add(new Label(" ", Label.CENTER)) ;
              add(new Label(" ", Label.CENTER)) ;

              add(l4) ;
              add(f4) ;

              add(l1) ;
              add(f1) ;

              add(new Label("on Earth", Label.CENTER)) ;
              add(new Label(" ", Label.CENTER)) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 ifuel = 1 ;
                 ides = 1;
                 butgo.setBackground(Color.green) ;
                 butgo.setForeground(Color.black) ;
                 weight = wtd / fconv ;
                 loadOut() ;
              }
           }
  
           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4 ;
             double v1,v2,v3,v4 ;
             int i1,i2,i3,i4 ;
             float fl1 ;

             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
             V4 = Double.valueOf(f4.getText()) ;
             v4 = V4.doubleValue() ;

     // weight
             wtd  = v1 ;
             vmn1 = wtmin;   vmx1 = wtmax ;
             if(v1 < vmn1) {
                 wtd = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 wtd =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             weight = wtd / fconv ;

     // drag coefficient
             cd  = v2 ;
             vmn2 = cdmin;   vmx2 = cdmax ;
             if(v2 < vmn2) {
                 cd = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 cd =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }

     // cross-sectional area
             catd  = v3 ;
             vmn3 = camin;   vmx3 = camax ;
             if(v3 < vmn3) {
                 catd = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 catd =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             catot = catd / aconv ;

     // muzzle velocity
             vmuzld  = v4 ;
             vmn4 = vmmin;   vmx4 = vmmax ;
             if(v4 < vmn4) {
                 vmuzld = v4 = vmn4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             if(v4 > vmx4) {
                 vmuzld =  v4 = vmx4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             vmuzl = vmuzld / lconv1 ;

             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
             i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
  
             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;
             rt.s4.setValue(i4) ;

             cg = 0.0 ;
             cp = 0.0 ;

             solve.comPute() ;

           }  // end handle
         }  //  end  left
       }   // end ballistic shell

       class Basi extends Panel {
          Hit outerparent ;
          Lt lt ;
          Rt rt ;
  
          Basi (Hit target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Hit outerparent ;
             Label l1 ;
             Scrollbar s1,s2,s3,s4;
             Button butgo;

             Rt (Hit target) {

               int i1,i2,i3,i4 ;
  
               outerparent = target ;
               setLayout(new GridLayout(7,1,10,5)) ;

               i1 = (int) (((vmuzld - vmmin)/(vmmax-vmmin))*1000.) ;
               i2 = (int) (((windd - wndmin)/(wndmax-wndmin))*1000.) ;
               i3 = (int) (((lnchang - langmin)/(langmax-langmin))*1000.) ;
               i4 = (int) (((cd - cdmin)/(cdmax-cdmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
  
               l1 = new Label("Set Conditions", Label.CENTER) ;
               l1.setForeground(Color.red) ;

               butgo = new Button("SWING") ;
               butgo.setBackground(Color.green) ;
               butgo.setForeground(Color.black) ;

               add(l1) ;
               add(s1) ;
               add(s3) ;
               add(s4) ;
               add(new Label(" ", Label.CENTER)) ;
               add(s2) ;
               add(butgo) ;
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleBut(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
          public void handleBar(Event evt) {     // ballistic shell
             String outspd,outang ;
             int i1,i2,i3,i4;
             double v1,v2,v3,v4 ;
             float fl1,fl2,fl3,fl4 ;

             outspd = " mph" ;
             outang = " degrees" ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;
             i4 = s4.getValue() ;

             vmn1 = vmmin;    vmx1 = vmmax ;
             vmn2 = wndmin;    vmx2 = wndmax ;
             vmn3 = langmin;    vmx3 = langmax ;
             vmn4 = cdmin;    vmx4 = cdmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
             v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
 
             vmuzld = v1 ;
             vmuzl = vmuzld / lconv1 * 88.0 / 60.0 ;
             windd = v2 ;
             wind = windd / lconv1 * 88.0 / 60.0 ;
             lnchang = v3 ;
             cd = v4 ;

             fl1 = filter0(v1) ;
             fl2 = filter0(v2) ;
             fl3 = filter0(v3) ;
             fl4 = filter3(v4) ;

             lt.f1.setText(String.valueOf(fl1) + outspd) ;
             lt.f2.setText(String.valueOf(fl2) + outspd) ;
             lt.f3.setText(String.valueOf(fl3) + outang) ;
             lt.f4.setText(String.valueOf(fl4)) ;

             solve.comPute() ;

           }  // end handle bar

           public void handleBut(Event evt) {
             double angle ;

             ifuel = 1;
             irange = 1 ;
             ides = 1 ;
             istab = 1 ;
             weight = wtd / fconv ;
             fire = 1 ;
             comp = 1 ;
             cockcal = 0 ;
             fltim = -1.0 ;
             drag = 0.0 ;
             timrail = 0.0 ;
             spd = vmuzl ;
             llaunch = 0.0 ;
             drag = (16.0 * cd * .5 * rho * catot * spd * spd / 144.) ; 
             angle = (90.0 - lnchang) * convdr ;
//               angle = lnchang * convdr ;
             vacc = (-drag*Math.sin(angle)-(weight*wtrat))/(weight/g0) ;
             hacc = (-drag*Math.cos(angle)) / (weight/g0)  ;
             cockflg = 0 ;
             vvel = spd * Math.cos(convdr*lnchang) ;
             hvel = spd * Math.sin(convdr*lnchang) ;
             grspd = hvel + wind ;
             vloc = 0.0 ;
             hloc = 0.0 ;
             hmax = 0.0 ;
             vmax = 0.0 ;
             spdmax = 0.0 ;
             npt = 0 ;
           }  // end handle but

         }  // end right
 
         class Lt extends Panel {
           Hit outerparent ;
           TextField f1, f2, f3, f4 ;
           Label l1, l2, l3, l4, lab ;
           Button butclr,butsav ;
  
           Lt (Hit target) {
              outerparent = target ;
              setLayout(new GridLayout(7,2,5,5)) ;

              butclr = new Button("Clear") ;
              butclr.setBackground(Color.white) ;
              butclr.setForeground(Color.blue) ;

              butsav = new Button("Save") ;
              butsav.setBackground(Color.blue) ;
              butsav.setForeground(Color.white) ;

              l1 = new Label("Speed", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)vmuzld),5) ;

              l2 = new Label("Speed", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)windd),5) ;

              l3 = new Label("Angle", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)lnchang),5) ;

              l4 = new Label("Drag - Cd", Label.CENTER) ;
              f4 = new TextField(String.valueOf((float)cd),5) ;

              add(new Label("Ball ", Label.CENTER)) ;
              add(new Label(" ", Label.CENTER)) ;

              add(l1) ;
              add(f1) ;

              add(l3) ;
              add(f3) ;

              add(l4) ;
              add(f4) ;

              add(new Label(" ", Label.CENTER)) ;
              add(new Label("Wind", Label.CENTER)) ;

              add(l2) ;
              add(f2) ;

              add(butclr) ;
              add(butsav) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
        //         this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;
              int i,j;

              if(label.equals("Clear")) {
                fire = 0 ;
                comp = 0 ;
                nsav = 0 ;
                for (j=0; j<=4; ++j) {
                  for (i=0; i<=npts[j]; ++i){
                     posx[j][i] = 0.0 ;  
                     posy[j][i] = 0.0 ;  
                     posa[i] = pid2 ;
                     posb1 = 0.0 ;
                  }
                  npts[j] = 0 ;
                }
              }
              if(label.equals("Save")) {
                 fire = 0 ;
                 comp = 0 ;
                 npts[nsav] = npt ;
                 nsav = nsav + 1 ;
                 if (nsav == 5) nsav = 4 ;
                 for (i=0; i<=npts[nsav]; ++i){
                     posx[nsav][i] = 0.0 ;  
                     posy[nsav][i] = 0.0 ;  
                     posa[i] = pid2 ;
                     posb1 = 0.0 ;
                  }
                  npts[nsav] = 0 ;
              }
           }
  
           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4 ;
             double v1,v2,v3,v4 ;
             int i1,i2,i3,i4 ;
             float fl1 ;

             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
             V4 = Double.valueOf(f4.getText()) ;
             v4 = V4.doubleValue() ;

     // muzzle velocity
             vmuzld  = v1 ;
             vmn1 = vmmin;   vmx1 = vmmax ;
             if(v1 < vmn1) {
                 vmuzld = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 vmuzld =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             vmuzl = vmuzld / lconv1 * 88.0 / 60.0 ;
   // wind
             windd  = v2 ;
             vmn2 = wndmin;   vmx2 = wndmax ;
             if(v2 < vmn2) {
                 windd = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 windd =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             wind = windd / lconv1 * 88.0 / 60.0 ;
  // launch angle
             lnchang  = v3 ;
             vmn3 = langmin;   vmx3 = langmax ;
             if(v3 < vmn3) {
                 lnchang = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 lnchang =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
  // drag coefficient
             cd  = v4 ;
             vmn4 = cdmin;   vmx4 = cdmax ;
             if(v4 < vmn4) {
                 cd = v4 = vmn4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             if(v4 > vmx4) {
                 cd =  v4 = vmx4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }

             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
             i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
  
             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;
             rt.s4.setValue(i4) ;

             cg = 0.0 ;
             cp = 0.0 ;

             solve.comPute() ;

           }  // end handle
         }  //  end  left
       }   // end baseball

    }  // end  Inp

  } // end of Act

  class View extends Canvas  
         implements Runnable{
     Hit outerparent ;
     Thread runner ;
     Point locate,anchor;
   
     View (Hit target) {
         setBackground(Color.white) ;
         runner = null ;
     } 

     public Insets insets() {
        return new Insets(0,5,0,5) ;
     }
 
     public boolean mouseDown(Event evt, int x, int y) {
        anchor = new Point(x,y) ;
        return true;
     }

     public boolean mouseUp(Event evt, int x, int y) {
        handleb(x,y) ;
        return true;
     }

     public boolean mouseDrag(Event evt, int x, int y) {
        handle(x,y) ;
        return true;
     }

     public void handle(int x, int y) {  // slider widgets
       // determine location
       if (y >= 20 && y <= 375) {
         if (x <= 35 ) {   // zoom widget
           if (y >= 45 && y <= 250) {
             sldloc = y ;
             if (sldloc < 50) sldloc = 50;
             if (sldloc > 250) sldloc = 250;
             fact = facmin + (250 - sldloc) * facrat;
             if (viewflg == 0) {
               if (fact < 5.0) fact = 5.0 ;
             }
           }
         }
/*
         if (x >= 36 ) {   // translate
           locate = new Point(x,y) ;
           yt =  yt + (int) (.2*(locate.y - anchor.y)) ;
           xt =  xt + (int) (.4*(locate.x - anchor.x))  ;
           if (xt > 50000) xt = 50000 ;
           if (xt < -50000) xt = -50000 ;
           if (yt > 50000) yt = 50000 ;
           if (yt <-50000) yt = -50000 ;
         }
*/
       }
       if (viewflg == 2) {
         factc = fact ;
         xtc = xt ;
         ytc = yt ;
         sldc = sldloc ;
       }
       if (viewflg == 1) {
         facts = fact ;
         xts = xt ;
         yts = yt ;
         slds = sldloc ;
       }
       if (viewflg == 0) {
         facto = fact ;
         xto = xt ;
         yto = yt ;
         sldo = sldloc ;
       }
     }

     public void handleb(int x, int y) { // view buttons
       float fl3 ;
       int i3 ;

/*
       if (y <= 30) { 
          if (x >= 650) { // save plot
             if (viewflg == 1) {
                npts[nsav] = npt ;
                nsav = nsav + 1 ;
                if (nsav == 5) nsav = 4 ;
             }
          }
       }
       if (x <= 30) { 
          if (y >=31 && y <= 45) {  // grid switch
             gridon = -gridon ;
          }
       }
 
       if (y > 415) {
          if (x >= 100 && x <= 150) { // pad switch 
             if (viewflg == 0) setDesignView() ;
             if (viewflg == 1) setRangeView() ;
             if (viewflg == 2) setGraphView() ;
          }
          if (x >= 200 && x <= 250) { // trak switch  
             trakon = -trakon ;
          }
       }

       if (y < 25) {
          if (viewflg == 0 && lnchgrf == 0) {
             if (x >=35 && x <= 95) {  // nose design
               part = 1 ;
               layin.show(act.inp, "nos")  ;
               act.inp.nose.lt.butgo.setBackground(Color.white) ;
               act.inp.nose.lt.butgo.setForeground(Color.blue) ;
             }
             if (x >=100 && x <= 160) {  // payload design
               part = 2 ;
               layin.show(act.inp, "pay")  ;
               act.inp.payl.lt.butgo.setBackground(Color.white) ;
               act.inp.payl.lt.butgo.setForeground(Color.blue) ;
             }
             if (x >=165 && x <= 225) {  // body design
               part = 3 ;
               if (rktype < 2 || rktype > 2){
                  layin.show(act.inp, "bod")  ;
                  act.inp.body.lt.butgo.setBackground(Color.white) ;
                  act.inp.body.lt.butgo.setForeground(Color.blue) ;
               }
               if (rktype == 2){
                  layin.show(act.inp, "bot")  ;
                  act.inp.boti.lt.butgo.setBackground(Color.white) ;
                  act.inp.boti.lt.butgo.setForeground(Color.blue) ;
               }
             }
             if (x >=230 && x <= 295) {  // fins design
               part = 4 ;
               layin.show(act.inp, "fin")  ;
               act.inp.fins.lt.butgo.setBackground(Color.white) ;
               act.inp.fins.lt.butgo.setForeground(Color.blue) ;
             }
             ides = 0 ;
             act.con.btm1.setBackground(Color.white) ;
             act.con.btm1.setForeground(Color.blue) ;
             act.con.btm4.setBackground(Color.white) ;
             act.con.btm4.setForeground(Color.blue) ;
          }
       }
*/
       view.repaint() ;
     }

     public void start() {
        if (runner == null) {
           runner = new Thread(this) ;
           runner.start() ;
        }
     }

     public void run() {
       int timer,i ;
       double vvld,hvld,angle,deltmx,oldmass,newmass;
       double vald,hald,grald;
       String outht,outspd,outfor,outpres ;
   
       timer = 100 ;
       deltim  = .2 ;
       angle = pid2 ;
       oldmass = 115. * .00237 /1728. ;
       while (true) {
          try { Thread.sleep(timer); }
          catch (InterruptedException e) {}
          outht = " ft" ;
          if (lunits == 1) outht = " m" ;
          outspd = " fps" ;
          if (lunits == 1) outspd = " mps" ;
          outfor = " oz" ;
          if (lunits == 1) outfor = " g" ;
          outpres = " psi" ;
          if (lunits == 1) outpres = " kPa" ;
          posa[0] = (90.0 - lnchang) * convdr ;
          if (fire == 1) {  // launch sequence
             if (comp == 1 && istab == 1 && 
               irange == 1 && ifuel == 1 && ides == 1) {
               fltim = fltim + deltim ;
               if (planet == 2) wind = 0.0 ;  // no wind on the moon
      // countdown
      // flight
               if (fltim >= 0.0) {
      // thrust
                  if (rktype == 10) {  // ballistic-no thrust or recovery
                      rtype = 0 ;
                      wtflt = weight * wtrat ;
                      thrust = 0.0 ;
                      deltim = .05 ;
                  }
                  vvld = vvel ;
                  hvld = hvel ;
                  grald = grspd ;
                  vald = vacc ;
                  hald = hacc ;
        // powered  and coasting
                  if (fltim < timd || rtype == 0 || planet == 1 || planet == 2) {
                     angle = Math.atan2(vvel,hvel) ;
                     if (vloc < llaunch && fltim < timd) {
                        angle = (90.0 - lnchang) * convdr ;
  //                      angle =  lnchang * convdr ;
                     }
                     if (cockflg == 1 && cockcal == 1) {
                        angle = pid2 + Math.atan2(wind-hvel,vvel) ;
                     }

                     vacc = ((thrust-drag)*Math.sin(angle)-wtflt)/(wtflt/(g0 * wtrat)) ;
                     hacc = (thrust-drag)*Math.cos(angle) / (wtflt/(g0 * wtrat))  ;
                     vvel = vvld + .5 * (vacc + vald) * deltim ;
                     hvel = hvld + .5 * (hacc + hald) * deltim ;
                     spd = Math.sqrt(vvel*vvel + hvel*hvel) ;
                     drag = (16.0 * cd * .5 * rho * catot * spd * spd / 144.) ; 
                     grspd = hvel + wind ;
                  }

                  vloc = vloc + .5 * (vvel + vvld) * deltim ;
                  hloc = hloc + .5 * (grspd +grald) * deltim ;
//                  hloc = hloc + .5 * (hvel + hvld) * deltim ;

                  npt = npt + 1 ;
          // determine if on or off rail ..
                  posx[nsav][npt] = hloc ;
                  if (vloc < llaunch && fltim < tim1) {
                     timrail = fltim ;
                     posx[nsav][npt] = hloc ;
                  }
                  posy[nsav][npt] = vloc ;
                  posa[npt] = angle ;

                  cockcal = 0 ;

               }
     // update maximums
               if (vloc > vmax) {
                  vmax = vloc ;
               }
               if (Math.abs(posx[nsav][npt]) > Math.abs(hmax)) {
                  hmax = posx[nsav][npt] ;
               }
               if (spd > spdmax) {
                  spdmax = spd;
               }
     // shutdown .. hit the ground
               if (vloc < 0.0 ) {  
                  posa[npt] = 0.0 ;
                  comp = 0 ;
                  vloc = 0.0 ;
                  irange = 0 ;
                  ifuel = 0 ;
               }
             }
 
     // strip charts
             posx[5][npt] = 10.0*fltim ;
             posy[5][npt] = thrust ;
             posx[6][npt] = 10.0*fltim ;
             posy[6][npt] = wtflt ;
             posx[7][npt] = 10.0*fltim ;
             posy[7][npt] = drag ;
             posx[8][npt] = 10.0*fltim ;
             posy[8][npt] = vvel ;
             posx[9][npt] = 10.0*fltim ;
             posy[9][npt] = vloc ;

             if (stepon == 1) {
                comp = 0 ;
                if (step == 1) {
                  comp = 1;
                  step = 0 ;
                } 
             }
          }
     // reset integration
          if (fire == 0) {
             wtflt = weight * wtrat ;
             thrust = 0.0 ;
             timrail = 0.0 ;
             deltim = .2 ;
             fltim = 0.0 ;
             hloc = 0.0 ;
             vloc = 0.0 ;
             vvel = 0.0 ;
             hvel = 0.0 ;
             vmax = 0.0 ;
             hmax = 0.0 ;
             spdmax = 0.0 ;
             npt = 0 ;
             nburn = 0 ;
  
          }
          if (trakon > 0 && viewflg == 1) {  // tracking view
             fact = 2.5 ;
             if (planet == 2) fact = .06 ;
             if (planet == 3) fact = .11 ;
             xt = 160 - (int)(fact * posx[nsav][npt]) ;
             yt = 260 + (int)(fact * posy[nsav][npt]) ;
          }
          view.repaint() ;
 
       }
     }

     public void update(Graphics g) {
           view.paint(g) ;
     }
 
     public void paint(Graphics g) {
        int i,j,k,n ;
        int nump ;
        int exes[] = new int[9] ;
        int whys[] = new int[9] ;
        int ylabel,ylabel2,xlabel,xlabel2;
        double yval,xval,scale,btbase;
        double cpa,spa,nosx,nosy,hstg,pumph;
        double factm ;
        String words,outlng ;
        Color col1,col2 ;

        col1 = new Color(0,121,0) ;   // dark green
        col2 = new Color(254,121,0) ; // dark orange
 
 // flight view
        if (viewflg == 1) {
          if (planet <= 1) offsGg.setColor(Color.cyan) ;
          if (planet == 2) offsGg.setColor(Color.black) ;
          if (planet == 3) offsGg.setColor(Color.pink) ;
          offsGg.fillRect(0,0,740,600) ;
                // hills
          exes[0] = (int) (fact*(0.0)) + xt ;
          whys[0] = (int) (fact*(200.0)) + yt ;
          exes[1] = (int) (fact*(2000.0)) + xt ;
          whys[1] = (int) (fact*(-100.)) + yt ;
          exes[2] = (int) (fact*(4200)) + xt ;
          whys[2] = (int) (fact*(100.0)) + yt  ;
          exes[3] = (int) (fact*(7000.)) + xt ;
          whys[3] = (int) (fact*(-200.0)) + yt ;
          exes[4] = (int) (fact*(9000.)) + xt ;
          whys[4] = (int) (fact*(100.0)) + yt ;
          exes[5] = (int) (fact*(10000.)) + xt ;
          whys[5] = (int) (fact*(-100.0)) + yt ;
          exes[6] = (int) (fact*(12000.)) + xt ;
          whys[6] = (int) (fact*(200.0)) + yt ;
          exes[7] = (int) (fact*(0.0)) + xt ;
          whys[7] = (int) (fact*(200.0)) + yt ;
          if (planet <= 1) offsGg.setColor(col1) ;
          if (planet == 2) offsGg.setColor(Color.darkGray) ;
          if (planet == 3) offsGg.setColor(col2) ;
          offsGg.fillPolygon(exes,whys,7) ;
          exes[0] = (int) (fact*(-250.0)) + xt ;
          whys[0] = (int) (fact*(0.0)) + yt ;
          exes[1] = (int) (fact*(-2000.0)) + xt ;
          whys[1] = (int) (fact*(-100.)) + yt ;
          exes[2] = (int) (fact*(-4200)) + xt ;
          whys[2] = (int) (fact*(100.0)) + yt  ;
          exes[3] = (int) (fact*(-7000.)) + xt ;
          whys[3] = (int) (fact*(-200.0)) + yt ;
          exes[4] = (int) (fact*(-9000.)) + xt ;
          whys[4] = (int) (fact*(100.0)) + yt ;
          exes[5] = (int) (fact*(-15000.)) + xt ;
          whys[5] = (int) (fact*(-100.0)) + yt ;
          exes[6] = (int) (fact*(-22000.)) + xt ;
          whys[6] = (int) (fact*(100.0)) + yt ;
          exes[7] = (int) (fact*(-250.)) + xt ;
          whys[7] = (int) (fact*(0.0)) + yt ;
          if (planet <= 1) offsGg.setColor(col1) ;
          if (planet == 2) offsGg.setColor(Color.darkGray) ;
          if (planet == 3) offsGg.setColor(col2) ;
          offsGg.fillPolygon(exes,whys,8) ;
                // ground plane
          exes[0] = 0 ;
          whys[0] = (int) (fact*(-5.0)) + yt ;
          exes[1] = 750 ;
          whys[1] = (int) (fact*(-5.)) + yt ;
          exes[2] = 750;
          whys[2] = 500 ;
          exes[3] = 0 ;
          whys[3] = 750 ;
          exes[4] = 0 ;
          whys[4] = (int) (fact*(-5.0)) + yt ;
          if (planet <= 1) offsGg.setColor(Color.green) ;
          if (planet == 2) offsGg.setColor(Color.gray) ;
          if (planet == 3) offsGg.setColor(Color.orange) ;
          offsGg.fillPolygon(exes,whys,5) ;
                // wall
          exes[0] = (int) (fact*(350.0)) + xt ;
          whys[0] = (int) (fact*(5.0)) + yt ;
          exes[1] = (int) (fact*(350.0)) + xt ;
          whys[1] = (int) (fact*(-15.)) + yt ;
          exes[2] = (int) (fact*(352.0)) + xt ;
          whys[2] = (int) (fact*(-15.)) + yt ;
          exes[3] = (int) (fact*(352.0)) + xt ;
          whys[3] = (int) (fact*(5.0)) + yt ;
          exes[4] = (int) (fact*(350.0)) + xt ;
          whys[4] = (int) (fact*(5.0)) + yt ;
          offsGg.setColor(Color.red) ;
          offsGg.fillPolygon(exes,whys,5) ;
          exes[0] = (int) (fact*(-350.0)) + xt ;
          exes[1] = (int) (fact*(-350.0)) + xt ;
          exes[2] = (int) (fact*(-352.0)) + xt ;
          exes[3] = (int) (fact*(-352.0)) + xt ;
          exes[4] = (int) (fact*(-350.0)) + xt ;
          offsGg.fillPolygon(exes,whys,5) ;
          if (planet <= 1) {
                // building  #1
             exes[0] = (int) (fact*(650.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(680.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(680.0)) + xt ;
             whys[2] = (int) (fact*(-50.)) + yt ;
             exes[3] = (int) (fact*(660.0)) + xt ;
             whys[3] = (int) (fact*(-50.0)) + yt ;
             exes[4] = (int) (fact*(660.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(650.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(650.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #2
             exes[0] = (int) (fact*(1550.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(1580.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(1580.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(1560.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(1560.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(1550.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(1550.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #3
             exes[0] = (int) (fact*(2350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(2390.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(2390.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(2370.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(2370.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(2350.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(2350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #4
             exes[0] = (int) (fact*(3250.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(3290.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(3290.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(3270.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(3270.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(3250.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(3250.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #5
             exes[0] = (int) (fact*(4450.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(4490.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(4490.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(4470.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(4470.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(4450.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(4450.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #6
             exes[0] = (int) (fact*(-750.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-790.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-790.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(-770.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(-770.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(-750.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(-750.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                // building  #7
             exes[0] = (int) (fact*(-1250.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-1290.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-1290.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(-1270.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(-1270.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(-1250.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(-1250.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #8
             exes[0] = (int) (fact*(-2350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-2390.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-2390.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-2370.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-2370.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(-2350.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(-2350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #9
             exes[0] = (int) (fact*(-3550.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-3580.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-3580.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-3560.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-3560.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(-3550.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(-3550.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #10
             exes[0] = (int) (fact*(-4350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-4380.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-4380.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-4360.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-4360.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(-4350.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(-4350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
          }
                // Grid paper background
          if (gridon >= 0) {  
            factm = 50. ;
            if (fact < 2.5 && fact >= .5) factm = 100. ;
            if (fact < .5 && fact >= .25) factm = 500. ;
            if (fact < .25 && fact >= .1) factm = 1000. ;
            if (fact < .1 && fact >= .05) factm = 5000. ;
            if (fact < .05 && fact >= .001) factm = 10000. ;

            outlng = " ft" ;
            if (lunits == 1) {
               outlng = " m" ;
               factm = .5 * factm ;
            }
            for (j=0; j<=50; ++j) {
               exes[0] = 0 ; 
               exes[1] = 700 ;
               whys[0] = whys[1] = (int) (-fact*(factm*j / lconv1)) + yt;
               offsGg.setColor(Color.red) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.drawString(words,252,whys[0]+5) ; 
            }
            for (j=0; j<=50; ++j) {
               whys[0] = (int) (-fact*(0.0)) + yt;
               whys[1] = 0;
               exes[0] = exes[1] = (int) (fact*(factm*j / lconv1)) + xt  ;
               offsGg.setColor(Color.red) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.setColor(Color.black) ;
               if (planet == 2) offsGg.setColor(Color.white) ;
               offsGg.drawString(words,exes[0]-5,260) ;

               exes[0] = exes[1] = (int) (-fact*(factm*j / lconv1)) + xt  ;
               offsGg.setColor(Color.red) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.setColor(Color.black) ;
               if (planet == 2) offsGg.setColor(Color.white) ;
               offsGg.drawString(words,exes[0]-5,260) ;
            }
          }
       // labels 
               // saved flights
          if (nsav >= 1) {
            for (i=0; i<= nsav-1; ++ i) {
              exes[0] = (int) (fact*(0.0)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              nump = npts[i] ;
              for (j=0; j<=nump; ++j){
                exes[1] = exes[0] ;
                whys[1] = whys[0] ;
                exes[0] = (int) (fact*(posx[i][j])) + xt ;
                whys[0] = (int) (fact*(-posy[i][j])) + yt ;
                offsGg.setColor(Color.white) ;
                offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                if(i==0) offsGg.setColor(Color.blue) ;
                if(i==1) offsGg.setColor(Color.white) ;
                if(i==2) offsGg.setColor(Color.magenta) ;
                if(i==3) offsGg.setColor(Color.orange) ;
                offsGg.drawString("*",exes[0]-3,whys[0]+5) ;
              }
            }
          }
               // flight trajectory
          exes[0] = (int) (fact*(0.0)) + xt ;
          whys[0] = (int) (fact*(0.0)) + yt ;
          for (j=0; j<=npt; ++j){
            exes[1] = exes[0] ;
            whys[1] = whys[0] ;
            exes[0] = (int) (fact*(posx[nsav][j])) + xt ;
            whys[0] = (int) (fact*(-posy[nsav][j])) + yt ;
            if (planet <= 1) offsGg.setColor(Color.black) ;
            if (planet == 2) offsGg.setColor(Color.white) ;
            if (planet == 3) offsGg.setColor(Color.black) ;
            if (j < nburn) offsGg.setColor(Color.red) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            offsGg.setColor(Color.red) ;
            if ((rktype < 3) || (rktype == 10)) {
              offsGg.drawString("*",exes[0]-3,whys[0]+5) ;
            }
            if (rktype == 3 ) {
               if (j < nburn) offsGg.drawString("*",exes[0]-3,whys[0]+5) ;
            }
          }
     // baseball
          if (ldisplay == 2) {
            cpa = Math.cos((90.0 - lnchang)*convdr) ;
            spa = Math.sin((90.0 - lnchang)*convdr) ;
  //               cpa = Math.cos(lnchang*convdr) ;
  //               spa = Math.sin(lnchang*convdr) ;
            exes[0] = (int) (0.0) + xt ;
            whys[0] = -(int) (0.0) + yt ;
            exes[1] = (int) (20. * cpa) + xt ; 
            whys[1] = -(int) (20. * spa) + yt ;
            offsGg.setColor(Color.black) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            exes[0] = (int) (fact*(posx[nsav][npt])) - 5 + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt])) - 5 + yt;
            offsGg.setColor(Color.white) ;
            offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
          }
 
   // wind vector
          exes[0] = 140 ;
          whys[0] = 75;
          exes[1] = 140 + (int) (5.*wind) ;
          whys[1] = 75 ;
          offsGg.setColor(Color.black) ;
          offsGg.drawString("Wind",exes[0]-15,whys[0]+15) ;
          offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
          if (wind >= 0.0) {
            exes[0] = exes[1] - 5 ;
            whys[0] = whys[1] - 3 ;
            exes[2] = exes[1] - 5 ;
            whys[2] = whys[1] + 3 ;
            exes[3] = exes[1] - 5 ;
            whys[3] = whys[1] - 3 ;
          }
          if (wind < 0.0) {
            exes[0] = exes[1] + 5 ;
            whys[0] = whys[1] - 3 ;
            exes[2] = exes[1] + 5 ;
            whys[2] = whys[1] + 3 ;
            exes[3] = exes[1] + 5 ;
            whys[3] = whys[1] - 3 ;
          }
          offsGg.fillPolygon(exes,whys,4) ;

          if (trakon > 0) {
            offsGg.setColor(Color.black) ;
            if (planet == 2) offsGg.setColor(Color.white) ;
            offsGg.drawString("TRACKING  MODE",120,415) ;
          }
        }
 
        if (viewflg == 2) {   // data traces
           offsGg.setColor(Color.white) ;
           offsGg.fillRect(0,0,600,600) ;
           if (gridon >= 0) {       // Grid paper background
             for (j=0; j<=50; ++j) {
               offsGg.setColor(Color.cyan) ;
               exes[0] = 0 ; 
               exes[1] = 500 ;
               whys[0] = whys[1] = (int) (fact*(10.*j)) + yt;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               whys[0] = whys[1] = (int) (-fact*(10.*j)) + yt;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
             }
             for (j=0; j<=60; ++j) {
               offsGg.setColor(Color.cyan) ;
               whys[0] = 0 ; whys[1] = 500 ;
               exes[0] = exes[1] = (int) (fact*(10.0*j)) + xt  ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               exes[0] = exes[1] = (int) (-fact*(10.0*j)) + xt  ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
             }
          }
          for (i=5; i<= 9; ++ i) {
            exes[0] = (int) (fact*(0.0)) + xt ;
            whys[0] = (int) (fact*((i-4) * 50.0 - posy[i][0])) + yt ;
            scale = 1.0 ;
            if (i == 5) {
               offsGg.setColor(Color.black) ;
               offsGg.drawString("Thrust",exes[0]-50,whys[0]) ;
            }
            if (i == 6) {
               offsGg.setColor(Color.blue) ;
               ylabel = (int) (fact*((i-4) * 50.0)) + yt ;
               offsGg.drawString("Weight",exes[0]-50,ylabel) ;
            }
            if (i == 7) {
               offsGg.setColor(Color.red) ;
               offsGg.drawString("Drag",exes[0]-50,whys[0]) ;
            }
            if (i == 8) {
               offsGg.setColor(Color.magenta) ;
               if (spdmax > 0.0) {
                 scale = 50.0 /spdmax ;
                 whys[0] = (int) (fact*((i-4) * 50.0 - scale * posy[i][0])) + yt ;
               }
               ylabel = (int) (fact*((i-4) * 50.0)) + yt ;
               offsGg.drawString("Velocity",exes[0]-50,ylabel) ;
            }
            if (i == 9) {
               offsGg.setColor(Color.green) ;
               if (vmax > 0.0) {
                 scale = 50.0 / vmax ;
                 whys[0] = (int) (fact*((i-4) * 50.0 - scale * posy[i][0])) + yt ;
               }
               offsGg.drawString("Height",exes[0]-50,whys[0]) ;
            }
            for (j=1; j<=npt; ++j){
              exes[1] = exes[0] ;
              whys[1] = whys[0] ;
              exes[0] = (int) (fact*(posx[i][j])) + xt ;
              whys[0] = (int) (fact*((i-4) * 50.0 - scale * posy[i][j])) + yt ;
              offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            }
          }
          offsGg.setColor(Color.black) ;
          exes[0] = (int) (fact*(50.0)) + xt ;
          whys[0] = (int) (fact*(260.0)) + yt ;
          offsGg.drawString("Time",exes[0],whys[0]) ;
        }
 // border 
 // side zoom widget
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(0,0,35,450) ;
        offsGg.setColor(Color.black) ;
        offsGg.drawString("Zoom",2,265) ;
        offsGg.drawLine(15,50,15,250) ;
        offsGg.fillRect(5,sldloc,20,5) ;

        if (gridon < 0) {     // Grid button
           offsGg.setColor(Color.blue) ;
           offsGg.fillRect(0,30,30,15) ;
           offsGg.setColor(Color.white) ;
           offsGg.drawString("Grid",2,42) ;
        }
        if (gridon >= 0) {
           offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(0,30,30,15) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Grid",2,42) ;
        }
 // bottom
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(34,415,400,40) ;
        offsGg.setColor(Color.blue) ;
        offsGg.fillRect(100,420,40,20) ;
        offsGg.setColor(Color.white) ;
        offsGg.drawString("Find",108,435) ;
        if (trakon < 0) {  // Track button
           offsGg.setColor(Color.blue) ;
           offsGg.fillRect(200,420,40,20) ;
           offsGg.setColor(Color.white) ;
           offsGg.drawString("Track",205,435) ;
        }
        if (trakon >= 0) {
           offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(200,420,40,20) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Track",205,435) ;
        }
 // top
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(34,0,700,25) ;
        if (viewflg == 0) {
           if (lnchgrf == 0) {
             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(35,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Nose",45,15) ;

             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(100,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Payload",105,15) ;

             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(165,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Body",175,15) ;

             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(230,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Fins",240,15) ;

             if (part == 1) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(35,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Nose",45,15) ;
             }

             if (part == 2) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(100,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Payload",105,15) ;
             }

             if (part == 3) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(165,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Body",175,15) ;
             }

             if (part == 4) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(230,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Fins",240,15) ;
             }
           }
        }
        if (viewflg == 1) {
               // time-height boxes
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Time",40,15) ;
           offsGg.drawString("Height",150,15) ;
           offsGg.drawString("Max",250,15) ;
           offsGg.drawString("Distance",350,15) ;
           offsGg.setColor(Color.white) ;
           offsGg.fillRect(80,2,40,18) ;
           offsGg.fillRect(200,2,40,18) ;
           offsGg.fillRect(280,2,40,18) ;
           offsGg.fillRect(400,2,40,18) ;
           if (fltim <= 0.0) {
             offsGg.setColor(Color.black) ;
             offsGg.drawString(String.valueOf(filter0(fltim)),90,15) ;
           }
           if (fltim > 0.0) {
             offsGg.setColor(Color.black) ;
             offsGg.drawString(String.valueOf(filter1(fltim)),90,15) ;
           }
           offsGg.setColor(Color.black) ;
           offsGg.drawString(String.valueOf(filter0(vloc*lconv1)),205,15) ;
           offsGg.drawString(String.valueOf(filter0(vmax*lconv1)),285,15) ;
           offsGg.drawString(String.valueOf(filter0(posx[nsav][npt]*lconv1)),405,15) ;
        }

 // right 
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(680,0,30,450) ;
 
        g.drawImage(offImg,0,0,this) ;   

     }  // end Paint
  }  // End View

} // end HitModeler
