      Program mesh

!-----Purpose:  This subroutine computes a 2-D three-zone grid for a
!               simple diffuser, one of the test cases supplied with
!               Wind-US. The grid is written to a file in PLOT3D 2-D
!               unformatted form, without iblank'ing.

!-----Called by:  

!-----Calls:  

      Implicit none
!-----Parameter statements
      Integer IDIM,JDIM    ! Max dimensions
      Integer NBLKS        ! Number of blocks
      Parameter (IDIM = 33, JDIM = 11)
      Parameter (NBLKS = 3)
!-----Local variables:
      Integer i,j          ! Indices in x and y directions
      Integer iblk         ! Current block number
      Integer imax(NBLKS),jmax(NBLKS) ! Block grid sizes
      Integer np           ! No. of points for plotc curve
      Real dx(NBLKS),dy(NBLKS)        ! Non-dim grid increments in blks
      Real x(IDIM,JDIM),y(IDIM,JDIM),z(IDIM,JDIM)   ! Grid coordinates
      Real xdiff1,xdiff2   ! x at start/end of diffuser section
      Real xloc            ! Local x coordinate
      Real xmax            ! x at end of duct
      Real xstrt(NBLKS),xend(NBLKS)   ! Non-dim x limits of blocks
      Real ymax            ! Max y at x = xloc
      Real ymax1,ymax2     ! Max y at start/end of diffuser section
      Real yslope          ! Slope of diffuser upper wall
      Real ystrt(NBLKS),yend(NBLKS)   ! Non-dim y limits of blocks

!-----Define geometric parameters (This mesh is in inches.)

      Data xdiff1,xdiff2,xmax /2.0, 6.0, 8.0/
      Data ymax1,ymax2 /1.0, 2.0/

!-----Set relative sizes and grid increments for each block

!-----Block 1
      imax(1) = 17
      jmax(1) =  6
      xstrt(1) = 0.0
      ystrt(1) = 0.0
      xend (1) = 0.5
      yend (1) = 0.5
      dx(1) = (xend(1) - xstrt(1))/(imax(1) - 1)
      dy(1) = (yend(1) - ystrt(1))/(jmax(1) - 1)
!-----Block 2
      imax(2) = 33
      jmax(2) = 11
      xstrt(2) = 0.0
      ystrt(2) = yend(1)
      xend (2) = xend(1)
      yend (2) = 1.0
      dx(2) = (xend(2) - xstrt(2))/(imax(2) - 1)
      dy(2) = (yend(2) - ystrt(2))/(jmax(2) - 1)
!-----Block 3
      imax(3) = 17
      jmax(3) = 11
      xstrt(3) = xend(1)
      ystrt(3) = 0.0
      xend (3) = 1.0
      yend (3) = 1.0
      dx(3) = (xend(3) - xstrt(3))/(imax(3) - 1)
      dy(3) = (yend(3) - ystrt(3))/(jmax(3) - 1)

!-----Open grid file, write header info

      Open (unit=2, file='case4.xyz', form='unformatted')
      Open (unit=9, file='mesh.plotin.data', form='formatted')
      Write (2) NBLKS
      Write (2) (imax(iblk),jmax(iblk),iblk=1,NBLKS)

!-----Construct the grid

      yslope = (ymax2 - ymax1)/(xdiff2 - xdiff1)   ! Slope of diff wall
      Do iblk = 1,NBLKS           ! Loop over no. of blocks
         Do i = 1,imax(iblk)      ! Loop over no. of x points
!-----------Compute x coordinates
            xloc = (xstrt(iblk) + dx(iblk)*(i-1))*xmax
            Do j = 1,jmax(iblk)   ! Loop over no. of y points
               x(i,j) = xloc
            End do
!-----------Get local max y, then compute y coordinates
            If (xloc <= xdiff1) then          ! Upstream of diffuser
               ymax = ymax1
            Else if (xloc >= xdiff2) then     ! Downstream of diffuser
               ymax = ymax2
            Else                              ! In diffuser
               ymax = ymax1 + yslope*(xloc-xdiff1)
            End if
            Do j = 1,jmax(iblk)   ! Loop over no. of y points
               y(i,j) = (ystrt(iblk) + dy(iblk)*(j-1))*ymax
            End do
         End do

!-----Write the grid file in PLOT3D xyz format

         Write (2) ((x(i,j),i=1,imax(iblk)),j=1,jmax(iblk)), &
                   ((y(i,j),i=1,imax(iblk)),j=1,jmax(iblk))

!-----Write data for plotc

         Do i = 1,imax(iblk)
            np = jmax(iblk)
            Write (9,10) np
            Write (9,20) (x(i,j),j=1,jmax(iblk))
            Write (9,20) (y(i,j),j=1,jmax(iblk))
         End do
         Do j = 1,jmax(iblk)
            np = imax(iblk)
            Write (9,10) np
            Write (9,20) (x(i,j),i=1,imax(iblk))
            Write (9,20) (y(i,j),i=1,imax(iblk))
         End do
10       Format (i2)
20       Format (1p,8e10.3)
      End do
      Close (unit=2)
      Close (unit=9)
      Stop
      End
