#!/usr/local/bin/perl

# Script to create Wind-US data input file.

  use warnings FATAL => 'uninitialized';    # Stop if uninitialized variables.
  use strict;           # Same as use strict "vars"+"refs"+"subs" below.
# use strict "vars";    # No undeclared variables.
# use strict "refs";    # No symbolic references.
# use strict "subs";    # No barewords.  "quote them", &sub, or sub().
  use English;          # English names for perl shortcuts
  use File::Basename;   # file name parsing
  use File::Copy;       # perl version of linux cp and mv commands
  use File::Which;      # perl version of linux which command

  my $datfile  = "case4.dat";               # No comments
  my $datfile2 = "case4.dat.commented";     # With comments

# If arguments, display usage and quit.
  if (@ARGV) {
    &Usage();
    goto EOF;
  }

# Write description.
  printf "This script will create a Wind-US data input file for the\n";
  printf "case4 tutorial ($datfile).  A fully commented version will\n";
  printf "also be written to $datfile2.\n";

# Do NOT overwrite existing files.
  foreach my $file ( $datfile, $datfile2 ) {
    if ( -e $file ) {
      die "File $file already exists.  Please remove and try again.";
    }
  }

# Fully commented *.dat file content.
#---------------------------------------------------------------------
my @lines = <<'EOH' =~ m/(.*\n)/g;
Wind-US test case 4, 2-D, 3 zones           ! Geometry Title
Subsonic internal flow                      ! Flow Title
Run 1                                       ! Arbitrary Title

/ Freestream and reference conditions
Freestream total 0.78 15.0 600.0 0. 0.      ! M, p0(psi), T0(R), alpha(deg), beta(deg)

/ Inflow conditions
Arbitrary Inflow
  Total                                     ! Flow conditions below are total, not static
  Hold_Totals                               ! Hold total conditions on inflow
  Zone 1
    Freestream                              ! Zone 1 inflow, use freestream conditions
  Zone 2
    Freestream                              ! Zone 2 inflow, use freestream conditions
Endinflow

/ Outflow conditions
Downstream pressure 14.13 zone 3            ! Exit p(psi)

/ Numerics
Cycles 500                                  ! Run 500 cycles
Iterations per cycle 5 Print frequency 5    ! 5 iterations/cycle; print every 5th

/ Viscous terms
Turbulence euler                            ! Solve the inviscid equations

/ Convergence data
Loads
   print planes frequency 5                 !  Print plane integrals every 5 iterations
   zone 1
      surface i 1 mass                      !  Mass flux at zone 1 entrance
   zone 2
      surface i 1 mass                      !  Mass flux at zone 2 entrance
   zone 3
      surface i 1    mass                   !  Mass flux at zone 3 entrance
      surface i last mass                   !  Mass flux at zone 3 exit
Endloads
EOH
#---------------------------------------------------------------------

# Write content to *.dat files.
  foreach my $file ( $datfile, $datfile2 ) {
    open(FILE,">$file") or die "Unable to open file $file";
      printf "  Writing $file\n";
      foreach (@lines) {
        my $line = $_;
        if ( $file eq $datfile ) {
          $line =~ s/ *!.*//;    # Strip trailing comments
        }
        printf FILE $line;
      }
    close(FILE);
  }

  END_OF_MAIN:
  goto EOF;

# ====================================================================
  sub Usage{
    printf "This script will create a Wind-US data input file for \n";
    printf "case 4 (case4.dat).\n";
    printf "Usage:\n";
    printf "  %s\n", basename($0);
    return;
  }
# ====================================================================
  sub sub1{
    return;
  }
# ====================================================================

  EOF:
