      program stubeic

c        Computes a uniformly-spaced, planar grid for the shock-tube
c         problem.  Assumptions:
c        1) Planar domain 
c
c-----------------------------------------------------------------------

      Implicit none

      Integer nim
      Integer njm

      Parameter ( nim = 200 )
      Parameter ( njm =  50 )

      Integer iprob
      Integer i, j
      Integer m
      Integer ni, nj

      Real x (nim,njm)
      Real y (nim,njm)

      Real xl, xr, xd, yh

c-----------------------------------------------------------------------

c.....Set gas variables.


      xl = 0.0
      xr = 1.0
      xd = 0.5
      yh = 0.1


c.....Generate an evenly spaced, planar grid.

      write(*,*) ' '
      write(*,*) 'Enter ni and nj'
      read (*,*) ni, nj

      do  i = 1, ni
        do  j = 1, nj
          x(i,j) = xl + ( xr - xl ) * ( i - 1.0 ) / ( ni - 1.0 )
          y(i,j) = yh * ( j - 1.0 ) / ( nj - 1.0 )
        enddo
      enddo

      open ( unit=7, file='stube.x.fmt' )
      write ( 7, * ) ni, nj
      write ( 7, * ) (( x(i,j), i=1,ni), j=1,nj ),
     &               (( y(i,j), i=1,ni), j=1,nj )

c-----------------------------------------------------------------------

      stop
      end
