#!/bin/bash

########################################
#  Enter Fortran compiler here
########################################
FC=ifort

########################################
#  Enter number of grid zones here
########################################
nzonemax=1

########################################
#  Create and run CFPOST script to write out flowfield
########################################
echo "
grid Seiner.cgd
solution Seiner.cfl

clear all
zone 1
!surface u 5
surface u 6
cut at z 1.0
variable x;y
genplot output Seiner.CL-y.out
clear variable
variable x;z
genplot output Seiner.CL-z.out
clear variable
variable x;u
genplot output Seiner.CL-u.out
clear variable
variable x;v
genplot output Seiner.CL-v.out
clear variable
variable x;V
genplot output Seiner.CL-V.out
clear variable
variable x;M
genplot output Seiner.CL-M.out
clear variable
variable x;rho
genplot output Seiner.CL-rho.out
clear variable
variable x;p
genplot output Seiner.CL-p.out
clear variable
variable x;T
genplot output Seiner.CL-T.out
clear variable
variable x;rho0
genplot output Seiner.CL-rho0.out
clear variable
variable x;p0
genplot output Seiner.CL-p0.out
clear variable
variable x;T0
genplot output Seiner.CL-T0.out
clear variable
variable x;k
genplot output Seiner.CL-k.out
clear variable
variable x;mut muinf
genplot output Seiner.CL-mut.out
clear variable

exit
" > Seiner.cfpost.com

cfpost_prod.exe < Seiner.cfpost.com

########################################
#  Clean up flowfield data
########################################
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'y' -e 'Cut' Seiner.CL-y.out > Seiner.CL-y.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'z' -e 'Cut' Seiner.CL-z.out > Seiner.CL-z.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'u' -e 'Cut' Seiner.CL-u.out > Seiner.CL-u.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'v' -e 'Cut' Seiner.CL-v.out > Seiner.CL-v.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'V' -e 'Cut' Seiner.CL-V.out > Seiner.CL-V.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'M' -e 'Cut' Seiner.CL-M.out > Seiner.CL-M.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'rho' -e 'Cut' Seiner.CL-rho.out > Seiner.CL-rho.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'p' -e 'Cut' Seiner.CL-p.out > Seiner.CL-p.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'T' -e 'Cut' Seiner.CL-T.out > Seiner.CL-T.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'rho0' -e 'Cut' Seiner.CL-rho0.out > Seiner.CL-rho0.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'p0' -e 'Cut' Seiner.CL-p0.out > Seiner.CL-p0.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'T0' -e 'Cut' Seiner.CL-T0.out > Seiner.CL-T0.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'k' -e 'Cut' Seiner.CL-k.out > Seiner.CL-k.out2
grep -v -e 'Exported' -e 'Turbulent' -e 'x' -e 'mut' -e 'Cut' Seiner.CL-mut.out > Seiner.CL-mut.out2

########################################
#  This Fortran code consolidates the flowfield data
########################################
echo "
c234567890123456789012345678901234567890123456789012345678901234567890
c
      Real x(1000),y(1000),z(1000),u(1000),v(1000),Vs(1000),M(1000),
     &     rho(1000),p(1000),T(1000),rho0(1000),p0(1000),T0(1000),
     &     tke(1000),mut(1000)
      Integer k,kmax,i,imax(10),imaxsum
c
11    FORMAT(E15.8,T20,E15.8,T40,E15.8,T60,E15.8,T80,E15.8,T100,
     &       E15.8,T120,E15.8,T140,E15.8,T160,E15.8,T180,E15.8,T200,
     &       E15.8,T220,E15.8,T240,E15.8,T260,E15.8,T280,E15.8)
c
      open(unit=21,file='Seiner.CL-y.out2',form='formatted')
      open(unit=22,file='Seiner.CL-z.out2',form='formatted')
      open(unit=23,file='Seiner.CL-u.out2',form='formatted')
      open(unit=24,file='Seiner.CL-v.out2',form='formatted')
      open(unit=25,file='Seiner.CL-V.out2',form='formatted')
      open(unit=26,file='Seiner.CL-M.out2',form='formatted')
      open(unit=27,file='Seiner.CL-rho.out2',form='formatted')
      open(unit=28,file='Seiner.CL-p.out2',form='formatted')
      open(unit=29,file='Seiner.CL-T.out2',form='formatted')
      open(unit=30,file='Seiner.CL-rho0.out2',form='formatted')
      open(unit=31,file='Seiner.CL-p0.out2',form='formatted')
      open(unit=32,file='Seiner.CL-T0.out2',form='formatted')
      open(unit=33,file='Seiner.CL-k.out2',form='formatted')
      open(unit=34,file='Seiner.CL-mut.out2',form='formatted')
c
      read(21,*) kmax
      read(22,*) kmax
      read(23,*) kmax
      read(24,*) kmax
      read(25,*) kmax
      read(26,*) kmax
      read(27,*) kmax
      read(28,*) kmax
      read(29,*) kmax
      read(30,*) kmax
      read(31,*) kmax
      read(32,*) kmax
      read(33,*) kmax
      read(34,*) kmax
c
      do k=1,kmax
        read(21,*) imax(k)
        read(22,*) imax(k)
        read(23,*) imax(k)
        read(24,*) imax(k)
        read(25,*) imax(k)
        read(26,*) imax(k)
        read(27,*) imax(k)
        read(28,*) imax(k)
        read(29,*) imax(k)
        read(30,*) imax(k)
        read(31,*) imax(k)
        read(32,*) imax(k)
        read(33,*) imax(k)
        read(34,*) imax(k)
        if (k .EQ. 1) then
	  imaxsum=0
	endif
        do i=1,imax(k)
	  read(21,*) x(i+imaxsum),y(i+imaxsum)
	  read(22,*) x(i+imaxsum),z(i+imaxsum)
	  read(23,*) x(i+imaxsum),u(i+imaxsum)
	  read(24,*) x(i+imaxsum),v(i+imaxsum)
	  read(25,*) x(i+imaxsum),Vs(i+imaxsum)
	  read(26,*) x(i+imaxsum),M(i+imaxsum)
	  read(27,*) x(i+imaxsum),rho(i+imaxsum)
	  read(28,*) x(i+imaxsum),p(i+imaxsum)
	  read(29,*) x(i+imaxsum),T(i+imaxsum)
	  read(30,*) x(i+imaxsum),rho0(i+imaxsum)
	  read(31,*) x(i+imaxsum),p0(i+imaxsum)
	  read(32,*) x(i+imaxsum),T0(i+imaxsum)
	  read(33,*) x(i+imaxsum),tke(i+imaxsum)
	  read(34,*) x(i+imaxsum),mut(i+imaxsum)
        enddo
	imaxsum=imaxsum+imax(k)
      enddo
      write(*,*) imaxsum
c
      close(21)
      close(22)
      close(23)
      close(24)
      close(25)
      close(26)
      close(27)
      close(28)
      close(29)
      close(30)
      close(31)
      close(32)
      close(33)
      close(34)
c
      open(unit=41,file='Seiner.CL.out3',form='formatted')
c
      do i=1,imaxsum
        write(41,11) x(i),y(i),z(i),u(i),v(i),Vs(i),M(i),
     &               rho(i),p(i),T(i),rho0(i),p0(i),T0(i),
     &               tke(i),mut(i)
      enddo
c
      close(41)
c
      end
" > CLconsolidate.f

$FC -o CLconsolidate.exe CLconsolidate.f
./CLconsolidate.exe

########################################
#  Sort the flowfield data
########################################
sort -g -u Seiner.CL.out3 > Seiner.CL.out4

########################################
#  This Fortran code formats the flowfield data
########################################
echo "
c234567890123456789012345678901234567890123456789012345678901234567890
c
      Real x(1000),y(1000),z(1000),u(1000),v(1000),Vs(1000),M(1000),
     &     rho(1000),p(1000),T(1000),rho0(1000),p0(1000),T0(1000),
     &     k(1000),mut(1000)
      Integer i,imax
      Character*43 charline1
      Character*11 charline2
      Character*42 charline3
      Character*25 charline4
      Character*9 charline5
c
11    FORMAT(E15.8,T20,E15.8,T40,E15.8,T60,E15.8,T80,E15.8,T100,
     &       E15.8,T120,E15.8,T140,E15.8,T160,E15.8,T180,E15.8,T200,
     &       E15.8,T220,E15.8,T240,E15.8,T260,E15.8,T280,E15.8)
c
      imax=441
c
      open(unit=21,file='Seiner.CL.out4',form='formatted')
      do i=1,imax
        read(21,*) x(i),y(i),z(i),u(i),v(i),Vs(i),M(i),
     &             rho(i),p(i),T(i),rho0(i),p0(i),T0(i),
     &             k(i),mut(i)
      enddo
      close(21)
c
      open(unit=31,file='Seiner-centerline.dat',form='formatted')
      charline1 = 'TITLE     = \"Seiner Nozzle Centerline Data\"'
      write(31,'(A,A)') charline1
      write(31,'(A)') 'VARIABLES = \"x [ft]\"'
      write(31,'(A)') '\"y [ft]\"'
      write(31,'(A)') '\"z [ft]\"'
      write(31,'(A)') '\"u [ft/s]\"'
      write(31,'(A)') '\"v [ft/s]\"'
      write(31,'(A)') '\"V [ft/s]\"'
      write(31,'(A)') '\"Mach\"'
      write(31,'(A)') '\"rho [slug/ft^3]\"'
      write(31,'(A)') '\"p [psi]\"'
      write(31,'(A)') '\"T [ degR]\"'
      write(31,'(A)') '\"rho0< [slug/ft^3]\"'
      write(31,'(A)') '\"p0 [psi]\"'
      write(31,'(A)') '\"T0 [<math>0</math>R]\"'
      write(31,'(A)') '\"k [ft^2/s^2]\"'
      charline2 = '\"mut/muinf\"'
      write(31,'(A,A)') charline2
      write(31,'(A)') ''
cc
      charline4 = 'ZONE T=\"Str-Uns_SST\", I='
      charline5 = ', F=POINT'
      write(31,'(A,I5,A)') charline4,imax,charline5
c
      do i=1,imax
        write(31,11) x(i),y(i),z(i),u(i),v(i),Vs(i),M(i),
     &               rho(i),p(i),T(i),rho0(i),p0(i),T0(i),
     &               k(i),mut(i)
      enddo
c
      end
" > SeinerTecplot.f

$FC -o SeinerTecplot.exe SeinerTecplot.f
./SeinerTecplot.exe

########################################
#  Extract max N-S residuals from LIS file (assumes single zone)
########################################
for ((nzone=1; nzone<=$nzonemax; nzone++))
do
    grep -a RES Seiner.lis | awk '{ print $3 "    " $4 "    " $7 "    " $8 }' | grep "   $nzone   " > Seiner.NSresid-$nzone.out
    grep -a RES Seiner.lis | awk '{ print $3 "    " $4 } ' | grep "   $nzone" | awk '{ c += length + 1 } END { print NR }' > Seiner.imax-$nzone.out
done

########################################
#  This Fortran code formats the N-S residuals data
########################################
echo $nzonemax > kmax.txt
echo "
c234567890123456789012345678901234567890123456789012345678901234567890
c This code formats N-S residuals data
c
      Real big(100000,8),l2(100000,8)
      Integer i,iter(100000,8),zone(100000,8),imax,k,kmax
      Character*34 charline1
      Character*24 charline2
      Character*44 charline3
      Character*9  charline4
      Character*9  charline5
      Character*12 charline6
      Character*4  charline7
      Character*17 charline8
      Character*15 charline9
      Character*20 charline10
      Character*4  charline11
c
11    FORMAT(I10,T20,E15.8,T40,E15.8)
c
      open(unit=40,file='kmax.txt',form='formatted')
      read(40,*) kmax
      close(40)
c      
      do k=1,kmax
        charline6='Seiner.imax-'
	charline7='.out'
	open(unit=41,file='dummy1',form='formatted')
	write(41,'(A12,I1,A4)') charline6,k,charline7
	rewind(41)
	read(41,'(A17)') charline8
	close(41)
	open(unit=20,file=charline8,form='formatted')
        read(20,*) imax
        close(20)
c
        charline9='Seiner.NSresid-'
	open(unit=42,file='dummy2',form='formatted')
	write(42,'(A15,I1,A4)') charline9,k,charline7
	rewind(42)
	read(42,'(A20)') charline10
	close(42)
	open(unit=21,file=charline10,form='formatted')
        do i=1,imax
          read(21,*) iter(i,k),zone(i,k),big(i,k),l2(i,k)
        enddo
        close(21)
      enddo
c
      open(unit=31,file='Seiner.NSresid.dat',form='formatted')
      charline1 = 'TITLE     = \"Seiner Jet, Mach 2.0:'
      charline2 = 'Navier-Stokes Residuals\"'
      write(31,'(A,A)') charline1,charline2
      write(31,'(A)') 'VARIABLES = \"iteration\"'
      write(31,'(A)') '\"N-S residual\"'
      write(31,'(A)') '\"L2 residual\"'
      write(31,'(A)') ''
c
      charline3 = 'ZONE T=\"Structured Grid, Unstructured Solver,'
      charline4 = ' SST\", I='
      charline11= ', J='
      charline5 = ', F=POINT'
      write(31,'(A,A,I7,A,I2,A)') charline3,charline4,imax,charline11
     &                            ,kmax,charline5
c
      do k=1,kmax
        do i=1,imax
          write(31,11) iter(i,k),big(i,k),l2(i,k)
        enddo
      enddo
c
      close(31)
c
      end
" > NSresid.f

$FC -o NSresid.exe NSresid.f
./NSresid.exe

########################################
#  Clean up intermediate output files
########################################
rm -f Seiner.CL*.out*
rm -f Seiner-centerline.out* FOR021
rm -f Seiner.NSresid*.out Seiner.imax*.out
rm -f *.jou *.f *.exe dummy* kmax.txt

