#!/bin/bash

########################################
#  Enter Fortran compiler here
########################################
FC=ifort

########################################
#  Enter number of grid zones here
########################################
nzonemax=3

########################################
#  Create and run CFPOST script to write out nozzle massflow
########################################
echo "
grid Seiner.cgd
solution Seiner.cfl

zone 1
  subset j all k all i  1
  subset j all k all i  2
  subset j all k all i  3
  subset j all k all i  4
  subset j all k all i  5
  subset j all k all i  6
  subset j all k all i  7
  subset j all k all i  8
  subset j all k all i  9
  subset j all k all i 10
  subset j all k all i 11
  subset j all k all i 12
  subset j all k all i 13
  subset j all k all i 14
  subset j all k all i 15
  subset j all k all i 16
  subset j all k all i 17
  subset j all k all i 18
  subset j all k all i 19
  subset j all k all i 20
  subset j all k all i 21
  subset j all k all i 22
  subset j all k all i 23
  subset j all k all i 24
  subset j all k all i 25
  subset j all k all i 26
  subset j all k all i 27
  subset j all k all i 28
  subset j all k all i 29
  subset j all k all i 30
  subset j all k all i 31
  subset j all k all i 32
  subset j all k all i 33
  subset j all k all i 34
  subset j all k all i 35
  subset j all k all i 36
  subset j all k all i 37
  subset j all k all i 38
  subset j all k all i 39
  subset j all k all i 40
  subset j all k all i 41
  subset j all k all i 42
  subset j all k all i 43
  subset j all k all i 44
  subset j all k all i 45
  subset j all k all i 46
  subset j all k all i 47
  subset j all k all i 48
  subset j all k all i 49
  subset j all k all i 50
  subset j all k all i 51
  subset j all k all i 52
  subset j all k all i 53
  subset j all k all i 54
  subset j all k all i 55
  subset j all k all i 56
  subset j all k all i 57
  subset j all k all i 58
  subset j all k all i 59
  subset j all k all i 60
  subset j all k all i 61
  subset j all k all i 62
  subset j all k all i 63
  subset j all k all i 64
  subset j all k all i 65
  subset j all k all i 66
  subset j all k all i 67
  subset j all k all i 68
  subset j all k all i 69
  subset j all k all i 70
  subset j all k all i 71
  subset j all k all i 72
  subset j all k all i 73
  subset j all k all i 74
  subset j all k all i 75
  subset j all k all i 76
  subset j all k all i 77
  subset j all k all i 78
  subset j all k all i 79
  subset j all k all i 80
  subset j all k all i 81
  subset j all k all i 82
  subset j all k all i 83
  subset j all k all i 84
  subset j all k all i 85
  subset j all k all i 86
  subset j all k all i 87
  subset j all k all i 88
  subset j all k all i 89
  subset j all k all i 90
  subset j all k all i 91
  subset j all k all i 92
  subset j all k all i 93
  subset j all k all i 94
  subset j all k all i 95
  subset j all k all i 96
  subset j all k all i 97
  subset j all k all i 98
  subset j all k all i 99
  subset j all k all i 100
  subset j all k all i 101
  subset j all k all i 102
  subset j all k all i 103
  subset j all k all i 104
  subset j all k all i 105
  subset j all k all i 106
  subset j all k all i 107
  subset j all k all i 108
  subset j all k all i 109
  subset j all k all i 110
  subset j all k all i 111
  subset j all k all i 112
  subset j all k all i 113
  subset j all k all i 114
  subset j all k all i 115
  subset j all k all i 116
  subset j all k all i 117
  subset j all k all i 118
  subset j all k all i 119
  subset j all k all i 120
  subset j all k all i 121
  subset j all k all i 122
  subset j all k all i 123
  subset j all k all i 124
  subset j all k all i 125
  subset j all k all i 126
  subset j all k all i 127
  subset j all k all i 128
  subset j all k all i 129
  subset j all k all i 130
  subset j all k all i 131
  subset j all k all i 132
  subset j all k all i 133
  subset j all k all i 134
  subset j all k all i 135
  subset j all k all i 136
  subset j all k all i 137
  subset j all k all i 138
  subset j all k all i 139
  subset j all k all i 140
  subset j all k all i 141
  subset j all k all i 142
  subset j all k all i 143
  subset j all k all i 144
  subset j all k all i 145
  subset j all k all i 146
  subset j all k all i 147
  subset j all k all i 148
  subset j all k all i 149
  subset j all k all i 150
  subset j all k all i 151
  subset j all k all i 152
  subset j all k all i 153
  subset j all k all i 154
  subset j all k all i 155
  subset j all k all i 156
  subset j all k all i 157
  subset j all k all i 158
  subset j all k all i 159
  subset j all k all i 160
  subset j all k all i 161
  subset j all k all i 162
  subset j all k all i 163
  subset j all k all i 164
  subset j all k all i 165
  subset j all k all i 166
  subset j all k all i 167
  subset j all k all i 168
  subset j all k all i 169
  subset j all k all i 170
  subset j all k all i 171
  subset j all k all i 172
  subset j all k all i 173
  subset j all k all i 174
  subset j all k all i 175
  subset j all k all i 176
  subset j all k all i 177
  subset j all k all i 178
  subset j all k all i 179
  subset j all k all i 180
  subset j all k all i 181
  subset j all k all i 182
  subset j all k all i 183
  subset j all k all i 184
  subset j all k all i 185
  subset j all k all i 186
  subset j all k all i 187
  subset j all k all i 188
  subset j all k all i 189
  subset j all k all i 190
  subset j all k all i 191
  subset j all k all i 192
  subset j all k all i 193
  subset j all k all i 194
  subset j all k all i 195
  subset j all k all i 196
  subset j all k all i 197
  subset j all k all i 198
  subset j all k all i 199
  subset j all k all i 200
  subset j all k all i 201
  subset j all k all i 202
  subset j all k all i 203
  subset j all k all i 204
  subset j all k all i 205
  subset j all k all i 206
  subset j all k all i 207
  subset j all k all i 208
  subset j all k all i 209
  subset j all k all i 210
  subset j all k all i 211
  subset j all k all i 212
  subset j all k all i 213
  subset j all k all i 214
  subset j all k all i 215
  subset j all k all i 216
  subset j all k all i 217
  subset j all k all i 218
  subset j all k all i 219
  subset j all k all i 220
  subset j all k all i 221
  subset j all k all i 222
  subset j all k all i 223
  subset j all k all i 224
  subset j all k all i 225
  subset j all k all i 226
  subset j all k all i 227
  subset j all k all i 228
  subset j all k all i 229
  subset j all k all i 230
  subset j all k all i 231
  subset j all k all i 232
  subset j all k all i 233
  subset j all k all i 234
  subset j all k all i 235
  subset j all k all i 236
  subset j all k all i 237
  subset j all k all i 238
  subset j all k all i 239
  subset j all k all i 240
  subset j all k all i 241
integrate flux output Seiner-flux.out axisymmetric
clear all

var x inches;M;u;v;w;p inches;p0 inches
zone 1
  subset j all k all i  1
  subset j all k all i  2
  subset j all k all i  3
  subset j all k all i  4
  subset j all k all i  5
  subset j all k all i  6
  subset j all k all i  7
  subset j all k all i  8
  subset j all k all i  9
  subset j all k all i 10
  subset j all k all i 11
  subset j all k all i 12
  subset j all k all i 13
  subset j all k all i 14
  subset j all k all i 15
  subset j all k all i 16
  subset j all k all i 17
  subset j all k all i 18
  subset j all k all i 19
  subset j all k all i 20
  subset j all k all i 21
  subset j all k all i 22
  subset j all k all i 23
  subset j all k all i 24
  subset j all k all i 25
  subset j all k all i 26
  subset j all k all i 27
  subset j all k all i 28
  subset j all k all i 29
  subset j all k all i 30
  subset j all k all i 31
  subset j all k all i 32
  subset j all k all i 33
  subset j all k all i 34
  subset j all k all i 35
  subset j all k all i 36
  subset j all k all i 37
  subset j all k all i 38
  subset j all k all i 39
  subset j all k all i 40
  subset j all k all i 41
  subset j all k all i 42
  subset j all k all i 43
  subset j all k all i 44
  subset j all k all i 45
  subset j all k all i 46
  subset j all k all i 47
  subset j all k all i 48
  subset j all k all i 49
  subset j all k all i 50
  subset j all k all i 51
  subset j all k all i 52
  subset j all k all i 53
  subset j all k all i 54
  subset j all k all i 55
  subset j all k all i 56
  subset j all k all i 57
  subset j all k all i 58
  subset j all k all i 59
  subset j all k all i 60
  subset j all k all i 61
  subset j all k all i 62
  subset j all k all i 63
  subset j all k all i 64
  subset j all k all i 65
  subset j all k all i 66
  subset j all k all i 67
  subset j all k all i 68
  subset j all k all i 69
  subset j all k all i 70
  subset j all k all i 71
  subset j all k all i 72
  subset j all k all i 73
  subset j all k all i 74
  subset j all k all i 75
  subset j all k all i 76
  subset j all k all i 77
  subset j all k all i 78
  subset j all k all i 79
  subset j all k all i 80
  subset j all k all i 81
  subset j all k all i 82
  subset j all k all i 83
  subset j all k all i 84
  subset j all k all i 85
  subset j all k all i 86
  subset j all k all i 87
  subset j all k all i 88
  subset j all k all i 89
  subset j all k all i 90
  subset j all k all i 91
  subset j all k all i 92
  subset j all k all i 93
  subset j all k all i 94
  subset j all k all i 95
  subset j all k all i 96
  subset j all k all i 97
  subset j all k all i 98
  subset j all k all i 99
  subset j all k all i 100
  subset j all k all i 101
  subset j all k all i 102
  subset j all k all i 103
  subset j all k all i 104
  subset j all k all i 105
  subset j all k all i 106
  subset j all k all i 107
  subset j all k all i 108
  subset j all k all i 109
  subset j all k all i 110
  subset j all k all i 111
  subset j all k all i 112
  subset j all k all i 113
  subset j all k all i 114
  subset j all k all i 115
  subset j all k all i 116
  subset j all k all i 117
  subset j all k all i 118
  subset j all k all i 119
  subset j all k all i 120
  subset j all k all i 121
  subset j all k all i 122
  subset j all k all i 123
  subset j all k all i 124
  subset j all k all i 125
  subset j all k all i 126
  subset j all k all i 127
  subset j all k all i 128
  subset j all k all i 129
  subset j all k all i 130
  subset j all k all i 131
  subset j all k all i 132
  subset j all k all i 133
  subset j all k all i 134
  subset j all k all i 135
  subset j all k all i 136
  subset j all k all i 137
  subset j all k all i 138
  subset j all k all i 139
  subset j all k all i 140
  subset j all k all i 141
  subset j all k all i 142
  subset j all k all i 143
  subset j all k all i 144
  subset j all k all i 145
  subset j all k all i 146
  subset j all k all i 147
  subset j all k all i 148
  subset j all k all i 149
  subset j all k all i 150
  subset j all k all i 151
  subset j all k all i 152
  subset j all k all i 153
  subset j all k all i 154
  subset j all k all i 155
  subset j all k all i 156
  subset j all k all i 157
  subset j all k all i 158
  subset j all k all i 159
  subset j all k all i 160
  subset j all k all i 161
  subset j all k all i 162
  subset j all k all i 163
  subset j all k all i 164
  subset j all k all i 165
  subset j all k all i 166
  subset j all k all i 167
  subset j all k all i 168
  subset j all k all i 169
  subset j all k all i 170
  subset j all k all i 171
  subset j all k all i 172
  subset j all k all i 173
  subset j all k all i 174
  subset j all k all i 175
  subset j all k all i 176
  subset j all k all i 177
  subset j all k all i 178
  subset j all k all i 179
  subset j all k all i 180
  subset j all k all i 181
  subset j all k all i 182
  subset j all k all i 183
  subset j all k all i 184
  subset j all k all i 185
  subset j all k all i 186
  subset j all k all i 187
  subset j all k all i 188
  subset j all k all i 189
  subset j all k all i 190
  subset j all k all i 191
  subset j all k all i 192
  subset j all k all i 193
  subset j all k all i 194
  subset j all k all i 195
  subset j all k all i 196
  subset j all k all i 197
  subset j all k all i 198
  subset j all k all i 199
  subset j all k all i 200
  subset j all k all i 201
  subset j all k all i 202
  subset j all k all i 203
  subset j all k all i 204
  subset j all k all i 205
  subset j all k all i 206
  subset j all k all i 207
  subset j all k all i 208
  subset j all k all i 209
  subset j all k all i 210
  subset j all k all i 211
  subset j all k all i 212
  subset j all k all i 213
  subset j all k all i 214
  subset j all k all i 215
  subset j all k all i 216
  subset j all k all i 217
  subset j all k all i 218
  subset j all k all i 219
  subset j all k all i 220
  subset j all k all i 221
  subset j all k all i 222
  subset j all k all i 223
  subset j all k all i 224
  subset j all k all i 225
  subset j all k all i 226
  subset j all k all i 227
  subset j all k all i 228
  subset j all k all i 229
  subset j all k all i 230
  subset j all k all i 231
  subset j all k all i 232
  subset j all k all i 233
  subset j all k all i 234
  subset j all k all i 235
  subset j all k all i 236
  subset j all k all i 237
  subset j all k all i 238
  subset j all k all i 239
  subset j all k all i 240
  subset j all k all i 241
integrate massflux output Seiner-massflux.out axisymmetric
clear all

end
" > Seiner.massflow.com

cfpost_prod.exe < Seiner.massflow.com

########################################
#  Clean up nozzle massflow data
########################################
grep -e ' Mass flow' -e ' I=' Seiner-flux.out > Seiner-flux.out2

grep -e 'x   ' -e 'M   ' -e 'u   ' -e 'v   ' -e 'w   ' -e 'p   ' -e 'p0   ' Seiner-massflux.out > Seiner-massflux.out2
grep -v -e 'Area' Seiner-massflux.out2 > Seiner-massflux.out3

########################################
#  This Fortran code sorts the nozzle massflow data
########################################
echo "
c234567890123456789012345678901234567890123456789012345678901234567890
c
      Real gfactor,wfactor,R,gamma,areaRef,
     &     x(1000),M(1000),u(1000),v(1000),w(1000),p(1000),p0(1000),
     &     xarea(1000),Marea(1000),uarea(1000),varea(1000),
     &     warea(1000),parea(1000),p0area(1000),
     &     area(1000),mdot(1000),area2(1000),mdot2(1000)
      Integer i,imax
      Character*3 dummy
c
      imax=241
      gfactor=32.17
      wfactor=1.0
      R=1716.0
      gamma=1.4
      areaRef=144.0
c
11    FORMAT(E15.8,T20,E15.8,T40,E15.8,T60,E15.8,T80,E15.8,
     &       T100,E15.8,T120,E15.8,T140,E15.8,T160,E15.8,T180,E15.8,
     &       T200,E15.8,T220,E15.8,T240,E15.8,T260,E15.8,T280,E15.8,
     &       T300,E15.8,T320,E15.8)
c
      open(unit=21,file='Seiner-flux.out2',form='formatted')
      do i=1,imax
        read(21,'(T16,E14.6E3)') area(i)
	read(21,'(T17,E13.5E3)') mdot(i)
	area2(i)=area(i)/areaRef
	mdot2(i)=(mdot(i)/gfactor)/wfactor
      enddo
      close(21)
c      
      open(unit=22,file='Seiner-massflux.out3',form='formatted')
      do i=1,imax
        read(22,'(T1,A3,T9,E12.4E3,T21,E12.4E3)') dummy,xarea(i),x(i)
        read(22,'(T1,A3,T9,E12.4E3,T21,E12.4E3)') dummy,Marea(i),M(i)
        read(22,'(T1,A3,T9,E12.4E3,T21,E12.4E3)') dummy,uarea(i),u(i)
        read(22,'(T1,A3,T9,E12.4E3,T21,E12.4E3)') dummy,varea(i),v(i)
        read(22,'(T1,A3,T9,E12.4E3,T21,E12.4E3)') dummy,warea(i),w(i)
        read(22,'(T1,A3,T9,E12.4E3,T21,E12.4E3)') dummy,parea(i),p(i)
        read(22,'(T1,A3,T9,E12.4E3,T21,E12.4E3)') dummy,p0area(i),p0(i)
      enddo
      close(22)
c
      open(unit=31,file='Seiner-massflux.dat',form='formatted')
      write(31,'(A,A)') 'TITLE     = "\Seiner Nozzle ',
     &                  'Integrated Quantities\\"'
      write(31,'(A)') 'VARIABLES = \"x [in]\"'
      write(31,'(A)') '\"y [in]\"'
      write(31,'(A)') '\"mdot [slug/s]\"'
      write(31,'(A)') '\"area [ft^2]\"'
      write(31,'(A)') '\"Mach\"'
      write(31,'(A)') '\"u [ft/s]\"'
      write(31,'(A)') '\"v [ft/s]\"'
      write(31,'(A)') '\"w [ft/s]\"'
      write(31,'(A)') '\"p [psi]\"'
      write(31,'(A)') '\"p0 [psi]\"'
      write(31,'(A)') '\"x(area) [in]\"'
      write(31,'(A)') '\"Mach(area)\"'
      write(31,'(A)') '\"u(area) [ft/s]\"'
      write(31,'(A)') '\"v(area) [ft/s]\"'
      write(31,'(A)') '\"w(area) [ft/s]\"'
      write(31,'(A)') '\"p(area) [psi]\"'
      write(31,'(A)') '\"p0(area) [psi]\"'
      write(31,'(A)') ''
c
      write(31,'(A,I3,A)') 'ZONE T=\"Seiner Nozzle\", I=',imax,
     &                     ', J=1, F=Point'
      do i=1,imax
        write(31,11) x(i),0.0,mdot2(i),area2(i),M(i),u(i),v(i),w(i),
     &               p(i),p0(i),xarea(i),Marea(i),uarea(i),varea(i),
     &               warea(i),parea(i),p0area(i)
      enddo
      close(31)
c
      end
" > massflow.f

$FC -o massflow.exe massflow.f
./massflow.exe

########################################
#  Create and run CFPOST script to write out flowfield
########################################
echo "
grid Seiner.cgd
solution Seiner.cfl

zone 1 thru last
plot3d x Seiner.x 3d mgrid unformatted
variable u;v;M;k;mut muinf
plot3d q Seiner.q 3d mgrid unformatted

clear all
zone 1
 subset i all j 1 k 1
zone 3
 subset i all j 1 k 1
variable x;y;z;u;v;V;M;rho;p;T;rho0;p0;T0;k;mut muinf
list lines 1000 output Seiner-centerline.out raw
" > Seiner.pp.com

cfpost_prod.exe < Seiner.pp.com

########################################
#  Clean up flowfield data
########################################
grep -v -e 'Subset' -e '----' -e 'ft' Seiner-centerline.out > Seiner-centerline.out2

########################################
#  This Fortran code sorts the flowfield data
########################################
echo "
c234567890123456789012345678901234567890123456789012345678901234567890
c
      Real x(1000),y(1000),z(1000),u(1000),v(1000),Vs(1000),M(1000),
     &     rho(1000),p(1000),T(1000),rho0(1000),p0(1000),T0(1000),
     &     k(1000),mut(1000)
      Integer i,imax1,imax2
      Character*43 charline1
      Character*26 charline4
      Character*9 charline5
c
11    FORMAT(E15.8,T20,E15.8,T40,E15.8,T60,E15.8,T80,E15.8,T100,
     &       E15.8,T120,E15.8,T140,E15.8,T160,E15.8,T180,E15.8,T200,
     &       E15.8,T220,E15.8,T240,E15.8,T260,E15.8,T280,E15.8)
c
      imax1=241
      imax2=201
c
      open(unit=21,file='Seiner-centerline.out2',form='formatted')
      do i=1,imax1
        read(21,*) x(i),y(i),z(i),u(i),v(i),Vs(i),M(i),
     &             rho(i),p(i),T(i),rho0(i),p0(i),T0(i),
     &             k(i),mut(i)
      enddo
      do i=1,imax2
        read(21,*) x(i+imax1),y(i+imax1),z(i+imax1),u(i+imax1),
     &             v(i+imax1),Vs(i+imax1),M(i+imax1),
     &             rho(i+imax1),p(i+imax1),T(i+imax1),
     &             rho0(i+imax1),p0(i+imax1),T0(i+imax1),
     &             k(i+imax1),mut(i+imax1)
      enddo
      close(21)
c
      open(unit=31,file='Seiner-centerline.dat',form='formatted')
      charline1 = 'TITLE     = \"Seiner Nozzle Centerline Data\"'
      write(31,'(A)') charline1
      write(31,'(A)') 'VARIABLES = \"x [ft]\"'
      write(31,'(A)') '\"y [ft]\"'
      write(31,'(A)') '\"z [ft]\"'
      write(31,'(A)') '\"u [ft/s]\"'
      write(31,'(A)') '\"v [ft/s]\"'
      write(31,'(A)') '\"Vmag [ft/s]\"'
      write(31,'(A)') '\"Mach\"'
      write(31,'(A)') '\"rho [slug/ft^3]\"'
      write(31,'(A)') '\"p [psi]\"'
      write(31,'(A)') '\"T [deg R]\"'
      write(31,'(A)') '\"rho0 [slug/ft^3]\"'
      write(31,'(A)') '\"p0 [psi]\"'
      write(31,'(A)') '\"T0 [deg R]\"'
      write(31,'(A)') '\"k [ft^2/s^2]\"'
      write(31,'(A)') '\"mut/muinf\"'
      write(31,'(A)') ' '
c
      charline4 = 'ZONE T=\"Str-Str_SSTcc\", I='
      charline5 = ', F=POINT'
      write(31,'(A,I3,A)') charline4,(imax1+imax2),charline5
c
      do i=1,(imax1+imax2)
        write(31,11) x(i),y(i),z(i),u(i),v(i),Vs(i),M(i),
     &               rho(i),p(i),T(i),rho0(i),p0(i),T0(i),
     &               k(i),mut(i)
      enddo
c
      end
" > SeinerTecplot.f

$FC -o SeinerTecplot.exe SeinerTecplot.f
SeinerTecplot.exe

########################################
#  Extract max N-S residuals from LIS file (assumes single zone)
########################################
for ((nzone=1; nzone<=$nzonemax; nzone++))
do
    grep -a RES Seiner.lis | awk '{ print $3 "    " $4 "    " $9 "    " $10 }' | grep "   $nzone   " > Seiner.NSresid-$nzone.out
    grep -a RES Seiner.lis | awk '{ print $3 "    " $4 } ' | grep "   $nzone" | awk '{ c += length + 1 } END { print NR }' > Seiner.imax-$nzone.out
done

########################################
#  This Fortran code formats the N-S residuals data
########################################
echo $nzonemax > kmax.txt
echo "
c234567890123456789012345678901234567890123456789012345678901234567890
c This code formats N-S residuals data
c
      Real big(100000,8),l2(100000,8)
      Integer i,iter(100000,8),zone(100000,8),imax,k,kmax
      Character*34 charline1
      Character*24 charline2
      Character*42 charline3
      Character*11  charline4
      Character*9  charline5
      Character*12 charline6
      Character*4  charline7
      Character*17 charline8
      Character*15 charline9
      Character*20 charline10
      Character*4  charline11
c
11    FORMAT(I10,T20,E15.8,T40,E15.8)
c
      open(unit=40,file='kmax.txt',form='formatted')
      read(40,*) kmax
      close(40)
c      
      do k=1,kmax
        charline6='Seiner.imax-'
	charline7='.out'
	open(unit=41,file='dummy1',form='formatted')
	write(41,'(A12,I1,A4)') charline6,k,charline7
	rewind(41)
	read(41,'(A17)') charline8
	close(41)
	open(unit=20,file=charline8,form='formatted')
        read(20,*) imax
        close(20)
c
        charline9='Seiner.NSresid-'
	open(unit=42,file='dummy2',form='formatted')
	write(42,'(A15,I1,A4)') charline9,k,charline7
	rewind(42)
	read(42,'(A20)') charline10
	close(42)
	open(unit=21,file=charline10,form='formatted')
        do i=1,imax
          read(21,*) iter(i,k),zone(i,k),big(i,k),l2(i,k)
        enddo
        close(21)
      enddo
c
      open(unit=31,file='Seiner.NSresid.dat',form='formatted')
      charline1 = 'TITLE     = \"Seiner Jet, Mach 2.0:'
      charline2 = 'Navier-Stokes Residuals\"'
      write(31,'(A,A)') charline1,charline2
      write(31,'(A)') 'VARIABLES = \"iteration\"'
      write(31,'(A)') '\"N-S residual\"'
      write(31,'(A)') '\"L2 residual\"'
      write(31,'(A)') ''
c
      charline3 = 'ZONE T=\"Structured Grid, Structured Solver,'
      charline4 = ' SSTcc\", I='
      charline11= ', J='
      charline5 = ', F=POINT'
      write(31,'(A,A,I7,A,I2,A)') charline3,charline4,imax,charline11
     &                            ,kmax,charline5
c
      do k=1,kmax
        do i=1,imax
          write(31,11) iter(i,k),big(i,k),l2(i,k)
        enddo
      enddo
c
      close(31)
c
      end
" > NSresid.f

$FC -o NSresid.exe NSresid.f
./NSresid.exe

########################################
#  Clean up intermediate output files
########################################
rm -f Seiner-flux.out* Seiner-massflux.out*
rm -f Seiner-centerline.out* FOR021
rm -f Seiner.NSresid*.out Seiner.imax*.out
rm -f *.jou *.f *.exe
rm -f dummy* kmax.txt
