#! /bin/sh 
#
   
# save_cfl - Save intermediate .cfl files.  This script is intended
   #            to be spawned during a run using the SPAWN keyword, as
   #
   #               SPAWN "path-to-script path-to-cfl" FREQUENCY num
   #
   #            where 'path-to-script' is the full path name for this
   #            script, 'path-to-cfl' is the full path name for the saved
   #            .cfl files (the current cycle number will automatically
   #            be appended to this name), and 'num' is the frequency for
   #            the SPAWN command.  Note that the quote marks around
   #            "path-to-script path-to-cfl" must be included.
# Check for enough arguments
   
if [ $# -lt 2 ] ; then
   echo 'Error: save_cfl: Path name for saved .cfl files not specified' >& 2
   echo '       Use WIND''s SPAWN keyword, as:' >& 2
   echo '       SPAWN "save_cfl.sh casename" FREQUENCY num' >& 2
   exit 1
fi
   
# $1 is path name for the saved .cfl files, $2 is current cycle number
   
cp FOR020 ${1}${2}.cfl
cp FOR020 temp.cfl
cfpost < cfpost.p3d.scr.com > cfpost.out 
cp cyl_lam.q ${1}${2}.q
/bin/rm -rf cyl_lam.q
/bin/rm -rf temp.cfl
