#!/bin/bash

########################################
#  Enter Fortran compiler here
########################################
FC=ifort

########################################
#  Create and run CFPOST script
########################################
echo "
grid FP4p5.cgd
solution FP4p5.cfl

clear all
zone 1
subset i 40 j all
variable x; y; u; v; rho; p; T; mu; mut muinf
list lines 120 output FP4p5.BL.out raw

clear all
zone 1
subset i all j 1
variable x; Cfx; delta; THETA; delta*
list lines 120 output FP4p5.Cf.out raw
" > FP4p5.cfpost.com

cfpost_prod.exe < FP4p5.cfpost.com

########################################
#  This Fortran code sorts the Cf data
########################################
echo "
c234567890123456789012345678901234567890123456789012345678901234567890
c
      Real x(1000),Cf(1000),Rex(1000),
     &     delta(1000),theta(1000),deltastar(1000),
     &     Uinf,nuinf
      Integer i,imax
      Character*45 charline1
      Character*43 charline2
      Character*42 charline3
      Character*14 charline4
      Character*9 charline5
c
11    FORMAT(E15.8,T20,E15.8,T40,E15.8,T60,E15.8,T80,E15.8,
     &       T100,E15.8)
c
c      imax=141
c      imax=31
      imax=46
      Uinf=2307.38
      nuinf=(0.814118E-07)/(0.751033E-04)
c
      open(unit=21,file='FP4p5.Cf.out',form='formatted')
c
      open(unit=31,file='FP4p5.Cf.dat',form='formatted')
      charline1 = 'TITLE     = \"Mach 4.5 Flow Over a Flat Plate:'
      charline2 = 'Skin Friction and Integrated BL Quantities\"'
      write(31,'(A,A)') charline1,charline2
      write(31,'(A)') 'VARIABLES = \"x [ft]\"'
      write(31,'(A)') '\"Rex\"'
      write(31,'(A)') '\"Cfx>\"'
      write(31,'(A)') '\"delta [ft]\"'
      write(31,'(A)') '\"theta [ft]\"'
      write(31,'(A)') '\"delta* [ft]\"'
      write(31,'(A)') ''
      charline3 = 'ZONE T=\"Structured Grid, Structured Solver,'
      charline4 = ' SST w/cc\", I='
      charline5 = ', F=POINT'
      write(31,'(A,A,I4,A)') charline3,charline4,(imax+0),charline5
c
      do i=1,3
        read(21,*)
      enddo
      do i=1,imax
        read(21,*) x(i),Cf(i),delta(i),theta(i),deltastar(i)
	Rex(i)=x(i)*Uinf/nuinf
      enddo
      close(21)
c
      do i=1,imax
	write(31,11) x(i),Rex(i),Cf(i),delta(i),theta(i),deltastar(i)
      enddo
      close(23)
c
      end
" > Cfsort.f

$FC -o Cfsort.exe Cfsort.f
./Cfsort.exe

########################################
#  This Fortran code sorts the BL data
########################################
echo "
c234567890123456789012345678901234567890123456789012345678901234567890
c This code compiles consolidates genplot files.
c
      Real x(1000),y(1000),u(1000),v(1000),rho(1000),p(1000),T(1000),
     &     mu(1000),mut(1000)
      Integer i,imax
      Character*45 charline1
      Character*42 charline2
      Character*42 charline3
      Character*14 charline4
      Character*9 charline5
c
11    FORMAT(E15.8,T20,E15.8,T40,E15.8,T60,E15.8,T80,E15.8,
     &       T100,E15.8,T120,E15.8,T140,E15.8,T160,E15.8)
c
      imax=81
c
      open(unit=21,file='FP4p5.BL.out',form='formatted')
      do i=1,3
        read(21,*)
      enddo
      do i=1,imax
        read(21,*) x(i),y(i),u(i),v(i),rho(i),p(i),T(i),mu(i),mut(i)
      enddo
      close(21)
c
      open(unit=31,file='FP4p5.BL.dat',form='formatted')
      charline1 = 'TITLE     = \"Mach 4.5 Flow Over a Flat Plate:'
      charline2 = 'Boundary Layer Profile at Rex=3.8 million\"'
      write(31,'(A,A)') charline1,charline2
      write(31,'(A)') 'VARIABLES = \"x [ft]\"'
      write(31,'(A)') '\"y [ft]\"'
      write(31,'(A)') '\"u [ft/s]\"'
      write(31,'(A)') '\"v [ft/s]\"'
      write(31,'(A)') '\"rho [slug/ft^3]\"'
      write(31,'(A)') '\"p [psi]\"'
      write(31,'(A)') '\"T [deg R]\"'
      write(31,'(A)') '\"mu [slug/(ft*s)]\"'
      write(31,'(A)') '\"mut/muinf\"'
      write(31,'(A)') ''
c
      charline3 = 'ZONE T=\"Structured Grid, Structured Solver,'
      charline4 = ' SST w/cc\", I='
      charline5 = ', F=POINT'
      write(31,'(A,A,I3,A)') charline3,charline4,imax,charline5
c
      do i=1,imax
        write(31,11) x(i),y(i),u(i),v(i),rho(i),p(i),T(i),mu(i),mut(i)
      enddo
c
      close(31)
c
      end
" > BLsort.f

$FC -o BLsort.exe BLsort.f
./BLsort.exe

########################################
#  Extract max N-S residuals from LIS file (assumes single zone)
########################################
grep -a RES FP4p5.lis | awk '{ print $2 "    " $9 "    " $10 }'  > FP4p5.NSresid.out
grep -a RES FP4p5.lis | awk '{ print $2 } ' | awk '{ c += length + 1 } END { print NR }' > FP4p5.imax.out

########################################
#  This Fortran code formats the N-S residuals data
########################################
echo "
c234567890123456789012345678901234567890123456789012345678901234567890
c This code formats N-S residuals data
c
      Real big(100000),l2(100000)
      Integer i,iter(100000),imax
      Character*45 charline1
      Character*24 charline2
      Character*42 charline3
      Character*14 charline4
      Character*9 charline5
c
11    FORMAT(I10,T20,E15.8,T40,E15.8)
c
      open(unit=20,file='FP4p5.imax.out',form='formatted')
      read(20,*) imax
      close(20)
c
      open(unit=21,file='FP4p5.NSresid.out',form='formatted')
      do i=1,imax
        read(21,*) iter(i),big(i),l2(i)
      enddo
      close(21)
c
      open(unit=31,file='FP4p5.NSresid.dat',form='formatted')
      charline1 = 'TITLE     = \"Mach 4.5 Flow Over a Flat Plate:'
      charline2 = 'Navier-Stokes Residuals\"'
      write(31,'(A,A)') charline1,charline2
      write(31,'(A)') 'VARIABLES = \"iteration\"'
      write(31,'(A)') '\"N-S residual\"'
      write(31,'(A)') '\"L2 residual\"'
      write(31,'(A)') ''
c
      charline3 = 'ZONE T=\"Structured Grid, Structured Solver,'
      charline4 = ' SST w/cc\", I='
      charline5 = ', F=POINT'
      write(31,'(A,A,I7,A)') charline3,charline4,imax,charline5
c
      do i=1,imax
        write(31,11) iter(i),big(i),l2(i)
      enddo
c
      close(31)
c
      end
" > NSresid.f

$FC -o NSresid.exe NSresid.f
./NSresid.exe

########################################
#  Clean up intermediate output files
########################################
rm -f FP4p5.BL*.out*
rm -f FP4p5.Cf.out*
rm -f FP4p5.delta.out
rm -f FP4p5.NSresid.out FP4p5.imax.out
rm -f *.jou *.f *.exe
