/*
                             HitModeler
                      Weather Effects  Version 
   
                           A Java Applet
                  to study the flight of hit baseball
                     Derived from RocketModeler II

                        Version 1.0c  - 15 Mar 07

                         Written by Tom Benson
                       NASA Glenn Research Center

>                              NOTICE
>This software is in the Public Domain.  It may be freely copied and used in
>non-commercial products, assuming proper credit to the author is given.  IT
>MAY NOT BE RESOLD.  If you want to use the software for commercial
>products, contact the author.
>No copyright is claimed in the United States under Title 17, U. S. Code.
>This software is provided "as is" without any warranty of any kind, either
>express, implied, or statutory, including, but not limited to, any warranty
>that the software will conform to specifications, any implied warranties of
>merchantability, fitness for a particular purpose, and freedom from
>infringement, and any warranty that the documentation will conform to the
>program, or any warranty that the software will be error free.
>In no event shall NASA be liable for any damages, including, but not
>limited to direct, indirect, special or consequential damages, arising out
>of, resulting from, or in any way connected with this software, whether or
>not based on warranty, contract, tort or otherwise, whether or not injury
>was sustained by persons or property or otherwise, and whether or not loss
>was sustained from, or arose out of the results of, or use of, the software
>or services provided hereunder.
 
  New test -
               
                only graphics input and output                


                                           TJB  15 Mar 07

*/

import java.awt.*;
import java.lang.Math ;

public class WHit extends java.applet.Applet {
 
   static double convdr = 3.1415926/180. ;
   static double pid2 = 3.1415926/2.0 ;
   static double pi = 3.1415926 ;
   static double zero = 0.0 ;
   static double wtzero = 0.00001 ;
 
   int rktype,ntype,part,rtype,fintype,numfin,lunits,planet,wthopt,place ;
   int nstage,numeng,nclust,btfair,balob ;
   int istab,ifuel,ides,irange ;
   int conflag,windopt,humopt,dragopt,tempopt,presopt ;
            // body geometry
   static double blngth,blngd,blmax,blmin,bdiam,bdiamd,bdmax,bdmin,brad ;
            // tail fairing geometry
   static double tlngth,tlngd,tlmax,tlmin,tdiam,tdiamd,tdmax,tdmin,trad ;
            // bottle tail fairing
   static double btlngth,btlngd,btlmax,btlmin;
   static double btdiam,btdiamd,btdmax,btdmin,btrad;
            // payload geometry
   static double plngth,plngd,plmax,plmin,pdiam,pdiamd,pdmax,pdmin,prad ;
            // payload fairing geometry
   static double qlngth,qlngd,qlmax,qlmin ;
            // nose geometry
   static double nlngth,nlngd,nlmax,nlmin,ndiam,ndiamd,ndmax,ndmin,nrad ;
   static double nfact,nfact2 ;
            // fin geometry
   static double flngth,flngd,flmax,flmin,fwidth,fwid,fwmax,fwmin,fwex ;
   static double fleang,flemax,flemin,fteang,ftemax,ftemin ;
   static double ftanle,ftante ;
   static double floc,flocd,flcmax,flcmin ;
   static double delt,ap,thet;
   static double[][] finx = new double[3][4] ;
   static double[][] finy = new double[3][4] ;

   static double vmn1,vmn2,vmn3,vmn4,vmn5,vmx1,vmx2,vmx3,vmx4,vmx5 ;
   static double lconv1,lconv2,fconv,pconv ;
   static double aconv,dconv2,dconv3,vconv ;
               // weight and materials
   static int mbod,mtfr,mnose,mfin,mpay,mpfr,mbtfr ;
   static double wbod,wtfr,wnose,wpar,wfin,wpay,wpfr,wbtfr,weng,wfuel ;
   static double wbal,wbald,wmax,wmin ;
   static double sabod,satfr,sanose,sapay,sapfr,safin,sabtfr,satot;
   static double pabod,patfr,panose,papay,papfr,pafin,pabtfr,patot;
   static double cabod,canose,capay,catot,carec,caexit,cabexit ;
   static double vbod,vtfr,vnose,vpay,vpfr;
   static double dbod,dtfr,dnose,dfin,dpay,dpfr,dbtfr ;
   static double cgbod,cgtfr,cgnose,cgfin,cgpay,cgpfr,cgbtfr,cgeng,cgfuel ;
   static double cpbod,cptfr,cpnose,cpfin,cppay,cppfr,cpbtfr ;
               // ballistic 
   static double wtd, wtmax,wtmin,cdmin,cdmax,catd,camin,camax ;
   static double vmuzl,vmuzld,vmmax,vmmin ;
               // stomp launcher
   static double sv1,sv1d,sv1min,sv1max,sv2,sv2d,sv2min,sv2max ;
   static double sl,sld,slmin,slmax ;
   static double lpress,volrat,vstomp,presin ;
   static double lpresd,lpresmax,lpresmin ;
              // solid rocket thrust
   static double th1,th2,tim1,tim2,timd;
   static double th1b1,th2b1,tim1b1,tim2b1 ;
            // engine geometry
   static double elngth,ediam,erad,mediam,merad;
   static double b1elngth,b1ediam,b1erad;
            // booster 1 geometry
   static double b1fw,b1fwd,b1fwmax,b1fleang,b1fteang,b1ftanle,b1ftante;
   static double b1lngth,b1lngd,b1lmax,b1flngth,b1flngd;
   static double wengb1,wfuelb1,sab1,pab1,cgb1,cpb1;
   static double wfinb1,safb1,pafb1,cgfb1,cpfb1;
              // bottle rocket thrust
   static double wat,watd,watmin,watmax,fpres,fpresd,fpresmin,fpresmax ;
   static double nozdiam,nozdiamd,nozdmin,nozdmax ;
   static double nozrad,noza,hwat,watrad ;
   static double ltub,ltubd,ltubmin,ltubmax ;
   static double volair,instair,instwat,instpres,mdot,uexit,lothrust ;
               // flight
   int fire,comp,npt,nsav,nburn,cockflg,cockcal,stepon,step;
   static int[] npts = new int[5];
   static double weight,drag,thrust,wtflt ;
   static double cg,cp,cd,cdrec ;
   static double g0,q0,ps0,pt0,ts0,rho,rlhum,temf,presm,gama,wtrat,rgas ;
   static double alt,altd,altmax,altmin ;
   static double wind,windd,wndmax,wndmin ;
   static double lnchang,langmax,langmin;
   static double rail,raild,railmin,railmax ;
   static double llaunch,timrail ;
   static double deltim,fltim,vacc,vvel,vloc,hacc,hvel,grspd,hloc,spd ;
   static double vmax,hmax,spdmax ;
   static double[][] posx = new double[10][5000] ;
   static double[][] posy = new double[10][5000] ;
   static double[] posa = new double [5000] ;
   static double posb1 ;
       /*  plot & probe data */
   static double fact,facmin,facrat;
   static double facts,facto,factc;
   static int xt,yt,sldloc,viewflg,gridon,lnchgrf,trakon,ldisplay;
   static int xts,yts,slds;
   static int xto,yto,sldo;
   static int xtc,ytc,sldc;

   Solver solve ;
   View view ;
   CardLayout layin,layen1,layen2 ;
   Image offImg ;
   Graphics offsGg ;

   public void init() {
     solve = new Solver() ;

     offImg = createImage(this.size().width,
                      this.size().height) ;
     offsGg = offImg.getGraphics() ;

     setLayout(new GridLayout(1,1,5,5)) ;

     view = new View(this) ;

     add(view) ;

     solve.setDefaults () ;

     solve.comPute () ;

     view.start() ;
  }
 
  public Insets insets() {
     return new Insets(5,5,5,5) ;
  }

  public int filter0(double inumbr) {
        //  output only to .
       int number ;
       int intermed ;
 
       number = (int) (inumbr);
       return number ;
  }

  public float filter1(double inumbr) {
     //  output only to .1
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 10.) ;
       number = (float) (intermed / 10. );
       return number ;
  }
 
  public float filter2(double inumbr) {
     //  output only to .01
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 100.) ;
       number = (float) (intermed / 100. );
       return number ;
  }
 
  public float filter5(double inumbr) {
     //  output only to .00001
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 100000.) ;
       number = (float) (intermed / 100000. );
       return number ;
  }

  public void setRangeView() {   // initial range view
       viewflg = 1 ;
       facts = fact = 1.5;
       facmin = .5 ;
       facrat = .005 ;
       xts = xt = 100; 
       yts = yt = 345 ;
       slds = sldloc= 50;
  }
 
  public void restRangeView() {   // restore range view
       viewflg = 1 ;
       fact = facts ;
       facmin = .01 ;
       facrat = .02 ;
       xt = xts ; 
       yt = yts ;
       sldloc = slds ;
  }
 
  public void setGraphView() {   // initial graph view
       viewflg = 2 ;
       factc = fact = 1.25;
       facmin = .01 ;
       facrat = .02 ;
       xtc = xt = 100; 
       ytc = yt = 40 ;
       sldc = sldloc= 288;
  }
 
  public void restGraphView() {   // restore graph view
       viewflg = 2 ;
       fact = factc ;
       facmin = .01 ;
       facrat = .02 ;
       xt = xtc ; 
       yt = ytc ;
       sldloc = sldc ;
  }
 
  public void loadBallistic() {   // load Ballistic info
    // ballisitic shell
       rktype = 10 ;
       fire = 0 ;
       comp = 0 ;
       tim1 = .2 ;
       weng = 0.0;
       wfuel = 0.0 ;
       nstage = 1; 
       cg = 0.0 ;
       cp = 0.0 ;
       balob = 0 ;
       weight = 5.0 ;
       wtd = weight * fconv;
       wtmin = 0.1 * fconv ;  wtmax = 100 * fconv ;
       cd = .3 ;
       cdmin = 0.0 ;  cdmax = .5 ;
//       catot = 6.45 ;
       catot = 6.514 ;
       catd = catot * aconv ;
       camin = 0.0 ;  camax = 10.0 * aconv ;
       vmuzl = 138. ; 
       vmuzld = vmuzl * lconv1 * 60.0 / 88.0 ; 
       vmmin = 50.0 * 60.0 / 88.0 ;  vmmax = 175. * lconv1 * 60.0 / 88.0 ;
  }

  public void loadOut() {   // output routine
     String outfor,outvel,outlng,outhi ;

     outfor = " oz" ;
     if (lunits == 1) outfor = " g" ;
     outlng = " in" ;
     if (lunits == 1) outlng = " cm" ;
     outhi = " ft" ;
     if (lunits == 1) outhi = " m" ;
     outvel = " ft/s" ;
     if (lunits == 1) outvel = " m/s" ;

     return ;
  }
 
  class Solver {
 
     Solver () {
     }

     public void setDefaults() {
 
    // units
       conflag = 0 ;
       windopt = 0 ;
       humopt = 0 ;
       dragopt = 0 ;
       tempopt = 0 ;
       presopt = 0 ;
       lunits = 0 ;
       dconv2 = 1.0 ;
       dconv3 = 1.0 ;
       lconv1 = 1.0 ;
       lconv2 = 1.0 ;
       aconv = 1.0 ;
       vconv = 1.0 ;
       fconv = 1.0 ;
       pconv = 1.0 ;

       nsav = 0 ;
       wtrat = 1.0 ;

       planet = 0 ;
       wthopt = 0 ;
       place = 0;
       g0 = 32.2 ;
       altd = alt = 700.0 ;
       altmin = 0.0;  altmax = 50000. ;
       ps0 = 14.7 ;
       rgas = 1718. ;
       getFreeStream() ;

       presin = 14.7 ;
       loadBallistic() ;

       part = 3 ;
       istab = 1 ;
       ifuel = 0 ;
       ides = 0 ;
       irange = 0 ;
       stepon = 0 ;
       step = 0 ;

    // launch
       windd = wind = 0.0 ;
       wndmin = -20.0 ; wndmax = 20.0 ;
       lnchang = 45.0 ;
       langmin = 0.0 ;  langmax = 80.0 ;
       raild = rail = 3.0 ;
       railmin = 1.0; railmax = 5.0 ;
       cockflg = 0 ;

       posa[0] = pid2 ;

       fire = 0 ;
       comp = 0 ;
       vacc = 0.0 ; vvel = 0.0 ; vloc = 0.0 ;
       hacc = 0.0 ; hvel = 0.0 ; grspd = 0.0; hloc = 0.0 ;
       vmax = 0.0 ; hmax = 0.0 ; 
       spd = 0.0 ; spdmax = 0.0 ;

         // graphics
       setGraphView() ;
       gridon = 1 ;
       trakon = 0 ;
       setRangeView() ;

       ldisplay = 2 ;
       cd = 0.3 ;
       cdmin = 0.0 ;  cdmax = 0.5;
       weight = 5.0 ;
       wtd  = weight * fconv ;
//       catot = 6.45 ;
       catot = 6.514 ;
       catd = catot * aconv ;
       istab = 1;
//       loadInput() ;
       return ;
     }

     public void getFreeStream() {    //  free stream conditions
     double hite,pvap ;       /* MODS  19 Jan 00  whole routine*/

       g0 = 32.2 ;
       rgas = 1718. ;                /* ft2/sec2 R */
       gama = 1.4 ;
       hite = alt ;
       wtrat = 1.0 ;
       if (planet <= 1) {    // Earth  standard day
          if (conflag == 0) {
             // Earth  standard day
             if (hite <= 36152.) {           // Troposphere
                ts0 = 518.6 - 3.56 * hite/1000. ;
                ps0 = 2116. * Math.pow(ts0/518.6,5.256) ;
             }
             if (hite >= 36152. && hite <= 82345.) {   // Stratosphere
                ts0 = 389.98 ;
                ps0 = 2116. * .2236 *
                     Math.exp((36000.-hite)/(53.35*389.98)) ;
             }
             if (place == 0) {
                    ps0 = 2116. ;
                if (windopt == 0) wind = 0.0 ;
                if (windopt == 1) wind = 5.0 * 88.0 / 60.0 ;
                if (windopt == 2) wind = -5.0 * 88.0 / 60.0 ;
                if (humopt == 0) rlhum = 0.3 ;
                if (humopt == 1) rlhum = 1.0 ;
                if (humopt == 2) rlhum = 0.0 ;
                if (dragopt == 0) cd = 0.3 ;
                if (dragopt == 1) cd = 0.0 ;
                if (tempopt == 0) ts0 = 519.6;
                if (tempopt == 1) ts0 = 549.6;
                if (tempopt == 2) ts0 = 494.6;
                if (presopt == 0) ps0 = 2116.;
                if (presopt == 1) ps0 = 2186.;
                if (presopt == 2) ps0 = 2045.;
             }
             temf = ts0 - 459.6 ;
             if (temf <= 0.0) temf = 0.0;
             presm = ps0 * 29.92 / 2116. ;
          }
          if (conflag == 1) {
             ts0 = temf + 459.6 ;
             if (temf < 0.0) {
                  temf = 0.0 ;
                  rlhum = 0.0 ;
             }
             ps0 = presm * 2116. / 29.92 ;
          }
          pvap = rlhum*(2.685+.00353*Math.pow(temf,2.245));/* Eq 1:6A  Domasch */
          rho = (ps0 - .379*pvap)/(rgas * ts0) ;  /* effect of humidty */
       }
       if (planet == 3) {   // Mars - curve fit of orbiter data
         rgas = 1149. ;                /* ft2/sec2 R */
         gama = 1.29 ;
         wtrat = .38 ;

         if (hite <= 22960.) {
            ts0 = 434.02 - .548 * hite/1000. ;
            ps0 = 14.62 * Math.pow(2.71828,-.00003 * hite) ;
         }
         if (hite > 22960.) {
            ts0 = 449.36 - 1.217 * hite/1000. ;
            ps0 = 14.62 * Math.pow(2.71828,-.00003 * hite) ;
         }
         rlhum = 0.0 ;
         temf = ts0 - 459.6 ;
         presm = ps0 * 29.92 / 2116. ;
         rho = ps0/(rgas * ts0) ;
       }

       if (planet == 1) rho = 0.0 ;   // Earth no drag
       ps0 = ps0 / 144. ;   // psi

       if (planet == 2) {     // Moon
          wtrat = .1667 ;
          gama = 1.4 ;
          ps0 = 0.0 ;
          rho = 0.0 ;
          rlhum = 0.0 ;
          temf = -250. ;
          presm = 0.0 ;
       }
       fpresmin = ps0 * pconv ;
       lpresmin = ps0 * pconv ;

//       loadInput() ;

       return ;
     }

     public void comPute() {
 
       loadOut() ;

       return ;
     }
  }

  class View extends Canvas  
         implements Runnable{
     WHit outerparent ;
     Thread runner ;
     Point locate,anchor;
   
     View (WHit target) {
         setBackground(Color.white) ;
         runner = null ;
     } 

     public Insets insets() {
        return new Insets(0,5,0,5) ;
     }
 
     public boolean mouseDown(Event evt, int x, int y) {
        anchor = new Point(x,y) ;
        return true;
     }

     public boolean mouseUp(Event evt, int x, int y) {
        handleb(x,y) ;
        return true;
     }

     public boolean mouseDrag(Event evt, int x, int y) {
        handle(x,y) ;
        return true;
     }

     public void handle(int x, int y) {  // slider widgets
       // determine location
       if (y >= 20 && y <= 375) {
         if (x <= 35 ) {   // zoom widget
           if (y >= 45 && y <= 250) {
             sldloc = y ;
             if (sldloc < 50) sldloc = 50;
             if (sldloc > 250) sldloc = 250;
             fact = facmin + (250 - sldloc) * facrat;
             if (viewflg == 0) {
               if (fact < 5.0) fact = 5.0 ;
             }
           }
         }
/*
         if (x >= 36 ) {   // translate
           locate = new Point(x,y) ;
           yt =  yt + (int) (.2*(locate.y - anchor.y)) ;
           xt =  xt + (int) (.4*(locate.x - anchor.x))  ;
           if (xt > 50000) xt = 50000 ;
           if (xt < -50000) xt = -50000 ;
           if (yt > 50000) yt = 50000 ;
           if (yt <-50000) yt = -50000 ;
         }
*/
       }
       if (viewflg == 2) {
         factc = fact ;
         xtc = xt ;
         ytc = yt ;
         sldc = sldloc ;
       }
       if (viewflg == 1) {
         facts = fact ;
         xts = xt ;
         yts = yt ;
         slds = sldloc ;
       }
       if (viewflg == 0) {
         facto = fact ;
         xto = xt ;
         yto = yt ;
         sldo = sldloc ;
       }
     }

     public void handleb(int x, int y) { // view buttons
       double angle ;
       float fl3 ;
       int i,j,i3 ;

       if (viewflg == 1) {
          if (y <= 30) { 
             if (x >= 240 && x <= 400) { // swing
                trakon = 0 ;
                facts = fact = 1.5;
                xts = xt = 100; 
                yts = yt = 345 ;
                ifuel = 1;
                irange = 1 ;
                ides = 1 ;
                istab = 1 ;
                weight = wtd / fconv ;
                fire = 1 ;
                comp = 1 ;
                cockcal = 0 ;
                fltim = -1.0 ;
                drag = 0.0 ;
                timrail = 0.0 ;
                spd = vmuzl ;
                llaunch = 0.0 ;
                drag = (16.0 * cd * .5 * rho * catot * spd * spd / 144.) ; 
                angle = (90.0 - lnchang) * convdr ;
                vacc = (-drag*Math.sin(angle)-(weight*wtrat))/(weight/g0) ;
                hacc = (-drag*Math.cos(angle)) / (weight/g0)  ;
                cockflg = 0 ;
                vvel = spd * Math.cos(convdr*lnchang) ;
                hvel = spd * Math.sin(convdr*lnchang) ;
                grspd = hvel + wind ;
                vloc = 0.0 ;
                hloc = 0.0 ;
                hmax = 0.0 ;
                vmax = 0.0 ;
                spdmax = 0.0 ;
                npt = 0 ;
             }
             if (x >= 40 && x <= 130) { // save
                trakon = 0 ;
                facts = fact = 1.5;
                xts = xt = 100; 
                yts = yt = 345 ;
                 fire = 0 ;
                 comp = 0 ;
                 npts[nsav] = npt ;
                 nsav = nsav + 1 ;
                 if (nsav == 5) nsav = 4 ;
                 for (i=0; i<=npts[nsav]; ++i){
                     posx[nsav][i] = 0.0 ;  
                     posy[nsav][i] = 0.0 ;  
                     posa[i] = pid2 ;
                     posb1 = 0.0 ;
                  }
                  npts[nsav] = 0 ;
             }
             if (x >= 120 && x <= 210) { // clear
                trakon = 0 ;
                facts = fact = 1.5;
                xts = xt = 100; 
                yts = yt = 345 ;
                fire = 0 ;
                comp = 0 ;
                nsav = 0 ;
                for (j=0; j<=4; ++j) {
                  for (i=0; i<=npts[j]; ++i){
                     posx[j][i] = 0.0 ;  
                     posy[j][i] = 0.0 ;  
                     posa[i] = pid2 ;
                     posb1 = 0.0 ;
                  }
                  npts[j] = 0 ;
                }
             }
          }
          if (y >= 440 && y <= 460) { 
             if (x >= 90 && x <= 220) { // high pressure
                presopt = 1 ;
             }
             if (x >= 300 && x <= 420) { // hot day
                tempopt = 1 ;
             }
             if (x >= 500 && x <= 620) { // humid day
                humopt = 1 ;
             }
             if (x >= 780 && x <= 870) { // no drag
                dragopt = 1 ;
             }
             if (x >= 680 && x <= 770) { // wind at back
                windopt = 1 ;
             }
             solve.getFreeStream() ;
          }
          if (y >= 470 && y <= 490) {  // middle buttons
             if (x >= 90 && x <= 220) { // avergae day
                presopt = 0 ;
             }
             if (x >= 300 && x <= 420) { // average day
                tempopt = 0 ;
             }
             if (x >= 500 && x <= 620) { // low humidity
                humopt = 0 ;
             }
             if (x >= 780 && x <= 870) { // drag
                dragopt = 0 ;
             }
             if (x >= 680 && x <= 770) { //  no wind 
                windopt = 0 ;
             }
             solve.getFreeStream() ;
          }
          if (y >= 500 && y <= 520) {  // lower buttons
             if (x >= 90 && x <= 220) { // low pressure
                presopt = 2 ;
             }
             if (x >= 300 && x <= 420) { // cold day
                tempopt = 2 ;
             }
             if (x >= 500 && x <= 620) { // no humidity
                humopt = 2 ;
             }
             if (x >= 680 && x <= 770) { // wind in face
                windopt = 2 ;
             }
             solve.getFreeStream() ;
          }
       }
/*
       if (x <= 30) { 
          if (y >=31 && y <= 45) {  // grid switch
             gridon = -gridon ;
          }
       }
 
       if (y > 415) {
          if (x >= 100 && x <= 150) { // pad switch 
             if (viewflg == 0) setDesignView() ;
             if (viewflg == 1) setRangeView() ;
             if (viewflg == 2) setGraphView() ;
          }
          if (x >= 200 && x <= 250) { // trak switch  
             trakon = -trakon ;
          }
       }

       if (y < 25) {
          if (viewflg == 0 && lnchgrf == 0) {
             if (x >=35 && x <= 95) {  // nose design
               part = 1 ;
               layin.show(act.inp, "nos")  ;
               act.inp.nose.lt.butgo.setBackground(Color.white) ;
               act.inp.nose.lt.butgo.setForeground(Color.blue) ;
             }
             if (x >=100 && x <= 160) {  // payload design
               part = 2 ;
               layin.show(act.inp, "pay")  ;
               act.inp.payl.lt.butgo.setBackground(Color.white) ;
               act.inp.payl.lt.butgo.setForeground(Color.blue) ;
             }
             if (x >=165 && x <= 225) {  // body design
               part = 3 ;
               if (rktype < 2 || rktype > 2){
                  layin.show(act.inp, "bod")  ;
                  act.inp.body.lt.butgo.setBackground(Color.white) ;
                  act.inp.body.lt.butgo.setForeground(Color.blue) ;
               }
               if (rktype == 2){
                  layin.show(act.inp, "bot")  ;
                  act.inp.boti.lt.butgo.setBackground(Color.white) ;
                  act.inp.boti.lt.butgo.setForeground(Color.blue) ;
               }
             }
             if (x >=230 && x <= 295) {  // fins design
               part = 4 ;
               layin.show(act.inp, "fin")  ;
               act.inp.fins.lt.butgo.setBackground(Color.white) ;
               act.inp.fins.lt.butgo.setForeground(Color.blue) ;
             }
             ides = 0 ;
             act.con.btm1.setBackground(Color.white) ;
             act.con.btm1.setForeground(Color.blue) ;
             act.con.btm4.setBackground(Color.white) ;
             act.con.btm4.setForeground(Color.blue) ;
          }
       }
*/
       view.repaint() ;
     }

     public void start() {
        if (runner == null) {
           runner = new Thread(this) ;
           runner.start() ;
        }
     }

     public void run() {
       int timer,i ;
       double vvld,hvld,angle,deltmx,oldmass,newmass;
       double vald,hald,grald;
       String outht,outspd,outfor,outpres ;
   
       timer = 100 ;
       deltim  = .2 ;
       angle = pid2 ;
       oldmass = 115. * .00237 /1728. ;
       while (true) {
          try { Thread.sleep(timer); }
          catch (InterruptedException e) {}
          outht = " ft" ;
          if (lunits == 1) outht = " m" ;
          outspd = " fps" ;
          if (lunits == 1) outspd = " mps" ;
          outfor = " oz" ;
          if (lunits == 1) outfor = " g" ;
          outpres = " psi" ;
          if (lunits == 1) outpres = " kPa" ;
          posa[0] = (90.0 - lnchang) * convdr ;
          if (fire == 1) {  // launch sequence
             if (comp == 1 && istab == 1 && 
               irange == 1 && ifuel == 1 && ides == 1) {
               fltim = fltim + deltim ;
               if (planet == 2) wind = 0.0 ;  // no wind on the moon
      // countdown
      // flight
               if (fltim >= 0.0) {
      // thrust
                  if (rktype == 10) {  // ballistic-no thrust or recovery
                      rtype = 0 ;
                      wtflt = weight * wtrat ;
                      thrust = 0.0 ;
                      deltim = .05 ;
                  }
                  vvld = vvel ;
                  hvld = hvel ;
                  grald = grspd ;
                  vald = vacc ;
                  hald = hacc ;
        // powered  and coasting
                  if (fltim < timd || rtype == 0 || planet == 1 || planet == 2) {
                     angle = Math.atan2(vvel,hvel) ;
                     if (vloc < llaunch && fltim < timd) {
                        angle = (90.0 - lnchang) * convdr ;
  //                      angle =  lnchang * convdr ;
                     }
                     if (cockflg == 1 && cockcal == 1) {
                        angle = pid2 + Math.atan2(wind-hvel,vvel) ;
                     }

                     vacc = ((thrust-drag)*Math.sin(angle)-wtflt)/(wtflt/(g0 * wtrat)) ;
                     hacc = (thrust-drag)*Math.cos(angle) / (wtflt/(g0 * wtrat))  ;
                     vvel = vvld + .5 * (vacc + vald) * deltim ;
                     hvel = hvld + .5 * (hacc + hald) * deltim ;
                     spd = Math.sqrt(vvel*vvel + hvel*hvel) ;
                     drag = (16.0 * cd * .5 * rho * catot * spd * spd / 144.) ; 
                     grspd = hvel + wind ;
                  }

                  vloc = vloc + .5 * (vvel + vvld) * deltim ;
                  hloc = hloc + .5 * (grspd +grald) * deltim ;
//                  hloc = hloc + .5 * (hvel + hvld) * deltim ;

                  npt = npt + 1 ;
          // determine if on or off rail ..
                  posx[nsav][npt] = hloc ;
                  if (vloc < llaunch && fltim < tim1) {
                     timrail = fltim ;
                     posx[nsav][npt] = hloc ;
                  }
                  posy[nsav][npt] = vloc ;
                  posa[npt] = angle ;

                  cockcal = 0 ;

               }
     // update maximums
               if (vloc > vmax) {
                  vmax = vloc ;
               }
               if (Math.abs(posx[nsav][npt]) > Math.abs(hmax)) {
                  hmax = posx[nsav][npt] ;
               }
               if (spd > spdmax) {
                  spdmax = spd;
               }

//  try at tracking switch

              if (fltim > 4.5) trakon = 1 ;
     // shutdown .. hit the ground
               if (vloc < 0.0 ) {  
                  posa[npt] = 0.0 ;
                  comp = 0 ;
                  vloc = 0.0 ;
                  irange = 0 ;
                  ifuel = 0 ;
               }
             }
 
     // strip charts
             posx[5][npt] = 10.0*fltim ;
             posy[5][npt] = thrust ;
             posx[6][npt] = 10.0*fltim ;
             posy[6][npt] = wtflt ;
             posx[7][npt] = 10.0*fltim ;
             posy[7][npt] = drag ;
             posx[8][npt] = 10.0*fltim ;
             posy[8][npt] = vvel ;
             posx[9][npt] = 10.0*fltim ;
             posy[9][npt] = vloc ;

             if (stepon == 1) {
                comp = 0 ;
                if (step == 1) {
                  comp = 1;
                  step = 0 ;
                } 
             }
          }
     // reset integration
          if (fire == 0) {
             wtflt = weight * wtrat ;
             thrust = 0.0 ;
             timrail = 0.0 ;
             deltim = .2 ;
             fltim = 0.0 ;
             hloc = 0.0 ;
             vloc = 0.0 ;
             vvel = 0.0 ;
             hvel = 0.0 ;
             vmax = 0.0 ;
             hmax = 0.0 ;
             spdmax = 0.0 ;
             npt = 0 ;
             nburn = 0 ;
  
          }
          if (trakon > 0 && viewflg == 1) {  // tracking view
             fact = 3.5 ;
             if (planet == 2) fact = .06 ;
             if (planet == 3) fact = .11 ;
             xt = 450 - (int)(fact * posx[nsav][npt]) ;
             yt = 300 + (int)(fact * posy[nsav][npt]) ;
          }
          view.repaint() ;
 
       }
     }

     public void update(Graphics g) {
           view.paint(g) ;
     }
 
     public void paint(Graphics g) {
        int i,j,k,n ;
        int nump ;
        int exes[] = new int[9] ;
        int whys[] = new int[9] ;
        int ylabel,ylabel2,xlabel,xlabel2;
        double yval,xval,scale,btbase;
        double cpa,spa,nosx,nosy,hstg,pumph;
        double factm ;
        String words,outlng ;
        String outpres,outtemp,outhum,outspd ;
        Color col1,col2,col3 ;

        outpres = " in Hg" ;
        outtemp = " deg F" ;
        outhum = " %" ;
        outspd = " mph" ;

        col1 = new Color(0,121,0) ;   // dark green
        col2 = new Color(254,121,0) ; // dark orange
        col3 = new Color(0,220,220) ; // sky blue
 
        Font old = new Font("Helvetica",Font.PLAIN,12);
        Font f = new Font("Helvetica",Font.PLAIN,18);

        offsGg.setFont(f) ;
 // flight view
        if (viewflg == 1) {
          if (planet <= 1) offsGg.setColor(col3) ;
          if (planet == 2) offsGg.setColor(Color.black) ;
          if (planet == 3) offsGg.setColor(Color.pink) ;
          offsGg.fillRect(0,0,940,600) ;
                // hills
          exes[0] = (int) (fact*(0.0)) + xt ;
          whys[0] = (int) (fact*(200.0)) + yt ;
          exes[1] = (int) (fact*(2000.0)) + xt ;
          whys[1] = (int) (fact*(-100.)) + yt ;
          exes[2] = (int) (fact*(4200)) + xt ;
          whys[2] = (int) (fact*(100.0)) + yt  ;
          exes[3] = (int) (fact*(7000.)) + xt ;
          whys[3] = (int) (fact*(-200.0)) + yt ;
          exes[4] = (int) (fact*(9000.)) + xt ;
          whys[4] = (int) (fact*(100.0)) + yt ;
          exes[5] = (int) (fact*(10000.)) + xt ;
          whys[5] = (int) (fact*(-100.0)) + yt ;
          exes[6] = (int) (fact*(12000.)) + xt ;
          whys[6] = (int) (fact*(200.0)) + yt ;
          exes[7] = (int) (fact*(0.0)) + xt ;
          whys[7] = (int) (fact*(200.0)) + yt ;
          if (planet <= 1) offsGg.setColor(col1) ;
          if (planet == 2) offsGg.setColor(Color.darkGray) ;
          if (planet == 3) offsGg.setColor(col2) ;
          offsGg.fillPolygon(exes,whys,7) ;
          exes[0] = (int) (fact*(-250.0)) + xt ;
          whys[0] = (int) (fact*(0.0)) + yt ;
          exes[1] = (int) (fact*(-2000.0)) + xt ;
          whys[1] = (int) (fact*(-100.)) + yt ;
          exes[2] = (int) (fact*(-4200)) + xt ;
          whys[2] = (int) (fact*(100.0)) + yt  ;
          exes[3] = (int) (fact*(-7000.)) + xt ;
          whys[3] = (int) (fact*(-200.0)) + yt ;
          exes[4] = (int) (fact*(-9000.)) + xt ;
          whys[4] = (int) (fact*(100.0)) + yt ;
          exes[5] = (int) (fact*(-15000.)) + xt ;
          whys[5] = (int) (fact*(-100.0)) + yt ;
          exes[6] = (int) (fact*(-22000.)) + xt ;
          whys[6] = (int) (fact*(100.0)) + yt ;
          exes[7] = (int) (fact*(-250.)) + xt ;
          whys[7] = (int) (fact*(0.0)) + yt ;
          if (planet <= 1) offsGg.setColor(col1) ;
          if (planet == 2) offsGg.setColor(Color.darkGray) ;
          if (planet == 3) offsGg.setColor(col2) ;
          offsGg.fillPolygon(exes,whys,8) ;
                // ground plane
          exes[0] = 0 ;
          whys[0] = (int) (fact*(-5.0)) + yt ;
          exes[1] = 950 ;
          whys[1] = (int) (fact*(-5.)) + yt ;
          exes[2] = 950;
          whys[2] = 500 ;
          exes[3] = 0 ;
          whys[3] = 950 ;
          exes[4] = 0 ;
          whys[4] = (int) (fact*(-5.0)) + yt ;
          if (planet <= 1) offsGg.setColor(col1) ;
          if (planet == 2) offsGg.setColor(Color.gray) ;
          if (planet == 3) offsGg.setColor(Color.orange) ;
          offsGg.fillPolygon(exes,whys,5) ;
                // wall
          exes[0] = (int) (fact*(375.0)) + xt ;
          whys[0] = (int) (fact*(5.0)) + yt ;
          exes[1] = (int) (fact*(375.0)) + xt ;
          whys[1] = (int) (fact*(-15.)) + yt ;
          exes[2] = (int) (fact*(380.0)) + xt ;
          whys[2] = (int) (fact*(-15.)) + yt ;
          exes[3] = (int) (fact*(380.0)) + xt ;
          whys[3] = (int) (fact*(5.0)) + yt ;
          exes[4] = (int) (fact*(375.0)) + xt ;
          whys[4] = (int) (fact*(5.0)) + yt ;
          offsGg.setColor(Color.red) ;
          offsGg.fillPolygon(exes,whys,5) ;
          exes[0] = (int) (fact*(-350.0)) + xt ;
          exes[1] = (int) (fact*(-350.0)) + xt ;
          exes[2] = (int) (fact*(-352.0)) + xt ;
          exes[3] = (int) (fact*(-352.0)) + xt ;
          exes[4] = (int) (fact*(-350.0)) + xt ;
          offsGg.fillPolygon(exes,whys,5) ;
          if (planet <= 1) {
                // building  #1
             exes[0] = (int) (fact*(650.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(680.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(680.0)) + xt ;
             whys[2] = (int) (fact*(-50.)) + yt ;
             exes[3] = (int) (fact*(660.0)) + xt ;
             whys[3] = (int) (fact*(-50.0)) + yt ;
             exes[4] = (int) (fact*(660.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(650.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(650.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #2
             exes[0] = (int) (fact*(1550.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(1580.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(1580.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(1560.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(1560.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(1550.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(1550.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #3
             exes[0] = (int) (fact*(2350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(2390.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(2390.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(2370.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(2370.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(2350.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(2350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #4
             exes[0] = (int) (fact*(3250.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(3290.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(3290.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(3270.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(3270.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(3250.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(3250.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #5
             exes[0] = (int) (fact*(4450.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(4490.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(4490.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(4470.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(4470.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(4450.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(4450.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #6
             exes[0] = (int) (fact*(-750.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-790.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-790.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(-770.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(-770.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(-750.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(-750.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                // building  #7
             exes[0] = (int) (fact*(-1250.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-1290.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-1290.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(-1270.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(-1270.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(-1250.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(-1250.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #8
             exes[0] = (int) (fact*(-2350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-2390.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-2390.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-2370.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-2370.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(-2350.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(-2350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #9
             exes[0] = (int) (fact*(-3550.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-3580.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-3580.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-3560.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-3560.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(-3550.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(-3550.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #10
             exes[0] = (int) (fact*(-4350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-4380.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-4380.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-4360.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-4360.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(-4350.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(-4350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
          }
                // Grid paper background
          if (gridon >= 0) {  
            factm = 50. ;
            if (fact < 2.5 && fact >= .5) factm = 100. ;
            if (fact < .5 && fact >= .25) factm = 500. ;
            if (fact < .25 && fact >= .1) factm = 1000. ;
            if (fact < .1 && fact >= .05) factm = 5000. ;
            if (fact < .05 && fact >= .001) factm = 10000. ;

            outlng = " ft" ;
            if (lunits == 1) {
               outlng = " m" ;
               factm = .5 * factm ;
            }
            for (j=0; j<=50; ++j) {
               exes[0] = 0 ; 
               exes[1] = 950 ;
               whys[0] = whys[1] = (int) (-fact*(factm*j / lconv1)) + yt;
               offsGg.setColor(Color.white) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.drawString(words,752,whys[0]-5) ; 
            }
            for (j=0; j<=50; ++j) {
               whys[0] = (int) (-fact*(0.0)) + yt;
               whys[1] = 0;
               exes[0] = exes[1] = (int) (fact*(factm*j / lconv1)) + xt  ;
               offsGg.setColor(Color.white) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.setColor(Color.white) ;
               if (planet == 2) offsGg.setColor(Color.white) ;
               if (j <= 4)offsGg.drawString(words,exes[0]-25,370) ;
               if (j >= 5)offsGg.drawString(words,exes[0]-30,370) ;

               exes[0] = exes[1] = (int) (-fact*(factm*j / lconv1)) + xt  ;
               offsGg.setColor(Color.white) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.setColor(Color.white) ;
               if (planet == 2) offsGg.setColor(Color.white) ;
               offsGg.drawString(words,exes[0]-25,370) ;
            }
          }
       // labels 
               // saved flights
          if (nsav >= 1) {
            for (i=0; i<= nsav-1; ++ i) {
              exes[0] = (int) (fact*(0.0)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              nump = npts[i] ;
              for (j=0; j<=nump; ++j){
                exes[1] = exes[0] ;
                whys[1] = whys[0] ;
                exes[0] = (int) (fact*(posx[i][j])) + xt ;
                whys[0] = (int) (fact*(-posy[i][j])) + yt ;
                offsGg.setColor(Color.white) ;
                offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                if(i==0) offsGg.setColor(Color.yellow) ;
                if(i==1) offsGg.setColor(Color.orange) ;
                if(i==2) offsGg.setColor(Color.magenta) ;
                if(i==3) offsGg.setColor(Color.red) ;
                if(fltim <= 4.5) offsGg.drawString("*",exes[0]-3,whys[0]+10) ;
                if (fltim > 4.5) offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
              }
            }
          }
               // flight trajectory
          exes[0] = (int) (fact*(0.0)) + xt ;
          whys[0] = (int) (fact*(0.0)) + yt ;
          for (j=0; j<=npt; ++j){
            exes[1] = exes[0] ;
            whys[1] = whys[0] ;
            exes[0] = (int) (fact*(posx[nsav][j])) + xt ;
            whys[0] = (int) (fact*(-posy[nsav][j])) + yt ;
            if (planet <= 1) offsGg.setColor(Color.white) ;
            if (planet == 2) offsGg.setColor(Color.white) ;
            if (planet == 3) offsGg.setColor(Color.black) ;
            if (j < nburn) offsGg.setColor(Color.white) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            offsGg.setColor(Color.white) ;
            if(fltim <= 4.5) offsGg.drawString("*",exes[0]-3,whys[0]+10) ;
            if (fltim > 4.5) offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
          }
     // baseball
          if (ldisplay == 2) {
            cpa = Math.cos((90.0 - lnchang)*convdr) ;
            spa = Math.sin((90.0 - lnchang)*convdr) ;
  //               cpa = Math.cos(lnchang*convdr) ;
  //               spa = Math.sin(lnchang*convdr) ;
            exes[0] = (int) (0.0) + xt ;
            whys[0] = -(int) (0.0) + yt ;
            exes[1] = (int) (20. * cpa) + xt ; 
            whys[1] = -(int) (20. * spa) + yt ;
            offsGg.setColor(Color.white) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            exes[0] = (int) (fact*(posx[nsav][npt])) - 5 + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt])) - 5 + yt;
            offsGg.setColor(Color.white) ;
            if(fltim <= 4.5) offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
          }
 
   // wind vector
          exes[0] = 140 ;
          whys[0] = 75;
          exes[1] = 140 + (int) (5.*wind) ;
          whys[1] = 75 ;
          offsGg.setColor(Color.white) ;
          offsGg.drawString("Wind",exes[0]-15,whys[0]+25) ;
          offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
          if (wind >= 0.0) {
            exes[0] = exes[1] - 5 ;
            whys[0] = whys[1] - 3 ;
            exes[2] = exes[1] - 5 ;
            whys[2] = whys[1] + 3 ;
            exes[3] = exes[1] - 5 ;
            whys[3] = whys[1] - 3 ;
          }
          if (wind < 0.0) {
            exes[0] = exes[1] + 5 ;
            whys[0] = whys[1] - 3 ;
            exes[2] = exes[1] + 5 ;
            whys[2] = whys[1] + 3 ;
            exes[3] = exes[1] + 5 ;
            whys[3] = whys[1] - 3 ;
          }
          offsGg.fillPolygon(exes,whys,4) ;
        }
 
 // border 
 // side zoom widget
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(0,0,35,550) ;
 // top
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(34,0,900,25) ;
        if (viewflg == 1) {
               // time-height boxes
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Time",445,17) ;
           offsGg.drawString("Height",580,17) ;
           offsGg.drawString("Distance",730,17) ;
           offsGg.setColor(Color.white) ;
           offsGg.fillRect(490,2,40,18) ;
           offsGg.fillRect(650,2,40,18) ;
           offsGg.fillRect(820,2,40,18) ;

           offsGg.setColor(Color.black) ;
           offsGg.drawString(String.valueOf(filter1(fltim)),495,17) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString(String.valueOf(filter0(vmax*lconv1)),655,17) ;
           offsGg.drawString(String.valueOf(filter0(posx[nsav][npt]*lconv1)),825,17) ;
   //  graphical buttons
           offsGg.setColor(Color.blue) ;
           offsGg.fillRect(40,2,70,18) ;
           offsGg.setColor(Color.white) ;
           offsGg.drawString("Save",50,17) ;
           offsGg.setColor(Color.orange) ;
           offsGg.fillRect(120,2,70,18) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Clear",130,17) ;
           offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(260,2,140,18) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("SWING",300,17) ;
        }

 // right 
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(880,0,30,550) ;
 
 // bottom
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(10,400,900,140) ;
 // weather buttons

           offsGg.setColor(Color.white) ;
           if (presopt == 1) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(90,442,130,18) ;
           offsGg.setColor(Color.red) ;
           offsGg.drawString("High Pressure",100,457) ;
           offsGg.setColor(Color.white) ;
           if (presopt == 0) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(90,472,130,18) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Average Day",105,487) ;
           offsGg.setColor(Color.white) ;
           if (presopt == 2) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(90,502,130,18) ;
           offsGg.setColor(Color.blue) ;
           offsGg.drawString("Low Pressure",100,517) ;

           offsGg.setColor(Color.white) ;
           if (tempopt == 1) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(300,442,120,18) ;
           offsGg.setColor(Color.red) ;
           offsGg.drawString("Hot Day",320,457) ;
           offsGg.setColor(Color.white) ;
           if (tempopt == 0) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(300,472,120,18) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Average Day",310,487) ;
           offsGg.setColor(Color.white) ;
           if (tempopt == 2) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(300,502,120,18) ;
           offsGg.setColor(Color.blue) ;
           offsGg.drawString("Cold Day",320,517) ;

           offsGg.setColor(Color.white) ;
           if (humopt == 1) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(500,442,120,18) ;
           offsGg.setColor(Color.red) ;
           offsGg.drawString("Humid Day",510,457) ;
           offsGg.setColor(Color.white) ;
           if (humopt == 0) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(500,472,120,18) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Average Day",510,487) ;
           offsGg.setColor(Color.white) ;
           if (humopt == 2) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(500,502,120,18) ;
           offsGg.setColor(Color.blue) ;
           offsGg.drawString("Dry Day",530,517) ;

           offsGg.setColor(Color.white) ;
           if (windopt == 1) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(680,442,90,18) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("+ Wind",700,457) ;
           offsGg.setColor(Color.white) ;
           if (windopt == 0) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(680,472,90,18) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("No Wind",690,487) ;
           offsGg.setColor(Color.white) ;
           if (windopt == 2) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(680,502,90,18) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("- Wind",700,517) ;

           offsGg.setColor(Color.white) ;
           if (dragopt == 1) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(780,442,90,18) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("No Drag",790,457) ;
           offsGg.setColor(Color.white) ;
           if (dragopt == 0) offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(780,472,90,18) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString(" Drag",790,487) ;
     // input
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Cd",795,428) ;
           offsGg.fillRect(830,412,40,18) ;
           offsGg.setColor(Color.cyan) ;
           offsGg.drawString(String.valueOf(filter1(cd)),840,428) ;

           offsGg.setColor(Color.black) ;
           offsGg.drawString("Wind",635,428) ;
           offsGg.fillRect(685,412,90,18) ;
           offsGg.setColor(Color.cyan) ;
           offsGg.drawString(String.valueOf(filter1(wind * 60. / 88.) + outspd),695,428) ;

           offsGg.setColor(Color.black) ;
           offsGg.drawString("Pressure",40,428) ;
           offsGg.fillRect(120,412,110,18) ;
           offsGg.setColor(Color.cyan) ;
           offsGg.drawString(String.valueOf(filter2(presm) + outpres),130,428) ;

           offsGg.setColor(Color.black) ;
           offsGg.drawString("Temperature",250,428) ;
           offsGg.fillRect(360,412,90,18) ;
           offsGg.setColor(Color.cyan) ;
           offsGg.drawString(String.valueOf(filter0(temf) + outtemp),370,428) ;

           offsGg.setColor(Color.black) ;
           offsGg.drawString("Humidity",470,428) ;
           offsGg.fillRect(545,412,70,18) ;
           offsGg.setColor(Color.cyan) ;
           offsGg.drawString(String.valueOf(filter0(100.0*rlhum) + outhum),555,428) ;

        g.drawImage(offImg,0,0,this) ;   

     }  // end Paint
  }  // End View

} // end WHitModeler
