/*
                 Vieweng - a Java viewer for the Wright Brothers
                        1903 engine animated gifs

                     Version 1.0.0a   - 4 Dec 02

                         Written by Tom Benson
                       NASA Glenn Research Center

>                              NOTICE
>This software is in the Public Domain.  It may be freely copied and used in
>non-commercial products, assuming proper credit to the author is given.  IT
>MAY NOT BE RESOLD.  If you want to use the software for commercial
>products, contact the author.
>No copyright is claimed in the United States under Title 17, U. S. Code.
>This software is provided "as is" without any warranty of any kind, either
>express, implied, or statutory, including, but not limited to, any warranty
>that the software will conform to specifications, any implied warranties of
>merchantability, fitness for a particular purpose, and freedom from
>infringement, and any warranty that the documentation will conform to the
>program, or any warranty that the software will be error free.
>In no event shall NASA be liable for any damages, including, but not
>limited to direct, indirect, special or consequential damages, arising out
>of, resulting from, or in any way connected with this software, whether or
>not based on warranty, contract, tort or otherwise, whether or not injury
>was sustained by persons or property or otherwise, and whether or not loss
>was sustained from, or arose out of the results of, or use of, the software
>or services provided hereunder.

*/

import java.awt.*;
import java.lang.Math ;

public class Vieweng extends java.applet.Applet {
 
   int counter,inc ;

   Dispnl dispnl ;
   Image offscreenImg ;
   Graphics offsGg ;
   Image[] animg = new Image[40] ;

   public void init() {
     int i;

     for (i = 1; i <= 39; i++ ) {
       animg[i-1] = getImage(getCodeBase(),
               "engrot" + i + ".gif") ;
     }

     offscreenImg = createImage(this.size().width,
                      this.size().height) ;
     offsGg = offscreenImg.getGraphics() ;

     setLayout(new GridLayout(1,1,5,5)) ;
 
     dispnl = new Dispnl(this) ;
 
     add(dispnl) ;
 
     counter = 0 ;
     inc = 0 ;
     dispnl.pic.start() ;
   }
 
 
  class Dispnl extends Panel {
     Vieweng outerparent ;
     Pic pic ;
     Conpnl conpnl ;

     Dispnl (Vieweng target) {
        outerparent = target ;
        setLayout(new BorderLayout(5,5)) ;
 
        pic = new Pic() ;
        conpnl = new Conpnl() ;
 
        add("Center", pic) ;
        add("South", conpnl) ;
     }
 
     class Conpnl extends Panel {
        Vieweng outerparent ;
        Button rotcc,rotcw,stepcc,stepcw,end ;
 
        Conpnl () {
          setLayout(new GridLayout(1,5,5,5)) ;
 
          rotcc = new Button("< Rotate") ;
          rotcc.setBackground(Color.white) ;
          rotcc.setForeground(Color.blue) ;
          stepcc = new Button("< Step") ;
          stepcc.setBackground(Color.blue) ;
          stepcc.setForeground(Color.white) ;
          end = new Button("Stop") ;
          end.setBackground(Color.red) ;
          end.setForeground(Color.white) ;
          stepcw = new Button("Step >") ;
          stepcw.setBackground(Color.blue) ;
          stepcw.setForeground(Color.white) ;
          rotcw = new Button("Rotate >") ;
          rotcw.setBackground(Color.white) ;
          rotcw.setForeground(Color.blue) ;

          add(rotcc) ;
          add(stepcc) ;
          add(end) ;
          add(stepcw) ;
          add(rotcw) ;
        }
 
        public boolean action(Event evt, Object arg) {
          if(evt.target instanceof Button) {
             String label = (String)arg ;
             if(label.equals("< Rotate")) inc = -1 ;
             if(label.equals("< Step")) {
                 counter = counter -1 ;
                 if (counter == -1) counter = 38 ;
                 inc = 0 ;
             }
             if(label.equals("Stop")) inc = 0 ;
             if(label.equals("Step >")) {
                 counter = counter +1 ;
                 if (counter == 39) counter = 0 ;
                 inc = 0 ;
             }
             if(label.equals("Rotate >")) inc = 1 ;
             return true ;
          }
          else return false ;
        } // end Handler
     }  // end Conpnl

     class Pic extends Canvas
             implements Runnable{
        Vieweng outerparent ;
        Thread runner ;
        Image displimg ;
   
        Pic () {
            setBackground(Color.black) ;
            runner = null ;
            displimg = getImage(getCodeBase(),"engrot1.gif") ;
        }

        public Insets insets() {
           return new Insets(0,10,0,10) ;
        }

        public void start() {
           if (runner == null) {
              runner = new Thread(this) ;
              runner.start() ;
           }
        }
   
        public void run() {
          while (true) {
              displimg = animg[counter] ;
              try { Thread.sleep(100); }
              catch (InterruptedException e) {}
              pic.repaint() ;
              counter = counter + inc ;
              if (counter == 39) counter = 0 ;
              if (counter == -1) counter = 38 ;
          }
        }

        public void update(Graphics g) {
           pic.paint(g) ;
        }
   
        public void paint(Graphics g) {
    
            offsGg.drawImage(displimg,0,0,this) ;
            g.drawImage(offscreenImg,0,0,this) ;
        }
      }
   }
}
