import java.awt.*;
import java.lang.Math ;

public class Atmos extends java.applet.Applet {

   double gama,alt,temp,press ;
   int lunits,var,planet,ther,prs ;

   Viewer view ;
   Inpnl inpnl ;
   Image plnimg ;
   Image mplnimg ;
   Image offscreenImg ;
   Graphics offsGg ;
   Image offImg2 ;
   Graphics off2Gg ;
   Point locate ;

   public void init() {

     offscreenImg = createImage(this.size().width,
                      this.size().height) ;
     offsGg = offscreenImg.getGraphics() ;
     offImg2 = createImage(this.size().width,
                      this.size().height) ;
     off2Gg = offImg2.getGraphics() ;
 
     plnimg = getImage(getCodeBase(),
      "images/plane.gif");
     mplnimg = getImage(getCodeBase(),
      "images/mpln.gif");
     locate = new Point(100,300) ;

     setLayout(new GridLayout(1,2,0,0)) ;

     setDefaults () ;

     view = new Viewer(this) ;

     inpnl = new Inpnl(this) ;

     add(view) ;
     add(inpnl) ;

     computeAtmos() ;
  }
 
  public Insets insets() {
     return new Insets(10,10,10,10) ;
  }

  public void setDefaults() {
     var = 0 ;
     alt = 0.0 ;
     planet = 0 ;
  }

  public void computeAtmos() {
     double rgas, rho0, rho, a0, lrat, mach ;
 
     rgas = 1718. ;                /* ft2/sec2 R */
     gama = 1.4 ;
     if (planet == 0) {    // Earth  standard day
       if (alt <= 36152.) {           // Troposphere
          temp = 518.6 - 3.56 * alt/1000. ;
          press = 2116. * Math.pow(temp/518.6,5.256) ;
       }
       if (alt >= 36152. && alt <= 82345.) {   // Stratosphere
          temp = 389.98 ;
          press = 2116. * .2236 *
             Math.exp((36000.-alt)/(53.35*389.98)) ;
       }
       if (alt >= 82345.) {          
          temp = 389.98 + 1.645 * (alt-82345)/1000. ;
          press = 2116. *.02456 * Math.pow(temp/389.98,-11.388) ;
       }
     }

     if (planet == 1) {   // Mars - curve fit of orbiter data
       rgas = 1149. ;                /* ft2/sec2 R */
       gama = 1.29 ;

       if (alt <= 22960.) {     
          temp = 434.02 - .548 * alt/1000. ;
          press = 14.62 * Math.pow(2.71828,-.00003 * alt) ;
       }
       if (alt > 22960.) {  
          temp = 449.36 - 1.217 * alt/1000. ;
          press = 14.62 * Math.pow(2.71828,-.00003 * alt) ;
       }
     }

     a0 = Math.sqrt(gama*rgas*temp) ;
     rho = press/(rgas*temp) ;
     mach = 800./a0 ;

     rho0 = .00237 ;
     lrat = 100. * rho / rho0 ;

     if (lunits == 0) {
             // convert to English (Farenheit and psi)
         temp = temp - 459.7 ;
         press = press / 144. ;
     }
     if (lunits == 1) {
         temp = temp * .55555 - 273.1 ;
         press = press * .04787 ;
         rho = rho * 515.4 ;
         a0 = a0 * .3048 ;
     }

     if (lunits == 0) {
         inpnl.uppnl.o1.setText(String.valueOf(filter0(alt))) ;
         inpnl.uppnl.l1u.setText("  feet ") ;
     }
     if (lunits == 1) {
         inpnl.uppnl.o1.setText(String.valueOf(filter0(alt*.3048))) ;
         inpnl.uppnl.l1u.setText("  meters ") ;
     }

     if (var == 0) {
         inpnl.uppnl.la.setText(" ") ;
         inpnl.uppnl.lb.setText(" ") ;
         inpnl.uppnl.lc.setText(" ") ;
         inpnl.uppnl.o2.setText(String.valueOf(filter0(temp))) ;
         if (lunits == 0) inpnl.uppnl.l2u.setText("  F  ") ;
         if (lunits == 1) inpnl.uppnl.l2u.setText("  C  ") ;
     }
     if (var == 1) {
         inpnl.uppnl.la.setText(" ") ;
         inpnl.uppnl.lb.setText(" ") ;
         inpnl.uppnl.lc.setText(" ") ;
         inpnl.uppnl.o2.setText(String.valueOf(filter3(press))) ;
         if (lunits == 0) inpnl.uppnl.l2u.setText(" psi  ") ;
         if (lunits == 1) inpnl.uppnl.l2u.setText(" K-Pa  ") ;
     }
     if (var == 2) {
         inpnl.uppnl.la.setText(" ") ;
         inpnl.uppnl.lb.setText(" ") ;
         inpnl.uppnl.lc.setText(" ") ;
         if (lunits == 0) {
            inpnl.uppnl.o2.setText(String.valueOf(filter5(rho))) ;
            inpnl.uppnl.l2u.setText("slugs / cu ft") ;
         }
         if (lunits == 1) {
            inpnl.uppnl.o2.setText(String.valueOf(filter3(rho))) ;
            inpnl.uppnl.l2u.setText("kg / cu m") ;
         }
     }
     if (var == 3) {
         inpnl.uppnl.la.setText(" ") ;
         inpnl.uppnl.lb.setText(" ") ;
         inpnl.uppnl.lc.setText(" ") ;
         inpnl.uppnl.o2.setText(String.valueOf(filter0(a0))) ;
         if (lunits == 0) inpnl.uppnl.l2u.setText(" ft/sec  ") ;
         if (lunits == 1) inpnl.uppnl.l2u.setText(" m/sec  ") ;
     }
     if (var == 4) {
         if (lrat >= 10.0) 
            inpnl.uppnl.o2.setText(String.valueOf(filter0(lrat))) ;
         if (lrat < 10.0)
            inpnl.uppnl.o2.setText(String.valueOf(filter3(lrat))) ;
         inpnl.uppnl.l2u.setText("% of Lift for") ;
         inpnl.uppnl.la.setText("Same Aircraft-") ;
         inpnl.uppnl.lb.setText("Same Velocity-") ;
         inpnl.uppnl.lc.setText("Earth, Alt = 0") ;
     }
     if (var == 5) {
         inpnl.uppnl.o2.setText(String.valueOf(filter3(mach))) ;
         inpnl.uppnl.l2u.setText(" ") ;
         inpnl.uppnl.lc.setText(" ") ;
         inpnl.uppnl.la.setText("Velocity = ") ;
         if (lunits == 0) {
             inpnl.uppnl.lb.setText("800 ft/sec") ;
         }
         if (lunits == 1) {
             inpnl.uppnl.lb.setText("244 m/sec") ;
         }
     }

     loadGage () ;
     view.repaint() ;
  }

  public int filter0(double inumbr) {
     //  integer output
       float number ;
       int intermed ;

       intermed = (int) (inumbr) ;
       number = (float) (intermed);
       return intermed ;
  }
 
  public float filter3(double inumbr) {
     //  output only to .001
       float number ;
       int intermed ;
  
       intermed = (int) (inumbr * 1000.) ;
       number = (float) (intermed / 1000. );
       return number ;
  }

  public float filter5(double inumbr) {
     //  output only to .00001
       float number ;
       int intermed ;
  
       intermed = (int) (inumbr * 100000.) ;
       number = (float) (intermed / 100000. );
       return number ;
  }

  public void loadGage() {
     ther = 70 - (int) (.5 * temp) ;
     if(lunits == 0) 
         prs = 152 - (int) (10. * press) ;
     if(lunits == 1) 
         prs = 152 - (int) (press) ;

     inpnl.dnpnl.repaint() ;
  }

  class Inpnl extends Panel {
     Atmos outerparent ;
     Uppnl uppnl ;
     Dnpnl dnpnl ;

     Inpnl (Atmos target) {                           
        outerparent = target ;
        setLayout(new GridLayout(2,1,10,10)) ;

        uppnl = new Uppnl(outerparent) ;
        dnpnl = new Dnpnl(outerparent) ;

        add(uppnl) ;
        add(dnpnl) ;
     }

     public Insets insets() {
        return new Insets(5,5,0,0) ;
     }

     class Uppnl extends Panel {
        TextField o1,o2 ;
        Label l1,l1u,l2u ;
        Label la,lb,lc ;
        Choice untch,plnitch,pltch ;

        Uppnl (Atmos target) {                           
            outerparent = target ;
            setLayout(new GridLayout(5,3,0,0)) ;
    
            l1 = new Label("Altitude", Label.CENTER) ;
            l1u = new Label(" feet ", Label.CENTER) ;
   
            o1 = new TextField() ;
            o1.setBackground(Color.black) ;
            o1.setForeground(Color.yellow) ;

            l2u = new Label(" F ", Label.CENTER) ;

            o2 = new TextField() ;
            o2.setBackground(Color.black) ;
            o2.setForeground(Color.yellow) ;
 
            untch = new Choice() ;
            untch.addItem("English Units") ;
            untch.addItem("Metric Units");
            untch.select(0) ;

            plnitch = new Choice() ;
            plnitch.addItem("Earth") ;
            plnitch.addItem("Mars");
            plnitch.select(0) ;

            pltch = new Choice() ;
            pltch.addItem("Temp.") ;
            pltch.addItem("Pressure");
            pltch.addItem("Density");
            pltch.addItem("Sound Speed");
            pltch.addItem("Lift Ratio");
            pltch.addItem("Mach");
            pltch.select(0) ;

            untch = new Choice() ;
            untch.addItem("English Units") ;
            untch.addItem("Metric Units");
            untch.select(0) ;

            la = new Label("  ", Label.CENTER) ;
            lb = new Label("  ", Label.CENTER) ;
            lc = new Label("  ", Label.CENTER) ;

            add(new Label("Planet : ", Label.RIGHT)) ;
            add(plnitch) ;
            add(untch) ;

            add(new Label("Select Output:", Label.LEFT)) ;
            add(new Label(" ", Label.CENTER)) ;
            add(new Label(" ", Label.CENTER)) ;

            add(pltch) ;
            add(o2) ;
            add(l2u) ;

            add(la) ;
            add(lb) ;
            add(lc) ;

            add(l1) ;
            add(o1) ;
            add(l1u) ;
        }

        public Insets insets() {
           return new Insets(5,5,5,5) ;
        }

        public boolean action(Event evt, Object arg) {
            if(evt.target instanceof Choice) {
               this.handleProb(evt) ;
               return true ;
            }
            else return false ;
        }
 
        public void handleProb(Object obj) {

            lunits  = untch.getSelectedIndex() ;
            var     = pltch.getSelectedIndex() ;
            planet  = plnitch.getSelectedIndex() ;
 
            computeAtmos() ;
        }
     }

     class Dnpnl extends Canvas {
        Atmos outerparent ;

        Dnpnl (Atmos target) {
            setBackground(Color.black) ;
        }

        public void update(Graphics g) {
            dnpnl.paint(g) ;
        }
 
        public Insets insets() {
           return new Insets(5,5,5,5) ;
        }

        public void paint(Graphics g) {
           int ex[] = { 200,190,190 } ;
           int ey[] = { 50,30,50 } ;
           int index ;

           off2Gg.setColor(Color.white) ;
           off2Gg.fillRect(0,0,300,175) ;
            // Thermometer
           off2Gg.setColor(Color.black) ;
           off2Gg.drawRect(40,10,20,125) ;
           off2Gg.setColor(Color.white) ;
           off2Gg.fillRect(42,19,17,105) ;
           off2Gg.setColor(Color.red) ;
           off2Gg.fillOval(34,117,35,35);
           off2Gg.drawString("Temperature",65,25);
           off2Gg.setColor(Color.black);
           off2Gg.drawString("100",5,25);
           off2Gg.drawString("50",5,50);
           off2Gg.drawString("0",5,75);
           off2Gg.drawString("-50",5,100);
           off2Gg.drawString("-100",5,125);
           for (index=0 ; index <= 4; index ++) {
             off2Gg.drawLine(30,20+index*25,40,20+index*25) ;
           }
           off2Gg.setColor(Color.red) ;
           off2Gg.fillRect(42,ther,17,135-ther) ;
           off2Gg.setColor(Color.black) ;
           if(lunits == 0) 
              off2Gg.drawString("F",65,75);
           if(lunits == 1) 
              off2Gg.drawString("C",65,75);
               // Pressure Gage
           ey[0] = prs ;
           ey[1] = prs - 5;
           ey[2] = prs + 5;
           off2Gg.setColor(Color.black) ;
           off2Gg.fillRect(165,0,90,160) ;
           off2Gg.drawString("Pressure",110,150);
           off2Gg.setColor(Color.yellow) ;
           off2Gg.fillRect(174,prs-2,20,5) ;
           off2Gg.fillPolygon(ex,ey,3) ;
           for (index=0 ; index <= 15; index ++) {
             if (index/5 * 5 == index) {
                 off2Gg.drawLine(195,2+index*10,225,2+index*10) ;
             }
             else {
                 off2Gg.drawLine(200,2+index*10,220,2+index*10) ;
             }
           }
           if(lunits == 0) {
              off2Gg.setColor(Color.yellow) ;
              off2Gg.drawString("15",227,10);
              off2Gg.drawString("10",227,57);
              off2Gg.drawString("5",227,107);
              off2Gg.drawString("0",227,152);
              off2Gg.setColor(Color.black) ;
              off2Gg.drawString("psi",257,75);
           }
           if(lunits == 1) {
              off2Gg.setColor(Color.yellow) ;
              off2Gg.drawString("150",227,10);
              off2Gg.drawString("100",227,57);
              off2Gg.drawString("50",227,107);
              off2Gg.drawString("0",227,152);
              off2Gg.setColor(Color.black) ;
              off2Gg.drawString("K-Pa",257,75);
           }

           g.drawImage(offImg2,0,0,this) ;
        }

     }
  }

  class Viewer extends Panel {
     Atmos outerparent ;

     Viewer (Atmos target) {
         setBackground(Color.blue) ;
     }
 
     public boolean mouseUp(Event evt, int x, int y) {
        handle(x,y) ;
        return true;
     }

     public boolean mouseDrag(Event evt, int x, int y) {
        handle(x,y) ;
        return true;
     }

     public void handle(int x, int y) {
         // determine location and altitude
        locate = new Point(x,y) ;
        if (locate.y > 300) locate.y = 300 ;
        if (locate.y < 50) locate.y = 50 ;
        alt = 400. * (300 - locate.y) ;

        computeAtmos() ;
     }

     public void update(Graphics g) {
         view.paint(g) ;
     }

     public void paint(Graphics g) {
      int iwidth = plnimg.getWidth(this) ;
      int iheight = plnimg.getHeight(this) ;
      int index;

      Font f = new Font("Helvetica",Font.PLAIN,18);
      offsGg.setFont(f) ;
        // Airplane on Background
      if (planet == 0) {
         offsGg.setColor(Color.blue) ;
         offsGg.fillRect(0,0,300,350) ;
         offsGg.drawImage(plnimg,120,locate.y-20,iwidth,iheight,this) ;
      }
      if (planet == 1) {
         offsGg.setColor(Color.orange) ;
         offsGg.fillRect(0,0,300,350) ;
         offsGg.drawImage(mplnimg,120,locate.y-20,iwidth,iheight,this) ;
      }
        // Axis
      offsGg.setColor(Color.white) ;
      offsGg.drawLine(100,50,100,300) ;
      offsGg.drawLine(102,50,102,300) ;
      offsGg.drawString("Use Mouse to move Airplane",30,15);

      if (lunits == 0) {     // English units
        offsGg.drawString("Altitude (feet)",10,40);
        offsGg.drawString("100,000",10,60);
        offsGg.drawString("80,000",10,105);
        offsGg.drawString("60,000",10,155);
        offsGg.drawString("40,000",10,205);
        offsGg.drawString("20,000",10,255);
        offsGg.drawString("0",10,300);
        for (index=0 ; index <= 5; index ++) {
          offsGg.drawLine(90,50+index*50,110,50+index*50) ;
        }
      }

      if (lunits == 1) {   // metric unity
        offsGg.drawString("Altitude (meters)",10,40);
        offsGg.drawString("30,000",10,59);
        offsGg.drawString("25,000",10,100);
        offsGg.drawString("20,000",10,141);
        offsGg.drawString("15,000",10,182);
        offsGg.drawString("10,000",10,219);
        offsGg.drawString("5,000",10,260);
        offsGg.drawString("0",10,300);
        for (index=0 ; index <= 7; index ++) {
          offsGg.drawLine(90,54+index*41,110,54+index*41) ;
        }
      }

      g.drawImage(offscreenImg,0,0,this) ;
    }
  }
}
