import java.awt.*;
import java.lang.Math ;

public class AtmoDemo extends java.applet.Applet  {

  Image plnimg ;
  Image offscreenImg ;
  Graphics offsGg;
  Point locate ;
  double alt,temp,press;
  float tempo,preso ;
  int ther,prs ;

  public void init() {
     offscreenImg = createImage(this.size().width,
            this.size().height) ;
     offsGg = offscreenImg.getGraphics() ;

     setBackground(Color.white) ;
     plnimg = getImage(getCodeBase(),
      "images/plane.gif");
     locate = new Point(100,300) ;
     alt = 0.0 ;
     ther = 92 ;
     prs = 36 ;
  }
  
  public boolean mouseUp(Event evt, int x, int y) {
     handle(x,y) ;
     return true;
  }

  public boolean mouseDrag(Event evt, int x, int y) {
     handle(x,y) ;
     return true;
  }

  public void handle(int x, int y) {
     AtmoDemo a = new AtmoDemo() ;
      // determine location and altitude
     locate = new Point(x,y) ;
     if (locate.y > 300) locate.y = 300 ;
     if (locate.y < 50) locate.y = 50 ;
     alt = 200. * (300 - locate.y) ;
      // determine the temperature
     temp = a.computeTemp(alt) ;
     tempo = (float) (temp) ;
     ther = 150 - (int) (temp) ;
      // determine the pressure
     press = a.computePres(alt,temp) ;
     preso = (float) (press);
     prs = 330 - (int) (20. * press) ;

     repaint() ;
  }

  public double computeTemp(double hite) {
     double number ;
 
     if (hite <= 36000.) {
        number = 518.6 - 3.56 * hite/1000. ;
     }
     else {
        number = 389.98 ;
     }
       // convert to Farenheit
     number = number - 460. ;

     return number ;
  }

  public double computePres(double hite, double tem) {
     double number,tlocal ;

     // convert temp to Rankine
     tlocal = tem + 460. ;
     if (hite <= 36000.) {
        number = 2116. * Math.pow(tlocal/518.6,5.256) ;
     }
     else {
        number = 2116. * .2236 * 
           Math.exp((36000.-hite)/(53.35*389.98)) ;
     }
     // convert pres to psi
     number = number / 144. ;
     return number ;
  }

  public void update(Graphics g) {
     g.clipRect(125, 25, 370, 350) ;
     paint(g) ;
  }

  public void paint(Graphics g) {
      int iwidth = plnimg.getWidth(this) ;
      int iheight = plnimg.getHeight(this) ;
      int index;
      int ex[] = { 450,440,440 } ;
      int ey[] = { 50,30,50 } ;

      Font f = new Font("Helvetica",Font.PLAIN,18);
      offsGg.setFont(f) ;
        // Instructions
      offsGg.drawString("Move Airplane to Desired Altitude",2,15);
      offsGg.drawString("Temperature",300,15);
      offsGg.drawString("Pressure",420,15);
        // Airplane on Background
      offsGg.setColor(Color.blue) ;
      offsGg.fillRect(0,20,250,310) ;
      offsGg.drawImage(plnimg,120,locate.y-20,iwidth,iheight,this) ;
        // Axis
      offsGg.setColor(Color.white) ; 
      offsGg.drawString("Altitude (feet)",10,40);
      offsGg.drawLine(100,50,100,300) ;
      offsGg.drawLine(102,50,102,300) ;

      offsGg.drawString("50,000",10,60);
      offsGg.drawString("40,000",10,105);
      offsGg.drawString("30,000",10,155);
      offsGg.drawString("20,000",10,205);
      offsGg.drawString("10,000",10,255);
      offsGg.drawString("0",10,300);
      for (index=0 ; index <= 5; index ++) {
        offsGg.drawLine(90,50+index*50,110,50+index*50) ;
      }
         // Printed altitude
      offsGg.fillRect(125,330,100,30) ;
      offsGg.setColor(Color.black) ; 
      offsGg.drawString("Altitude = ",20,350);
      offsGg.drawString(Double.toString(alt),125,350);

         // Thermometer 
      offsGg.setColor(Color.black) ;
      offsGg.drawRect(330,30,30,250) ;
      offsGg.setColor(Color.white) ;
      offsGg.fillRect(332,29,27,270) ;
      offsGg.setColor(Color.red) ;
      offsGg.fillOval(310,250,70,70);
      offsGg.setColor(Color.black);
      offsGg.drawString("F",370,155);
      offsGg.drawString("100",280,55);
      offsGg.drawString("50",280,105);
      offsGg.drawString("0",280,155);
      offsGg.drawString("-50",280,205);
      offsGg.drawString("-100",280,255);
      for (index=0 ; index <= 4; index ++) {
        offsGg.drawLine(320,50+index*50,330,50+index*50) ;
      }
      offsGg.setColor(Color.red) ;
      offsGg.fillRect(332,ther,27,270-ther) ;
         // Printed temperature
      offsGg.setColor(Color.white) ;
      offsGg.fillRect(300,330,70,30) ;
      offsGg.setColor(Color.black) ; 
      offsGg.drawString("Temp. = ",230,350);
      offsGg.drawString(Float.toString(tempo),300,350);

         // Pressure Gage
      ey[0] = prs ;
      ey[1] = prs - 5;
      ey[2] = prs + 5;
      offsGg.setColor(Color.black) ;
      offsGg.fillRect(415,20,80,305) ;
      offsGg.setColor(Color.yellow) ;
      offsGg.fillRect(424,prs-2,20,5) ;
      offsGg.fillPolygon(ex,ey,3) ;
      offsGg.drawString("psi",420,320);
      offsGg.drawString("15",470,35);
      offsGg.drawString("10",470,135);
      offsGg.drawString("5",470,235);
      offsGg.drawString("1",470,315);
      for (index=0 ; index <= 14; index ++) {
        offsGg.drawLine(450,30+index*20,470,30+index*20) ;
      }
         // Printed pressure
      offsGg.setColor(Color.white) ;
      offsGg.fillRect(450,330,55,30) ;
      offsGg.setColor(Color.black) ; 
      offsGg.drawString("Press. = ",380,350);
      offsGg.drawString(Float.toString(preso),450,350);
 
      g.drawImage(offscreenImg,0,0,this) ;
  }
}