/*
                             CurveBall
                 Kiosk  Version  -- some buttons disabled
   
                           A Java Applet
            to calculate the flight trajectory of a cruve ball
                          Based on FoilSim II

                     Version 1.7e   - 14 May 12

                              Written by 

                              Tom Benson
                       NASA Glenn Research Center

                             Peter Sherman
                       Lakeside High School, Seattle, WA      

>                              NOTICE
>This software is in the Public Domain.  It may be freely copied and used in
>non-commercial products, assuming proper credit to the author is given.  IT
>MAY NOT BE RESOLD.  If you want to use the software for commercial
>products, contact the author.
>No copyright is claimed in the United States under Title 17, U. S. Code.
>This software is provided "as is" without any warranty of any kind, either
>express, implied, or statutory, including, but not limited to, any warranty
>that the software will conform to specifications, any implied warranties of
>merchantability, fitness for a particular purpose, and freedom from
>infringement, and any warranty that the documentation will conform to the
>program, or any warranty that the software will be error free.
>In no event shall NASA be liable for any damages, including, but not
>limited to direct, indirect, special or consequential damages, arising out
>of, resulting from, or in any way connected with this software, whether or
>not based on warranty, contract, tort or otherwise, whether or not injury
>was sustained by persons or property or otherwise, and whether or not loss
>was sustained from, or arose out of the results of, or use of, the software
>or services provided hereunder.
 
  New test -
             * add second graphics
             * re-organize input panels
             * change defaults (reset) for Cleveland
             * add hot day - cold day
             * correct ball size   (rball = .12)
             * improve analysis    (integrated cylinder)
             * add lift coefficient  (Cl = .15)
 
             * change computation scheme to flight integration
             *     save pitch option
             * include the drag
             * include 3rd dimension
             *    add vertical equation
             *    vary the spin axis
             * add input panel for spin direction
             * add view from the catcher 
             * keep record of pitch results (inches)
             * add "specify" option to weather
             * add softball aerodynamics and weight
             * add "specify" option to ball weight / diameter / cd
             * add softball diamond .. 
             *    shorter distance to home 
             *    no mound
             *    release point 
                  change limits on height (underhand) 
              
                                           TJB  14 May 12

*/

import java.awt.*;
import java.lang.Math ;

public class Ball extends java.applet.Applet {
 
   static double convdr = 3.1415926/180. ;
   static double pid2 = 3.1415926/2.0 ;
   static double rval,ycval,xcval,gamval,alfval,thkval,camval,chrd,cl ;
   static double thkinpt,caminpt ;                 /* MODS 10 Sep 99 */
   static double leg,teg,lem,tem;
   static double usq,vsq,alt,altmax,area,armax,armin ;
   static double chord,span,aspr,arold,chrdold,spnold ; /* Mod 13 Jan 00 */
   static double q0,ps0,pt0,ts0,rho,rlhum,temf,presm ;
   static double lyg,lrg,lthg,lxgt,lygt,lrgt,lthgt;/* MOD 20 Jul */
   static double lxm,lym,lxmt,lymt,vxdir;/* MOD 20 Jul */
   static double deltb,xflow ;             /* MODS  20 Jul 99 */
   static double delx,delt,vfsd,spin,spindr ;
   static double vel,pres,lift,side,omega,radcrv ;
       // pitch data
   static double deltim,ptim,spd,wball,lpit,rball,bdiam,cd,drag,wtrat ;
   static double relsy,relsz,relsx,yangr,zangr,sangr,relsdr ;
   static double zacc,zvel,zloc ;
   static double yacc,yvel,yloc ;
   static double xacc,xvel,xloc ;

   static double rg[][]  = new double[20][40] ; 
   static double thg[][] = new double[20][40] ; 
   static double xg[][]  = new double[20][40] ; 
   static double yg[][]  = new double[20][40] ; 
   static double xm[][]  = new double[20][40] ; 
   static double ym[][]  = new double[20][40] ; 

   int nptc,npt2,nlnc,nln2,rdflag,browflag;
   int foil,flflag,lunits,lftout,planet,wthopt,place,balflag,iball ;
   int conflag,displ,antim1,ancol1,antim2,ancol2; 
       /* units data */
   static double vmn1,vmn2,vmn3,vmn4,vmn5,vmn6,vmn7,vmn8 ;
   static double vmx1,vmx2,vmx3,vmx4,vmx5,vmx6,vmx7,vmx8 ;
   static double vconv,vmaxa,vmaxb ;
   static double pconv,pmax,pmin,lconv,fconv,fmax,fmaxb;
   int lflag,gflag,plscale,nond;
       /*  plot & probe data */
   static double fact,fact2,xpval,ypval,pbval;
   static double prg,pthg,pxg,pyg,pxm,pym ;
   int ptchflag,pboflag,xt,ytt,yts,xtc,xt2,yt2,ntikx,ntiky,npt,nptb ;
   int lines,nord,nabs,ntr,pitch,comp,call,nsav ;
   static int[] npts = new int[5];
   static double begx,endx,begy,endy,begz,endz ;
   static String labx,labxu,laby,labyu ;
   static double posx[][]  = new double[5][75] ;
   static double posy[][]  = new double[5][75] ;
   static double posz[][]  = new double[5][75] ;
   static double yoff[] = new double[5] ;
   static double zoff[] = new double[5] ;
   static double pltrg[]  = new double[2] ;
   static double plthg1[]  = new double[2] ;
   static double plthg2[]  = new double[2] ;
   static double pltxg[]  = new double[2] ;
   static double pltyg[]  = new double[2] ;

   Solver solve ;
   View1 view1 ;
   Inp inp;
   Image offscreenImg ;
   Graphics offsGg ;
   Image offImg3 ;
   Graphics off3Gg ;
   Image offImg4 ;
   Graphics off4Gg ;

   public void init() {
     int i;
     Ball a = new Ball() ;
     solve = new Solver() ;

     offscreenImg = createImage(this.size().width,
                      this.size().height) ;
     offsGg = offscreenImg.getGraphics() ;
     offImg3 = createImage(this.size().width,
                      this.size().height) ;
     off3Gg = offImg3.getGraphics() ;
     offImg4 = createImage(this.size().width,
                      this.size().height) ;
     off4Gg = offImg4.getGraphics() ;

     setLayout(new GridLayout(2,1,5,5)) ;

     solve.setDefaults () ;
 
     view1  = new View1(this) ;
     inp = new Inp(this) ;

     add(view1) ;
     add(inp) ;

     solve.getFreeStream ();
     computeFlow () ;
     view1.start() ;
  }
 
  public Insets insets() {
     return new Insets(10,10,10,10) ;
  }

  public void computeFlow() { 

     if (flflag == 1) {
         solve.getCirc ();                   /* get circulation */
         solve.genFlow () ;
         solve.getFreeStream () ;
     }
 
     loadOut() ;

     view1.loadPlot() ;

  }

  public int filter0(double inumbr) {
        //  output only to .
       int number ;
       int intermed ;
 
       number = (int) (inumbr);
       return number ;
  }

  public float filter1(double inumbr) {
     //  output only to .1
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 10.) ;
       number = (float) (intermed / 10. );
       return number ;
  }
 
  public float filter2(double inumbr) {
     //  output only to .01
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 100.) ;
       number = (float) (intermed / 100. );
       return number ;
  }
 
  public float filter3(double inumbr) {
     //  output only to .001
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 1000.) ;
       number = (float) (intermed / 1000. );
       return number ;
  }
 
  public float filter5(double inumbr) {
     //  output only to .00001
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 100000.) ;
       number = (float) (intermed / 100000. );
       return number ;
  }
 
  public void setUnits() {   // Switching Units
       double ovs,chords,spans,aros,chos,spos ;
       double alts,ares ;

       alts = alt / lconv ;
       chords = chord / lconv ;
       spans = span / lconv ;
       ares = area /lconv/lconv ;
       aros = arold /lconv/lconv ;
       chos = chrdold / lconv ;
       spos = spnold / lconv ;
       ovs = vfsd / vconv ;

       switch (lunits) {
          case 0: {                             /* English */
            lconv = 1.;                      /*  feet    */
            vconv = .6818; vmaxa = 100.; vmaxb = 100. ;  /*  mph  */
            fconv = 1.0; fmax = 100000.; fmaxb = .5;  /* pounds   */
            pconv = 14.7  ;                   /* lb/sq in */
            break;
          }
          case 1: {                             /* Metric */
            lconv = .3048;                    /* meters */
            vconv = 1.097;  vmaxa = 167.; vmaxb = 167.;   /* km/hr  */
            fconv = 4.448 ; fmax = 500000.; fmaxb = 2.5; /* newtons */
            pconv = 101.3 ;               /* kilo-pascals */
            break ;
          }
       }
 
       alt = alts * lconv ;
       chord = chords * lconv ;
       span = spans * lconv ;
       area = ares * lconv * lconv ;
       arold = aros * lconv * lconv ;
       chrdold = chos * lconv ;
       spnold = spos * lconv ;
       vfsd  = ovs * vconv;

       return ;
  }

  public void loadProb() {   // load the input panel
       int i1,i2,i3,i4,i5,i6,i7,i8 ;
       double v1,v2,v3,v4,v5,v6,v7,v8 ;
       float fl1,fl2,fl3,fl4,fl5,fl6,fl7,fl8 ;
       String outpres,outtemp,outhum,outht ;
       String outspd,outspin,outang ;

       outpres = " in Hg" ;
       outtemp = " deg F" ;
       outhum = " %" ;
       outht = " feet" ;
       outspd = " mph" ;
       outspin = " rpm" ;
       outang = " deg" ;

       v1 = 0.0 ;
       v2 = 0.0 ;
       v3 = 0.0 ;
       v4 = 0.0 ;
       v5 = 0.0 ;
       v6 = 0.0 ;
       v7 = 0.0 ;
       v8 = 0.0 ;

       switch (lunits)  {
          case 0: {                             /* English */
              inp.m.mdl.mdll.o1.setText(String.valueOf(
                                          filter3(presm))) ;
              inp.m.mdl.mdll.o2.setText(String.valueOf(
                                         filter0(ts0 - 460.))) ;
              inp.m.mdl.mdll.o3.setText(String.valueOf(
                                          filter0(rlhum * 100.))) ;
              inp.m.mdl.mdll.o4.setText(String.valueOf(
                                         filter0(alt))) ;
              break;
           }
           case 1: {                             /* Metric */
              inp.m.mdl.mdll.o1.setText(String.valueOf(
                                          filter3(101.3/14.7*ps0/144.))) ;
              inp.m.mdl.mdll.o2.setText(String.valueOf(
                                         filter0(ts0*5.0/9.0 - 273.1))) ;
              inp.m.mdl.mdll.o3.setText(String.valueOf(
                                          filter0(rlhum*100.))) ;
              inp.m.mdl.mdll.o4.setText(String.valueOf(
                                         filter0(alt))) ;
              break ;
           }
       }

       v1 = vfsd ;
       vmn1 = 30.0;   vmx1= 105. ;
       v2 = spin * 60.0 ;
       vmn2 = -2000.0; vmx2 = 2060.0 ;
       v3 = relsy * lconv / relsdr ;
       vmn3 = 0.0;   vmx3 = 4.0 * lconv ;
       v4 = yangr ;
       vmn4 = -15.0;   vmx4 = 15.0 ;
       v5 = relsz * lconv ;
       vmn5 = 1.0;   vmx5 = 8.0 * lconv ;
       v6 = zangr ;
       vmn6 = -15.0;   vmx6 = 15.0 ;
       v7 = sangr ;
       vmn7 = -90.0;   vmx7 = 90.0 ;
       v8 = relsx * lconv ;
       vmn8 = -8.0;   vmx8 = 0.0 ;

       fl1 = (float) v1 ;
       fl2 = (float) v2 ;
       fl3 = (float) v3 ;
       fl4 = (float) v4 ;
       fl5 = (float) v5 ;
       fl6 = (float) v6 ;
       fl7 = (float) v7 ;
       fl8 = (float) v8 ;

       inp.l.lol1.f1.setText(String.valueOf(filter0(v1))) ;
       inp.l.lol1.f2.setText(String.valueOf(filter0(v2))) ;
       inp.l.lol1.f7.setText(String.valueOf(filter2(v7))) ;

       inp.l.lor1.f5.setText(String.valueOf(filter3(v5))) ;
       inp.l.lor1.f6.setText(String.valueOf(filter2(v6))) ;
       inp.l.lor1.f3.setText(String.valueOf(filter3(v3))) ;
       inp.l.lor1.f4.setText(String.valueOf(filter2(v4))) ;
       inp.l.lor1.f8.setText(String.valueOf(filter2(v8))) ;

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
       i5 = (int) (((v5 - vmn5)/(vmx5-vmn5))*1000.) ;
       i6 = (int) (((v6 - vmn6)/(vmx6-vmn6))*1000.) ;
       i7 = (int) (((v7 - vmn7)/(vmx7-vmn7))*1000.) ;
       i8 = (int) (((v8 - vmn8)/(vmx8-vmn8))*1000.) ;

       inp.l.lol2.s1.setValue(i1) ;
       inp.l.lol2.s2.setValue(i2) ;
       inp.l.lor2.s3.setValue(i3) ;
       inp.l.lor2.s4.setValue(i4) ;
       inp.l.lor2.s5.setValue(i5) ;
       inp.l.lor2.s6.setValue(i6) ;
       inp.l.lol2.s7.setValue(i7) ;
       inp.l.lor2.s8.setValue(i8) ;

       computeFlow() ;
       return ;
  }

  public void loadOut() {   // output routine
      String outpres,outtemp,outhum,outht ;

      outpres = " in Hg" ;
      outtemp = " deg F" ;
      outhum = " %" ;
      outht = " feet" ;

      if (conflag == 1) {
        switch (lunits)  {
          case 0: {                             /* English */
              inp.m.mdl.mdll.o1.setText(String.valueOf(
                                          filter3(presm))) ;
              inp.m.mdl.mdll.o2.setText(String.valueOf(
                                          filter0(ts0 - 460.))) ;
              inp.m.mdl.mdll.o3.setText(String.valueOf(
                                          filter0(rlhum * 100.))) ;
              inp.m.mdl.mdll.o4.setText(String.valueOf(
                                          filter0(alt))) ;
              break;
           }
           case 1: {                             /* Metric */
              inp.m.mdl.mdll.o1.setText(String.valueOf(
                                          filter3(101.3/14.7*ps0/144.))) ;
              inp.m.mdl.mdll.o2.setText(String.valueOf(
                                          filter0(ts0*5.0/9.0 - 273.1))) ;
              inp.m.mdl.mdll.o3.setText(String.valueOf(
                                          filter0(rlhum*100.))) ;
              inp.m.mdl.mdll.o4.setText(String.valueOf(
                                          filter0(alt))) ;
              break ;
           }
        }
     }
     return ;
  }

  class Solver {
 
     Solver () {
     }

     public void setDefaults() {

        planet = 0 ;
        wtrat = 1.0 ;
        wthopt = 0 ;
        place = 0 ;
        lunits = 0 ;
        lftout = 0 ;
        nlnc = 15 ;
        nln2 = nlnc/2 + 1 ;
        nptc = 37 ;
        npt2 = nptc/2 + 1 ;
        deltb = .5 ;
        foil = 0 ;
        flflag = 1;
        thkval = .5 ;
        thkinpt = 12.5 ;                   /* MODS 10 SEP 99 */
        camval = 0.0 ;
        caminpt = 0.0 ;
        alfval = 0.0 ;
        gamval = 0.0 ;
        spin = 33.33 ;
        spindr = -1.0 ;
        rval = 1.0 ;
        ycval = 0.0 ;
        xcval = 0.0 ;
        conflag = 2 ;                             /* MODS  2 Apr 99 */
        displ = 0 ;                              /* MODS  22 Apr 99 */
        relsy = 3.0 ;
        relsz = 6.0 ;
        relsx = 0.0 ;
        relsdr = 1.0 ;
        yangr = -0.5 ;
        zangr = 1.0 ;
        sangr = 0.0 ;
 
        xpval = 2.1;
        ypval = -.5 ;
        pboflag = 0 ;
        xflow = -10.0;                             /* MODS  20 Jul 99 */

        pconv = 14.7;
        pmin = .5 ;
        pmax = 1.0 ;
        fconv = 1.0 ;
        fmax = 100000. ;
        fmaxb = .50 ;
        vconv = .6818 ;
        vfsd = 80. ;
        vmaxa = 100. ;
        vmaxb = 100. ;
        lconv = 1.0 ;

        balflag = 0;
        iball = 0 ;
        wball = 5.0 / 16. ;     // weight of baseball = 5 oz. 
        rball = .12 ;           //  baseball radius = .12 ft (2.88 in)
        bdiam = rball * 12.0 * 2.0 ;
        lpit = 60.5 ;           // distance to home plate in ft 
        area = 3.14159 * rball * rball ;
        cd = .3 ;
 
        nsav = 0 ;
        pitch = 0 ;
        comp = 0 ;
        call = 0 ;
        zacc = 32.2 ; zvel = 0.0; zloc = relsz;
        yacc = 0.0;   yvel = 0.0; yloc = relsy;
        xacc = 0.0;   xvel = vfsd; xloc = relsx ;

        alt = 700.0 ;
        altmax = 50000. ;
        chrdold = chord = 2.0 ;
        spnold = span = 10.0 ;
        aspr = 5.0 ;
        armax = 1000.01 ;
        armin = .01 ;                 /* MODS 9 SEP 99 */
        presm = 29.172 ;
        temf  = 60.0 ;
        ts0 = temf + 459.6 ;
        rlhum = 0.0 ;

        xt = 400 ;
        xtc = 325 ;
        ytt = 360 ;
        yts = 150 ;
        fact = 50. ;
        xt2 = 320 ;
        yt2 = 55 ;
        fact2 = 25. ;
        pltxg[1] = 0.0 ;
        pltyg[1] = 1.0 ;
        plthg1[1] = 0.0 ;
        plthg2[1] = 0.0 ;
        pltrg[1] = 1.0 ;
        begy=-10.; endy=10. ; 
        begx=-65. ; endx=0. ; 
        begz= 0. ; endz=20. ; 
        nptb = 1;
 
        vmn1 = 30.0;     vmx1 = 105.0 ;
        vmn2 = -2000.0;   vmx2 = 2060.0 ;
        vmn3 = 0.0;   vmx3 = 4.0 ;
        vmn4 = -15.0;   vmx4 = 15.0 ;
        vmn5 = 1.0;   vmx5 = 8.0 ;
        vmn6 = -15.0;   vmx6 = 15.0 ;
        vmn7 = -90.0;   vmx7 = 90.0 ;
        vmn8 = -8.0;   vmx8 = 0.0 ;

        return ;
     }

     public void getFreeStream() {    //  free stream conditions
       double hite,pvap,rgas,gama ;       /* MODS  19 Jan 00  whole routine*/

       rgas = 1718. ;                /* ft2/sec2 R */
       gama = 1.4 ;
       hite = alt/lconv ;
       if (planet == 0) {    // Earth  standard day
         if (conflag == 1) {
           if (hite <= 36152.) {           // Troposphere
              ts0 = 518.6 - 3.56 * hite/1000. ;
              ps0 = 2116. * Math.pow(ts0/518.6,5.256) ;
           }
           if (hite >= 36152. && hite <= 82345.) {   // Stratosphere
              ts0 = 389.98 ;
              ps0 = 2116. * .2236 *
                 Math.exp((36000.-hite)/(53.35*389.98)) ;
           }
           if (hite >= 82345.) {
              ts0 = 389.98 + 1.645 * (hite-82345)/1000. ;
              ps0 = 2116. *.02456 * Math.pow(ts0/389.98,-11.388) ;
           }
           if (place == 0) {
             if(wthopt == 0) ts0 = 519.6 ;
             if(wthopt == 1) ts0 = 549.6 ;
             if(wthopt == 2) ts0 = 494.6 ;
             if(wthopt == 3) ts0 = 549.6 ;
           }
           if (wthopt <= 2) {
               rlhum = 0.0 ;
           }
           if (wthopt == 3) {
               rlhum = 1.0 ;
           }
           temf = ts0 - 459.6 ;
           if (temf <= 0.0) temf = 0.0 ;                    
           presm = ps0 * 29.92 / 2116. ;
         }
         if (conflag == 2) {
            ts0 = temf + 459.6 ;
            if (temf < 0.0) {
                  temf = 0.0 ;
                  rlhum = 0.0 ;
            }
            ps0 = presm * 2116. / 29.92 ;
         }
         pvap = rlhum*(2.685+.00353*Math.pow(temf,2.245));/* Eq 1:6A  Domasch */
         rho = (ps0 - .379*pvap)/(rgas * ts0) ;  /* effect of humidty */
       }

       if (planet == 1) {   // Mars - curve fit of orbiter data
         rgas = 1149. ;                /* ft2/sec2 R */
         gama = 1.29 ;

         if (hite <= 22960.) {
            ts0 = 434.02 - .548 * hite/1000. ;
            ps0 = 14.62 * Math.pow(2.71828,-.00003 * hite) ;
         }
         if (hite > 22960.) {
            ts0 = 449.36 - 1.217 * hite/1000. ;
            ps0 = 14.62 * Math.pow(2.71828,-.00003 * hite) ;
         }
         rho = ps0/(rgas*ts0) ;
         presm = ps0 * 29.92 / 2116. ;
       }

       q0  = .5 * rho * vfsd * vfsd / (vconv * vconv) ;
       pt0 = ps0 + q0 ;

       return ;
     }

     public void getCirc() {   // circulation from Kutta condition
       double thet,rdm,thtm ;
       double beta;
       int index;

       xcval = 0.0 ;
       switch (foil)  {
          case 0: {         /* get circulation from spin for baseball */
              gamval = 4.0 * 3.1415926 * 3.1415926 *spin * rball * rball
                                 / (vfsd/vconv) ;
              gamval = gamval * spindr ;
              ycval = .0001 ;
              break ;
          }
          case 1:  {                  /* Juokowski geometry*/
              ycval = camval / 2.0 ;
              rval = thkval/4.0 +Math.sqrt(thkval*thkval/16.0+ycval*ycval +1.0);
              xcval = 1.0 - Math.sqrt(rval*rval - ycval*ycval) ;
              beta = Math.asin(ycval/rval)/convdr ;     /* Kutta condition */
              gamval = 2.0*rval*Math.sin((alfval+beta)*convdr) ;
              break ;
          }
          case 2:  {                  /* Elliptical geometry*/
              ycval = camval / 2.0 ;
              rval = thkval/4.0 + Math.sqrt(thkval*thkval/16.0+ycval*ycval+1.0);
              beta = Math.asin(ycval/rval)/convdr ;    /* Kutta condition */
              gamval = 2.0*rval*Math.sin((alfval+beta)*convdr) ;
              break ;
          }
       }
                                                   /* geometry */
       for (index =1; index <= nptc; ++index) {
           thet = (index -1)*360./(nptc-1) ;
           xg[0][index] = rval * Math.cos(convdr * thet) + xcval ;
           yg[0][index] = rval * Math.sin(convdr * thet) + ycval ;
           rg[0][index] = Math.sqrt(xg[0][index]*xg[0][index] +
                                    yg[0][index]*yg[0][index])  ;
           thg[0][index] = Math.atan2(yg[0][index],xg[0][index])/convdr;
           xm[0][index] = (rg[0][index] + 1.0/rg[0][index])*
                        Math.cos(convdr*thg[0][index]) ;
           ym[0][index] = (rg[0][index] - 1.0/rg[0][index])*
                        Math.sin(convdr*thg[0][index]) ;
           rdm = Math.sqrt(xm[0][index]*xm[0][index] +
                           ym[0][index]*ym[0][index])  ;
           thtm = Math.atan2(ym[0][index],xm[0][index])/convdr;
           xm[0][index] = rdm * Math.cos((thtm - alfval)*convdr);
           ym[0][index] = rdm * Math.sin((thtm - alfval)*convdr);
           getVel(rval,thet) ;
       }

       return ;
     }

     public void genFlow() {   // generate flowfield
       double rnew,thet,psv,fxg;
       int k,index;
                              /* all lines of flow  except stagnation line*/
       for (k=1; k<=nlnc; ++k) {
         psv = -.5*(nln2-1) + .5*(k-1) ;
         fxg = xflow ;
         for (index =1; index <=nptc; ++ index) {
           solve.getPoints (fxg,psv) ;
           xg[k][index]  = lxgt ;
           yg[k][index]  = lygt ;
           rg[k][index]  = lrgt ;
           thg[k][index] = lthgt ;
           xm[k][index]  = lxmt ;
           ym[k][index]  = lymt ;
           solve.getVel(lrg,lthg) ;
           fxg = fxg + vxdir*deltb ;
         }
       }
                                              /*  stagnation line */
       k = nln2 ;
       psv = 0.0 ;
                                              /*  incoming flow */
       for (index =1; index <= npt2; ++ index) {
           rnew = 10.0 - (10.0 - rval)*Math.sin(pid2*(index-1)/(npt2-1)) ;
           thet = Math.asin(.999*(psv - gamval*Math.log(rnew/rval))/
                                   (rnew - rval*rval/rnew)) ;
           fxg =  - rnew * Math.cos(thet) ;
           solve.getPoints (fxg,psv) ;
           xg[k][index]  = lxgt ;
           yg[k][index]  = lygt ;
           rg[k][index]  = lrgt ;
           thg[k][index] = lthgt ;
           xm[k][index]  = lxmt ;
           ym[k][index]  = lymt ;
       }
                                              /*  downstream flow */
       for (index = 1; index <= npt2; ++ index) {
           rnew = 10.0 + .01 - (10.0 - rval)*Math.cos(pid2*(index-1)/(npt2-1)) ;
           thet = Math.asin(.999*(psv - gamval*Math.log(rnew/rval))/
                                      (rnew - rval*rval/rnew)) ;
           fxg =   rnew * Math.cos(thet) ;
           solve.getPoints (fxg,psv) ;
           xg[k][npt2+index]  = lxgt ;
           yg[k][npt2+index]  = lygt ;
           rg[k][npt2+index]  = lrgt ;
           thg[k][npt2+index] = lthgt ;
           xm[k][npt2+index]  = lxmt ;
           ym[k][npt2+index]  = lymt ;
       }
                                              /*  stagnation point */
       xg[k][npt2]  = xcval ;
       yg[k][npt2]  = ycval ;
       rg[k][npt2]  = Math.sqrt(xcval*xcval+ycval*ycval) ;
       thg[k][npt2] = Math.atan2(ycval,xcval)/convdr ;
       xm[k][npt2]  = (xm[k][npt2+1] + xm[k][npt2-1])/2.0 ;
       ym[k][npt2]  = (ym[0][nptc/4+1] + ym[0][nptc/4*3+1])/2.0 ;
                                /*  compute lift coefficient */
       leg = xcval - Math.sqrt(rval*rval - ycval*ycval) ;
       teg = xcval + Math.sqrt(rval*rval - ycval*ycval) ;
       lem = leg + 1.0/leg ;
       tem = teg + 1.0/teg ;
       chrd = tem - lem ;
       cl = gamval*4.0*3.1415926/chrd ;

       return ;
     }

     public void getPoints(double fxg, double psv) {   // flow in x-psi
       double radm,thetm ;                /* MODS  20 Jul 99  whole routine*/
       double fnew,ynew,yold,rfac,deriv ;
       double xold,xnew,thet ;
       double rmin,rmax ;
       int iter,isign;
                       /* get variables in the generating plane */
                           /* iterate to find value of yg */
       ynew = 10.0 ;
       yold = 10.0 ;
       if (psv < 0.0) ynew = -10.0 ;
       if (Math.abs(psv) < .001 && alfval < 0.0) ynew = rval ;
       if (Math.abs(psv) < .001 && alfval >= 0.0) ynew = -rval ;
       fnew = 0.1 ;
       iter = 1 ;
       while (Math.abs(fnew) >= .00001 && iter < 25) {
           ++iter ;
           rfac = fxg*fxg + ynew*ynew ;
           if (rfac < rval*rval) rfac = rval*rval + .01 ;
           fnew = psv - ynew*(1.0 - rval*rval/rfac)
                  - gamval*Math.log(Math.sqrt(rfac)/rval) ;
           deriv = - (1.0 - rval*rval/rfac)
               - 2.0 * ynew*ynew*rval*rval/(rfac*rfac)
               - gamval * ynew / rfac ;
           yold = ynew ;
           ynew = yold  - .5*fnew/deriv ;
       }
       lyg = yold ;
                                     /* rotate for angle of attack */
       lrg = Math.sqrt(fxg*fxg + lyg*lyg) ;
       lthg = Math.atan2(lyg,fxg)/convdr ;
       lxgt = lrg * Math.cos(convdr*(lthg + alfval)) ;
       lygt = lrg * Math.sin(convdr*(lthg + alfval)) ;
                              /* translate cylinder to generate airfoil */
       lxgt = lxgt + xcval ;
       lygt = lygt + ycval ;
       lrgt = Math.sqrt(lxgt*lxgt + lygt*lygt) ;
       lthgt = Math.atan2(lygt,lxgt)/convdr ;
                               /*  Kutta-Joukowski mapping */
       lxm = (lrgt + 1.0/lrgt)*Math.cos(convdr*lthgt) ;
       lym = (lrgt - 1.0/lrgt)*Math.sin(convdr*lthgt) ;
                              /* tranforms for view fixed with free stream */
                /* take out rotation for angle of attack mapped and cylinder */
       radm = Math.sqrt(lxm*lxm+lym*lym) ;
       thetm = Math.atan2(lym,lxm)/convdr ;
       lxmt = radm*Math.cos(convdr*(thetm-alfval)) ;
       lymt = radm*Math.sin(convdr*(thetm-alfval)) ;

       lxgt = lxgt - xcval ;
       lygt = lygt - ycval ;
       lrgt = Math.sqrt(lxgt*lxgt + lygt*lygt)  ;
       lthgt = Math.atan2(lygt,lxgt)/convdr;
       lxgt = lrgt * Math.cos((lthgt - alfval)*convdr);
       lygt = lrgt * Math.sin((lthgt - alfval)*convdr);

       return ;
     }
 
     public void getVel(double radius, double theta) {  //velocity and pressure 
      double ur,uth,jake1,jake2,jakesq ;
      double xloca,yloca,thrad,alfrad ;

      thrad = convdr * theta ;
      alfrad = convdr * alfval ;
                                /* get x, y location in cylinder plane */
      xloca = radius * Math.cos(thrad) ;
      yloca = radius * Math.sin(thrad) ;
                                /* velocity in cylinder plane */
      ur  = Math.cos(thrad-alfrad)*(1.0-(rval*rval)/(radius*radius)) ;
      uth = -Math.sin(thrad-alfrad)*(1.0+(rval*rval)/(radius*radius))
                            - gamval/radius;
      usq = ur*ur + uth*uth ;
      vxdir = ur * Math.cos(thrad) - uth * Math.sin(thrad) ; // MODS  20 Jul 99 
                                /* translate to generate airfoil  */
      xloca = xloca + xcval ;
      yloca = yloca + ycval ;
                                   /* compute new radius-theta  */
      radius = Math.sqrt(xloca*xloca + yloca*yloca) ;
      thrad  = Math.atan2(yloca,xloca) ;
                                   /* compute Joukowski Jacobian  */
      jake1 = 1.0 - Math.cos(2.0*thrad)/(radius*radius) ;
      jake2 = Math.sin(2.0*thrad)/(radius*radius) ;
      jakesq = jake1*jake1 + jake2*jake2 ;
      if (Math.abs(jakesq) <= .01) jakesq = .01 ;  /* protection */
      vsq = usq / jakesq ;
          /* vel is velocity ratio - pres is coefficient  (p-p0)/q0   */
      if (foil > 0) {
           vel = Math.sqrt(vsq) ;
           pres = 1.0 - vsq ;
      }
      if (foil == 0) {
           vel = Math.sqrt(usq) ;
           pres = 1.0 - usq ;
      }
      return ;
    }
  }
 
  class Inp extends Panel {
     Ball outerparent ;
     M m;
     L l;

     Inp (Ball target) {
          outerparent = target ;
          setLayout(new GridLayout(2,1,5,5)) ;

          m = new M(outerparent) ;
          l = new L(outerparent) ;

          add(l) ;
          add(m) ;
     }

     class M extends Panel {
        Ball outerparent ;
        Mdl mdl ;
        Mdr mdr ;
   
        M (Ball target) { 
          outerparent = target ;
          setLayout(new GridLayout(1,2,5,5)) ;
 
          mdl = new Mdl(outerparent) ;
          mdr = new Mdr(outerparent) ;

          add(mdr) ;  
          add(mdl) ;  
     }

     class Mdl extends Panel {
        Ball outerparent ;
        Mdlu mdlu ;
        Mdll mdll ;

        Mdl (Ball target) { 
          outerparent = target ;
          setLayout(new GridLayout(2,1,5,5)) ;
 
          mdll = new Mdll(outerparent) ;
          mdlu = new Mdlu(outerparent) ;

          add(mdlu) ;  
          add(mdll) ;  
        }

        class Mdlu extends Panel {
           Ball outerparent ;
           Choice placeh,weatch ;
           Label l1,l2 ;

           Mdlu (Ball target) { 
             outerparent = target ;
             setLayout(new GridLayout(2,2,0,0)) ;
    
             placeh = new Choice() ;
             placeh.setForeground(Color.red) ;
             placeh.addItem("Cleveland") ;
             placeh.addItem("Denver") ;
             placeh.addItem("New York") ;
             placeh.addItem("Chicago") ;
             placeh.addItem("Mt.Everest") ;
             placeh.addItem("Mars");
             placeh.select(0) ;
 
             weatch = new Choice() ;
             weatch.setForeground(Color.red) ;
             weatch.addItem("Average Day") ;
             weatch.addItem("Hot Day") ;
             weatch.addItem("Cold Day") ;
             weatch.addItem("Hot, Humid Day") ;
             weatch.addItem("Specify") ;

             l1 = new Label("Set Stadium Location:", Label.RIGHT) ;
             l1.setForeground(Color.red) ;

             l2 = new Label("Set Weather Conditions:", Label.RIGHT) ;
             l2.setForeground(Color.red) ;

             add(l1) ;
             add(placeh) ;

             add(l2) ;
             add(weatch) ;
           }

           public boolean action(Event evt, Object arg) {
              if(evt.target instanceof Choice) {
                  this.handleProb(arg) ;
                  return true ;
              }
              else return false ;
           }

           public void handleProb(Object obj) {
              int i2,i1 ;
    
              planet  = 0 ;
              wthopt  = weatch.getSelectedIndex() ;
              i1 = 0 ;
              if(wthopt == 4) i1 = 1 ;
              i2  = placeh.getSelectedIndex() ;
              switch (i2) {
                 case 0:{                            /* Cleveland */
                        place = 0 ;
                        alt = 700.0 * lconv ;
                        wtrat = 1.0 ;
                        break ;
                 }
                 case 1:{                            /* Denver */
                        place = 0 ;
                        alt = 5280.0 * lconv ;
                        wtrat = 1.0 ;
                        break ;
                 }
                 case 2:{                            /* New York */
                        place = 0 ;
                        alt = 0. * lconv ;
                        wtrat = 1.0 ;
                        break ;
                 }
                 case 3:{                            /* Chicago */
                        place = 0 ;
                        alt = 568. * lconv ;
                        wtrat = 1.0 ;
                        break ;
                 }
                 case 4:{                            /* Mt. Everest */
                        place = 1 ;
                        alt = 29028. * lconv ;
                        wtrat = 1.0 ;
                        break ;
                 }
                 case 5:{                            /* Mars */
                        planet = 1 ;
                        alt = 0.0 * lconv ;
                        wtrat = .333 ;
                        break ;
                 }
              }

              switch (i1) {
                 case 0:{                            /* Standard Day */
                        conflag = 1 ;
                        mdll.o1.setBackground(Color.black) ;
                        mdll.o1.setForeground(Color.cyan) ;
                        mdll.o2.setBackground(Color.black) ;
                        mdll.o2.setForeground(Color.cyan) ;
                        mdll.o3.setBackground(Color.black) ;
                        mdll.o3.setForeground(Color.cyan) ;
                        break ;
                 }
                 case 1:{                            /* Set Conditions */
                        conflag = 2 ;
                        mdll.o1.setBackground(Color.white) ;
                        mdll.o1.setForeground(Color.black) ;
                        mdll.o2.setBackground(Color.white) ;
                        mdll.o2.setForeground(Color.black) ;
                        mdll.o3.setBackground(Color.white) ;
                        mdll.o3.setForeground(Color.black) ;
                        break ;
                 }
              }

              computeFlow() ;
           }
        }

        class Mdll extends Panel {
           Ball outerparent ;
           TextField o1,o2,o3,o4 ;
           Label l1,l2,l3,l4 ;

           Mdll (Ball target) { 
             outerparent = target ;
             setLayout(new GridLayout(3,4,0,0)) ;
 
             l1 = new Label("Press - in. Hg", Label.CENTER) ;
             o1 = new TextField("29.172",5) ;
             o1.setBackground(Color.black) ;
             o1.setForeground(Color.cyan) ;

             l2 = new Label("Temp - deg F", Label.CENTER) ;
             o2 = new TextField("59",5) ;
             o2.setBackground(Color.black) ;
             o2.setForeground(Color.cyan) ;

             l3 = new Label("Humidity - %", Label.CENTER) ;
             o3 = new TextField("0.0",5) ;
             o3.setBackground(Color.black) ;
             o3.setForeground(Color.cyan) ;

             l4 = new Label("Altitude - ft", Label.CENTER) ;
             o4 = new TextField("700.0",5) ;
             o4.setBackground(Color.black) ;
             o4.setForeground(Color.cyan) ;

             add(l1) ;
             add(o1) ;
             add(l3) ;
             add(o3) ;
    
             add(l2) ;
             add(o2) ;
             add(l4) ;
             add(o4) ;
    
             add(new Label(" ", Label.RIGHT)) ;
             add(new Label(" ", Label.RIGHT)) ;
             add(new Label(" ", Label.RIGHT)) ;
             add(new Label(" ", Label.RIGHT)) ;
           }

           public boolean handleEvent(Event evt) {
             if(evt.id == Event.ACTION_EVENT) {
                this.handleText(evt) ;
                return true ;
             }
             else return false ;
           }
 
           public void handleText(Event evt) {
              Double V1,V2,V3 ;
              double v1,v2,v3 ;
              float fl1 ;

              V1 = Double.valueOf(o1.getText()) ;
              v1 = V1.doubleValue() ;
              V2 = Double.valueOf(o2.getText()) ;
              v2 = V2.doubleValue() ;
              V3 = Double.valueOf(o3.getText()) ;
              v3 = V3.doubleValue() ;
 
              if (conflag == 2) {
                 if(v1 < 5.0) {
                    v1 = 5.0 ;
                    fl1 = (float) v1 ;
                    o1.setText(String.valueOf(fl1)) ;
                 }
                 if(v1 > 50.0) {
                    v1 = 50.0 ;
                    fl1 = (float) v1 ;
                    o1.setText(String.valueOf(fl1)) ;
                 }
                 presm = v1 ;
                 temf = v2 ;
                 if(v3 < 1.0) {
                    v3 = 0.0 ;
                    fl1 = (float) v3 ;
                    o3.setText(String.valueOf(fl1)) ;
                 }
                 if(v3 > 100.0) {
                    v3 = 100.0 ;
                    fl1 = (float) v3 ;
                    o3.setText(String.valueOf(fl1)) ;
                 }
                 rlhum = v3 /100. ;
                 computeFlow() ;
              }
           }
        }
     }

     class Mdr extends Panel {
        Ball outerparent ;
        Button ptchbt,butclr,butsav,resbt ;
        TextField o1,o2,o3,o4,o5,o6,o7,o8 ;
        Label l1,l2,l3,l4,l5,l6,l7,l8 ;
        Label lu4,la1,la2 ;

        Mdr (Ball target) { 
          int i1 ;

          outerparent = target ;
          setLayout(new GridLayout(5,4,5,5)) ;
 
          la1 = new Label("Results", Label.CENTER) ;
          la1.setForeground(Color.blue) ;

          ptchbt = new Button("PITCH") ;
          ptchbt.setBackground(Color.green) ;
          ptchbt.setForeground(Color.black) ;

          butclr = new Button("Clear") ;
          butclr.setBackground(Color.white) ;
          butclr.setForeground(Color.blue) ;

          butsav = new Button("Save") ;
          butsav.setBackground(Color.blue) ;
          butsav.setForeground(Color.white) ;

          resbt = new Button("Reset") ;
          resbt.setBackground(Color.orange) ;
          resbt.setForeground(Color.black) ;
 
          l1 = new Label("Instant Speed", Label.CENTER) ;
          o1 = new TextField("0.0 mph ",5) ;
          o1.setBackground(Color.black) ;
          o1.setForeground(Color.cyan) ;

          l2 = new Label("Diameter-in ", Label.RIGHT) ;
          o2 = new TextField("2.9",5) ;
          o2.setBackground(Color.black) ;
          o2.setForeground(Color.cyan) ;

          l3 = new Label("Time", Label.CENTER) ;
          o3 = new TextField("0.0 sec ",5) ;
          o3.setBackground(Color.black) ;
          o3.setForeground(Color.cyan) ;

          l4 = new Label("Weight-oz", Label.RIGHT) ;
          o4 = new TextField("5",5) ;
          o4.setBackground(Color.black) ;
          o4.setForeground(Color.cyan) ;
 
          l5 = new Label("Normal Force", Label.CENTER) ;
          o5 = new TextField("0.0 oz ",5) ;
          o5.setBackground(Color.black) ;
          o5.setForeground(Color.cyan) ;

          l6 = new Label("Drag Force", Label.CENTER) ;
          o6 = new TextField("0 oz",5) ;
          o6.setBackground(Color.black) ;
          o6.setForeground(Color.cyan) ;
  
          l7 = new Label("Drag Coef. - Cd", Label.CENTER) ;
          o7 = new TextField("0.3",5) ;
          o7.setBackground(Color.black) ;
          o7.setForeground(Color.cyan) ;

          l8 = new Label("Distance - ft", Label.RIGHT) ;
          o8 = new TextField("60.5",5) ;
          o8.setBackground(Color.black) ;
          o8.setForeground(Color.cyan) ;
            
          add(l2) ;
          add(o2) ;
          add(l4) ;
          add(o4) ;

          add(l7) ;
          add(o7) ;
          add(l8) ;
          add(o8) ;

          add(ptchbt) ;
          add(butsav) ;
          add(butclr) ;
          add(resbt) ;

          add(l3) ;
          add(o3) ;
          add(l1) ;
          add(o1) ;

          add(l5) ;
          add(o5) ;
          add(l6) ;
          add(o6) ;
        }
 
        public boolean action(Event evt, Object arg) {
            int i,j ;
            Double V7,V4,V2,V8 ;
            double v7,v4,v2,v8 ;
            float fl1 ;

            V7 = Double.valueOf(o7.getText()) ;
            v7 = V7.doubleValue() ;
            V4 = Double.valueOf(o4.getText()) ;
            v4 = V4.doubleValue() ;
            V2 = Double.valueOf(o2.getText()) ;
            v2 = V2.doubleValue() ;
            V8 = Double.valueOf(o8.getText()) ;
            v8 = V8.doubleValue() ;

            if(evt.target instanceof Button) {
               String label = (String)arg ;
               if(label.equals("PITCH")){
                     nptb = 1 ;
                     pitch = 1 ;
                     comp = 1 ;
                     if(balflag == 1) {
                       if(v7 < .05) {
                          v7 = .05 ;
                          fl1 = (float) v7 ;
                          o7.setText(String.valueOf(fl1)) ;
                       }
                       if(v7 > 2.0) {
                          v7 = 2.0 ;
                          fl1 = (float) v7 ;
                          o7.setText(String.valueOf(fl1)) ;
                       }
                       cd = v7 ;
                       if(v4 < .5) {
                          v4 = .5 ;
                          fl1 = (float) v4 ;
                          o4.setText(String.valueOf(fl1)) ;
                       }
                       if(v4 > 32.0) {
                          v4 = 32.0 ;
                          fl1 = (float) v4 ;
                          o4.setText(String.valueOf(fl1)) ;
                       }
                       wball = v4 / 16.0 ;
                       if(v2 < .5) {
                          v2 = .5 ;
                          fl1 = (float) v2 ;
                          o2.setText(String.valueOf(fl1)) ;
                       }
                       if(v2 > 12.0) {
                          v2 = 12.0 ;
                          fl1 = (float) v2 ;
                          o2.setText(String.valueOf(fl1)) ;
                       }
                       bdiam = v2 ;
                       rball = bdiam / 12.0 / 2.0 ;
                       area = 3.1415926 * rball * rball ;
                       if(v8 < 10.0) {
                          v8 = 10.0 ;
                          fl1 = (float) v8 ;
                          o8.setText(String.valueOf(fl1)) ;
                       }
                       if(v8 > 75.0) {
                          v8 = 75.0 ;
                          fl1 = (float) v2 ;
                          o8.setText(String.valueOf(fl1)) ;
                       }
                       lpit = v8 ;
                     }
                     xloc = relsx ;
                     xvel = -vfsd * Math.cos(convdr*yangr) * Math.cos(convdr*zangr) / vconv ;
                     xacc = 0.0 ;
                     yloc = relsy ;
                     yvel = vfsd * Math.sin(convdr*yangr) / vconv ;
                     yacc = 0.0 ;
                     zloc = relsz ;
                     zvel = vfsd * Math.sin(convdr*zangr) / vconv ;
                     zacc = 0.0 ;
                     call = 0 ;
                     npt = 0 ;
                     ptim = 0.0 ;
                     posx[nsav][nptb] = xloc ;
                     posy[nsav][nptb] = yloc ;
                     posz[nsav][nptb] = zloc ;
                     posx[nsav][0] = xloc ;
                     posy[nsav][0] = yloc ;
                     posz[nsav][0] = zloc ;
               }
               if(label.equals("Clear")) {
                 nptb = 1 ;
                 pitch = 0 ;
                 comp = 0 ;
                 nsav = 0 ;
                 for (j=0; j<=4; ++j) {
                   for (i=0; i<=npts[j]; ++i){
                     posx[j][i] = 0.0 ;
                     posy[j][i] = 0.0 ;
                     posz[j][i] = 0.0 ;
                   }
                   npts[j] = 0 ;
                 }
               }
               if(label.equals("Save")) {
                  pitch = 0 ;
                  comp = 0 ;
                  npts[nsav] = npt ;
                  nsav = nsav + 1 ;
                  if (nsav == 5) nsav = 4 ;
                  for (i=0; i<=npts[nsav]; ++i){
                      posx[nsav][i] = 0.0 ;
                      posy[nsav][i] = 0.0 ;
                      posz[nsav][i] = 0.0 ;
                   }
                   npts[nsav] = 0 ;
               }
               if(label.equals("Reset")) {
                  solve.setDefaults() ;
                  inp.l.lol1.ch1.setState(true) ;
                  inp.l.lol1.ch2.setState(false) ;
                  inp.m.mdl.mdlu.placeh.select(0) ;
                  inp.m.mdl.mdlu.weatch.select(0) ;
                  inp.m.mdl.mdll.o1.setBackground(Color.black) ;
                  inp.m.mdl.mdll.o1.setForeground(Color.cyan) ;
                  inp.m.mdl.mdll.o2.setBackground(Color.black) ;
                  inp.m.mdl.mdll.o2.setForeground(Color.cyan) ;
                  inp.m.mdl.mdll.o3.setBackground(Color.black) ;
                  inp.m.mdl.mdll.o3.setForeground(Color.cyan) ;
                  inp.m.mdr.o8.setText(String.valueOf(filter3(lpit))) ;
                  inp.m.mdr.o8.setBackground(Color.black) ;
                  inp.m.mdr.o8.setForeground(Color.cyan) ;
                  inp.m.mdr.o7.setText(String.valueOf(filter3(cd))) ;
                  inp.m.mdr.o7.setBackground(Color.black) ;
                  inp.m.mdr.o7.setForeground(Color.cyan) ;
                  inp.m.mdr.o2.setText(String.valueOf(filter3(bdiam))) ;
                  inp.m.mdr.o2.setBackground(Color.black) ;
                  inp.m.mdr.o2.setForeground(Color.cyan) ;
                  inp.m.mdr.o4.setText(String.valueOf(filter3(wball * 16.0))) ;
                  inp.m.mdr.o4.setBackground(Color.black) ;
                  inp.m.mdr.o4.setForeground(Color.cyan) ;
                  inp.l.lol2.ballch.select(0) ;
                  pitch = 0 ;
                  comp = 0 ;
                  nsav = 0 ;
                  for (j=0; j<=4; ++j) {
                      for (i=0; i<=npts[j]; ++i){
                         posx[j][i] = 0.0 ;
                         posy[j][i] = 0.0 ;
                         posz[j][i] = 0.0 ;
                      }
                      npts[j] = 0 ;
                  }
                  loadProb() ;
               }

               computeFlow() ;
               return true ;
            }
            else return false ;
        }
     }
  }

  class L extends Panel {
     Ball outerparent ;
     Lor1 lor1 ;
     Lor2 lor2 ;
     Lol1 lol1 ;
     Lol2 lol2 ;

     L (Ball target) { 
          outerparent = target ;
          setLayout(new GridLayout(1,4,5,5)) ;
 
          lol1 = new Lol1(outerparent) ;
          lol2 = new Lol2(outerparent) ;
          lor1 = new Lor1(outerparent) ;
          lor2 = new Lor2(outerparent) ;

          add(lol1) ;  
          add(lol2) ;  
          add(lor1) ;  
          add(lor2) ;  
     }

     class Lol1 extends Panel {
        Ball outerparent ;
        TextField f1,f2,f7 ;
        Label l1,l2,l7,lab1,lab2 ;
        Checkbox ch1,ch2 ;
        CheckboxGroup cbg ;

        Lol1 (Ball target) {

         outerparent = target ;
         setLayout(new GridLayout(5,2,5,5)) ;

         lab1 = new Label("CurveBall - Expert", Label.RIGHT) ;
         lab1.setForeground(Color.blue) ;
         lab2 = new Label(" Version 1.7e", Label.LEFT) ;
         lab2.setForeground(Color.blue) ;

         l1 = new Label("Release Vel-mph ", Label.CENTER) ;
         f1 = new TextField("80.0",5) ;

         l2 = new Label("Spin - rpm", Label.CENTER) ;
         f2 = new TextField("2000.0",5) ;

         l7 = new Label("Spin Axis - deg", Label.CENTER) ;
         f7 = new TextField("0.0",5) ;

         cbg = new CheckboxGroup() ;

         ch1 = new Checkbox("Right Hander",cbg,true) ;
         ch2 = new Checkbox("Left Hander",cbg,false) ;

         add(lab1) ;
         add(lab2) ;

         add(ch2) ;
         add(ch1) ;

         add(l1) ;
         add(f1) ;

         add(l2) ;
         add(f2) ;

         add(l7) ;
         add(f7) ;

       }
 
       public boolean handleEvent(Event evt) {
         if(evt.target instanceof Checkbox) {
            this.handleZoom(evt) ;
            return true ;
         }
         else return false ;
       }
 
        public void handleZoom(Object obj) {
            int i1,i2,i3 ;
            Double V3 ;
            double v3 ;
            String outht ;

            outht = " feet" ;

            if (ch1.getState()) {    // righty
                 spindr = -1.0 ;
                 relsdr = 1.0 ;
            }
            if (ch2.getState()) {    // lefty
                 spindr = 1.0 ;
                 relsdr = -1.0 ;
            }

            i3 = l.lor2.s3.getValue() ;
            v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
            relsy = v3 / lconv * relsdr ;
            l.lor1.f3.setText(String.valueOf(filter3(relsy))) ;

            computeFlow() ;
        }
     }

     class Lol2 extends Panel {
        Ball outerparent ;
        Scrollbar s1,s2,s7;
        Choice ballch;
        Label lab1;

        Lol2 (Ball target) {
         int i1,i2,i7 ;

         outerparent = target ;
         setLayout(new GridLayout(5,1,5,5)) ;

         lab1 = new Label("Set Conditions:", Label.CENTER) ;
         lab1.setForeground(Color.red) ;

         i1 = (int) (((80.0 - vmn1)/(vmx1-vmn1))*1000.) ;
         i2 = (int) (((2000.0 - vmn2)/(vmx2-vmn2))*1000.) ;
         i7 = (int) (((0.0 - vmn7)/(vmx7-vmn7))*1000.) ;

         ballch = new Choice() ;
         ballch.setForeground(Color.red) ;
         ballch.addItem(" Baseball ") ;
         ballch.addItem(" Fast Pitch Softball ") ;
         ballch.addItem(" Slow Pitch Softball ") ;
         ballch.addItem(" Specify ") ;
         ballch.select(0) ;

         s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
         s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
         s7 = new Scrollbar(Scrollbar.HORIZONTAL,i7,10,0,1000);

         add(lab1) ;
         add(ballch) ;
         add(s1) ;
         add(s2) ;
         add(s7) ;
       }
 
       public boolean handleEvent(Event evt) {
            if(evt.id == Event.ACTION_EVENT) {
               this.handleBut(evt) ;
               return true ;
            }
            if(evt.id == Event.SCROLL_ABSOLUTE) {
               this.handleBar(evt) ;
               return true ;
            }
            if(evt.id == Event.SCROLL_LINE_DOWN) {
               this.handleBar(evt) ;
               return true ;
            }
            if(evt.id == Event.SCROLL_LINE_UP) {
               this.handleBar(evt) ;
               return true ;
            }
            if(evt.id == Event.SCROLL_PAGE_DOWN) {
               this.handleBar(evt) ;
               return true ;
            }
            if(evt.id == Event.SCROLL_PAGE_UP) {
               this.handleBar(evt) ;
               return true ;
            }
            else return false ;
       }

       public void handleBar(Event evt) {
         int i1,i2,i7 ;
         double v1,v2,v7 ;
         float fl1,fl2,fl7 ;
         String outspd,outspin,outang ;

         outspd = " mph" ;
         outspin = " rpm" ;
         outang = " deg" ;

// Input for computations
         i1 = s1.getValue() ;
         i2 = s2.getValue() ;
         i7 = s7.getValue() ;

         v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
         v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
         v7 = i7 * (vmx7 - vmn7)/ 1000. + vmn7 ;
 
         vfsd = v1 ;
         spin  = v2 ;
         spin = spin/60.0 ;
         sangr = v7 ;

         fl1 = (float) v1 ;
         fl2 = (float) v2 ;
         fl7 = (float) v7 ;
 
         lol1.f1.setText(String.valueOf(filter0(vfsd))) ;
         lol1.f2.setText(String.valueOf(filter0(spin*60.0))) ;
         lol1.f7.setText(String.valueOf(filter2(sangr))) ;

         computeFlow() ;
       }

       public void handleBut(Event evt) {

         iball  = ballch.getSelectedIndex() ;

         switch (iball) {
            case 0:{                            // baseball
                balflag = 0;
                bdiam = 2.87 ;
                wball = 5.0 / 16.0 ;
                cd = .3 ;
                lpit = 60.5 ;
                inp.m.mdr.o8.setText(String.valueOf(filter3(lpit))) ;
                inp.m.mdr.o8.setBackground(Color.black) ;
                inp.m.mdr.o8.setForeground(Color.cyan) ;
                inp.m.mdr.o7.setText(String.valueOf(filter3(cd))) ;
                inp.m.mdr.o7.setBackground(Color.black) ;
                inp.m.mdr.o7.setForeground(Color.cyan) ;
                inp.m.mdr.o2.setText(String.valueOf(filter3(bdiam))) ;
                inp.m.mdr.o2.setBackground(Color.black) ;
                inp.m.mdr.o2.setForeground(Color.cyan) ;
                inp.m.mdr.o4.setText(String.valueOf(filter3(wball * 16.0))) ;
                inp.m.mdr.o4.setBackground(Color.black) ;
                inp.m.mdr.o4.setForeground(Color.cyan) ;
                break ;
            }
            case 1:{                            // fast pitch softball
                balflag = 0;
                bdiam = 3.8 ;
                wball = 6.25 / 16.0 ;
                cd = .4 ;
                lpit = 43. ;   // fast pitch
                inp.m.mdr.o8.setText(String.valueOf(filter3(lpit))) ;
                inp.m.mdr.o8.setBackground(Color.black) ;
                inp.m.mdr.o8.setForeground(Color.yellow) ;
                inp.m.mdr.o7.setText(String.valueOf(filter3(cd))) ;
                inp.m.mdr.o7.setBackground(Color.black) ;
                inp.m.mdr.o7.setForeground(Color.yellow) ;
                inp.m.mdr.o2.setText(String.valueOf(filter3(bdiam))) ;
                inp.m.mdr.o2.setBackground(Color.black) ;
                inp.m.mdr.o2.setForeground(Color.yellow) ;
                inp.m.mdr.o4.setText(String.valueOf(filter3(wball * 16.0))) ;
                inp.m.mdr.o4.setBackground(Color.black) ;
                inp.m.mdr.o4.setForeground(Color.yellow) ;
                break ;
            }
            case 2:{                            // slow pitch softball
                balflag = 0;
                bdiam = 3.8 ;
                wball = 6.25 / 16.0 ;
                cd = .4 ;
                lpit = 50. ;   // slow pitch
                inp.m.mdr.o8.setText(String.valueOf(filter3(lpit))) ;
                inp.m.mdr.o8.setBackground(Color.black) ;
                inp.m.mdr.o8.setForeground(Color.yellow) ;
                inp.m.mdr.o7.setText(String.valueOf(filter3(cd))) ;
                inp.m.mdr.o7.setBackground(Color.black) ;
                inp.m.mdr.o7.setForeground(Color.yellow) ;
                inp.m.mdr.o2.setText(String.valueOf(filter3(bdiam))) ;
                inp.m.mdr.o2.setBackground(Color.black) ;
                inp.m.mdr.o2.setForeground(Color.yellow) ;
                inp.m.mdr.o4.setText(String.valueOf(filter3(wball * 16.0))) ;
                inp.m.mdr.o4.setBackground(Color.black) ;
                inp.m.mdr.o4.setForeground(Color.yellow) ;
                break ;
            }
            case 3:{                            // input ball parameters
                balflag = 1;
                inp.m.mdr.o8.setBackground(Color.white) ;
                inp.m.mdr.o8.setForeground(Color.black) ;
                inp.m.mdr.o7.setBackground(Color.white) ;
                inp.m.mdr.o7.setForeground(Color.black) ;
                inp.m.mdr.o2.setBackground(Color.white) ;
                inp.m.mdr.o2.setForeground(Color.black) ;
                inp.m.mdr.o4.setBackground(Color.white) ;
                inp.m.mdr.o4.setForeground(Color.black) ;
                break ;
            }
         }
         rball = bdiam / 12.0 / 2.0 ;
         area = 3.14159 * rball * rball ;
       }  // end handle but
     }

     class Lor1 extends Panel {
        Ball outerparent ;
        TextField f5,f6,f3,f4,f8 ;
        Label l5,l6,l3,l4,l8,lab1 ;

        Lor1 (Ball target) {

         outerparent = target ;
         setLayout(new GridLayout(6,2,5,5)) ;

         l5 = new Label("Height - Z - feet", Label.CENTER) ;
         f5 = new TextField("6.0",5) ;

         l6 = new Label("Vert Angle - deg", Label.CENTER) ;
         f6 = new TextField("1.0",5) ;

         l3 = new Label("Side - Y - feet", Label.CENTER) ;
         f3 = new TextField("3.0",5) ;

         l4 = new Label("Side Angle - deg", Label.CENTER) ;
         f4 = new TextField("-0.5",5) ;

         l8 = new Label("Dist - X - feet", Label.CENTER) ;
         f8 = new TextField("0.0",5) ;

         add(new Label("Release Point ", Label.CENTER)) ;
         add(new Label(" ", Label.CENTER)) ;

         add(l5) ;
         add(f5) ;

         add(l6) ;
         add(f6) ;

         add(l3) ;
         add(f3) ;

         add(l4) ;
         add(f4) ;

         add(l8) ;
         add(f8) ;
       }
 
       public boolean handleEvent(Event evt) {
         if(evt.id == Event.ACTION_EVENT) {
            this.handleText(evt) ;
            return true ;
         }
         else return false ;
       }
 
       public void handleText(Event evt) {
          Double V5,V6,V3,V4,V8 ;
          double v5,v6,v3,v4,v8 ;
          float fl1 ;
          int i5,i6,i3,i4,i8 ;

          V5 = Double.valueOf(f5.getText()) ;
          v5 = V5.doubleValue() ;
          V6 = Double.valueOf(f6.getText()) ;
          v6 = V6.doubleValue() ;
          V3 = Double.valueOf(f3.getText()) ;
          v3 = V3.doubleValue() ;
          V4 = Double.valueOf(f4.getText()) ;
          v4 = V4.doubleValue() ;
          V8 = Double.valueOf(f8.getText()) ;
          v8 = V8.doubleValue() ;

          relsz = v5 ;
          if(v5 < vmn5) {
             relsz = v5 = vmn5 ;
             fl1 = (float) v5 ;
             f5.setText(String.valueOf(fl1)) ;
          }
          if(v5 > vmx5) {
             relsz = v5 = vmx5 ;
             fl1 = (float) v5 ;
             f5.setText(String.valueOf(fl1)) ;
          }
          relsz = relsz / lconv ;

          zangr = v6 ;
          if(v6 < vmn6) {
             zangr = v6 = vmn6 ;
             fl1 = (float) v6 ;
             f6.setText(String.valueOf(fl1)) ;
          }
          if(v6 > vmx6) {
             zangr = v6 = vmx6 ;
             fl1 = (float) v6 ;
             f6.setText(String.valueOf(fl1)) ;
          }

          relsy = v3 ;
          if(v3 < vmn3) {
             relsy = v3 = vmn3 ;
             fl1 = (float) v3 ;
             f3.setText(String.valueOf(fl1)) ;
          }
          if(v3 > vmx3) {
             relsy = v3 = vmx3 ;
             fl1 = (float) v3 ;
             f3.setText(String.valueOf(fl1)) ;
          }
          relsy = relsy / lconv * relsdr ;

          yangr = v4 ;
          if(v4 < vmn4) {
             yangr = v4 = vmn4 ;
             fl1 = (float) v4 ;
             f4.setText(String.valueOf(fl1)) ;
          }
          if(v4 > vmx4) {
             yangr = v4 = vmx4 ;
             fl1 = (float) v4 ;
             f4.setText(String.valueOf(fl1)) ;
          }

          relsx = v8 ;
          if(v8 < vmn8) {
             relsx = v8 = vmn8 ;
             fl1 = (float) v8 ;
             f8.setText(String.valueOf(fl1)) ;
          }
          if(v8 > vmx8) {
             relsx = v8 = vmx8 ;
             fl1 = (float) v8 ;
             f8.setText(String.valueOf(fl1)) ;
          }
          relsx = relsx / lconv ;

          i5 = (int) (((v5 - vmn5)/(vmx5-vmn5))*1000.) ;
          i6 = (int) (((v6 - vmn6)/(vmx6-vmn6))*1000.) ;
          i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
          i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
          i8 = (int) (((v8 - vmn8)/(vmx8-vmn8))*1000.) ;

          lor2.s5.setValue(i5) ;
          lor2.s6.setValue(i6) ;
          lor2.s3.setValue(i3) ;
          lor2.s4.setValue(i4) ;
          lor2.s8.setValue(i8) ;
 
          computeFlow() ;
       }
     }

     class Lor2 extends Panel {
        Ball outerparent ;
        Scrollbar s5,s6,s3,s4,s8;
        Label lab1;

        Lor2 (Ball target) {
         int i5,i6,i3,i4,i8 ;

         outerparent = target ;
         setLayout(new GridLayout(6,1,5,5)) ;

         lab1 = new Label("Set Conditions:", Label.CENTER) ;
         lab1.setForeground(Color.red) ;

         i5 = (int) (((6.0 - vmn5)/(vmx5-vmn5))*1000.) ;
         i6 = (int) (((1.0 - vmn6)/(vmx6-vmn6))*1000.) ;
         i3 = (int) (((3.0 - vmn3)/(vmx3-vmn3))*1000.) ;
         i4 = (int) (((-0.5 - vmn4)/(vmx4-vmn4))*1000.) ;
         i8 = (int) (((0.0 - vmn8)/(vmx8-vmn8))*1000.) ;

         s5 = new Scrollbar(Scrollbar.HORIZONTAL,i5,10,0,1000);
         s6 = new Scrollbar(Scrollbar.HORIZONTAL,i6,10,0,1000);
         s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
         s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
         s8 = new Scrollbar(Scrollbar.HORIZONTAL,i8,10,0,1000);

         add(lab1) ;
         add(s5) ;
         add(s6) ;
         add(s3) ;
         add(s4) ;
         add(s8) ;
       }
 
       public boolean handleEvent(Event evt) {
            if(evt.id == Event.ACTION_EVENT) {
               this.handleBar(evt) ;
               return true ;
            }
            if(evt.id == Event.SCROLL_ABSOLUTE) {
               this.handleBar(evt) ;
               return true ;
            }
            if(evt.id == Event.SCROLL_LINE_DOWN) {
               this.handleBar(evt) ;
               return true ;
            }
            if(evt.id == Event.SCROLL_LINE_UP) {
               this.handleBar(evt) ;
               return true ;
            }
            if(evt.id == Event.SCROLL_PAGE_DOWN) {
               this.handleBar(evt) ;
               return true ;
            }
            if(evt.id == Event.SCROLL_PAGE_UP) {
               this.handleBar(evt) ;
               return true ;
            }
            else return false ;
       }

       public void handleBar(Event evt) {
         int i5,i6,i3,i4,i8 ;
         double v5,v6,v3,v4,v8 ;
         float fl5,fl6,fl3,fl4,fl8 ;
         String outspd,outspin,outang,outht ;

         outht = " feet" ;
         outang = " deg" ;

// Input for computations
         i5 = s5.getValue() ;
         i6 = s6.getValue() ;
         i3 = s3.getValue() ;
         i4 = s4.getValue() ;
         i8 = s8.getValue() ;

         v5 = i5 * (vmx5 - vmn5)/ 1000. + vmn5 ;
         v6 = i6 * (vmx6 - vmn6)/ 1000. + vmn6 ;
         v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
         v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
         v8 = i8 * (vmx8 - vmn8)/ 1000. + vmn8 ;
 
         relsz = v5 / lconv  ;
         zangr = v6 ;
         relsy = v3 / lconv * relsdr ;
         yangr = v4 ;
         relsx = v8 / lconv  ;

         fl5 = (float) v5 ;
         fl6 = (float) v6 ;
         fl3 = (float) v3 ;
         fl4 = (float) v4 ;
         fl8 = (float) v8 ;

         lor1.f5.setText(String.valueOf(filter3(relsz))) ;
         lor1.f6.setText(String.valueOf(filter2(zangr))) ;
         lor1.f3.setText(String.valueOf(filter3(relsy))) ;
         lor1.f4.setText(String.valueOf(filter2(yangr))) ;
         lor1.f8.setText(String.valueOf(filter3(relsx))) ;

         computeFlow() ;
       }
     }
   }
  }

  class View1 extends Canvas  
         implements Runnable{
     Ball outerparent ;
     Thread runner ;
     Image displimg,nasaimg ;

     View1 (Ball target) {
         setBackground(Color.black) ;
         runner = null ;
         displimg = getImage(getCodeBase(),"baseball.gif") ;
         nasaimg = getImage(getCodeBase(),"mball3.gif") ;
     }

     public Insets insets() {
        return new Insets(0,10,0,10) ;
     }
 
     public void start() {
        if (runner == null) {
           runner = new Thread(this) ;
           runner.start() ;
        }
        antim1 = 0 ;                              /* MODS  21 JUL 99 */
        ancol1 = 1 ;                              /* MODS  27 JUL 99 */
     }

     public void run() {
       int timer ;
       String outfor,outtim,outspd ;
       double yvld,xvld,zvld,hangle,vangle,deltim;
       double yald,xald,zald;
       double yfor,xfor,zfor;

       outspd = " mph" ;
       outfor = " oz" ;
       outtim = " sec" ;
       timer = 100 ;
       while (true) {
          ++ antim1 ;
          try { Thread.sleep(timer); }
          catch (InterruptedException e) {}
          if (antim1 == 3) {
             antim1 = 0;
             ancol1 = - ancol1 ;               /* MODS 27 JUL 99 */
          }
          timer = 135 - (int) (.227 *vfsd/vconv) ;
                                            // make the ball spin
          plthg1[1] = plthg1[1] - spin*spindr*1.489 ;
          if (plthg1[1] < -360.0) {
                plthg1[1] = plthg1[1] + 360.0 ;
          }
          if (plthg1[1] > 360.0) {
                plthg1[1] = plthg1[1] - 360.0 ;
          }
          plthg1[0] = plthg1[1] + 180.0 ;
          if (plthg1[0] > 270.0) {
                plthg1[0] = plthg1[0] - 360.0 ;
          }

   // new integration scheme
          if (pitch == 1) {
             deltim = .02 ;
             if (comp == 1) {
                zvld = zvel ;
                yvld = yvel ;
                xvld = xvel ;
                zald = zacc ;
                yald = yacc ;
                xald = xacc ;

                hangle = Math.atan2(yvel,xvel) ;
                vangle = Math.atan2(zvel,xvel) ;

                spd = Math.sqrt(yvel*yvel + xvel*xvel + zvel*zvel) ;

                side = gamval * rho * spd*spd; /* lift/ft */
                side = side * rball * 4.0/3.0 * .15 ; // lift integration cl=.15

                drag = cd * .5 * rho * area * spd * spd ;
       // forces
                xfor = side*Math.cos(sangr*convdr)*Math.sin(hangle) 
                        + drag*Math.cos(hangle)*Math.cos(vangle) ;
                yfor = side*Math.cos(sangr*convdr)*Math.cos(hangle)  ;
                zfor = wball + side*Math.sin(sangr*convdr) - drag*Math.sin(vangle) ;
       // acceleration
                xacc =  xfor / wball * 32.2 ; 
                yacc = -yfor / wball * 32.2 ;
                zacc = -zfor / wball * 32.2 * wtrat ;

                xvel = xvel + .5 * (xacc + xald) * deltim ;
                yvel = yvel + .5 * (yacc + yald) * deltim ;
                zvel = zvel + .5 * (zacc + zald) * deltim ;

                xloc = xloc + .5 * (xvel + xvld) * deltim ;
                yloc = yloc + .5 * (yvel + yvld) * deltim ;
                zloc = zloc + .5 * (zvel + zvld) * deltim ;
    
                npt = npt + 1 ;
                ptim = ptim + deltim ;
   
                inp.m.mdr.o5.setText(String.valueOf(
                               filter3(Math.abs(side*fconv*16.0))) + outfor) ;
                inp.m.mdr.o6.setText(String.valueOf(
                               filter3(Math.abs(drag*fconv*16.0))) + outfor) ;
                inp.m.mdr.o4.setText(String.valueOf(
                               filter3(wball*fconv*16.0*wtrat))) ;
                inp.m.mdr.o3.setText(String.valueOf(
                                          filter2(ptim)) + outtim) ;
                inp.m.mdr.o1.setText(String.valueOf(
                                          filter0(spd*vconv)) + outspd) ;
   
                if (zloc <= 0.0) {    // pitch in the dirt
                   comp = 0 ;
                   call = 2 ;
                   zoff[nsav] = zloc ;
                }
                if (Math.abs(xloc) >= lpit) {
                   comp = 0 ;
                   yoff[nsav] = Math.abs (yloc) * 12.0 ;
                   zoff[nsav] = zloc ;
                   call = 1 ;
                }
             }
          }
   // reset integration
          if (pitch == 0) {
              xloc = relsx ;
              xvel = vfsd/vconv ;
              xacc = 0.0 ;
              yloc = relsy ;
              yvel = 0.0 ;
              yacc = 0.0 ;
              ptim = 0.0 ;
              call = 0 ;
          }
   // animate path of ball

          nptb = nptb + 1 ;
          if (nptb >= npt) nptb = npt ;

          posx[nsav][nptb] = xloc ;
          posy[nsav][nptb] = yloc ;
          posz[nsav][nptb] = zloc ;

          view1.repaint() ;
       }
     }

     public void loadPlot() {
       return ;
     }

     public void update(Graphics g) {
        view1.paint(g) ;
     }
 
    public void paint(Graphics g) {
      int i,j,k,n,tbgn,tend ;
      int nump,xpic,ypic ;
      int xlabel,ylabel,ind,inmax,inmin ;
      int exes[] = new int[8] ;
      int whys[] = new int[8] ;
      double offx,scalex;
      double offy,scaley,scalecy;
      double offz,scalez,scalecz;
      double length;
      Color col1,col2,col3 ;

      col1 = new Color(0,121,0) ;   // dark green
      col2 = new Color(254,121,0) ; // dark orange
      col3 = new Color(0,220,220) ; // sky blue

      offx = 0.0 - begx ;
      scalex = 8.0/(endx-begx) ;
      offy = 0.0 - begy ;
      scaley = 4.0/(endy-begy) ;
      offz = 0.0 - begz ;
      scalez = 4.0/(endz-begz) ;
      scalecz = 7.0/(endz-begz) ;
      scalecy = 7.0/(endy-begy) ;

         offsGg.setColor(col1) ;
         offsGg.fillRect(0,0,950,400) ;

  //  Top View

  // pitching mound
         offsGg.setColor(col2) ;
         offsGg.fillOval((int) (fact*scalex*(offx - 8.5)) + xt,
             (int) (fact*scaley*(-offy-5.0)) + ytt,100,100);
  // pitching rubber
         exes[0] = (int) (fact * scalex*(offx - 0.5)) + xt ;
         whys[0] = (int) (fact * scaley*(-offy + 1.0)) + ytt ;
         exes[1] = (int) (fact * scalex*(offx + 0.5)) + xt ;
         whys[1] = (int) (fact * scaley*(-offy + 1.0)) + ytt ;
         exes[2] = (int) (fact * scalex*(offx + 0.5)) + xt ;
         whys[2] = (int) (fact * scaley*(-offy - 1.0)) + ytt ;
         exes[3] = (int) (fact * scalex*(offx - 0.5)) + xt ;
         whys[3] = (int) (fact * scaley*(-offy - 1.0)) + ytt ;
         offsGg.setColor(Color.yellow) ;
         offsGg.fillPolygon(exes,whys,4) ;
 // home plate
         exes[0] = (int) (fact* (scalex*(offx - (lpit + 2.5)))) + xt ;
         whys[0] = (int) (fact* (-scaley*(offy - .75))) + ytt ;
         exes[1] = (int) (fact* (scalex*(offx - (lpit + .1)))) + xt ;
         whys[1] = (int) (fact* (-scaley*(offy - .75))) + ytt ;
         exes[2] = (int) (fact* (scalex*(offx - (lpit + .1)))) + xt ;
         whys[2] = (int) (fact* (-scaley*(offy + .75))) + ytt ;
         exes[3] = (int) (fact* (scalex*(offx - (lpit + 2.5)))) + xt ;
         whys[3] = (int) (fact* (-scaley*(offy + .75))) + ytt ;
         exes[4] = (int) (fact* (scalex*(offx - (lpit + 3.5)))) + xt ;
         whys[4] = (int) (fact* (-scaley*(offy + 0.0))) + ytt ;
         offsGg.setColor(Color.black) ;
         offsGg.fillPolygon(exes,whys,5) ;

         exes[0] = (int) (fact* (scalex*(offx - (lpit + 2.2)))) + xt ;
         whys[0] = (int) (fact* (-scaley*(offy - .6))) + ytt ;
         exes[1] = (int) (fact* (scalex*(offx - (lpit + .4)))) + xt ;
         whys[1] = (int) (fact* (-scaley*(offy - .6))) + ytt ;
         exes[2] = (int) (fact* (scalex*(offx - (lpit + .4)))) + xt ;
         whys[2] = (int) (fact* (-scaley*(offy + .6))) + ytt ;
         exes[3] = (int) (fact* (scalex*(offx - (lpit + 2.2)))) + xt ;
         whys[3] = (int) (fact* (-scaley*(offy + .6))) + ytt ;
         exes[4] = (int) (fact* (scalex*(offx - (lpit + 3.0)))) + xt ;
         whys[4] = (int) (fact* (-scaley*(offy + 0.0))) + ytt ;
         offsGg.setColor(Color.white) ;
         offsGg.fillPolygon(exes,whys,5) ;
 // Foul lines 
         exes[0] = (int) (fact* (scalex*(offx - (lpit + 2.5)))) + xt ;
         whys[0] = (int) (fact* (-scaley*(offy - .75))) + ytt ;
         exes[1] = (int) (fact* (scalex*(offx - (lpit - 57.35)))) + xt ;
         whys[1] = (int) (fact* (-scaley*(offy - 25.5))) + ytt ;
         offsGg.setColor(Color.white) ;
         offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
         exes[0] = (int) (fact* (scalex*(offx - (lpit + 2.5)))) + xt;
         whys[0] = (int) (fact* (-scaley*(offy + .75))) + ytt ;
         exes[1] = (int) (fact* (scalex*(offx - (lpit - 57.35)))) + xt ;
         whys[1] = (int) (fact* (-scaley*(offy + 25.5))) + ytt ;
         offsGg.setColor(Color.white) ;
         offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
 // ball and vector
         if (comp == 0) {
            offsGg.fillOval((int) (fact*scalex*(offx+relsx)) + xt,
             (int) (fact*(-scaley*(offy+relsy))) + ytt - 2,5,5);
            exes[0] = (int) (fact* (scalex*(offx+relsx))) + xt ;
            whys[0] = (int) (fact* (-scaley*(offy+relsy))) + ytt ;
            length = 10.0 * (vfsd / vmaxa) ;
            exes[1] = (int) (fact* (scalex*(offx+relsx - 
                     length * Math.cos(convdr*yangr)))) + xt ;
            whys[1] = (int) (fact* (-scaley*(offy+relsy +
                     length * Math.sin(convdr*yangr)))) + ytt ;
            offsGg.setColor(Color.white) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            exes[0] = exes[1] + 
              (int) (10.0*Math.cos(convdr*yangr) - 4.0*Math.sin(convdr*yangr)) ;
            exes[2] = exes[1] +
              (int) (10.0*Math.cos(convdr*yangr) + 4.0*Math.sin(convdr*yangr)) ;
            whys[0] = whys[1] +
              (int) (10.0*Math.sin(convdr*yangr) + 4.0*Math.cos(convdr*yangr)) ;
            whys[2] = whys[1] +
              (int) (10.0*Math.sin(convdr*yangr) - 4.0*Math.cos(convdr*yangr)) ;
            offsGg.fillPolygon(exes,whys,3) ;
            offsGg.setColor(Color.white) ;
            offsGg.fillOval((int) (fact*scalex*(offx+relsx )) + xt ,
             (int) (fact*(-scaley*(offy+relsy))) + ytt - 5,10,10);
            exes[0] = (int) (fact* (scalex*(offx+relsx + 
                     0.5 * Math.cos(convdr*(plthg1[1] + 180.))))) + xt + 5 ;
            whys[0] = (int) (fact* (-scaley*(offy+relsy +
                     0.5 * Math.sin(convdr*(plthg1[1] + 180.))))) + ytt ;
            exes[1] = (int) (fact* (scalex*(offx+relsx + 
                     0.5 * Math.cos(convdr*plthg1[1])))) + xt + 5 ;
            whys[1] = (int) (fact* (-scaley*(offy+relsy +
                     0.5 * Math.sin(convdr*plthg1[1])))) + ytt ;
            offsGg.setColor(Color.red) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
        }

 // animated pitch
   // saved pitches
         if (nsav >= 1) {
           for (i=0; i<= nsav-1; ++ i) {
              exes[0] = (int) (fact* (scalex*(offx+posx[i][0]))) + xt ;
              whys[0] = (int) (fact* (-scaley*(offy+posy[i][0]))) + ytt ;
              if(i==0) {
                 offsGg.setColor(Color.yellow) ;
                 offsGg.drawString("inches",350,195) ;
              }
              if(i==1) offsGg.setColor(Color.orange) ;
              if(i==2) offsGg.setColor(Color.red) ;
              if(i==3) offsGg.setColor(Color.magenta) ;
              if(i==4) offsGg.setColor(Color.orange) ;
              offsGg.fillOval(exes[0],whys[0],5,5);
              nump = npts[i] ;
              for (j=1; j<=nump; ++j){
                 exes[1] = exes[0] ;
                 whys[1] = whys[0] ;
                 exes[0] = (int) (fact*scalex*(offx+posx[i][j])) + xt ;
                 whys[0] = (int) (fact*(-scaley*(offy+posy[i][j]))) + ytt;
                 offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                 offsGg.fillOval(exes[0],whys[0]-2,5,5);
              }
              offsGg.drawString(String.valueOf(filter1(yoff[i])),320,195+i*15) ;
           }
         }

         if (pitch == 1) {
            exes[0] = (int) (fact* (scalex*(offx+posx[nsav][0]))) + xt ;
            whys[0] = (int) (fact* (-scaley*(offy+posy[nsav][0]))) + ytt ;
            offsGg.setColor(Color.white) ;
            for (i=1; i<=nptb; ++i) {                /* plot trajectory */
               exes[1] = exes[0] ;
               whys[1] = whys[0] ;
               exes[0] = (int) (fact*scalex*(offx+posx[nsav][i])) + xt ;
               whys[0] = (int) (fact*(-scaley*(offy+posy[nsav][i]))) + ytt;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               offsGg.fillOval(exes[0],whys[0]-2,5,5);
            }
            offsGg.setColor(Color.white) ;
            offsGg.fillOval((int) (fact*scalex*(offx+posx[nsav][nptb])) + xt ,
             (int) (fact*(-scaley*(offy+posy[nsav][nptb]))) + ytt - 5,10,10);
         }

 // Bars
       offsGg.setColor(Color.white) ;
       offsGg.fillRect(0,170,950,10) ;
       offsGg.fillRect(300,0,10,350) ;
       offsGg.fillRect(110,180,5,200) ;

 //  Side View
       offsGg.setColor(col1) ;
       offsGg.fillRect(310,150,750,20) ;
       offsGg.setColor(col3) ;
       offsGg.fillRect(310,0,750,150) ;
  // pitching mound
       offsGg.setColor(col2) ;
       exes[0] = (int) (fact*scalex*(offx - 8.5)) + xt ;
       whys[0] = 160 ;
       exes[1] = (int) (fact*scalex*(offx - 8.5)) + 50 + xt ; 
       whys[1] = 140 ;
       if(iball == 1 || iball == 2) whys[1]= 155 ;
       exes[2] = (int) (fact*scalex*(offx - 8.5)) + 100 + xt ; 
       whys[2] = 160 ;
       offsGg.fillPolygon(exes,whys,3) ;
  // home plate
       exes[0] = (int) (fact* (scalex*(offx - (lpit + 2.5)))) + xt ;
       whys[0] = 155 ;
       offsGg.setColor(Color.white) ;
       offsGg.fillRect(exes[0],whys[0],15,3) ;
 //  Strike Zone
       exes[0] = (int) (fact*scalex*(offx - (lpit- .5))) + xt ;
       whys[0] = (int) (fact* (-scalez*(offz+1.5))) + yts ;
       exes[1] = (int) (fact*scalex*(offx - (lpit - .5))) - 30 + xt ; 
       whys[1] = whys[0] ;
       offsGg.setColor(Color.white) ;
       offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
       offsGg.drawString("Knees",exes[1]-40,whys[1]+5) ;
       exes[0] = (int) (fact*scalex*(offx - (lpit - .5))) + xt ;
       whys[0] = (int) (fact* (-scalez*(offz+4.5))) + yts ;
       exes[1] = (int) (fact*scalex*(offx - (lpit - .5))) - 30 + xt ; 
       whys[1] = whys[0] ;
       offsGg.setColor(Color.white) ;
       offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
       offsGg.drawString("Letters",exes[1]-40,whys[1]+5) ;
 // ball and vector
       if (comp == 0) {
          offsGg.fillOval((int) (fact*scalex*(offx+relsx)) + xt,
             (int) (fact*(-scalez*(offz+relsz))) + yts - 2,5,5);
          exes[0] = (int) (fact* (scalex*(offx+relsx))) + xt ;
          whys[0] = (int) (fact* (-scalez*(offz+relsz))) + yts ;
          length = 10.0 * (vfsd / vmaxa) ;
          exes[1] = (int) (fact* (scalex*(offx+relsx - 
                     length * Math.cos(convdr*yangr)))) + xt ;
          whys[1] = (int) (fact* (-scalez*(offz+relsz +
                     length * Math.sin(convdr*zangr)))) + yts ;
          offsGg.setColor(Color.white) ;
          offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
          exes[0] = exes[1] + 
            (int) (10.0*Math.cos(convdr*zangr) - 4.0*Math.sin(convdr*zangr)) ;
          exes[2] = exes[1] +
            (int) (10.0*Math.cos(convdr*zangr) + 4.0*Math.sin(convdr*zangr)) ;
          whys[0] = whys[1] +
            (int) (10.0*Math.sin(convdr*zangr) + 4.0*Math.cos(convdr*zangr)) ;
          whys[2] = whys[1] +
            (int) (10.0*Math.sin(convdr*zangr) - 4.0*Math.cos(convdr*zangr)) ;
          offsGg.fillPolygon(exes,whys,3) ;
          offsGg.setColor(Color.white) ;
          offsGg.fillOval((int) (fact*scalex*(offx+relsx )) + xt ,
             (int) (fact*(-scalez*(offz+relsz))) + yts - 5,10,10);
          exes[0] = (int) (fact* (scalex*(offx+relsx + 
                     0.5 * Math.cos(convdr*(plthg1[1] + 180.))))) + xt + 5 ;
          whys[0] = (int) (fact* (-scalez*(offz+relsz +
                     0.5 * Math.sin(convdr*(plthg1[1] + 180.))))) + yts ;
          exes[1] = (int) (fact* (scalex*(offx+relsx + 
                     0.5 * Math.cos(convdr*plthg1[1])))) + xt + 5 ;
          whys[1] = (int) (fact* (-scalez*(offz+relsz +
                     0.5 * Math.sin(convdr*plthg1[1])))) + yts ;
          offsGg.setColor(Color.red) ;
          offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
       }
   // saved pitches
       if (nsav >= 1) {
         for (i=0; i<= nsav-1; ++ i) {
            exes[0] = (int) (fact* (scalex*(offx+posx[i][0]))) + xt ;
            whys[0] = (int) (fact* (-scalez*(offz+posz[i][0]))) + yts ;
            if(i==0) {
               offsGg.setColor(Color.yellow) ;
               offsGg.drawString("feet",360,15) ;
            }
            if(i==1) offsGg.setColor(Color.orange) ;
            if(i==2) offsGg.setColor(Color.red) ;
            if(i==3) offsGg.setColor(Color.magenta) ;
            if(i==4) offsGg.setColor(Color.orange) ;
            offsGg.fillOval(exes[0],whys[0],5,5);
            nump = npts[i] ;
            for (j=1; j<=nump; ++j){
               exes[1] = exes[0] ;
               whys[1] = whys[0] ;
               exes[0] = (int) (fact*scalex*(offx+posx[i][j])) + xt ;
               whys[0] = (int) (fact*(-scalez*(offz+posz[i][j]))) + yts;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               offsGg.fillOval(exes[0],whys[0]-2,5,5);
            }
            offsGg.drawString(String.valueOf(filter3(zoff[i])),320,15 + i*15) ;
         }
       }
    // pitch
       if (pitch == 1) {
          exes[0] = (int) (fact* (scalex*(offx+posx[nsav][0]))) + xt ;
          whys[0] = (int) (fact* (-scalez*(offz+posz[nsav][0]))) + yts ;
          offsGg.setColor(Color.white) ;
          for (i=1; i<=nptb; ++i) {                /* plot trajectory */
             exes[1] = exes[0] ;
             whys[1] = whys[0] ;
             exes[0] = (int) (fact*scalex*(offx+posx[nsav][i])) + xt ;
             whys[0] = (int) (fact*(-scalez*(offz+posz[nsav][i]))) + yts;
             offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
             offsGg.fillOval(exes[0],whys[0]-2,5,5);
          }
          offsGg.setColor(Color.white) ;
          offsGg.fillOval((int) (fact*scalex*(offx+posx[nsav][nptb])) + xt ,
             (int) (fact*(-scalez*(offz+posz[nsav][nptb]))) + yts - 5,10,10);
       }

 //  Catcher View
       offsGg.setColor(col1) ;
       offsGg.fillRect(0,120,300,20) ;
       offsGg.setColor(col3) ;
       offsGg.fillRect(0,0,300,120) ;
  // pitching mound
       offsGg.setColor(col2) ;
       exes[0] = 50 ;
       whys[0] = 130 ;
       exes[1] = 150 ; 
       whys[1] = 110 ;
       if(iball == 1 || iball ==2) whys[1] = 125 ;
       exes[2] = 250 ; 
       whys[2] = 130 ;
       offsGg.fillPolygon(exes,whys,3) ;
 // ball 
      if (comp == 0) {
        offsGg.setColor(Color.white) ;
        offsGg.fillOval((int) (fact*(-scalecy*(offy+relsy))) + xtc -5,
             (int) (fact*(-scalecz*(offz+relsz))) + yts - 5,10,10);
      }
   // saved pitches
       if (nsav >= 1) {
         for (i=0; i<= nsav-1; ++ i) {
            exes[0] = (int) (fact* (-scalecy*(offy+posy[i][0]))) + xtc ;
            whys[0] = (int) (fact* (-scalecz*(offz+posz[i][0]))) + yts ;
            if(i==0) offsGg.setColor(Color.yellow) ;
            if(i==1) offsGg.setColor(Color.orange) ;
            if(i==2) offsGg.setColor(Color.red) ;
            if(i==3) offsGg.setColor(Color.magenta) ;
            if(i==4) offsGg.setColor(Color.orange) ;
            offsGg.fillOval(exes[0],whys[0],5,5);
            nump = npts[i] ;
            for (j=1; j<=nump; ++j){
               exes[1] = exes[0] ;
               whys[1] = whys[0] ;
               exes[0] = (int) (fact*(-scalecy*(offy+posy[i][j]))) + xtc ;
               whys[0] = (int) (fact*(-scalecz*(offz+posz[i][j]))) + yts;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               offsGg.fillOval(exes[0]-2,whys[0]-2,5,5);
            }
         }
       }
    // pitch
       if (pitch == 1) {
          exes[0] = (int) (fact* (-scalecy*(offy+posy[nsav][0]))) + xtc ;
          whys[0] = (int) (fact* (-scalecz*(offz+posz[nsav][0]))) + yts ;
          offsGg.setColor(Color.white) ;
          for (i=1; i<=nptb; ++i) {                /* plot trajectory */
             exes[1] = exes[0] ;
             whys[1] = whys[0] ;
             exes[0] = (int) (fact*(-scalecy*(offy+posy[nsav][i]))) + xtc ;
             whys[0] = (int) (fact*(-scalecz*(offz+posz[nsav][i]))) + yts;
             offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
             offsGg.fillOval(exes[0]-2,whys[0]-2,5,5);
          }
          offsGg.fillOval((int) (fact*(-scalecy*(offy+posy[nsav][nptb]))) + xtc-5,
             (int) (fact*(-scalecz*(offz+posz[nsav][nptb]))) + yts - 5,10,10);
       }
 // Strike Zone
       exes[0] = (int) (fact* (-scalecy*(offy - .75))) + xtc ;
       whys[0] = (int) (fact* (-scalecz*(offz + 1.5))) + yts ;
       exes[1] = (int) (fact* (-scalecy*(offy + .75))) + xtc ;
       whys[1] = (int) (fact* (-scalecz*(offz + 4.5))) + yts ;
       offsGg.setColor(Color.white) ;
       offsGg.drawLine(exes[0],whys[0],exes[1],whys[0]) ;
       offsGg.drawLine(exes[0],whys[1],exes[1],whys[1]) ;
       offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
       offsGg.drawLine(exes[1],whys[0],exes[1],whys[1]) ;
 // plate
       exes[0] = (int) (fact* (-scalecy*(offy + .75))) + xtc ;
       whys[0] = (int) (fact* (-scalecz*(offz + 0.0))) + yts ;
       offsGg.fillRect(exes[0],whys[0],30,7) ;
       whys[0] = (int) (fact* (-scalecz*(offz + 0.0))) + yts + 7 ;
       exes[1] = (int) (fact* (-scalecy*(offy - .75))) + xtc ;
       whys[1] = (int) (fact* (-scalecz*(offz + 0.0))) + yts + 7 ;
       exes[2] = (int) (fact* (-scalecy*(offy + .75))) + xtc + 15 ;
       whys[2] = (int) (fact* (-scalecz*(offz + 0.0))) + yts + 12 ;
       offsGg.fillPolygon(exes,whys,3) ;

 //  Labels
       offsGg.setColor(Color.white) ;
       offsGg.drawString("Top View",830,320) ;
       exes[0] = 880 ;
       whys[0] = 260 ;
       exes[1] = 880 ; 
       whys[1] = 230 ;
       exes[2] = 850 ; 
       whys[2] = 260 ;
       offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
       offsGg.drawString("Y",870,240) ;
       offsGg.drawLine(exes[0],whys[0],exes[2],whys[2]) ;
       offsGg.drawString("X",850,255) ;

       offsGg.setColor(Color.white) ;
       offsGg.drawString("Side View",830,20) ;
       exes[0] = 880 ;
       whys[0] = 60 ;
       exes[1] = 880 ; 
       whys[1] = 30 ;
       exes[2] = 850 ; 
       whys[2] = 60 ;
       offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
       offsGg.drawString("Z",870,40) ;
       offsGg.drawLine(exes[0],whys[0],exes[2],whys[2]) ;
       offsGg.drawString("X",850,55) ;

       offsGg.setColor(Color.white) ;
       offsGg.drawString("Catcher View",10,20) ;
       offsGg.drawString("Strike Zone",30,100) ;

   // outcome
       offsGg.setColor(Color.blue) ;
       offsGg.fillRect(0,180,110,185) ;
       offsGg.setColor(Color.white) ;
       offsGg.drawString("Umpire's Call",10,195) ;
       if (call == 1) {
         if (yoff[nsav] <= 9.0 && zoff[nsav] >= 1.5 && zoff[nsav] <= 4.5) {
            if(antim1 == 0) {
               offsGg.setColor(Color.red) ;
               offsGg.fillRect(10,205,90,30) ;
               offsGg.setColor(Color.white) ;
               offsGg.drawString("STRIKE !",30,225) ;
            }
            if(antim1 == 1) {
               offsGg.setColor(Color.yellow) ;
               offsGg.fillRect(10,205,90,30) ;
               offsGg.setColor(Color.red) ;
               offsGg.drawString("STRIKE !",30,225) ;
            }
         }
         else {
            offsGg.setColor(Color.white) ;
            offsGg.fillRect(10,200,90,25) ;
            offsGg.setColor(Color.blue) ;
            offsGg.drawString("Ball",40,215) ;
            if (yoff[nsav] > 9.0) {
              offsGg.setColor(Color.white) ;
              offsGg.drawString("Wide",40,245) ;
            }
            if (zoff[nsav] < 1.5) {
              offsGg.setColor(Color.white) ;
              offsGg.drawString("Low",40,260) ;
            }
            if (zoff[nsav] > 4.5) {
              offsGg.setColor(Color.white) ;
              offsGg.drawString("High",40,260) ;
            }
         }
         offsGg.setColor(Color.white) ;
         offsGg.drawString(String.valueOf(filter1(yoff[nsav])),320,260) ;
         offsGg.drawString("inches",350,260) ;
         offsGg.drawString("from Center",320,275) ;
         offsGg.drawString(String.valueOf(filter3(zoff[nsav])),320,75) ;
         offsGg.drawString("feet",360,75) ;
         offsGg.drawString("from Ground",320,90) ;
       }
       if (call == 2) {
         offsGg.setColor(Color.white) ;
         offsGg.fillRect(10,205,90,25) ;
         offsGg.setColor(Color.blue) ;
         offsGg.drawString("Ball",40,215) ;
         offsGg.setColor(Color.white) ;
         offsGg.drawString("Low",40,260) ;
         offsGg.setColor(Color.white) ;
         offsGg.drawString("In the Dirt",315,60) ;
       }

  // spin axis
       xpic = 160 ;
       ypic = 220 ;
       exes[0] = xpic + 54 ;
       whys[0] = ypic + 36 ;
       exes[1] = xpic + 54 + (int)(50*Math.sin(convdr*sangr)) ; 
       whys[1] = ypic + 36 - (int)(50*Math.cos(convdr*sangr)) ;
       offsGg.setColor(Color.white) ;
       offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
       offsGg.drawString("Left or Right",190,200) ;
       offsGg.drawString("Perpendicular (Normal) Force",120,330) ;
       if (spindr <= 0.0) {
          if (spin >= 0.0) {
             offsGg.drawString("Down",120,300) ;
             offsGg.drawString("Up",270,300) ;
          }
          if (spin <= 0.0) {
             offsGg.drawString("Up",120,300) ;
             offsGg.drawString("Down",270,300) ;
          }
       }
       if (spindr >= 0.0) {
          if (spin >= 0.0) {
             offsGg.drawString("Up",120,300) ;
             offsGg.drawString("Down",270,300) ;
          }
          if (spin <= 0.0) {
             offsGg.drawString("Down",120,300) ;
             offsGg.drawString("Up",270,300) ;
          }
       }

       offsGg.setColor(Color.white) ;
       offsGg.fillRect(0,265,110,300) ;
       offsGg.drawImage(nasaimg,10,265,this) ;
       offsGg.drawImage(displimg,xpic,ypic,this) ;

       g.drawImage(offscreenImg,0,0,this) ;   
     }
   }
}
