/*
                             HitModeler
   
                           A Java Applet
                  to study the flight of hit baseball
                     Derived from RocketModeler II

                           Version 1.2b - 10 Apr 12

                               Written by 

                               Tom Benson
                             Peter Sherman
                       NASA Glenn Research Center

>                              NOTICE
>This software is in the Public Domain.  It may be freely copied and used in
>non-commercial products, assuming proper credit to the author is given.  IT
>MAY NOT BE RESOLD.  If you want to use the software for commercial
>products, contact the author.
>No copyright is claimed in the United States under Title 17, U. S. Code.
>This software is provided "as is" without any warranty of any kind, either
>express, implied, or statutory, including, but not limited to, any warranty
>that the software will conform to specifications, any implied warranties of
>merchantability, fitness for a particular purpose, and freedom from
>infringement, and any warranty that the documentation will conform to the
>program, or any warranty that the software will be error free.
>In no event shall NASA be liable for any damages, including, but not
>limited to direct, indirect, special or consequential damages, arising out
>of, resulting from, or in any way connected with this software, whether or
>not based on warranty, contract, tort or otherwise, whether or not injury
>was sustained by persons or property or otherwise, and whether or not loss
>was sustained from, or arose out of the results of, or use of, the software
>or services provided hereunder.
 
  New test -
              * change buttons
              * move wind input 
              * reset the temp for hot and cold days
              * improve wind correction
              * add softball 
              * add general location
              * add any ball

                                           TJB  11 Apr 12

*/

import java.awt.*;
import java.lang.Math ;

public class Hit extends java.applet.Applet {
 
   static double convdr = 3.1415926/180. ;
   static double pid2 = 3.1415926/2.0 ;
   static double pi = 3.1415926 ;
   static double zero = 0.0 ;
   static double wtzero = 0.00001 ;
 
   int rktype,ntype,part,rtype,fintype,numfin,lunits,planet,wthopt,place ;
   int nstage,numeng,nclust,btfair,balob ;
   int istab,ifuel,ides,irange ;
   int conflag,locflag,balflag ;
            // body geometry
   static double blngth,blngd,blmax,blmin,bdiam,bdiamd,bdmax,bdmin,brad ;
            // tail fairing geometry
   static double tlngth,tlngd,tlmax,tlmin,tdiam,tdiamd,tdmax,tdmin,trad ;
            // bottle tail fairing
   static double btlngth,btlngd,btlmax,btlmin;
   static double btdiam,btdiamd,btdmax,btdmin,btrad;
            // payload geometry
   static double plngth,plngd,plmax,plmin,pdiam,pdiamd,pdmax,pdmin,prad ;
            // payload fairing geometry
   static double qlngth,qlngd,qlmax,qlmin ;
            // nose geometry
   static double nlngth,nlngd,nlmax,nlmin,ndiam,ndiamd,ndmax,ndmin,nrad ;
   static double nfact,nfact2 ;
            // fin geometry
   static double flngth,flngd,flmax,flmin,fwidth,fwid,fwmax,fwmin,fwex ;
   static double fleang,flemax,flemin,fteang,ftemax,ftemin ;
   static double ftanle,ftante ;
   static double floc,flocd,flcmax,flcmin ;
   static double delt,ap,thet;
   static double[][] finx = new double[3][4] ;
   static double[][] finy = new double[3][4] ;

   static double vmn1,vmn2,vmn3,vmn4,vmn5,vmn6,vmx1,vmx2,vmx3,vmx4,vmx5,vmx6 ;
   static double lconv1,lconv2,fconv,pconv ;
   static double aconv,dconv2,dconv3,vconv ;
               // weight and materials
   static int mbod,mtfr,mnose,mfin,mpay,mpfr,mbtfr ;
   static double wbod,wtfr,wnose,wpar,wfin,wpay,wpfr,wbtfr,weng,wfuel ;
   static double wbal,wbald,wmax,wmin ;
   static double sabod,satfr,sanose,sapay,sapfr,safin,sabtfr,satot;
   static double pabod,patfr,panose,papay,papfr,pafin,pabtfr,patot;
   static double cabod,canose,capay,catot,carec,caexit,cabexit ;
   static double vbod,vtfr,vnose,vpay,vpfr;
   static double dbod,dtfr,dnose,dfin,dpay,dpfr,dbtfr ;
   static double cgbod,cgtfr,cgnose,cgfin,cgpay,cgpfr,cgbtfr,cgeng,cgfuel ;
   static double cpbod,cptfr,cpnose,cpfin,cppay,cppfr,cpbtfr ;
               // ballistic 
   static double wtd, wtmax,wtmin,cdmin,cdmax,catd,camin,camax ;
   static double vmuzl,vmuzld,vmmax,vmmin ;
               // stomp launcher
   static double sv1,sv1d,sv1min,sv1max,sv2,sv2d,sv2min,sv2max ;
   static double sl,sld,slmin,slmax ;
   static double lpress,volrat,vstomp,presin ;
   static double lpresd,lpresmax,lpresmin ;
              // solid rocket thrust
   static double th1,th2,tim1,tim2,timd;
   static double th1b1,th2b1,tim1b1,tim2b1 ;
            // engine geometry
   static double elngth,ediam,erad,mediam,merad;
   static double b1elngth,b1ediam,b1erad;
            // booster 1 geometry
   static double b1fw,b1fwd,b1fwmax,b1fleang,b1fteang,b1ftanle,b1ftante;
   static double b1lngth,b1lngd,b1lmax,b1flngth,b1flngd;
   static double wengb1,wfuelb1,sab1,pab1,cgb1,cpb1;
   static double wfinb1,safb1,pafb1,cgfb1,cpfb1;
              // bottle rocket thrust
   static double wat,watd,watmin,watmax,fpres,fpresd,fpresmin,fpresmax ;
   static double nozdiam,nozdiamd,nozdmin,nozdmax ;
   static double nozrad,noza,hwat,watrad ;
   static double ltub,ltubd,ltubmin,ltubmax ;
   static double volair,instair,instwat,instpres,mdot,uexit,lothrust ;
               // flight
   int fire,comp,npt,nsav,nburn,cockflg,cockcal,stepon,step,presopt;
   static int[] npts = new int[5];
   static double weight,drag,thrust,wtflt ;
   static double diameter,diamin,diamax ;
   static double cg,cp,cd,cdrec ;
   static double g0,q0,ps0,pt0,ts0,rho,rlhum,temf,presm,gama,wtrat,rgas ;
   static double alt,altd,altmax,altmin ;
   static double wind,windd,wndmax,wndmin ;
   static double lnchang,langmax,langmin;
   static double rail,raild,railmin,railmax ;
   static double llaunch,timrail ;
   static double deltim,fltim,vacc,vvel,vloc,hacc,hvel,grspd,hloc,spd ;
   static double vmax,hmax,spdmax ;
   static double[][] posx = new double[10][5000] ;
   static double[][] posy = new double[10][5000] ;
   static double[] posa = new double [5000] ;
   static double posb1 ;
       /*  plot & probe data */
   static double fact,facmin,facrat;
   static double facts,facto,factc;
   static int xt,yt,sldloc,viewflg,gridon,lnchgrf,trakon,ldisplay;
   static int xts,yts,slds;
   static int xto,yto,sldo;
   static int xtc,ytc,sldc;

   Solver solve ;
   View view ;
   Act act ;
   CardLayout layin,layen1,layen2 ;
   Image offImg ;
   Graphics offsGg ;

   public void init() {
     solve = new Solver() ;

     offImg = createImage(this.size().width,
                      this.size().height) ;
     offsGg = offImg.getGraphics() ;

     setLayout(new GridLayout(2,1,5,5)) ;

     view = new View(this) ;
     act = new Act(this) ;

     add(view) ;
     add(act) ;

     solve.setDefaults () ;
     loadInput() ;

     solve.comPute () ;

     view.start() ;
  }
 
  public Insets insets() {
     return new Insets(5,5,5,5) ;
  }

  public int filter0(double inumbr) {
        //  output only to .
       int number ;
       int intermed ;
 
       number = (int) (inumbr);
       return number ;
  }

  public float filter1(double inumbr) {
     //  output only to .1
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 10.) ;
       number = (float) (intermed / 10. );
       return number ;
  }
 
  public float filter3(double inumbr) {
     //  output only to .001
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 1000.) ;
       number = (float) (intermed / 1000. );
       return number ;
  }
 
  public float filter5(double inumbr) {
     //  output only to .00001
       float number ;
       int intermed ;
 
       intermed = (int) (inumbr * 100000.) ;
       number = (float) (intermed / 100000. );
       return number ;
  }

  public void setRangeView() {   // initial range view
       viewflg = 1 ;
       facts = fact = 1.25;
       facmin = .5 ;
       facrat = .005 ;
       xts = xt = 100; 
       yts = yt = 240 ;
       slds = sldloc= 125;
  }
 
  public void restRangeView() {   // restore range view
       viewflg = 1 ;
       fact = facts ;
       facmin = .01 ;
       facrat = .02 ;
       xt = xts ; 
       yt = yts ;
       sldloc = slds ;
  }
 
  public void setGraphView() {   // initial graph view
       viewflg = 2 ;
       factc = fact = 1.25;
       facmin = .01 ;
       facrat = .02 ;
       xtc = xt = 100; 
       ytc = yt = 40 ;
       sldc = sldloc= 288;
  }
 
  public void restGraphView() {   // restore graph view
       viewflg = 2 ;
       fact = factc ;
       facmin = .01 ;
       facrat = .02 ;
       xt = xtc ; 
       yt = ytc ;
       sldloc = sldc ;
  }
 
  public void loadBallistic() {   // load Ballistic info
    // ballisitic shell
       rktype = 10 ;
       fire = 0 ;
       comp = 0 ;
       tim1 = .2 ;
       weng = 0.0;
       wfuel = 0.0 ;
       nstage = 1; 
       cg = 0.0 ;
       cp = 0.0 ;
       balob = 0 ;
       weight = 5.0 ;
       wtd = weight * fconv;
       wtmin = 0.1 * fconv ;  wtmax = 100 * fconv ;
       cd = .3 ;
       cdmin = 0.0 ;  cdmax = 0.5 ;
       catot = 6.51 ;
       catd = catot * aconv ;
       diameter = 2.0 * Math.sqrt(catot / 3.1415926) ;
       diamin = 1.0; diamax = 12.0 ;
       camin = 0.0 ;  camax = 10.0 * aconv ;
       vmuzl = 146.7 ; 
       vmuzld = vmuzl * lconv1 * 60.0 / 88.0 ; 
       vmmin = 50.0 * 60.0 / 88.0 ;  vmmax = 160. * lconv1 * 60.0 / 88.0 ;
  }

  public void loadInput() {   // load the input panels
       String outden2,outden3,outlng,outfor ;
       int i1,i2,i3,i4,i5,i6 ;
       double v1,v2,v3,v4,v5,v6 ;
       float fl1,fl2,fl3,fl4,fl5,fl6 ;

       outden2 = " oz/in2" ;
       if (lunits == 1) outden2 = " g/cs" ;
       outden3 = " oz/in3" ;
       if (lunits == 1) outden3 = " g/cc" ;
       outlng = " in" ;
       if (lunits == 1) outlng = " cm" ;
       outfor = " oz" ;
       if (lunits == 1) outfor = " g" ;

     // ballisitic shell
       v1 = wtd ;
       vmn1 = wtmin; vmx1 = wtmax ;
       v2 = cd ;
       vmn2 = cdmin; vmx2 = cdmax ;
       v3 = catd ;
       vmn3 = camin; vmx3 = camax ;
       v4 = vmuzld ;
       vmn4 = vmmin; vmx4 = vmmax ;

       act.inp.bali.lt.f1.setText(String.valueOf(filter3(wtd))) ;
       act.inp.bali.lt.f2.setText(String.valueOf(filter3(cd))) ;
       act.inp.bali.lt.f3.setText(String.valueOf(filter3(catd))) ;
       act.inp.bali.lt.f4.setText(String.valueOf(filter3(vmuzld))) ;
       act.inp.bali.rt.obch.select(balob) ;

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;

       act.inp.bali.rt.s1.setValue(i1) ;
       act.inp.bali.rt.s2.setValue(i2) ;
       act.inp.bali.rt.s3.setValue(i3) ;
       act.inp.bali.rt.s4.setValue(i4) ;

     // baseball
       v1 = vmuzld ;
       vmn1 = vmmin; vmx1 = vmmax ;
       v2 = windd ;
       vmn2 = wndmin;  vmx2 = wndmax ;
       v3 = lnchang ;
       vmn3 = langmin;  vmx3 = langmax ;
       v4 = cd ;
       vmn4 = cdmin;  vmx4 = cdmax ;

       act.inp.basi.lt.f1.setText(String.valueOf(filter3(vmuzld))) ;
       act.inp.basi.lt.f2.setText(String.valueOf(filter3(windd))) ;
       act.inp.basi.lt.f3.setText(String.valueOf(filter3(lnchang))) ;
       act.inp.basi.lt.f4.setText(String.valueOf(filter3(cd))) ;

       i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
       i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
       i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
       i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;

       act.inp.basi.rt.s1.setValue(i1) ;
       act.inp.basi.rt.s2.setValue(i2) ;
       act.inp.basi.rt.s3.setValue(i3) ;
       act.inp.basi.rt.s4.setValue(i4) ;

     // baseball control 
       v1 = presm ;
       v2 = temf ;
       v3 = rlhum ;
       v4 = alt ;

       act.conb.o1.setText(String.valueOf(filter3(presm))) ;
       act.conb.o2.setText(String.valueOf(filter0(temf))) ;
       act.conb.o3.setText(String.valueOf(filter3(rlhum * 100.))) ;
       act.conb.o4.setText(String.valueOf(filter0(alt))) ;

       return ;
  }

  public void loadOut() {   // output routine
     String outfor,outvel,outlng,outhi ;

     outfor = " oz" ;
     if (lunits == 1) outfor = " g" ;
     outlng = " in" ;
     if (lunits == 1) outlng = " cm" ;
     outhi = " ft" ;
     if (lunits == 1) outhi = " m" ;
     outvel = " ft/s" ;
     if (lunits == 1) outvel = " m/s" ;

     return ;
  }
 
  class Solver {
 
     Solver () {
     }

     public void setDefaults() {
 
    // units
       conflag = 0 ;
       locflag = 0 ;
       balflag = 0 ;
       lunits = 0 ;
       dconv2 = 1.0 ;
       dconv3 = 1.0 ;
       lconv1 = 1.0 ;
       lconv2 = 1.0 ;
       aconv = 1.0 ;
       vconv = 1.0 ;
       fconv = 1.0 ;
       pconv = 1.0 ;

       nsav = 0 ;
       wtrat = 1.0 ;

       planet = 0 ;
       wthopt = 0 ;
       place = 0 ;
       g0 = 32.2 ;
       altd = alt = 700.0 ;
       altmin = 0.0;  altmax = 50000. ;
       ps0 = 14.7 ;
       rgas = 1718. ;
       getFreeStream() ;

       presin = 14.7 ;
       loadBallistic() ;

       part = 3 ;
       istab = 1 ;
       ifuel = 0 ;
       ides = 0 ;
       irange = 0 ;
       stepon = 0 ;
       step = 0 ;

    // launch
       windd = wind = 0.0 ;
       wndmin = -20.0 ; wndmax = 20.0 ;
       lnchang = 45.0 ;
       langmin = 0.0 ;  langmax = 80.0 ;
       raild = rail = 3.0 ;
       railmin = 1.0; railmax = 5.0 ;
       cockflg = 0 ;
       presopt = 0 ;

       posa[0] = pid2 ;

       fire = 0 ;
       comp = 0 ;
       vacc = 0.0 ; vvel = 0.0 ; vloc = 0.0 ;
       hacc = 0.0 ; hvel = 0.0 ; grspd= 0.0 ; hloc = 0.0 ;
       vmax = 0.0 ; hmax = 0.0 ; 
       spd = 0.0 ; spdmax = 0.0 ;

         // graphics
       setGraphView() ;
       gridon = 1 ;
       trakon = 0 ;
       setRangeView() ;

       ldisplay = 2 ;
       cd = 0.3 ;
       cdmin = 0.0 ;  cdmax = 0.5;
       weight = 5.0 ;
       wtd  = weight * fconv ;
//       catot = 6.45 ;
       catot = 6.514 ;
       catd = catot * aconv ;
       istab = 1;
       loadInput() ;
       return ;
     }

     public void getWtCgCp() {

   //    weight = wnose + wbod + wtfr + wbal + wpar + wpay + wpfr + wfin
   //             + weng + wfuel ;
       patot = panose + pabod + patfr + papay + papfr + pafin ;
    // cross-sectional area
       catot = cabod ; 
       if ((canose > catot) && (ntype < 4)) catot = canose ;
       if ((capay > catot) && (plngth > .01)) catot = capay ;

       wtflt = weight * wtrat ;

       return ;
     }
 
     public void getFreeStream() {    //  free stream conditions
     double hite,pvap ;       /* MODS  19 Jan 00  whole routine*/

       g0 = 32.2 ;
       rgas = 1718. ;                /* ft2/sec2 R */
       gama = 1.4 ;
       hite = alt ;
       wtrat = 1.0 ;
       if (planet <= 1) {    // Earth  standard day
          if (conflag == 0) {
             // Earth  standard day
             if (hite <= 36152.) {           // Troposphere
                ts0 = 518.6 - 3.56 * hite/1000. ;
                ps0 = 2116. * Math.pow(ts0/518.6,5.256) ;
             }
             if (hite >= 36152. && hite <= 82345.) {   // Stratosphere
                ts0 = 389.98 ;
                ps0 = 2116. * .2236 *
                     Math.exp((36000.-hite)/(53.35*389.98)) ;
             }
             if (place == 0) {
                if (wthopt == 0) ts0 = 519.6;
                if (wthopt == 1) ts0 = 549.6;
                if (wthopt == 2) ts0 = 494.6;
             }
             rlhum = 0.0 ;
             temf = ts0 - 459.6 ;
             if (temf <= 0.0) temf = 0.0 ;
             presm = ps0 * 29.92 / 2116. ;
          }
          if (conflag == 1) {
             ts0 = temf + 459.6 ;
             if (temf < 0.0) {
                  temf = 0.0 ;
                  rlhum = 0.0 ;
             }
             ps0 = presm * 2116. / 29.92 ;
          }
          pvap = rlhum*(2.685+.00353*Math.pow(temf,2.245));/* Eq 1:6A  Domasch */
          rho = (ps0 - .379*pvap)/(rgas * ts0) ;  /* effect of humidty */
       }
       if (planet == 3) {   // Mars - curve fit of orbiter data
         rgas = 1149. ;                /* ft2/sec2 R */
         gama = 1.29 ;
         wtrat = .38 ;

         if (hite <= 22960.) {
            ts0 = 434.02 - .548 * hite/1000. ;
            ps0 = 14.62 * Math.pow(2.71828,-.00003 * hite) ;
         }
         if (hite > 22960.) {
            ts0 = 449.36 - 1.217 * hite/1000. ;
            ps0 = 14.62 * Math.pow(2.71828,-.00003 * hite) ;
         }
         rlhum = 0.0 ;
         temf = ts0 - 459.6 ;
         presm = ps0 * 29.92 / 2116. ;
         rho = ps0/(rgas * ts0) ;
       }

       if (planet == 1) rho = 0.0 ;   // Earth no drag
       ps0 = ps0 / 144. ;   // psi

       if (planet == 2) {     // Moon
          wtrat = .1667 ;
          gama = 1.4 ;
          ps0 = 0.0 ;
          rho = 0.0 ;
          rlhum = 0.0 ;
          temf = -250. ;
          presm = 0.0 ;
       }
       fpresmin = ps0 * pconv ;
       lpresmin = ps0 * pconv ;

       loadInput() ;

       return ;
     }

     public void comPute() {
 
       if (rktype <= 9) {
          getWtCgCp() ;
       }

       loadOut() ;

       return ;
     }
  }

  class Act extends Panel {
     Hit outerparent ;
     Conb conb ;
     Inp inp ;

     Act (Hit target) {

       outerparent = target ;
       setLayout(new GridLayout(1,2,5,5)) ;

       conb = new Conb(outerparent) ;
       inp = new Inp(outerparent) ;

       add(conb) ;
       add(inp) ;
    }

    class Conb extends Panel {  // baseball control
       Hit outerparent ;
       Label lab1,lab2 ;
       TextField o1,o2,o3,o4 ;
       Label l1,l2,l3,l4 ;
       Choice placeh,weatch ;
       Button rest ;

       Conb (Hit target) {
          outerparent = target ;
          setLayout(new GridLayout(8,2,5,5)) ;

          lab1 = new Label("Batter Up!", Label.CENTER) ;
          lab1.setForeground(Color.red) ;
          lab2 = new Label("HitModeler Vers. 1.2b", Label.CENTER) ;
          lab2.setForeground(Color.red) ;

          placeh = new Choice() ;
          placeh.addItem("Cleveland") ;
          placeh.addItem("Denver") ;
          placeh.addItem("New York") ;
          placeh.addItem("Chicago") ;
          placeh.addItem("Mt.Everest") ;
          placeh.addItem("Mars");
          placeh.addItem("Moon");
          placeh.addItem("Specify Altitude");
          placeh.select(0) ;

          weatch = new Choice() ;
          weatch.addItem("Average Day") ;
          weatch.addItem("Hot Day") ;
          weatch.addItem("Cold Day") ;
          weatch.addItem("Specify") ;
          weatch.select(0) ;

          l1 = new Label("Pressure - in Hg", Label.CENTER) ;
          o1 = new TextField("29.172",5) ;
          o1.setBackground(Color.black) ;
          o1.setForeground(Color.yellow) ;
          l2 = new Label("Temperature - F", Label.CENTER) ;
          o2 = new TextField("59",5) ;
          o2.setBackground(Color.black) ;
          o2.setForeground(Color.yellow) ;
          l3 = new Label("Rel. Humidity -%", Label.CENTER) ;
          o3 = new TextField("0.0",5) ;
          o3.setBackground(Color.black) ;
          o3.setForeground(Color.yellow) ;
          l4 = new Label("Altitude-ft", Label.CENTER) ;
          o4 = new TextField("700.0",5) ;
          o4.setBackground(Color.black) ;
          o4.setForeground(Color.yellow) ;

          rest = new Button("Reset") ;
          rest.setBackground(Color.orange) ;
          rest.setForeground(Color.black) ;
 
          add(lab2) ;
          add(lab1) ;

          add(new Label("Stadium Location :", Label.RIGHT)) ;
          add(placeh) ;

          add(l4) ;
          add(o4) ;

          add(new Label("Weather Conditions:", Label.RIGHT)) ;
          add(weatch) ;

          add(l1) ;
          add(o1) ;

          add(l2) ;
          add(o2) ;

          add(l3) ;
          add(o3) ;

          add(rest) ;
          add(new Label(" ", Label.CENTER)) ;

       }

       public boolean action(Event evt, Object arg) {
          if(evt.target instanceof Choice) {
               this.handleProb(arg) ;
               return true ;
          }
          if(evt.target instanceof Button) {
              this.handleBut(evt,arg) ;
             return true ;
          }
          if(evt.target instanceof TextField) {
              this.handleText(evt,arg) ;
             return true ;
          }
          else return false ;
       }

       public void handleProb(Object obj) {
          int i2,i1 ;

          planet  = 0 ;
          i1  = weatch.getSelectedIndex() ;
          i2  = placeh.getSelectedIndex() ;
          switch (i2) {
             case 0:{                            /* Cleveland */
                    locflag = 0;
                    o4.setBackground(Color.black) ;
                    o4.setForeground(Color.yellow) ;
                    place = 0 ;
                    alt = 700.0 * lconv1 ;
                    break ;
             }
             case 1:{                            /* Denver */
                    locflag = 0;
                    o4.setBackground(Color.black) ;
                    o4.setForeground(Color.yellow) ;
                    place = 0 ;
                    alt = 5280.0 * lconv1 ;
                    break ;
             }
             case 2:{                            /* New York */
                    locflag = 0;
                    o4.setBackground(Color.black) ;
                    o4.setForeground(Color.yellow) ;
                    place = 0 ;
                    alt = 0. * lconv1 ;
                    break ;
             }
             case 3:{                            /* Chicago */
                    locflag = 0;
                    o4.setBackground(Color.black) ;
                    o4.setForeground(Color.yellow) ;
                    place = 0 ;
                    alt = 586. * lconv1 ;
                    break ;
             }
             case 4:{                            /* Mt. Everest */
                    locflag = 0;
                    o4.setBackground(Color.black) ;
                    o4.setForeground(Color.yellow) ;
                    place = 1 ;
                    alt = 29028. * lconv1 ;
                    break ;
             }
             case 5:{                            /* Mars */
                    locflag = 0;
                    o4.setBackground(Color.black) ;
                    o4.setForeground(Color.yellow) ;
                    planet = 3 ;
                    alt = 0.0 * lconv1 ;
                    break ;
             }
             case 6:{                            /* Moon */
                    locflag = 0;
                    o4.setBackground(Color.black) ;
                    o4.setForeground(Color.yellow) ;
                    planet = 2 ;
                    alt = 0.0 * lconv1 ;
                    break ;
             }
             case 7:{                            /* Specify Altitude */
                    locflag = 1;
                    o4.setBackground(Color.white) ;
                    o4.setForeground(Color.black) ;
                    place = 0 ;
                    break ;
             }
          }
          switch (i1) {
             case 0:{                            /* Average Day */
                    conflag = 0 ;
                    wthopt = 0 ;
                    o1.setBackground(Color.black) ;
                    o1.setForeground(Color.yellow) ;
                    o2.setBackground(Color.black) ;
                    o2.setForeground(Color.yellow) ;
                    o3.setBackground(Color.black) ;
                    o3.setForeground(Color.yellow) ;
                    break ;
             }
             case 1:{                            /* Hot Day */
                    conflag = 0 ;
                    wthopt = 1 ;
                    o1.setBackground(Color.black) ;
                    o1.setForeground(Color.yellow) ;
                    o2.setBackground(Color.black) ;
                    o2.setForeground(Color.yellow) ;
                    o3.setBackground(Color.black) ;
                    o3.setForeground(Color.yellow) ;
                    break ;
             }
             case 2:{                            /* Cold Day */
                    conflag = 0 ;
                    wthopt = 2 ;
                    o1.setBackground(Color.black) ;
                    o1.setForeground(Color.yellow) ;
                    o2.setBackground(Color.black) ;
                    o2.setForeground(Color.yellow) ;
                    o3.setBackground(Color.black) ;
                    o3.setForeground(Color.yellow) ;
                    break ;
             }
             case 3:{                            /* Set Conditions */
                    conflag = 1 ;
                    o1.setBackground(Color.white) ;
                    o1.setForeground(Color.black) ;
                    o2.setBackground(Color.white) ;
                    o2.setForeground(Color.black) ;
                    o3.setBackground(Color.white) ;
                    o3.setForeground(Color.black) ;
                    break ;
             }
          }

          solve.getFreeStream() ;
       }

       public void handleBut(Event evt, Object obj) {
         String label = (String)obj ;
         int j, i ;

         if(label.equals("Reset")) {
            solve.setDefaults () ;
            placeh.select(0) ;
            weatch.select(0) ;

            fire = 0 ;
            comp = 0 ;
            nsav = 0 ;
            for (j=0; j<=4; ++j) {
               for (i=0; i<=npts[j]; ++i){
                  posx[j][i] = 0.0 ;  
                  posy[j][i] = 0.0 ;  
                  posa[i] = pid2 ;
                  posb1 = 0.0 ;
               }
               npts[j] = 0 ;
            }
            conflag = 0 ;
            locflag = 0 ;
            o1.setBackground(Color.black) ;
            o1.setForeground(Color.yellow) ;
            o2.setBackground(Color.black) ;
            o2.setForeground(Color.yellow) ;
            o3.setBackground(Color.black) ;
            o3.setForeground(Color.yellow) ;
            o4.setBackground(Color.black) ;
            o4.setForeground(Color.yellow) ;
         }
       }

       public void handleText(Event evt, Object obj) {
          Double V1,V2,V3,V4 ;
          double v1,v2,v3,v4 ;
          float fl1 ;

          V1 = Double.valueOf(o1.getText()) ;
          v1 = V1.doubleValue() ;
          V2 = Double.valueOf(o2.getText()) ;
          v2 = V2.doubleValue() ;
          V3 = Double.valueOf(o3.getText()) ;
          v3 = V3.doubleValue() ;
          V4 = Double.valueOf(o4.getText()) ;
          v4 = V4.doubleValue() ;

          if (locflag == 1) {
             if(v4 < altmin) {
                v4 = altmin ;
                fl1 = (float) v4 ;
                o4.setText(String.valueOf(fl1)) ;
             }
             if(v4 > altmax) {
                v4 = altmax ;
                fl1 = (float) v4 ;
                o4.setText(String.valueOf(fl1)) ;
             }
             alt = altd =  v4 ;
             solve.getFreeStream() ;
          }

          if (conflag == 1) {
             if(v1 < 5.0) {
                v1 = 5.0 ;
                fl1 = (float) v1 ;
                o1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > 50.0) {
                v1 = 50.0 ;
                fl1 = (float) v1 ;
                o1.setText(String.valueOf(fl1)) ;
             }
             presm = v1 ;
             temf = v2 ;
             if(v3 < 1.0) {
                v3 = 0.0 ;
                fl1 = (float) v3 ;
                o3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > 100.0) {
                v3 = 100.0 ;
                fl1 = (float) v3 ;
                o3.setText(String.valueOf(fl1)) ;
             }
             rlhum = v3 /100. ;

             solve.getFreeStream() ;
          }
       }
    }

    class Inp extends Panel {
       Hit outerparent ;
       Bali bali ;
       Basi basi ;

       Inp (Hit target) {

          outerparent = target ;
          layin = new CardLayout() ;
          setLayout(layin) ;

          bali = new Bali(outerparent) ;
          basi = new Basi(outerparent) ;

          add ("bas", basi) ;
          add ("bal", bali) ;
       }

       class Bali extends Panel {
          Hit outerparent ;
          Lt lt ;
          Rt rt ;
  
          Bali (Hit target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Hit outerparent ;
             Scrollbar s1,s2,s3,s4;
             Choice obch ;

             Rt (Hit target) {

               int i1,i2,i3,i4 ;
  
               outerparent = target ;
               setLayout(new GridLayout(7,1,10,5)) ;

               i1 = (int) (((wtd - wtmin)/(wtmax-wtmin))*1000.) ;
               i2 = (int) (((cd - cdmin)/(cdmax-cdmin))*1000.) ;
               i3 = (int) (((catd - camin)/(camax-camin))*1000.) ;
               i4 = (int) (((vmuzld - vmmin)/(vmmax-vmmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
  
               obch = new Choice() ;
               obch.addItem("Rocket") ;
               obch.addItem("Ideal Shell (Drag=0)") ;
               obch.addItem("Baseball") ;
               obch.select(0) ;
 
               add(obch) ;
               add(s2) ;
               add(s3) ;
               add(new Label(" ", Label.CENTER)) ;
               add(s4) ;
               add(s1) ;
               add(new Label(" ", Label.CENTER)) ;
           }
 
           public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleCho(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
          public void handleCho(Event evt) {
             int i1,i2,i3 ;
             double v1,v2,v3 ;
             float fl1,fl2,fl3 ;

             balob = obch.getSelectedIndex() ;

             vmn1 = wtmin;    vmx1 = wtmax ;
             vmn2 = cdmin;    vmx2 = cdmax ;
             vmn3 = camin;    vmx3 = camax ;

             switch (balob) {
                 case 0:{              /* Rocket */
                     ldisplay = 0 ;
                     v2 = cd = 0.7 ;
                     i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                     fl2 = filter3(v2) ;
                     lt.f2.setText(String.valueOf(fl2)) ;
                     rt.s2.setValue(i2) ;
                     break;
                 }
                 case 1:{              /* Shell */
                     ldisplay = 1 ;
                     v2 = cd = 0.0 ;
                     i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                     fl2 = filter3(v2) ;
                     lt.f2.setText(String.valueOf(fl2)) ;
                     rt.s2.setValue(i2) ;
                     break;
                 }
                 case 2:{              /* Baseball */
                     ldisplay = 2 ;
                     v2 = cd = 0.07 ;
                     i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
                     fl2 = filter3(v2) ;
                     lt.f2.setText(String.valueOf(fl2)) ;
                     rt.s2.setValue(i2) ;
                     weight = 5.0 ;
                     v1  = wtd = weight * fconv ;
                     i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
                     fl1 = filter3(v1) ;
                     lt.f1.setText(String.valueOf(fl1)) ;
                     rt.s1.setValue(i1) ;
                     catot = 6.45 ;
                     v3 = catd = catot * aconv ;
                     i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
                     fl3 = filter3(v3) ;
                     lt.f3.setText(String.valueOf(fl3)) ;
                     rt.s3.setValue(i3) ;
                     break;
                 }
             }
             solve.comPute() ;
          }

          public void handleBar(Event evt) {     // ballistic shell
             int i1,i2,i3,i4;
             double v1,v2,v3,v4 ;
             float fl1,fl2,fl3,fl4 ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;
             i4 = s4.getValue() ;

             vmn1 = wtmin;    vmx1 = wtmax ;
             vmn2 = cdmin;    vmx2 = cdmax ;
             vmn3 = camin;    vmx3 = camax ;
             vmn4 = vmmin;    vmx4 = vmmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
             v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
 
             wtd = v1 ;
             weight = wtd / fconv ;
             cd = v2 ;
             cg = 0.0 ;
             cp = 0.0 ;
             catd = v3 ;
             catot = catd / aconv ;
             vmuzld = v4 ;
             vmuzl = vmuzld / lconv1 * 88.0 / 60.0 ;
 
             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl3 = filter3(v3) ;
             fl4 = filter3(v4) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f3.setText(String.valueOf(fl3)) ;
             lt.f4.setText(String.valueOf(fl4)) ;

             solve.comPute() ;

           }  // end handle
         }  // end right
 
         class Lt extends Panel {
           Hit outerparent ;
           TextField f1, f2, f3, f4 ;
           Label l1, l2, l3, l4, lab ;
           Button butgo ;
  
           Lt (Hit target) {
              outerparent = target ;
              setLayout(new GridLayout(7,2,5,5)) ;

              butgo = new Button("GO") ;
              butgo.setBackground(Color.white) ;
              butgo.setForeground(Color.blue) ;

              l1 = new Label("Weight oz", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)wtd),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("Drag Coeff", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)cd),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              l3 = new Label("Area sq in", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)catd),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("Speed fps", Label.CENTER) ;
              f4 = new TextField(String.valueOf((float)vmuzld),5) ;
              f4.setBackground(Color.white) ;
              f4.setForeground(Color.black) ;

              add(butgo) ;
              add(new Label("Object:", Label.RIGHT)) ;

              add(l2) ;
              add(f2) ;

              add(l3) ;
              add(f3) ;

              add(new Label(" ", Label.CENTER)) ;
              add(new Label(" ", Label.CENTER)) ;

              add(l4) ;
              add(f4) ;

              add(l1) ;
              add(f1) ;

              add(new Label("on Earth", Label.CENTER)) ;
              add(new Label(" ", Label.CENTER)) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              if(label.equals("GO")) {
                 ifuel = 1 ;
                 ides = 1;
                 butgo.setBackground(Color.green) ;
                 butgo.setForeground(Color.black) ;
                 weight = wtd / fconv ;
                 loadOut() ;
              }
           }
  
           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4 ;
             double v1,v2,v3,v4 ;
             int i1,i2,i3,i4 ;
             float fl1 ;

             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;
             V4 = Double.valueOf(f4.getText()) ;
             v4 = V4.doubleValue() ;

     // weight
             wtd  = v1 ;
             vmn1 = wtmin;   vmx1 = wtmax ;
             if(v1 < vmn1) {
                 wtd = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 wtd =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             weight = wtd / fconv ;

     // drag coefficient
             cd  = v2 ;
             vmn2 = cdmin;   vmx2 = cdmax ;
             if(v2 < vmn2) {
                 cd = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 cd =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }

     // cross-sectional area
             catd  = v3 ;
             vmn3 = camin;   vmx3 = camax ;
             if(v3 < vmn3) {
                 catd = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 catd =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             catot = catd / aconv ;

     // muzzle velocity
             vmuzld  = v4 ;
             vmn4 = vmmin;   vmx4 = vmmax ;
             if(v4 < vmn4) {
                 vmuzld = v4 = vmn4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             if(v4 > vmx4) {
                 vmuzld =  v4 = vmx4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
             }
             vmuzl = vmuzld / lconv1 ;

             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
             i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
  
             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;
             rt.s4.setValue(i4) ;

             cg = 0.0 ;
             cp = 0.0 ;

             solve.comPute() ;

           }  // end handle
         }  //  end  left
       }   // end ballistic shell

       class Basi extends Panel {
          Hit outerparent ;
          Lt lt ;
          Rt rt ;
  
          Basi (Hit target) {
  
            outerparent = target ;
            setLayout(new GridLayout(1,2,5,5)) ;
  
            lt = new Lt(outerparent) ;
            rt = new Rt(outerparent) ;

            add(lt) ;
            add(rt) ;
          }

          class Rt extends Panel {
             Hit outerparent ;
             Choice ballch ;
             Scrollbar s1,s2,s3,s4,s5,s6;
             Button butgo;

             Rt (Hit target) {

               int i1,i2,i3,i4,i5,i6 ;
  
               outerparent = target ;
               setLayout(new GridLayout(9,1,10,5)) ;

               ballch = new Choice() ;
               ballch.addItem("Baseball") ;
               ballch.addItem("Softball") ;
               ballch.addItem("Input Ball");
               ballch.select(0) ;

               i1 = (int) (((vmuzld - vmmin)/(vmmax-vmmin))*1000.) ;
               i2 = (int) (((windd - wndmin)/(wndmax-wndmin))*1000.) ;
               i3 = (int) (((lnchang - langmin)/(langmax-langmin))*1000.) ;
               i4 = (int) (((cd - cdmin)/(cdmax-cdmin))*1000.) ;
               i5 = (int) (((diameter - diamin)/(diamax-diamin))*1000.) ;
               i6 = (int) (((weight - wtmin)/(wtmax-wtmin))*1000.) ;
  
               s1 = new Scrollbar(Scrollbar.HORIZONTAL,i1,10,0,1000);
               s2 = new Scrollbar(Scrollbar.HORIZONTAL,i2,10,0,1000);
               s3 = new Scrollbar(Scrollbar.HORIZONTAL,i3,10,0,1000);
               s4 = new Scrollbar(Scrollbar.HORIZONTAL,i4,10,0,1000);
               s5 = new Scrollbar(Scrollbar.HORIZONTAL,i5,10,0,1000);
               s6 = new Scrollbar(Scrollbar.HORIZONTAL,i6,10,0,1000);
  
               butgo = new Button("SWING") ;
               butgo.setBackground(Color.red) ;
               butgo.setForeground(Color.white) ;

               add(ballch) ;
               add(s1) ;
               add(s3) ;
               add(s4) ;
               add(s5) ;
               add(s6) ;

               add(new Label(" ", Label.CENTER)) ;
               add(s2) ;
               add(butgo) ;
           }

            public boolean handleEvent(Event evt) {
               if(evt.id == Event.ACTION_EVENT) {
                  this.handleBut(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_ABSOLUTE) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_LINE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_DOWN) {
                  this.handleBar(evt) ;
                  return true ;
               }
               if(evt.id == Event.SCROLL_PAGE_UP) {
                  this.handleBar(evt) ;
                  return true ;
               }
               else return false ;
          }
  
          public void handleBar(Event evt) {     // ball inputs
             int i1,i2,i3,i4,i5,i6;
             double v1,v2,v3,v4,v5,v6 ;
             float fl1,fl2,fl3,fl4,fl5,fl6 ;

             i1 = s1.getValue() ;
             i2 = s2.getValue() ;
             i3 = s3.getValue() ;

             vmn1 = vmmin;    vmx1 = vmmax ;
             vmn2 = wndmin;    vmx2 = wndmax ;
             vmn3 = langmin;    vmx3 = langmax ;

             v1 = i1 * (vmx1 - vmn1)/ 1000. + vmn1 ;
             v2 = i2 * (vmx2 - vmn2)/ 1000. + vmn2 ;
             v3 = i3 * (vmx3 - vmn3)/ 1000. + vmn3 ;
 
             vmuzld = v1 ;
             vmuzl = vmuzld / lconv1 * 88.0 / 60.0 ;
             windd = v2 ;
             wind = windd / lconv1 * 88.0 / 60.0 ;
             lnchang = v3 ;

             fl1 = filter3(v1) ;
             fl2 = filter3(v2) ;
             fl3 = filter3(v3) ;

             lt.f1.setText(String.valueOf(fl1)) ;
             lt.f2.setText(String.valueOf(fl2)) ;
             lt.f3.setText(String.valueOf(fl3)) ;

             if (balflag == 1) {
                i4 = s4.getValue() ;
                vmn4 = cdmin;    vmx4 = cdmax ;
                v4 = i4 * (vmx4 - vmn4)/ 1000. + vmn4 ;
                cd = v4 ;
                fl4 = filter3(v4) ;
                lt.f4.setText(String.valueOf(fl4)) ;
                i5 = s5.getValue() ;
                vmn5 = diamin;    vmx5 = diamax ;
                v5 = i5 * (vmx5 - vmn5)/ 1000. + vmn5 ;
                diameter = v5 ;
                catot = 3.1415926 * .25 * diameter * diameter ;
                fl5 = filter3(v5) ;
                lt.f5.setText(String.valueOf(fl5)) ;
                i6 = s6.getValue() ;
                vmn6 = wtmin;    vmx6 = wtmax ;
                v6 = i6 * (vmx6 - vmn6)/ 1000. + vmn6 ;
                weight = v6 ;
                fl6 = filter3(v6) ;
                lt.f6.setText(String.valueOf(fl6)) ;
             }

             solve.comPute() ;

           }  // end handle bar

           public void handleBut(Event evt) {
             int iball,i4,i5,i6 ;
             double angle ;

             iball  = ballch.getSelectedIndex() ;

             switch (iball) {
                case 0:{                            // baseball
                    balflag = 0;
                    diameter = 2.87 ;
                    weight = 5.0 ;
                    cd = .3 ;
                    lt.f4.setText(String.valueOf(filter3(cd))) ;
                    lt.f4.setBackground(Color.black) ;
                    lt.f4.setForeground(Color.yellow) ;
                    i4 = (int) (((cd - cdmin)/(cdmax-cdmin))*1000.) ;  
                    rt.s4.setValue(i4) ;
                    lt.f5.setText(String.valueOf(filter3(diameter))) ;
                    lt.f5.setBackground(Color.black) ;
                    lt.f5.setForeground(Color.yellow) ;
                    i5 = (int) (((diameter - diamin)/(diamax-diamin))*1000.) ;  
                    rt.s5.setValue(i5) ;
                    lt.f6.setText(String.valueOf(filter3(weight))) ;
                    lt.f6.setBackground(Color.black) ;
                    lt.f6.setForeground(Color.yellow) ;
                    i6 = (int) (((weight - wtmin)/(wtmax-wtmin))*1000.) ;  
                    rt.s6.setValue(i6) ;
                    break ;
                }
                case 1:{                            // softball
                    balflag = 0;
                    diameter = 3.8 ;
                    weight = 6.25 ;
                    cd = .4 ;
                    lt.f4.setText(String.valueOf(filter3(cd))) ;
                    lt.f4.setBackground(Color.black) ;
                    lt.f4.setForeground(Color.yellow) ;
                    i4 = (int) (((cd - cdmin)/(cdmax-cdmin))*1000.) ;  
                    rt.s4.setValue(i4) ;
                    lt.f5.setText(String.valueOf(filter3(diameter))) ;
                    lt.f5.setBackground(Color.black) ;
                    lt.f5.setForeground(Color.yellow) ;
                    i5 = (int) (((diameter - diamin)/(diamax-diamin))*1000.) ;  
                    rt.s5.setValue(i5) ;
                    lt.f6.setText(String.valueOf(filter3(weight))) ;
                    lt.f6.setBackground(Color.black) ;
                    lt.f6.setForeground(Color.yellow) ;
                    i6 = (int) (((weight - wtmin)/(wtmax-wtmin))*1000.) ;  
                    rt.s6.setValue(i6) ;
                    break ;
                }
                case 2:{                            // input ball parameters
                    balflag = 1;
                    lt.f4.setBackground(Color.white) ;
                    lt.f4.setForeground(Color.black) ;
                    lt.f5.setBackground(Color.white) ;
                    lt.f5.setForeground(Color.black) ;
                    lt.f6.setBackground(Color.white) ;
                    lt.f6.setForeground(Color.black) ;
                    break ;
               }
             }
             catot = 3.1415926 * .25 * diameter * diameter ;

             ifuel = 1;
             irange = 1 ;
             ides = 1 ;
             istab = 1 ;
 //            weight = wtd / fconv ;
             fire = 1 ;
             comp = 1 ;
             cockcal = 0 ;
             fltim = -1.0 ;
             drag = 0.0 ;
             timrail = 0.0 ;
             spd = vmuzl ;
             llaunch = 0.0 ;
             drag = (16.0 * cd * .5 * rho * catot * spd * spd / 144.) ;
             angle = (90.0 - lnchang) * convdr ;
//               angle = lnchang * convdr ;
             vacc = (-drag*Math.sin(angle)-(weight*wtrat))/(weight/g0) ;
             hacc = (-drag*Math.cos(angle)) / (weight/g0)  ;
             cockflg = 0 ;
             vvel = spd * Math.cos(convdr*lnchang) ;
             hvel = spd * Math.sin(convdr*lnchang) ;
             grspd = hvel + wind ;
             vloc = 0.0 ;
             hloc = 0.0 ;
             hmax = 0.0 ;
             vmax = 0.0 ;
             spdmax = 0.0 ;
             npt = 0 ;
           }  // end handle but

         }  // end right
 
         class Lt extends Panel {
           Hit outerparent ;
           TextField f1, f2, f3, f4, f5, f6 ;
           Label l1, l2, l3, l4, l5, l6, lab1 ;
           Button butclr,butsav ;
  
           Lt (Hit target) {
              outerparent = target ;
              setLayout(new GridLayout(9,2,5,5)) ;

              butclr = new Button("Clear") ;
              butclr.setBackground(Color.white) ;
              butclr.setForeground(Color.blue) ;

              butsav = new Button("Save") ;
              butsav.setBackground(Color.blue) ;
              butsav.setForeground(Color.white) ;

              lab1 = new Label("Ball:", Label.RIGHT) ;
              lab1.setBackground(Color.white) ;
              lab1.setForeground(Color.red) ;

              l1 = new Label("Speed (mph)", Label.CENTER) ;
              f1 = new TextField(String.valueOf((float)vmuzld),5) ;
              f1.setBackground(Color.white) ;
              f1.setForeground(Color.black) ;

              l2 = new Label("Speed (mph)", Label.CENTER) ;
              f2 = new TextField(String.valueOf((float)windd),5) ;
              f2.setBackground(Color.white) ;
              f2.setForeground(Color.black) ;

              l3 = new Label("Angle", Label.CENTER) ;
              f3 = new TextField(String.valueOf((float)lnchang),5) ;
              f3.setBackground(Color.white) ;
              f3.setForeground(Color.black) ;

              l4 = new Label("Drag - Cd", Label.CENTER) ;
              f4 = new TextField(String.valueOf((float)cd),5) ;
              f4.setBackground(Color.black) ;
              f4.setForeground(Color.yellow) ;

              l5 = new Label("Diameter (ins)", Label.CENTER) ;
              f5 = new TextField(String.valueOf(filter3(diameter)),5) ;
              f5.setBackground(Color.black) ;
              f5.setForeground(Color.yellow) ;

              l6 = new Label("Weight (oz)", Label.CENTER) ;
              f6 = new TextField(String.valueOf(filter3(weight)),5) ;
              f6.setBackground(Color.black) ;
              f6.setForeground(Color.yellow) ;

              add(new Label(" ", Label.CENTER)) ;
              add(lab1) ;

              add(l1) ;
              add(f1) ;

              add(l3) ;
              add(f3) ;

              add(l4) ;
              add(f4) ;

              add(l5) ;
              add(f5) ;

              add(l6) ;
              add(f6) ;

              add(new Label(" ", Label.CENTER)) ;
              add(new Label("Wind", Label.CENTER)) ;

              add(l2) ;
              add(f2) ;

              add(butclr) ;
              add(butsav) ;
           }

           public boolean action(Event evt, Object arg) {
             if(evt.target instanceof TextField) {
                 this.handleText(evt,arg) ;
                 return true ;
             }
             if(evt.target instanceof Button) {
                this.handleBut(evt,arg) ;
                return true ;
             }
             else return false ;
           }
  
           public void handleBut(Event evt, Object arg) {
              String label = (String)arg ;

              int i,j;

              if(label.equals("Clear")) {
                fire = 0 ;
                comp = 0 ;
                nsav = 0 ;
                for (j=0; j<=4; ++j) {
                  for (i=0; i<=npts[j]; ++i){
                     posx[j][i] = 0.0 ;
                     posy[j][i] = 0.0 ;
                     posa[i] = pid2 ;
                     posb1 = 0.0 ;
                  }
                  npts[j] = 0 ;
                }
              }
              if(label.equals("Save")) {
                 fire = 0 ;
                 comp = 0 ;
                 npts[nsav] = npt ;
                 nsav = nsav + 1 ;
                 if (nsav == 5) nsav = 4 ;
                 for (i=0; i<=npts[nsav]; ++i){
                     posx[nsav][i] = 0.0 ;
                     posy[nsav][i] = 0.0 ;
                     posa[i] = pid2 ;
                     posb1 = 0.0 ;
                  }
                  npts[nsav] = 0 ;
              }
           }
  
           public void handleText(Event evt, Object arg) {
             Double V1,V2,V3,V4,V5,V6 ;
             double v1,v2,v3,v4,v5,v6 ;
             int i1,i2,i3,i4,i5,i6 ;
             float fl1 ;

             V1 = Double.valueOf(f1.getText()) ;
             v1 = V1.doubleValue() ;
             V2 = Double.valueOf(f2.getText()) ;
             v2 = V2.doubleValue() ;
             V3 = Double.valueOf(f3.getText()) ;
             v3 = V3.doubleValue() ;

     // muzzle velocity
             vmuzld  = v1 ;
             vmn1 = vmmin;   vmx1 = vmmax ;
             if(v1 < vmn1) {
                 vmuzld = v1 = vmn1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             if(v1 > vmx1) {
                 vmuzld =  v1 = vmx1 ;
                 fl1 = (float) v1 ;
                 f1.setText(String.valueOf(fl1)) ;
             }
             vmuzl = vmuzld / lconv1 * 88.0 / 60.0 ;
   // wind
             windd  = v2 ;
             vmn2 = wndmin;   vmx2 = wndmax ;
             if(v2 < vmn2) {
                 windd = v2 = vmn2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             if(v2 > vmx2) {
                 windd =  v2 = vmx2 ;
                 fl1 = (float) v2 ;
                 f2.setText(String.valueOf(fl1)) ;
             }
             wind = windd / lconv1 * 88.0 / 60.0 ;
  // launch angle
             lnchang  = v3 ;
             vmn3 = langmin;   vmx3 = langmax ;
             if(v3 < vmn3) {
                 lnchang = v3 = vmn3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }
             if(v3 > vmx3) {
                 lnchang =  v3 = vmx3 ;
                 fl1 = (float) v3 ;
                 f3.setText(String.valueOf(fl1)) ;
             }

             i1 = (int) (((v1 - vmn1)/(vmx1-vmn1))*1000.) ;
             i2 = (int) (((v2 - vmn2)/(vmx2-vmn2))*1000.) ;
             i3 = (int) (((v3 - vmn3)/(vmx3-vmn3))*1000.) ;
  
             rt.s1.setValue(i1) ;
             rt.s2.setValue(i2) ;
             rt.s3.setValue(i3) ;

             if (balflag == 1) {
                V4 = Double.valueOf(f4.getText()) ;
                v4 = V4.doubleValue() ;
  // drag coefficient
               cd  = v4 ;
               vmn4 = cdmin;   vmx4 = cdmax ;
               if(v4 < vmn4) {
                 cd = v4 = vmn4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
               }
               if(v4 > vmx4) {
                 cd =  v4 = vmx4 ;
                 fl1 = (float) v4 ;
                 f4.setText(String.valueOf(fl1)) ;
               }
               i4 = (int) (((v4 - vmn4)/(vmx4-vmn4))*1000.) ;
               rt.s4.setValue(i4) ;
  // diameter
               V5 = Double.valueOf(f5.getText()) ;
               v5 = V5.doubleValue() ;
               diameter  = v5 ;
               vmn5 = diamin;   vmx5 = diamax ;
               if(v5 < vmn5) {
                 diameter = v5 = vmn5 ;
                 fl1 = (float) v5 ;
                 f5.setText(String.valueOf(fl1)) ;
               }
               if(v5 > vmx5) {
                 diameter = v5 = vmx5 ;
                 fl1 = (float) v5 ;
                 f5.setText(String.valueOf(fl1)) ;
               }
               i5 = (int) (((v5 - vmn5)/(vmx5-vmn5))*1000.) ;
               rt.s5.setValue(i5) ;
               catot = 3.1415926 * .25 * diameter * diameter ;
 // weight
               V6 = Double.valueOf(f6.getText()) ;
               v6 = V6.doubleValue() ;
               weight  = v6 ;
               vmn6 = wtmin;   vmx6 = wtmax ;
               if(v6 < vmn6) {
                 weight = v6 = vmn6 ;
                 fl1 = (float) v6 ;
                 f6.setText(String.valueOf(fl1)) ;
               }
               if(v6 > vmx6) {
                 weight =  v6 = vmx6 ;
                 fl1 = (float) v6 ;
                 f6.setText(String.valueOf(fl1)) ;
               }
               i6 = (int) (((v6 - vmn6)/(vmx6-vmn6))*1000.) ;
               rt.s6.setValue(i6) ;

             }

             cg = 0.0 ;
             cp = 0.0 ;

             solve.comPute() ;

           }  // end handle
         }  //  end  left
       }   // end baseball

    }  // end  Inp

  } // end of Act

  class View extends Canvas  
         implements Runnable{
     Hit outerparent ;
     Thread runner ;
     Point locate,anchor;
   
     View (Hit target) {
         setBackground(Color.white) ;
         runner = null ;
     } 

     public Insets insets() {
        return new Insets(0,5,0,5) ;
     }
 
     public boolean mouseDown(Event evt, int x, int y) {
        anchor = new Point(x,y) ;
        return true;
     }

     public boolean mouseUp(Event evt, int x, int y) {
        handleb(x,y) ;
        return true;
     }

     public boolean mouseDrag(Event evt, int x, int y) {
        handle(x,y) ;
        return true;
     }

     public void handle(int x, int y) {  // slider widgets
       // determine location
       if (y >= 20 && y <= 375) {
         if (x <= 35 ) {   // zoom widget
           if (y >= 45 && y <= 250) {
             sldloc = y ;
             if (sldloc < 50) sldloc = 50;
             if (sldloc > 250) sldloc = 250;
             fact = facmin + (250 - sldloc) * facrat;
             if (viewflg == 0) {
               if (fact < 5.0) fact = 5.0 ;
             }
           }
         }
/*
         if (x >= 36 ) {   // translate
           locate = new Point(x,y) ;
           yt =  yt + (int) (.2*(locate.y - anchor.y)) ;
           xt =  xt + (int) (.4*(locate.x - anchor.x))  ;
           if (xt > 50000) xt = 50000 ;
           if (xt < -50000) xt = -50000 ;
           if (yt > 50000) yt = 50000 ;
           if (yt <-50000) yt = -50000 ;
         }
*/
       }
       if (viewflg == 2) {
         factc = fact ;
         xtc = xt ;
         ytc = yt ;
         sldc = sldloc ;
       }
       if (viewflg == 1) {
         facts = fact ;
         xts = xt ;
         yts = yt ;
         slds = sldloc ;
       }
       if (viewflg == 0) {
         facto = fact ;
         xto = xt ;
         yto = yt ;
         sldo = sldloc ;
       }
     }

     public void handleb(int x, int y) { // view buttons
       float fl3 ;
       int i3 ;

/*
       if (y <= 30) { 
          if (x >= 650) { // save plot
             if (viewflg == 1) {
                npts[nsav] = npt ;
                nsav = nsav + 1 ;
                if (nsav == 5) nsav = 4 ;
             }
          }
       }
       if (x <= 30) { 
          if (y >=31 && y <= 45) {  // grid switch
             gridon = -gridon ;
          }
       }
 
       if (y > 415) {
          if (x >= 100 && x <= 150) { // pad switch 
             if (viewflg == 0) setDesignView() ;
             if (viewflg == 1) setRangeView() ;
             if (viewflg == 2) setGraphView() ;
          }
          if (x >= 200 && x <= 250) { // trak switch  
             trakon = -trakon ;
          }
       }

       if (y < 25) {
          if (viewflg == 0 && lnchgrf == 0) {
             if (x >=35 && x <= 95) {  // nose design
               part = 1 ;
               layin.show(act.inp, "nos")  ;
               act.inp.nose.lt.butgo.setBackground(Color.white) ;
               act.inp.nose.lt.butgo.setForeground(Color.blue) ;
             }
             if (x >=100 && x <= 160) {  // payload design
               part = 2 ;
               layin.show(act.inp, "pay")  ;
               act.inp.payl.lt.butgo.setBackground(Color.white) ;
               act.inp.payl.lt.butgo.setForeground(Color.blue) ;
             }
             if (x >=165 && x <= 225) {  // body design
               part = 3 ;
               if (rktype < 2 || rktype > 2){
                  layin.show(act.inp, "bod")  ;
                  act.inp.body.lt.butgo.setBackground(Color.white) ;
                  act.inp.body.lt.butgo.setForeground(Color.blue) ;
               }
               if (rktype == 2){
                  layin.show(act.inp, "bot")  ;
                  act.inp.boti.lt.butgo.setBackground(Color.white) ;
                  act.inp.boti.lt.butgo.setForeground(Color.blue) ;
               }
             }
             if (x >=230 && x <= 295) {  // fins design
               part = 4 ;
               layin.show(act.inp, "fin")  ;
               act.inp.fins.lt.butgo.setBackground(Color.white) ;
               act.inp.fins.lt.butgo.setForeground(Color.blue) ;
             }
             ides = 0 ;
             act.con.btm1.setBackground(Color.white) ;
             act.con.btm1.setForeground(Color.blue) ;
             act.con.btm4.setBackground(Color.white) ;
             act.con.btm4.setForeground(Color.blue) ;
          }
       }
*/
       view.repaint() ;
     }

     public void start() {
        if (runner == null) {
           runner = new Thread(this) ;
           runner.start() ;
        }
     }

     public void run() {
       int timer,i ;
       double vvld,hvld,angle,deltmx,oldmass,newmass;
       double vald,hald,grald;
       String outht,outspd,outfor,outpres ;
   
       timer = 100 ;
       deltim  = .2 ;
       angle = pid2 ;
       oldmass = 115. * .00237 /1728. ;
       while (true) {
          try { Thread.sleep(timer); }
          catch (InterruptedException e) {}
          outht = " ft" ;
          if (lunits == 1) outht = " m" ;
          outspd = " fps" ;
          if (lunits == 1) outspd = " mps" ;
          outfor = " oz" ;
          if (lunits == 1) outfor = " g" ;
          outpres = " psi" ;
          if (lunits == 1) outpres = " kPa" ;
          posa[0] = (90.0 - lnchang) * convdr ;
          if (fire == 1) {  // launch sequence
             if (comp == 1 && istab == 1 && 
               irange == 1 && ifuel == 1 && ides == 1) {
               fltim = fltim + deltim ;
               if (planet == 2) wind = 0.0 ;  // no wind on the moon
      // countdown
      // flight
               if (fltim >= 0.0) {
      // thrust
                  if (rktype == 10) {  // ballistic-no thrust or recovery
                      rtype = 0 ;
                      wtflt = weight * wtrat ;
                      thrust = 0.0 ;
                      deltim = .05 ;
                  }
                  if (rktype == 1) {  // stomp rocket-no thrust or recovery
                      rtype = 0 ;
                      wtflt = weight * wtrat ;
                      thrust = 0.0 ;
                      deltim = .05 ;
                  }
                  if (rktype == 2) {  // bottle rocket-thrust or recovery
                      if (vloc <= llaunch &&
                            fltim <= (timrail + .15) 
                           ) { // launch tube-constant weight-constant vol
                         wtflt = weight * wtrat ;
                         thrust = (fpres - ps0)  * noza * 16.0 ;
                         instwat = wat ;
                         instair = volair ;
                         instpres = fpres ;
                         deltim = .01 ;
                         tim2 = fltim ;
                         oldmass = instair * .00237 /1728. ;
                      }
                      if (vloc >= llaunch && 
                                   instwat >= 0.01 && 
                                   instpres >= ps0) { // water expulsion
                         deltim = .01 ;
                         volrat = volair / instair ;
                         instpres = fpres * Math.pow(volrat,1.4) ;
                                // 1.94 slug/cu ft = density water
                         if (instpres >= ps0) {
                           uexit = Math.sqrt(2.0 * (instpres - ps0) * 144 / 1.94) ; // ft/sec
                         }
                         if (instpres <= ps0) {
                           uexit = 0.0 ;
                         }
                         mdot = 1.94 * uexit * noza / 144. ;  //   slug/sec
                         thrust = mdot * uexit * 16.0 ;  //  oz
                         instwat = instwat - mdot * deltim * 1728. / 1.94 ;  // cu in
                         instair = 115. - instwat ;
                         oldmass = instair * .00237 /1728. ;
                         wtflt = (weight - wfuel + instwat * .578) * wtrat ; // oz
                         tim2 = fltim ;
                      }
                      if (instwat <= 0.0 ) instwat = 0.0 ;
                      if (vloc >= llaunch && 
                                   instwat <=  0.05 &&
                                   instpres <= ps0 ) {  // out of fuel-thrust =  0
                         wtflt = (weight - wfuel) * wtrat ;
                         thrust = 0.0 ;
                         deltim = .2 ;
                      }
                      if (vloc >= llaunch && 
                                   instwat <= 0.0 && 
                                   instpres >= ps0) { //out of fuel .. pressure pop 
                         wtflt = (weight - wfuel) * wtrat ;
                         uexit = Math.sqrt(1.4 * rgas * ts0) ;
                         mdot = .34346 * noza * (instpres/14.7) / 32.2 ;
                         newmass = oldmass - mdot * deltim ;
                         if (newmass >= 0.0 ) {
                             thrust = mdot * uexit * 16.0 
                                  + (instpres - ps0) * noza * 16.0 ; 
                             instpres = instpres * Math.pow(newmass/oldmass,1.4) ;
                             oldmass = newmass ;
                         }
                         if (newmass < 0.0) {
                             thrust = 0.0 ;
                             instpres = 0.0 ;
                         }
                         if (instpres <= ps0) instpres = ps0 -.05 ;
                      }
/*
 act.con.diag4.setText(String.valueOf(instpres)) ;
 act.con.diag3.setText(String.valueOf(instpres)) ;
 act.con.diag2.setText(String.valueOf(instpres)) ;
 act.con.diag1.setText(String.valueOf(filter0(wher1))) ;
*/
                      if (instpres <= ps0) { 
                         wtflt = (weight - wfuel) * wtrat ;
                         thrust = 0.0 ;
                         deltim = .2 ;
                      }
                  }
                  if (rktype == 3) {  // model rocket - thrust and recovery system
                      if (nstage == 1) {
                         wtflt = (weight - (fltim/tim2)*wfuel) * wtrat ;
                         if (fltim > tim2) wtflt = (weight - wfuel) * wtrat ;
                         if(fltim <= tim1) {
                            thrust = 16.0*th1 ;
                            deltim = tim1 / 10.0 ;
                         }
                      }
                      if (nstage == 2) {
                         if (fltim < tim1) deltim = tim1 / 30.0 ;
                         if (fltim < tim2b1) {
                           wtflt = (weight - (fltim/tim2b1)*wfuelb1) * wtrat ;
                           if(fltim <= tim1b1) thrust = 16.0*th1b1 ;
                           if(fltim >= tim1b1) thrust = 16.0*th2b1 ; 
                         }
                         if ((fltim >= tim2b1) && (fltim < tim2)) {
                           wtflt = (weight - wfuelb1 - wengb1 - 
                              ((fltim - tim2b1)/(tim2 - tim2b1))*wfuel) * wtrat ;
                           thrust = 16.0*th1 ;
                         }
                         if (fltim > tim2) {
                           wtflt = (weight - wfuelb1 - wengb1 -wfuel) * wtrat ;
                         }
                      }
                      if((fltim >= tim1) && (fltim < tim2)) {
                          thrust = 16.0*th2 ;
                      }
                      if((fltim >= tim2) && (fltim < timd)) {
                          thrust = 0.0 ;
                          deltim = .2 ;
                      }
                  }

                  vvld = vvel ;
                  hvld = hvel ;
                  grald = grspd ;
                  vald = vacc ;
                  hald = hacc ;

        // powered  and coasting
                  if (fltim < timd || rtype == 0 || planet == 1 || planet == 2) {
                     angle = Math.atan2(vvel,hvel) ;
                     if (vloc < llaunch && fltim < timd) {
                        angle = (90.0 - lnchang) * convdr ;
  //                      angle =  lnchang * convdr ;
                     }
                     if (cockflg == 1 && cockcal == 1) {
                        angle = pid2 + Math.atan2(wind-hvel,vvel) ;
                     }

                     vacc = ((thrust-drag)*Math.sin(angle)-wtflt)/(wtflt/(g0 * wtrat)) ;
                     hacc = (thrust-drag)*Math.cos(angle) / (wtflt/(g0 * wtrat))  ;
                     vvel = vvld + .5 * (vacc + vald) * deltim ;
                     hvel = hvld + .5 * (hacc + hald) * deltim ;
                     spd = Math.sqrt(vvel*vvel + hvel*hvel) ;
                     drag = (16.0 * cd * .5 * rho * catot * spd * spd / 144.) ; 
                     grspd = hvel + wind ;
                  }

        // recovery
                  if (fltim >= timd && rtype >= 1 && (planet == 0 || planet == 3)) {
                     vvel = -Math.sqrt((2.0 * wtflt * 144.)/
                                       (16.0 * cdrec * rho * carec));
                     spd = -vvel ;
                     angle = -pid2 ;
                     hvel = -hvld ;
                     grspd = hvel + wind ;
                     deltmx = 1.0 ;
                     if (vmax > 500.) deltmx = 2.0 ;
                     if (vmax > 700.) deltmx = 3.0 ;
                     if (vmax > 1000.) deltmx = 5.0 ;
                     deltim = deltim + .2 ;
                     if (deltim > deltmx) deltim = deltmx ;
                     drag = wtflt ;
                  }

                  vloc = vloc + .5 * (vvel + vvld) * deltim ;
                  hloc = hloc + .5 * (grspd +grald) * deltim ;

                  npt = npt + 1 ;
                  posx[nsav][npt] = hloc ;

          // determine if on or off rail ..
                  if (vloc < llaunch && fltim < tim1) {
                     timrail = fltim ;
                     posx[nsav][npt] = hloc ;
                  }

                  posy[nsav][npt] = vloc ;
                  posa[npt] = angle ;

          // determine if engine burning        
                  if (rktype == 3 || rktype == 2) {    
                    if (fltim <= tim2) nburn = npt ;
          // discarded 1st stage
                    if (nstage == 2) {
                      if (fltim <= tim2b1) posb1 = posy[nsav][npt] ;
                      if (fltim > tim2b1) posb1 = vloc - 100.0 * (fltim - tim2b1) ;
                    }
                  }

                  cockcal = 0 ;
                  if (fltim > timrail && fltim < tim2) cockcal = 1;
         // deploy parachute for bottle rocket at apogee
                  if (rktype == 2 && rtype >= 1 && fltim < timd) {
                     if (vvel < 0.0) timd = fltim ;
                  }

               }
     // update maximums
               if (vloc > vmax) {
                  vmax = vloc ;
               }
               if (Math.abs(posx[nsav][npt]) > Math.abs(hmax)) {
                  hmax = posx[nsav][npt] ;
               }
               if (spd > spdmax) {
                  spdmax = spd;
               }
     // shutdown .. hit the ground
               if (vloc < 0.0 ) {  
                  posa[npt] = 0.0 ;
                  comp = 0 ;
                  vloc = 0.0 ;
                  irange = 0 ;
                  ifuel = 0 ;
               }
             }
 
     // strip charts
             posx[5][npt] = 10.0*fltim ;
             posy[5][npt] = thrust ;
             posx[6][npt] = 10.0*fltim ;
             posy[6][npt] = wtflt ;
             posx[7][npt] = 10.0*fltim ;
             posy[7][npt] = drag ;
             posx[8][npt] = 10.0*fltim ;
             posy[8][npt] = vvel ;
             posx[9][npt] = 10.0*fltim ;
             posy[9][npt] = vloc ;

             if (stepon == 1) {
                comp = 0 ;
                if (step == 1) {
                  comp = 1;
                  step = 0 ;
                } 
             }
          }
     // reset integration
          if (fire == 0) {
             wtflt = weight * wtrat ;
             thrust = 0.0 ;
             timrail = 0.0 ;
             deltim = .2 ;
             fltim = 0.0 ;
             hloc = 0.0 ;
             vloc = 0.0 ;
             vvel = 0.0 ;
             hvel = 0.0 ;
             vmax = 0.0 ;
             hmax = 0.0 ;
             spdmax = 0.0 ;
             npt = 0 ;
             nburn = 0 ;
  
          }
          if (trakon > 0 && viewflg == 1) {  // tracking view
             fact = 2.5 ;
             if (planet == 2) fact = .06 ;
             if (planet == 3) fact = .11 ;
             xt = 160 - (int)(fact * posx[nsav][npt]) ;
             yt = 260 + (int)(fact * posy[nsav][npt]) ;
          }
          view.repaint() ;
 
       }
     }

     public void update(Graphics g) {
           view.paint(g) ;
     }
 
     public void paint(Graphics g) {
        int i,j,k,n ;
        int nump ;
        int exes[] = new int[9] ;
        int whys[] = new int[9] ;
        int ylabel,ylabel2,xlabel,xlabel2;
        double yval,xval,scale,btbase;
        double cpa,spa,nosx,nosy,hstg,pumph;
        double factm ;
        String words,outlng ;
        Color col1,col2 ;

        col1 = new Color(0,121,0) ;   // dark green
        col2 = new Color(254,121,0) ; // dark orange
 
 // design view
        if (viewflg == 0) {
           offsGg.setColor(Color.white) ;
           offsGg.fillRect(0,0,750,600) ;
           if (gridon >= 0) {       // Grid paper background
             if (lunits == 0) {
                for (j=0; j<=60; ++j) {
                  offsGg.setColor(Color.cyan) ;
                  if ((j/12) * 12 == j) offsGg.setColor(Color.blue) ;
                  whys[0] = 0 ; whys[1] = 500 ;
                  exes[0] = exes[1] = (int) (fact*(j)) + xt  ;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  exes[0] = exes[1] = (int) (-fact*(j)) + xt  ;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                }
                for (j=0; j<=60; ++j) {
                  offsGg.setColor(Color.cyan) ;
                  if ((j/12) * 12 == j) offsGg.setColor(Color.blue) ;
                  exes[0] = 0 ; 
                  exes[1] = 500 ;
                  whys[0] = whys[1] = (int) (fact*(j)) + yt;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  whys[0] = whys[1] = (int) (-fact*(j)) + yt;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  if (j == 1) {
                     whys[0] = (int) (-fact*(j)) + yt;
                     offsGg.setColor(Color.black) ;
                     offsGg.drawString("1 inch",230,whys[0]+5) ; 
                  }
                  if (j == 12) {
                     whys[0] = (int) (-fact*(j)) + yt;
                     offsGg.setColor(Color.blue) ;
                     offsGg.drawString("1 foot",230,whys[0]+5) ; 
                  }
                }
             }
             if (lunits == 1) {
                for (j=0; j<=60; ++j) {
                  offsGg.setColor(Color.cyan) ;
                  if ((j/12) * 12 == j) offsGg.setColor(Color.blue) ;
                  whys[0] = 0 ; whys[1] = 500 ;
                  exes[0] = exes[1] = (int) (fact*(j* 10.0 / lconv2)) + xt  ;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  exes[0] = exes[1] = (int) (-fact*(j* 10.0 / lconv2)) + xt  ;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                }
                for (j=0; j<=60; ++j) {
                  offsGg.setColor(Color.cyan) ;
                  if ((j/10) * 10 == j) offsGg.setColor(Color.blue) ;
                  exes[0] = 0 ; 
                  exes[1] = 500 ;
                  whys[0] = whys[1] = (int) (fact*(j *10.0 / lconv2)) + yt;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  whys[0] = whys[1] = (int) (-fact*(j * 10.0 / lconv2)) + yt;
                  offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                  if (j == 1) {
                     whys[0] = (int) (-fact*(j* 10.0 / lconv2)) + yt;
                     offsGg.setColor(Color.black) ;
                     offsGg.drawString("10 cm",230,whys[0]+5) ; 
                  }
                  if (j == 10) {
                     whys[0] = (int) (-fact*(j* 10.0 / lconv2)) + yt;
                     offsGg.setColor(Color.blue) ;
                     offsGg.drawString("1 meter",230,whys[0]+5) ; 
                  }
                }
             }
           }
   
           if (rktype < 2 || rktype > 2) {
         // tail fairing
              exes[0] = (int) (fact*(-brad)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(-trad)) + xt ;
              whys[1] = (int) (fact*(tlngth)) + yt ;
              exes[2] = (int) (fact*(trad)) + xt ;
              whys[2] = (int) (fact*(tlngth)) + yt ;
              exes[3] = (int) (fact*(brad)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(-brad)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,4) ;
        // body tube
              exes[0] = (int) (fact*(-brad)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(-brad)) + xt ;
              whys[1] = (int) (fact*(-blngth)) + yt ;
              exes[2] = (int) (fact*(brad)) + xt ;
              whys[2] = (int) (fact*(-blngth)) + yt ;
              exes[3] = (int) (fact*(brad)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(-brad)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.green) ;
              offsGg.fillPolygon(exes,whys,4) ;
           }
      // bottle rocket
           if (rktype ==  2) {
         // tail fairing
              if (btfair == 1) {
                 exes[0] = (int) (fact*(-brad)) + xt ;
                 whys[0] = (int) (fact*(-4.0)) + yt ;
                 exes[1] = (int) (fact*(-btrad)) + xt ;
                 whys[1] = (int) (fact*(-(4.0 - btlngth))) + yt ;
                 exes[2] = (int) (fact*(btrad)) + xt ;
                 whys[2] = (int) (fact*(-(4.0 - btlngth))) + yt ;
                 exes[3] = (int) (fact*(brad)) + xt ;
                 whys[3] = (int) (fact*(-4.0)) + yt ;
                 exes[4] = (int) (fact*(-brad)) + xt ;
                 whys[4] = (int) (fact*(-4.0)) + yt ;
                 offsGg.setColor(Color.red) ;
                 offsGg.fillPolygon(exes,whys,4) ;
              }
         // body
              exes[0] = (int) (fact*(-brad)) + xt ;
              whys[0] = (int) (fact*(-4.0)) + yt ;
              exes[1] = (int) (fact*(-brad)) + xt ;
              whys[1] = (int) (fact*(-12.0)) + yt ;
              exes[2] = (int) (fact*(brad)) + xt ;
              whys[2] = (int) (fact*(-12.0)) + yt ;
              exes[3] = (int) (fact*(brad)) + xt ;
              whys[3] = (int) (fact*(-4.0)) + yt ;
              exes[4] = (int) (fact*(-brad)) + xt ;
              whys[4] = (int) (fact*(-4.0)) + yt ;
              offsGg.setColor(Color.green) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(-.5)) + xt ;
              whys[0] = (int) (fact*(-1.5)) + yt ;
              exes[1] = (int) (fact*(-brad)) + xt ;
              whys[1] = (int) (fact*(-4.0)) + yt ;
              exes[2] = (int) (fact*(brad)) + xt ;
              whys[2] = (int) (fact*(-4.0)) + yt ;
              exes[3] = (int) (fact*(.5)) + xt ;
              whys[3] = (int) (fact*(-1.5)) + yt ;
              exes[4] = (int) (fact*(-.5)) + xt ;
              whys[4] = (int) (fact*(-1.5)) + yt ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(-.5)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(-.5)) + xt ;
              whys[1] = (int) (fact*(-1.5)) + yt ;
              exes[2] = (int) (fact*(.5)) + xt ;
              whys[2] = (int) (fact*(-1.5)) + yt ;
              exes[3] = (int) (fact*(.5)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(-.5)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.fillPolygon(exes,whys,4) ;
           }
        // payload fairing
           exes[0] = (int) (fact*(-brad)) + xt ;
           whys[0] = (int) (fact*(-blngth)) + yt ;
           exes[1] = (int) (fact*(-prad)) + xt ;
           whys[1] = (int) (fact*(-(blngth + qlngth))) + yt ;
           exes[2] = (int) (fact*(prad)) + xt ;
           whys[2] = (int) (fact*(-(blngth + qlngth))) + yt ;
           exes[3] = (int) (fact*(brad)) + xt ;
           whys[3] = (int) (fact*(-blngth)) + yt ;
           exes[4] = (int) (fact*(-brad)) + xt ;
           whys[4] = (int) (fact*(-blngth)) + yt ;
           offsGg.setColor(Color.blue) ;
           offsGg.fillPolygon(exes,whys,4) ;
        // payload tube
           exes[0] = (int) (fact*(-prad)) + xt ;
           whys[0] = (int) (fact*(-(blngth + qlngth))) + yt ;
           exes[1] = (int) (fact*(-prad)) + xt ;
           whys[1] = (int) (fact*(-(blngth + qlngth + plngth))) + yt ;
           exes[2] = (int) (fact*(prad)) + xt ;
           whys[2] = (int) (fact*(-(blngth + qlngth + plngth))) + yt ;
           exes[3] = (int) (fact*(prad)) + xt ;
           whys[3] = (int) (fact*(-(blngth + qlngth))) + yt ;
           exes[4] = (int) (fact*(-prad)) + xt ;
           whys[4] = (int) (fact*(-(blngth + qlngth))) + yt ;
           offsGg.setColor(Color.green) ;
           offsGg.fillPolygon(exes,whys,4) ;
        // nose
           if (ntype == 0) {   // cone
              exes[0] = (int) (fact*(-nrad)) + xt ;
              whys[0] = (int) (fact*(-(blngth + qlngth + plngth))) + yt ;
              exes[1] = (int) (fact*(0.0)) + xt ;
              whys[1] = (int) (fact*(-(blngth + qlngth + plngth + nlngth))) + yt ;
              exes[2] = (int) (fact*(nrad)) + xt ;
              whys[2] = (int) (fact*(-(blngth + qlngth + plngth))) + yt ;
              exes[3] = (int) (fact*(-nrad)) + xt ;
              whys[3] = (int) (fact*(-(blngth + qlngth + plngth))) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,3) ;
           }
           if (ntype == 2 ) {   // parabola 
              for (j=1; j<=8; ++j) {
                yval = (j-1) * nlngth / 7.0 ;
                xval = nrad * (1.0 - (yval*yval/nlngth/nlngth));
                whys[j] = (int) (fact*(-(blngth + qlngth + plngth + yval)))+yt;
                exes[j] = (int) (fact*(xval)) + xt ;
              }
              exes[0] = (int) (fact*(0.0)) + xt ;
              whys[0] = (int) (fact*(-(blngth + qlngth + plngth)))+yt;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,9) ;
              for (j=1; j<=8; ++j) {
                yval = (j-1) * nlngth / 7.0 ;
                xval = nrad * (1.0 - (yval*yval/nlngth/nlngth));
                whys[j] = (int) (fact*(-(blngth + qlngth + plngth + yval)))+yt;
                exes[j] = (int) (fact*(-xval)) + xt ;
              }
              offsGg.fillPolygon(exes,whys,9) ;
           }
           if (ntype == 1 || ntype == 3) {   // ellipse 
              exes[0] = (int) (fact*(-nrad)) + xt ;
              whys[0] = (int) (fact*(-(blngth + qlngth + plngth + nlngth))) + yt ;
              exes[1] = (int) (fact*(2.0*nrad));
              whys[1] = (int) (fact*(2.0*nlngth));
              offsGg.setColor(Color.red) ;
              offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],0,180) ;
           }
        //  fins
           if (rktype < 2 || rktype > 2) {
              if (fintype == 0) {   // trapezoidal
                 exes[0] = (int) (fact*(-(brad + finx[0][0]))) + xt ;
                 whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                 exes[1] = (int) (fact*(-(brad + finx[0][1]))) + xt ;
                 whys[1] = (int) (fact*(-finy[0][1])) + yt ;
                 exes[2] = (int) (fact*(-(brad + finx[0][2]))) + xt ;
                 whys[2] = (int) (fact*(-finy[0][2])) + yt ;
                 exes[3] = (int) (fact*(-(brad + finx[0][3]))) + xt ;
                 whys[3] = (int) (fact*(-finy[0][3])) + yt ;
                 exes[4] = (int) (fact*(-(brad + finx[0][0]))) + xt ;
                 whys[4] = (int) (fact*(-finy[0][0])) + yt ;
                 offsGg.setColor(Color.black) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(brad + finx[0][0])) + xt ;
                 exes[1] = (int) (fact*(brad + finx[0][1])) + xt ;
                 exes[2] = (int) (fact*(brad + finx[0][2])) + xt ;
                 exes[3] = (int) (fact*(brad + finx[0][3])) + xt ;
                 exes[4] = (int) (fact*(brad + finx[0][0])) + xt ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(0.0)) + xt ;
                 offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                 offsGg.drawLine(exes[0],whys[1],exes[0],whys[2]) ;
                 offsGg.drawLine(exes[0],whys[2],exes[0],whys[3]) ;
              }
              if (fintype == 1) {  // elliptical
                 exes[0] = (int) (fact*(brad + finx[0][0])) + xt ;
                 whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                 exes[1] = (int) (fact*(finx[0][1]));
                 whys[1] = (int) (fact*(finy[0][1]));
                 offsGg.setColor(Color.black) ;
                 offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,-180) ;
                 exes[0] = (int) (fact*(-brad + finx[0][0])) + xt ;
                 offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,180) ;
                 exes[0] = (int) (fact*(0.0)) + xt ;
                 whys[0] = (int) (fact*(-floc)) + yt ;
                 whys[1] = (int) (fact*(-(floc + flngth))) + yt ;
                 offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
              }
           }
       // bottle rocket
           if (rktype == 2) {
              if (floc <= 1.5) {
                 btbase = btrad ;
                 if (btfair == 0) btbase = .5 ;
                 if (fintype == 0) {   // trapezoidal
                    exes[0] = (int) (fact*(-(btbase + finx[0][0]))) + xt ;
                    whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                    exes[1] = (int) (fact*(-(btbase+ finx[0][1]))) + xt ;
                    whys[1] = (int) (fact*(-finy[0][1])) + yt ;
                    exes[2] = (int) (fact*(-(btbase + finx[0][2]))) + xt ;
                    whys[2] = (int) (fact*(-finy[0][2])) + yt ;
                    exes[3] = (int) (fact*(-(btbase + finx[0][3]))) + xt ;
                    whys[3] = (int) (fact*(-finy[0][3])) + yt ;
                    exes[4] = (int) (fact*(-(btbase + finx[0][0]))) + xt ;
                    whys[4] = (int) (fact*(-finy[0][0])) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(btbase + finx[0][0])) + xt ;
                    exes[1] = (int) (fact*(btbase + finx[0][1])) + xt ;
                    exes[2] = (int) (fact*(btbase + finx[0][2])) + xt ;
                    exes[3] = (int) (fact*(btbase + finx[0][3])) + xt ;
                    exes[4] = (int) (fact*(btbase + finx[0][0])) + xt ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(0.0)) + xt ;
                    offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                    offsGg.drawLine(exes[0],whys[1],exes[0],whys[2]) ;
                    offsGg.drawLine(exes[0],whys[2],exes[0],whys[3]) ;
                 }
                 if (fintype == 1) {  // elliptical
                    exes[0] = (int) (fact*(btbase + finx[0][0])) + xt ;
                    whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                    exes[1] = (int) (fact*(finx[0][1]));
                    whys[1] = (int) (fact*(finy[0][1]));
                    offsGg.setColor(Color.black) ;
                    offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,-180) ;
                    exes[0] = (int) (fact*(-btbase + finx[0][0])) + xt ;
                    offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,180) ;
                    exes[0] = (int) (fact*(0.0)) + xt ;
                    whys[0] = (int) (fact*(-floc)) + yt ;
                    whys[1] = (int) (fact*(-(floc + flngth))) + yt ;
                    offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                 }
              }
              else {
                 if (fintype == 0) {   // trapezoidal
                    exes[0] = (int) (fact*(-(brad + finx[0][0]))) + xt ;
                    whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                    exes[1] = (int) (fact*(-(brad + finx[0][1]))) + xt ;
                    whys[1] = (int) (fact*(-finy[0][1])) + yt ;
                    exes[2] = (int) (fact*(-(brad + finx[0][2]))) + xt ;
                    whys[2] = (int) (fact*(-finy[0][2])) + yt ;
                    exes[3] = (int) (fact*(-(brad + finx[0][3]))) + xt ;
                    whys[3] = (int) (fact*(-finy[0][3])) + yt ;
                    exes[4] = (int) (fact*(-(brad + finx[0][0]))) + xt ;
                    whys[4] = (int) (fact*(-finy[0][0])) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(brad + finx[0][0])) + xt ;
                    exes[1] = (int) (fact*(brad + finx[0][1])) + xt ;
                    exes[2] = (int) (fact*(brad + finx[0][2])) + xt ;
                    exes[3] = (int) (fact*(brad + finx[0][3])) + xt ;
                    exes[4] = (int) (fact*(brad + finx[0][0])) + xt ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(0.0)) + xt ;
                    offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                    offsGg.drawLine(exes[0],whys[1],exes[0],whys[2]) ;
                    offsGg.drawLine(exes[0],whys[2],exes[0],whys[3]) ;
                 }
                 if (fintype == 1) {  // elliptical
                    exes[0] = (int) (fact*(brad + finx[0][0])) + xt ;
                    whys[0] = (int) (fact*(-finy[0][0])) + yt ;
                    exes[1] = (int) (fact*(finx[0][1]));
                    whys[1] = (int) (fact*(finy[0][1]));
                    offsGg.setColor(Color.black) ;
                    offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,-180) ;
                    exes[0] = (int) (fact*(-brad + finx[0][0])) + xt ;
                    offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,180) ;
                    exes[0] = (int) (fact*(0.0)) + xt ;
                    whys[0] = (int) (fact*(-floc)) + yt ;
                    whys[1] = (int) (fact*(-(floc + flngth))) + yt ;
                    offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                 }
              }
           }
           if (nstage == 2) {
          // booster 1 tube
              exes[0] = (int) (fact*(-brad)) + xt ;
              whys[0] = (int) (fact*(tlngth)) + yt ;
              exes[1] = (int) (fact*(-brad)) + xt ;
              whys[1] = (int) (fact*(tlngth + b1lngth)) + yt ;
              exes[2] = (int) (fact*(brad)) + xt ;
              whys[2] = (int) (fact*(tlngth + b1lngth)) + yt ;
              exes[3] = (int) (fact*(brad)) + xt ;
              whys[3] = (int) (fact*(tlngth)) + yt ;
              exes[4] = (int) (fact*(-brad)) + xt ;
              whys[4] = (int) (fact*(tlngth)) + yt ;
              offsGg.setColor(Color.green) ;
              offsGg.fillPolygon(exes,whys,4) ;
        //  booster fins
              if (fintype == 0) {   // trapezoidal
                 exes[0] = (int) (fact*(-(brad + finx[1][0]))) + xt ;
                 whys[0] = (int) (fact*(-finy[1][0])) + yt ;
                 exes[1] = (int) (fact*(-(brad + finx[1][1]))) + xt ;
                 whys[1] = (int) (fact*(-finy[1][1])) + yt ;
                 exes[2] = (int) (fact*(-(brad + finx[1][2]))) + xt ;
                 whys[2] = (int) (fact*(-finy[1][2])) + yt ;
                 exes[3] = (int) (fact*(-(brad + finx[1][3]))) + xt ;
                 whys[3] = (int) (fact*(-finy[1][3])) + yt ;
                 exes[4] = (int) (fact*(-(brad + finx[1][0]))) + xt ;
                 whys[4] = (int) (fact*(-finy[1][0])) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(brad + finx[1][0])) + xt ;
                 exes[1] = (int) (fact*(brad + finx[1][1])) + xt ;
                 exes[2] = (int) (fact*(brad + finx[1][2])) + xt ;
                 exes[3] = (int) (fact*(brad + finx[1][3])) + xt ;
                 exes[4] = (int) (fact*(brad + finx[1][0])) + xt ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(0.0)) + xt ;
                 offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                 offsGg.drawLine(exes[0],whys[1],exes[0],whys[2]) ;
                 offsGg.drawLine(exes[0],whys[2],exes[0],whys[3]) ;
              }
              if (fintype == 1) {  // elliptical
                 exes[0] = (int) (fact*(brad + finx[1][0])) + xt ;
                 whys[0] = (int) (fact*(-finy[1][0])) + yt ;
                 exes[1] = (int) (fact*(finx[1][1]));
                 whys[1] = (int) (fact*(finy[1][1]));
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,-180) ;
                 exes[0] = (int) (fact*(-brad + finx[1][0])) + xt ;
                 offsGg.fillArc(exes[0],whys[0],exes[1],whys[1],90,180) ;
                 exes[0] = (int) (fact*(0.0)) + xt ;
                 whys[0] = (int) (fact*(-floc)) + yt ;
                 whys[1] = (int) (fact*(-(floc + flngth))) + yt ;
                 offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
              }
           }
   // labels
           exes[0] = (int) (fact*(-brad -3.0)) + xt ;
           whys[0] = (int) (fact*(-(blngth + qlngth + plngth +.5*nlngth))) + yt;
           offsGg.setColor(Color.black) ;
           if (part == 1) offsGg.setColor(Color.red) ;
           offsGg.drawString("Nose",exes[0],whys[0]) ;
           if (plngth > 0.0) {
             exes[0] = (int) (fact*(-brad -4.0)) + xt ;
             whys[0] = (int) (fact*(-(blngth + qlngth + .5*plngth))) + yt ;
             offsGg.setColor(Color.black) ;
             if (part == 2) offsGg.setColor(Color.red) ;
             offsGg.drawString("Payload",exes[0],whys[0]) ;
           }
           if (qlngth > 0.0) {
             exes[0] = (int) (fact*(-brad -4.0)) + xt ;
             whys[0] = (int) (fact*(-(blngth + .5*qlngth))) + yt ;
             offsGg.setColor(Color.black) ;
             if (part == 2) offsGg.setColor(Color.red) ;
             offsGg.drawString("Fairing",exes[0],whys[0]) ;
           }
           exes[0] = (int) (fact*(-brad -3.0)) + xt ;
           whys[0] = (int) (fact*(-.5*blngth)) + yt ;
           offsGg.setColor(Color.black) ;
           if (part == 3) offsGg.setColor(Color.red) ;
           offsGg.drawString("Body",exes[0],whys[0]) ;
           if (tlngth > 0.0) {
             exes[0] = (int) (fact*(-brad -4.0)) + xt ;
             whys[0] = (int) (fact*( .5*tlngth)) + yt ;
             offsGg.setColor(Color.black) ;
             if (part == 3) offsGg.setColor(Color.red) ;
             offsGg.drawString("Fairing",exes[0],whys[0]) ;
           }
           exes[0] = (int) (fact*(-(brad + finx[0][1] + 2.0))) + xt ;
           whys[0] = (int) (fact*(-finy[0][1])) + yt ;
           offsGg.setColor(Color.black) ;
           if (part == 4) offsGg.setColor(Color.red) ;
           offsGg.drawString("Fins",exes[0],whys[0]) ;

           if (lnchgrf == 1) {   // stomp launcher
                  //  launch tube
              exes[0] = (int) (fact*(-trad +.1)) + xt ;
              whys[0] = (int) (fact*(-sl+ tlngth)) + yt ;
              exes[1] = (int) (fact*(-trad +.1)) + xt ;
              whys[1] = (int) (fact*(0.0+ tlngth)) + yt ;
              exes[2] = (int) (fact*(trad - .1)) + xt ;
              whys[2] = (int) (fact*(0.0+ tlngth)) + yt ;
              exes[3] = (int) (fact*(trad - .1)) + xt ;
              whys[3] = (int) (fact*(-sl+ tlngth)) + yt ;
              exes[4] = (int) (fact*(-trad + .1)) + xt ;
              whys[4] = (int) (fact*(-sl+ tlngth)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
                       // feed lines
              exes[0] = (int) (fact*(.2)) + xt ;
              whys[0] = (int) (fact*(.6+ tlngth)) + yt ;
              exes[1] = (int) (fact*(-.2)) + xt ;
              whys[1] = (int) (fact*(.6+ tlngth)) + yt ;
              exes[2] = (int) (fact*(-.2)) + xt ;
              whys[2] = (int) (fact*(0.0+ tlngth)) + yt ;
              exes[3] = (int) (fact*(.2)) + xt ;
              whys[3] = (int) (fact*(0.0+ tlngth)) + yt ;
              exes[4] = (int) (fact*(.2)) + xt ;
              whys[4] = (int) (fact*(.6+ tlngth)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(6.2)) + xt ;
              whys[0] = (int) (fact*(.4+ tlngth)) + yt ;
              exes[1] = (int) (fact*(0.0)) + xt ;
              whys[1] = (int) (fact*(.4+ tlngth)) + yt ;
              exes[2] = (int) (fact*(0.0)) + xt ;
              whys[2] = (int) (fact*(.6+ tlngth)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(.6+ tlngth)) + yt ;
              exes[4] = (int) (fact*(6.2)) + xt ;
              whys[4] = (int) (fact*(.4+ tlngth)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(5.8)) + xt ;
              whys[0] = (int) (fact*(.4+ tlngth)) + yt ;
              exes[1] = (int) (fact*(5.8)) + xt ;
              whys[1] = (int) (fact*(0.0)) + yt ;
              exes[2] = (int) (fact*(6.2)) + xt ;
              whys[2] = (int) (fact*(0.0)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(.4+ tlngth)) + yt ;
              exes[4] = (int) (fact*(5.8)) + xt ;
              whys[4] = (int) (fact*(.4+ tlngth)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
                    // resevoir
              pumph = Math.sqrt(sv1) ;
              exes[0] = (int) (fact*(4.0)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(8.0)) + xt ;
              whys[1] = (int) (fact*(0.0)) + yt ;
              exes[2] = (int) (fact*(8.0)) + xt ;
              whys[2] = (int) (fact*(-pumph)) + yt ;
              exes[3] = (int) (fact*(4.0)) + xt ;
              whys[3] = (int) (fact*(-pumph)) + yt ;
              exes[4] = (int) (fact*(4.0)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(4.1)) + xt ;
              whys[0] = (int) (fact*(-(sv2/sv1) * pumph )) + yt ;
              exes[1] = (int) (fact*(7.9)) + xt ;
              whys[1] = (int) (fact*(-(sv2/sv1) * pumph )) + yt ;
              exes[2] = (int) (fact*(7.9)) + xt ;
              whys[2] = (int) (fact*(-pumph +.1)) + yt ;
              exes[3] = (int) (fact*(4.1)) + xt ;
              whys[3] = (int) (fact*(-pumph +.1)) + yt ;
              exes[4] = (int) (fact*(4.1)) + xt ;
              whys[4] = (int) (fact*(-(sv2/sv1) * pumph )) + yt ;
              offsGg.setColor(Color.yellow) ;
              offsGg.fillPolygon(exes,whys,4) ;
                   // plunger
              exes[0] = (int) (fact*(5.8)) + xt ;
              whys[0] = (int) (fact*(-pumph)) + yt ;
              exes[1] = (int) (fact*(5.8)) + xt ;
              whys[1] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[2] = (int) (fact*(6.2)) + xt ;
              whys[2] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(-pumph)) + yt ;
              exes[4] = (int) (fact*(5.8)) + xt ;
              whys[4] = (int) (fact*(-pumph)) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(5.0)) + xt ;
              whys[0] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[1] = (int) (fact*(7.0)) + xt ;
              whys[1] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[2] = (int) (fact*(7.0)) + xt ;
              whys[2] = (int) (fact*(-pumph - 1.2)) + yt ;
              exes[3] = (int) (fact*(5.0)) + xt ;
              whys[3] = (int) (fact*(-pumph - 1.2)) + yt ;
              exes[4] = (int) (fact*(5.0)) + xt ;
              whys[4] = (int) (fact*(-pumph - 1.0)) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,4) ;
                 // labels
              exes[0] = (int) (fact*(4.0)) + xt ;
              whys[0] = (int) (fact*(1.5+ tlngth)) + yt;
              offsGg.setColor(Color.black) ;
              offsGg.drawString("Propulsion",exes[0],whys[0]) ;
              exes[0] = (int) (fact*(trad + 1.5)) + xt ;
              whys[0] = (int) (fact*(- .5+ tlngth)) + yt ;
              offsGg.drawString("Length",exes[0],whys[0]) ;
           }
           if (lnchgrf == 2) {   // bottle rocket
                  // fuel 
              if (wat < 1.178) {
                 exes[0] = (int) (fact*(-.5)) + xt ;
                 whys[0] = (int) (fact*(0.0)) + yt ;
                 exes[1] = (int) (fact*(-.5)) + xt ;
                 whys[1] = (int) (fact*(-hwat)) + yt ;
                 exes[2] = (int) (fact*(.5)) + xt ;
                 whys[2] = (int) (fact*(-hwat)) + yt ;
                 exes[3] = (int) (fact*(.5)) + xt ;
                 whys[3] = (int) (fact*(0.0)) + yt ;
                 exes[4] = (int) (fact*(-.5)) + xt ;
                 whys[4] = (int) (fact*(0.0)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
              }
              if ((wat >= 1.178) && (wat <= 14.922)) {
                 exes[0] = (int) (fact*(-.5)) + xt ;
                 whys[0] = (int) (fact*(0.0)) + yt ;
                 exes[1] = (int) (fact*(-.5)) + xt ;
                 whys[1] = (int) (fact*(-1.5)) + yt ;
                 exes[2] = (int) (fact*(.5)) + xt ;
                 whys[2] = (int) (fact*(-1.5)) + yt ;
                 exes[3] = (int) (fact*(.5)) + xt ;
                 whys[3] = (int) (fact*(0.0)) + yt ;
                 exes[4] = (int) (fact*(-.5)) + xt ;
                 whys[4] = (int) (fact*(0.0)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(-.5)) + xt ;
                 whys[0] = (int) (fact*(-1.5)) + yt ;
                 exes[1] = (int) (fact*(-watrad)) + xt ;
                 whys[1] = (int) (fact*(-hwat)) + yt ;
                 exes[2] = (int) (fact*(watrad)) + xt ;
                 whys[2] = (int) (fact*(-hwat)) + yt ;
                 exes[3] = (int) (fact*(.5)) + xt ;
                 whys[3] = (int) (fact*(-1.5)) + yt ;
                 exes[4] = (int) (fact*(-.5)) + xt ;
                 whys[4] = (int) (fact*(-1.5)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
              }
              if (wat > 14.922) {
                 exes[0] = (int) (fact*(-.5)) + xt ;
                 whys[0] = (int) (fact*(0.0)) + yt ;
                 exes[1] = (int) (fact*(-.5)) + xt ;
                 whys[1] = (int) (fact*(-1.5)) + yt ;
                 exes[2] = (int) (fact*(.5)) + xt ;
                 whys[2] = (int) (fact*(-1.5)) + yt ;
                 exes[3] = (int) (fact*(.5)) + xt ;
                 whys[3] = (int) (fact*(0.0)) + yt ;
                 exes[4] = (int) (fact*(-.5)) + xt ;
                 whys[4] = (int) (fact*(0.0)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(-.5)) + xt ;
                 whys[0] = (int) (fact*(-1.5)) + yt ;
                 exes[1] = (int) (fact*(-2.0)) + xt ;
                 whys[1] = (int) (fact*(-4.0)) + yt ;
                 exes[2] = (int) (fact*(2.0)) + xt ;
                 whys[2] = (int) (fact*(-4.0)) + yt ;
                 exes[3] = (int) (fact*(.5)) + xt ;
                 whys[3] = (int) (fact*(-1.5)) + yt ;
                 exes[4] = (int) (fact*(-.5)) + xt ;
                 whys[4] = (int) (fact*(-1.5)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(-2.0)) + xt ;
                 whys[0] = (int) (fact*(-4.0)) + yt ;
                 exes[1] = (int) (fact*(-2.0)) + xt ;
                 whys[1] = (int) (fact*(-hwat)) + yt ;
                 exes[2] = (int) (fact*(2.0)) + xt ;
                 whys[2] = (int) (fact*(-hwat)) + yt ;
                 exes[3] = (int) (fact*(2.0)) + xt ;
                 whys[3] = (int) (fact*(-4.0)) + yt ;
                 exes[4] = (int) (fact*(-2.0)) + xt ;
                 whys[4] = (int) (fact*(-4.0)) + yt ;
                 offsGg.setColor(Color.blue) ;
                 offsGg.fillPolygon(exes,whys,4) ;
              }
                  //  nozzle cap
              exes[0] = (int) (fact*(-.5)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(-.5)) + xt ;
              whys[1] = (int) (fact*(-.5)) + yt ;
              exes[2] = (int) (fact*(.5)) + xt ;
              whys[2] = (int) (fact*(-.5)) + yt ;
              exes[3] = (int) (fact*(.5)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(-.5)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.black) ;
              offsGg.fillPolygon(exes,whys,4) ;
                  //  launch tube
              exes[0] = (int) (fact*(-nozrad)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(-nozrad)) + xt ;
              whys[1] = (int) (fact*(-ltub)) + yt ;
              exes[2] = (int) (fact*(nozrad)) + xt ;
              whys[2] = (int) (fact*(-ltub)) + yt ;
              exes[3] = (int) (fact*(nozrad)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(-nozrad)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.yellow) ;
              offsGg.fillPolygon(exes,whys,4) ;
                       // feed lines
              exes[0] = (int) (fact*(.2)) + xt ;
              whys[0] = (int) (fact*(.6)) + yt ;
              exes[1] = (int) (fact*(-.2)) + xt ;
              whys[1] = (int) (fact*(.6)) + yt ;
              exes[2] = (int) (fact*(-.2)) + xt ;
              whys[2] = (int) (fact*(0.0)) + yt ;
              exes[3] = (int) (fact*(.2)) + xt ;
              whys[3] = (int) (fact*(0.0)) + yt ;
              exes[4] = (int) (fact*(.2)) + xt ;
              whys[4] = (int) (fact*(.6)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(6.2)) + xt ;
              whys[0] = (int) (fact*(.4)) + yt ;
              exes[1] = (int) (fact*(0.0)) + xt ;
              whys[1] = (int) (fact*(.4)) + yt ;
              exes[2] = (int) (fact*(0.0)) + xt ;
              whys[2] = (int) (fact*(.6)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(.6)) + yt ;
              exes[4] = (int) (fact*(6.2)) + xt ;
              whys[4] = (int) (fact*(.4)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(5.8)) + xt ;
              whys[0] = (int) (fact*(.4)) + yt ;
              exes[1] = (int) (fact*(5.8)) + xt ;
              whys[1] = (int) (fact*(0.0)) + yt ;
              exes[2] = (int) (fact*(6.2)) + xt ;
              whys[2] = (int) (fact*(0.0)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(.4)) + yt ;
              exes[4] = (int) (fact*(5.8)) + xt ;
              whys[4] = (int) (fact*(.4)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
                    // resevoir
              pumph = Math.sqrt(8.0) ;
              exes[0] = (int) (fact*(4.0)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              exes[1] = (int) (fact*(8.0)) + xt ;
              whys[1] = (int) (fact*(0.0)) + yt ;
              exes[2] = (int) (fact*(8.0)) + xt ;
              whys[2] = (int) (fact*(-pumph)) + yt ;
              exes[3] = (int) (fact*(4.0)) + xt ;
              whys[3] = (int) (fact*(-pumph)) + yt ;
              exes[4] = (int) (fact*(4.0)) + xt ;
              whys[4] = (int) (fact*(0.0)) + yt ;
              offsGg.setColor(Color.blue) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(4.1)) + xt ;
              whys[0] = (int) (fact*(-(.25) * pumph )) + yt ;
              exes[1] = (int) (fact*(7.9)) + xt ;
              whys[1] = (int) (fact*(-(.25) * pumph )) + yt ;
              exes[2] = (int) (fact*(7.9)) + xt ;
              whys[2] = (int) (fact*(-pumph +.1)) + yt ;
              exes[3] = (int) (fact*(4.1)) + xt ;
              whys[3] = (int) (fact*(-pumph +.1)) + yt ;
              exes[4] = (int) (fact*(4.1)) + xt ;
              whys[4] = (int) (fact*(-(.25) * pumph )) + yt ;
              offsGg.setColor(Color.yellow) ;
              offsGg.fillPolygon(exes,whys,4) ;
                   // plunger
              exes[0] = (int) (fact*(5.8)) + xt ;
              whys[0] = (int) (fact*(-pumph)) + yt ;
              exes[1] = (int) (fact*(5.8)) + xt ;
              whys[1] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[2] = (int) (fact*(6.2)) + xt ;
              whys[2] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[3] = (int) (fact*(6.2)) + xt ;
              whys[3] = (int) (fact*(-pumph)) + yt ;
              exes[4] = (int) (fact*(5.8)) + xt ;
              whys[4] = (int) (fact*(-pumph)) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,4) ;
              exes[0] = (int) (fact*(5.0)) + xt ;
              whys[0] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[1] = (int) (fact*(7.0)) + xt ;
              whys[1] = (int) (fact*(-pumph -1.0)) + yt ;
              exes[2] = (int) (fact*(7.0)) + xt ;
              whys[2] = (int) (fact*(-pumph - 1.2)) + yt ;
              exes[3] = (int) (fact*(5.0)) + xt ;
              whys[3] = (int) (fact*(-pumph - 1.2)) + yt ;
              exes[4] = (int) (fact*(5.0)) + xt ;
              whys[4] = (int) (fact*(-pumph - 1.0)) + yt ;
              offsGg.setColor(Color.red) ;
              offsGg.fillPolygon(exes,whys,4) ;
                 // labels
              exes[0] = (int) (fact*(4.0)) + xt ;
              whys[0] = (int) (fact*(1.5)) + yt;
              offsGg.setColor(Color.black) ;
              offsGg.drawString("Propulsion",exes[0],whys[0]) ;
              exes[0] = (int) (fact*(btrad + 1.5)) + xt ;
              whys[0] = (int) (fact*(- .5)) + yt ;
              offsGg.drawString("Length",exes[0],whys[0]) ;
           }
           if (lnchgrf == 3) {   // solid rocket
              if (nclust == 0) {
                 exes[0] = (int) (fact*(erad)) + xt ;
                 whys[0] = (int) (fact*(-elngth + tlngth)) + yt ;
                 exes[1] = (int) (fact*(-erad)) + xt ;
                 whys[1] = (int) (fact*(-elngth + tlngth)) + yt ;
                 exes[2] = (int) (fact*(-erad)) + xt ;
                 whys[2] = (int) (fact*(tlngth)) + yt ;
                 exes[3] = (int) (fact*(erad)) + xt ;
                 whys[3] = (int) (fact*(tlngth)) + yt ;
                 exes[4] = (int) (fact*(erad)) + xt ;
                 whys[4] = (int) (fact*(-elngth + tlngth)) + yt ;
                 offsGg.setColor(Color.orange) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(erad)) + xt ;
                 whys[0] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                 exes[1] = (int) (fact*(-erad)) + xt ;
                 whys[1] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                 exes[2] = (int) (fact*(-erad)) + xt ;
                 whys[2] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                 exes[3] = (int) (fact*(erad)) + xt ;
                 whys[3] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                 exes[4] = (int) (fact*(erad)) + xt ;
                 whys[4] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                 offsGg.setColor(Color.black) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 exes[0] = (int) (fact*(erad)) + xt ;
                 whys[0] = (int) (fact*(-.2 + tlngth)) + yt ;
                 exes[1] = (int) (fact*(-erad)) + xt ;
                 whys[1] = (int) (fact*(-.2 + tlngth)) + yt ;
                 exes[2] = (int) (fact*(-erad)) + xt ;
                 whys[2] = (int) (fact*(-.3 + tlngth)) + yt ;
                 exes[3] = (int) (fact*(erad)) + xt ;
                 whys[3] = (int) (fact*(-.3 + tlngth)) + yt ;
                 exes[4] = (int) (fact*(erad)) + xt ;
                 whys[4] = (int) (fact*(-.2 + tlngth)) + yt ;
                 offsGg.setColor(Color.black) ;
                 offsGg.fillPolygon(exes,whys,4) ;
                 if (nstage == 2) {
                    exes[0] = (int) (fact*(b1erad)) + xt ;
                    whys[0] = (int) (fact*(b1lngth -b1elngth + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-b1erad)) + xt ;
                    whys[1] = (int) (fact*(b1lngth -b1elngth + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-b1erad)) + xt ;
                    whys[2] = (int) (fact*(b1lngth + tlngth)) + yt ;
                    exes[3] = (int) (fact*(b1erad)) + xt ;
                    whys[3] = (int) (fact*(b1lngth + tlngth)) + yt ;
                    exes[4] = (int) (fact*(b1erad)) + xt ;
                    whys[4] = (int) (fact*(b1lngth  -b1elngth + tlngth)) + yt ;
                    offsGg.setColor(Color.orange) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(b1erad)) + xt ;
                    whys[0] = (int) (fact*(b1lngth -b1elngth + .2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-b1erad)) + xt ;
                    whys[1] = (int) (fact*(b1lngth -b1elngth + .2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-b1erad)) + xt ;
                    whys[2] = (int) (fact*(b1lngth -b1elngth + .3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(b1erad)) + xt ;
                    whys[3] = (int) (fact*(b1lngth -b1elngth + .3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(b1erad)) + xt ;
                    whys[4] = (int) (fact*(b1lngth -b1elngth + .2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(b1erad)) + xt ;
                    whys[0] = (int) (fact*(b1lngth -.2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-b1erad)) + xt ;
                    whys[1] = (int) (fact*(b1lngth -.2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-b1erad)) + xt ;
                    whys[2] = (int) (fact*(b1lngth -.3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(b1erad)) + xt ;
                    whys[3] = (int) (fact*(b1lngth -.3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(b1erad)) + xt ;
                    whys[4] = (int) (fact*(b1lngth -.2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                 }
              }
              if (nclust == 1) {
                 if (numeng == 1) {
                    exes[0] = (int) (fact*(erad)) + xt ;
                    whys[0] = (int) (fact*(-elngth + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-erad)) + xt ;
                    whys[1] = (int) (fact*(-elngth + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-erad)) + xt ;
                    whys[2] = (int) (fact*(tlngth)) + yt ;
                    exes[3] = (int) (fact*(erad)) + xt ;
                    whys[3] = (int) (fact*(tlngth)) + yt ;
                    exes[4] = (int) (fact*(erad)) + xt ;
                    whys[4] = (int) (fact*(-elngth + tlngth)) + yt ;
                    offsGg.setColor(Color.orange) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(erad)) + xt ;
                    whys[0] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-erad)) + xt ;
                    whys[1] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-erad)) + xt ;
                    whys[2] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(erad)) + xt ;
                    whys[3] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(erad)) + xt ;
                    whys[4] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(erad)) + xt ;
                    whys[0] = (int) (fact*(-.2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(-erad)) + xt ;
                    whys[1] = (int) (fact*(-.2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(-erad)) + xt ;
                    whys[2] = (int) (fact*(-.3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(erad)) + xt ;
                    whys[3] = (int) (fact*(-.3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(erad)) + xt ;
                    whys[4] = (int) (fact*(-.2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                 }
                 if (numeng > 1) {
                    exes[0] = (int) (fact*(-ediam)) + xt ;
                    whys[0] = (int) (fact*(-elngth + tlngth)) + yt ;
                    exes[1] = (int) (fact*(ediam)) + xt ;
                    whys[1] = (int) (fact*(-elngth + tlngth)) + yt ;
                    exes[2] = (int) (fact*(ediam)) + xt ;
                    whys[2] = (int) (fact*(tlngth)) + yt ;
                    exes[3] = (int) (fact*(-ediam)) + xt ;
                    whys[3] = (int) (fact*(tlngth)) + yt ;
                    exes[4] = (int) (fact*(-ediam)) + xt ;
                    whys[4] = (int) (fact*(-elngth + tlngth)) + yt ;
                    offsGg.setColor(Color.orange) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(-ediam)) + xt ;
                    whys[0] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(ediam)) + xt ;
                    whys[1] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(ediam)) + xt ;
                    whys[2] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(-ediam)) + xt ;
                    whys[3] = (int) (fact*(-elngth + .3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(-ediam)) + xt ;
                    whys[4] = (int) (fact*(-elngth + .2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;
                    exes[0] = (int) (fact*(-ediam)) + xt ;
                    whys[0] = (int) (fact*(-.2 + tlngth)) + yt ;
                    exes[1] = (int) (fact*(ediam)) + xt ;
                    whys[1] = (int) (fact*(-.2 + tlngth)) + yt ;
                    exes[2] = (int) (fact*(ediam)) + xt ;
                    whys[2] = (int) (fact*(-.3 + tlngth)) + yt ;
                    exes[3] = (int) (fact*(-ediam)) + xt ;
                    whys[3] = (int) (fact*(-.3 + tlngth)) + yt ;
                    exes[4] = (int) (fact*(-ediam)) + xt ;
                    whys[4] = (int) (fact*(-.2 + tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.fillPolygon(exes,whys,4) ;

                    exes[0] = (int) (fact*(0.0)) + xt ;
                    whys[0] = (int) (fact*(-elngth + tlngth)) + yt ;
                    whys[1] = (int) (fact*(tlngth)) + yt ;
                    offsGg.setColor(Color.black) ;
                    offsGg.drawLine(exes[0],whys[0],exes[0],whys[1]) ;
                 }
              }
           }
   // cg-cp
           exes[0] = (int) (fact*(0.0)) - 5 + xt ;
           whys[0] = (int) (fact*(-cg)) - 5 + yt;
           offsGg.setColor(Color.red) ;
           offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
           offsGg.setColor(Color.yellow) ;
           offsGg.fillArc(exes[0]+1,whys[0]+1,8,8,0,360) ;
           exes[0] = (int) (fact*(brad)) + 5 + xt ;
           offsGg.setColor(Color.blue) ;
           offsGg.drawString("Cg-Center of Gravity",exes[0],whys[0] + 10) ;

           exes[0] = (int) (fact*(0.0)) - 5 + xt ;
           whys[0] = (int) (fact*(-cp)) - 5 + yt;
           offsGg.setColor(Color.black) ;
           offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
           exes[0] = (int) (fact*(brad)) + 5 + xt ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Cp-Center of Pressure",exes[0],whys[0] + 10) ;
        }

 // flight view
        if (viewflg == 1) {
          if (planet <= 1) offsGg.setColor(Color.cyan) ;
          if (planet == 2) offsGg.setColor(Color.black) ;
          if (planet == 3) offsGg.setColor(Color.pink) ;
          offsGg.fillRect(0,0,740,600) ;
                // hills
          exes[0] = (int) (fact*(0.0)) + xt ;
          whys[0] = (int) (fact*(200.0)) + yt ;
          exes[1] = (int) (fact*(2000.0)) + xt ;
          whys[1] = (int) (fact*(-100.)) + yt ;
          exes[2] = (int) (fact*(4200)) + xt ;
          whys[2] = (int) (fact*(100.0)) + yt  ;
          exes[3] = (int) (fact*(7000.)) + xt ;
          whys[3] = (int) (fact*(-200.0)) + yt ;
          exes[4] = (int) (fact*(9000.)) + xt ;
          whys[4] = (int) (fact*(100.0)) + yt ;
          exes[5] = (int) (fact*(10000.)) + xt ;
          whys[5] = (int) (fact*(-100.0)) + yt ;
          exes[6] = (int) (fact*(12000.)) + xt ;
          whys[6] = (int) (fact*(200.0)) + yt ;
          exes[7] = (int) (fact*(0.0)) + xt ;
          whys[7] = (int) (fact*(200.0)) + yt ;
          if (planet <= 1) offsGg.setColor(col1) ;
          if (planet == 2) offsGg.setColor(Color.darkGray) ;
          if (planet == 3) offsGg.setColor(col2) ;
          offsGg.fillPolygon(exes,whys,7) ;
          exes[0] = (int) (fact*(-250.0)) + xt ;
          whys[0] = (int) (fact*(0.0)) + yt ;
          exes[1] = (int) (fact*(-2000.0)) + xt ;
          whys[1] = (int) (fact*(-100.)) + yt ;
          exes[2] = (int) (fact*(-4200)) + xt ;
          whys[2] = (int) (fact*(100.0)) + yt  ;
          exes[3] = (int) (fact*(-7000.)) + xt ;
          whys[3] = (int) (fact*(-200.0)) + yt ;
          exes[4] = (int) (fact*(-9000.)) + xt ;
          whys[4] = (int) (fact*(100.0)) + yt ;
          exes[5] = (int) (fact*(-15000.)) + xt ;
          whys[5] = (int) (fact*(-100.0)) + yt ;
          exes[6] = (int) (fact*(-22000.)) + xt ;
          whys[6] = (int) (fact*(100.0)) + yt ;
          exes[7] = (int) (fact*(-250.)) + xt ;
          whys[7] = (int) (fact*(0.0)) + yt ;
          if (planet <= 1) offsGg.setColor(col1) ;
          if (planet == 2) offsGg.setColor(Color.darkGray) ;
          if (planet == 3) offsGg.setColor(col2) ;
          offsGg.fillPolygon(exes,whys,8) ;
                // ground plane
          exes[0] = 0 ;
          whys[0] = (int) (fact*(-5.0)) + yt ;
          exes[1] = 750 ;
          whys[1] = (int) (fact*(-5.)) + yt ;
          exes[2] = 750;
          whys[2] = 500 ;
          exes[3] = 0 ;
          whys[3] = 750 ;
          exes[4] = 0 ;
          whys[4] = (int) (fact*(-5.0)) + yt ;
          if (planet <= 1) offsGg.setColor(Color.green) ;
          if (planet == 2) offsGg.setColor(Color.gray) ;
          if (planet == 3) offsGg.setColor(Color.orange) ;
          offsGg.fillPolygon(exes,whys,5) ;
                // wall
          exes[0] = (int) (fact*(350.0)) + xt ;
          whys[0] = (int) (fact*(5.0)) + yt ;
          exes[1] = (int) (fact*(350.0)) + xt ;
          whys[1] = (int) (fact*(-15.)) + yt ;
          exes[2] = (int) (fact*(352.0)) + xt ;
          whys[2] = (int) (fact*(-15.)) + yt ;
          exes[3] = (int) (fact*(352.0)) + xt ;
          whys[3] = (int) (fact*(5.0)) + yt ;
          exes[4] = (int) (fact*(350.0)) + xt ;
          whys[4] = (int) (fact*(5.0)) + yt ;
          offsGg.setColor(Color.red) ;
          offsGg.fillPolygon(exes,whys,5) ;
          exes[0] = (int) (fact*(-350.0)) + xt ;
          exes[1] = (int) (fact*(-350.0)) + xt ;
          exes[2] = (int) (fact*(-352.0)) + xt ;
          exes[3] = (int) (fact*(-352.0)) + xt ;
          exes[4] = (int) (fact*(-350.0)) + xt ;
          offsGg.fillPolygon(exes,whys,5) ;
          if (planet <= 1) {
                // building  #1
             exes[0] = (int) (fact*(650.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(680.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(680.0)) + xt ;
             whys[2] = (int) (fact*(-50.)) + yt ;
             exes[3] = (int) (fact*(660.0)) + xt ;
             whys[3] = (int) (fact*(-50.0)) + yt ;
             exes[4] = (int) (fact*(660.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(650.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(650.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #2
             exes[0] = (int) (fact*(1550.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(1580.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(1580.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(1560.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(1560.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(1550.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(1550.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #3
             exes[0] = (int) (fact*(2350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(2390.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(2390.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(2370.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(2370.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(2350.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(2350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #4
             exes[0] = (int) (fact*(3250.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(3290.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(3290.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(3270.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(3270.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(3250.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(3250.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #5
             exes[0] = (int) (fact*(4450.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(4490.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(4490.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(4470.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(4470.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(4450.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(4450.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #6
             exes[0] = (int) (fact*(-750.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-790.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-790.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(-770.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(-770.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(-750.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(-750.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                // building  #7
             exes[0] = (int) (fact*(-1250.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-1290.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-1290.0)) + xt ;
             whys[2] = (int) (fact*(-60.)) + yt ;
             exes[3] = (int) (fact*(-1270.0)) + xt ;
             whys[3] = (int) (fact*(-60.0)) + yt ;
             exes[4] = (int) (fact*(-1270.0)) + xt ;
             whys[4] = (int) (fact*(-20.0)) + yt ;
             exes[5] = (int) (fact*(-1250.0)) + xt ;
             whys[5] = (int) (fact*(-20.0)) + yt ;
             exes[6] = (int) (fact*(-1250.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #8
             exes[0] = (int) (fact*(-2350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-2390.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-2390.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-2370.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-2370.0)) + xt ;
             whys[4] = (int) (fact*(-70.0)) + yt ;
             exes[5] = (int) (fact*(-2350.0)) + xt ;
             whys[5] = (int) (fact*(-70.0)) + yt ;
             exes[6] = (int) (fact*(-2350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #9
             exes[0] = (int) (fact*(-3550.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-3580.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-3580.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-3560.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-3560.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(-3550.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(-3550.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
                   // building  #10
             exes[0] = (int) (fact*(-4350.0)) + xt ;
             whys[0] = (int) (fact*(10.0)) + yt ;
             exes[1] = (int) (fact*(-4380.0)) + xt ;
             whys[1] = (int) (fact*(10.0)) + yt ;
             exes[2] = (int) (fact*(-4380.0)) + xt ;
             whys[2] = (int) (fact*(-40.)) + yt ;
             exes[3] = (int) (fact*(-4360.0)) + xt ;
             whys[3] = (int) (fact*(-40.0)) + yt ;
             exes[4] = (int) (fact*(-4360.0)) + xt ;
             whys[4] = (int) (fact*(-80.0)) + yt ;
             exes[5] = (int) (fact*(-4350.0)) + xt ;
             whys[5] = (int) (fact*(-80.0)) + yt ;
             exes[6] = (int) (fact*(-4350.0)) + xt ;
             whys[6] = (int) (fact*(10.0)) + yt ;
             offsGg.setColor(Color.black) ;
             offsGg.fillPolygon(exes,whys,6) ;
          }
                // Grid paper background
          if (gridon >= 0) {  
            factm = 50. ;
            if (fact < 2.5 && fact >= .5) factm = 100. ;
            if (fact < .5 && fact >= .25) factm = 500. ;
            if (fact < .25 && fact >= .1) factm = 1000. ;
            if (fact < .1 && fact >= .05) factm = 5000. ;
            if (fact < .05 && fact >= .001) factm = 10000. ;

            outlng = " ft" ;
            if (lunits == 1) {
               outlng = " m" ;
               factm = .5 * factm ;
            }
            for (j=0; j<=50; ++j) {
               exes[0] = 0 ; 
               exes[1] = 700 ;
               whys[0] = whys[1] = (int) (-fact*(factm*j / lconv1)) + yt;
               offsGg.setColor(Color.red) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.drawString(words,252,whys[0]+5) ; 
            }
            for (j=0; j<=50; ++j) {
               whys[0] = (int) (-fact*(0.0)) + yt;
               whys[1] = 0;
               exes[0] = exes[1] = (int) (fact*(factm*j / lconv1)) + xt  ;
               offsGg.setColor(Color.red) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.setColor(Color.black) ;
               if (planet == 2) offsGg.setColor(Color.white) ;
               offsGg.drawString(words,exes[0]-5,260) ;

               exes[0] = exes[1] = (int) (-fact*(factm*j / lconv1)) + xt  ;
               offsGg.setColor(Color.red) ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               words = String.valueOf(factm * j)  + outlng;
               offsGg.setColor(Color.black) ;
               if (planet == 2) offsGg.setColor(Color.white) ;
               offsGg.drawString(words,exes[0]-5,260) ;
            }
          }
       // labels 
               // saved flights
          if (nsav >= 1) {
            for (i=0; i<= nsav-1; ++ i) {
              exes[0] = (int) (fact*(0.0)) + xt ;
              whys[0] = (int) (fact*(0.0)) + yt ;
              nump = npts[i] ;
              for (j=0; j<=nump; ++j){
                exes[1] = exes[0] ;
                whys[1] = whys[0] ;
                exes[0] = (int) (fact*(posx[i][j])) + xt ;
                whys[0] = (int) (fact*(-posy[i][j])) + yt ;
                offsGg.setColor(Color.white) ;
                offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
                if(i==0) offsGg.setColor(Color.blue) ;
                if(i==1) offsGg.setColor(Color.white) ;
                if(i==2) offsGg.setColor(Color.magenta) ;
                if(i==3) offsGg.setColor(Color.orange) ;
                offsGg.drawString("*",exes[0]-3,whys[0]+5) ;
              }
            }
          }
               // flight trajectory
          exes[0] = (int) (fact*(0.0)) + xt ;
          whys[0] = (int) (fact*(0.0)) + yt ;
          for (j=0; j<=npt; ++j){
            exes[1] = exes[0] ;
            whys[1] = whys[0] ;
            exes[0] = (int) (fact*(posx[nsav][j])) + xt ;
            whys[0] = (int) (fact*(-posy[nsav][j])) + yt ;
            if (planet <= 1) offsGg.setColor(Color.black) ;
            if (planet == 2) offsGg.setColor(Color.white) ;
            if (planet == 3) offsGg.setColor(Color.black) ;
            if (j < nburn) offsGg.setColor(Color.red) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            offsGg.setColor(Color.red) ;
            if ((rktype < 3) || (rktype == 10)) {
              offsGg.drawString("*",exes[0]-3,whys[0]+5) ;
            }
            if (rktype == 3 ) {
               if (j < nburn) offsGg.drawString("*",exes[0]-3,whys[0]+5) ;
            }
          }
     // flight rocket
          if (ldisplay == 0) {
            cpa = Math.cos(posa[npt]) ;
            spa = Math.sin(posa[npt]) ;
            if (rktype >= 2 && fltim >= timd && rtype >= 1) {
               cpa = Math.cos(pid2) ;
               spa = Math.sin(pid2) ;
               if (vloc == 0.0) {
                 cpa = Math.cos(0.0) ;
                 spa = Math.sin(0.0) ;
               }
            }
        // fins
            exes[0] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0. * cpa + 8.0 * spa) + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (0. * spa - 8.0 * cpa) + yt ;
            exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0. * cpa - 8.0 * spa) + xt ;
            whys[1] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (0. * spa + 8.0 * cpa) + yt ;
            exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (15. * cpa - 0.0 * spa) + xt ;
            whys[2] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (15. * spa + 0.0 * cpa)+ yt ;
            exes[3] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0. * cpa + 8.0 * spa) + xt ;
            whys[3] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (0. * spa - 8.0 * cpa) + yt ;
            offsGg.setColor(Color.blue) ;
            offsGg.fillPolygon(exes,whys,3) ;
        // body
            exes[0] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa - 3.0 * spa) + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (0.0 * spa + 3.0 * cpa) + yt ;
            exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa + 3.0 * spa) + xt ;
            whys[1] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (0.0 * spa - 3.0 * cpa)+ yt ;
            exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (40. * cpa + 3.0 * spa) + xt ;
            whys[2] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (40. * spa - 3.0 * cpa)+ yt ;
            exes[3] = (int) (fact*(posx[nsav][npt]))
                    + (int) (40. * cpa - 3.0 * spa) + xt ;
            whys[3] = (int) (fact*(-posy[nsav][npt]))
                  - (int) (40. * spa + 3.0 * cpa)+ yt ;
            exes[4] = (int) (fact*(posx[nsav][npt]))
                    + (int) (0.0 * cpa - 3.0 * spa) + xt ;
            whys[4] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (0.0 * spa + 3.0 * cpa)+ yt ;
            offsGg.setColor(Color.white) ;
            offsGg.fillPolygon(exes,whys,4) ;
        // nose
            nosx = 0.0 ;
            nosy = 40.0 ;
            if (rktype >= 2 && fltim >= timd && rtype >= 1) {
               nosx = 5.0 ;
               nosy = 20.0 ;
            }
            exes[0] = (int) (fact*(posx[nsav][npt]))
                  + (int) (nosy * cpa + (nosx +3.0) * spa) + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (nosy * spa - (nosx + 3.0) * cpa)+ yt ;
            exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) ((nosy + 15.) * cpa - nosx * spa) + xt ;
            whys[1] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) ((nosy + 15.) * spa + nosx * cpa) + yt ;
            exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (nosy * cpa + (nosx - 3.0) * spa) + xt ;
            whys[2] = (int) (fact*(-posy[nsav][npt]))
                  - (int) (nosy * spa - (nosx - 3.0) * cpa)+ yt ;
            exes[3] = (int) (fact*(posx[nsav][npt]))
                    + (int) (nosy * cpa + (nosx + 3.0) * spa) + xt ;
            whys[3] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (nosy * spa - (nosx + 3.0) * cpa)+ yt ;
            offsGg.setColor(Color.red) ;
            offsGg.fillPolygon(exes,whys,3) ;
        // booster stage
            hstg = 0.0 ;
            if (rktype == 3 && nstage == 2) {
               hstg = 10.0 ;
           // fins
               exes[0] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa - 8.0 * spa) + xt ;
               whys[0] = (int) (fact*(-posb1)) 
                    - (int) (0.0 * spa + 8.0 * cpa) + yt ;
               exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa + 8.0 * spa) + xt ;
               whys[1] = (int) (fact*(-posb1))
                    - (int) (0.0 * spa - 8.0 * cpa)+ yt ;
               exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (-hstg * cpa + 8.0 * spa) + xt ;
               whys[2] = (int) (fact*(-posb1))
                    - (int) (-hstg * spa - 8.0 * cpa)+ yt ;
               exes[3] = (int) (fact*(posx[nsav][npt]))
                    + (int) (-hstg * cpa - 8.0 * spa) + xt ;
               whys[3] = (int) (fact*(-posb1))
                    - (int) (-hstg * spa + 8.0 * cpa)+ yt ;
               exes[4] = (int) (fact*(posx[nsav][npt]))
                    + (int) (0.0 * cpa - 8.0 * spa) + xt ;
               whys[4] = (int) (fact*(-posb1))
                  - (int) (0.0 * spa + 8.0 * cpa)+ yt ;
               offsGg.setColor(Color.blue) ;
               offsGg.fillPolygon(exes,whys,4) ;
          //  body
               exes[0] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa - 3.0 * spa) + xt ;
               whys[0] = (int) (fact*(-posb1)) 
                    - (int) (0.0 * spa + 3.0 * cpa) + yt ;
               exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (0.0 * cpa + 3.0 * spa) + xt ;
               whys[1] = (int) (fact*(-posb1))
                    - (int) (0.0 * spa - 3.0 * cpa)+ yt ;
               exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (-hstg * cpa + 3.0 * spa) + xt ;
               whys[2] = (int) (fact*(-posb1))
                    - (int) (-hstg * spa - 3.0 * cpa)+ yt ;
               exes[3] = (int) (fact*(posx[nsav][npt]))
                    + (int) (-hstg * cpa - 3.0 * spa) + xt ;
               whys[3] = (int) (fact*(-posb1))
                    - (int) (-hstg * spa + 3.0 * cpa)+ yt ;
               exes[4] = (int) (fact*(posx[nsav][npt]))
                    + (int) (0.0 * cpa - 3.0 * spa) + xt ;
               whys[4] = (int) (fact*(-posb1))
                    - (int) (0.0 * spa + 3.0 * cpa)+ yt ;
               offsGg.setColor(Color.magenta) ;
               offsGg.fillPolygon(exes,whys,4) ;
               if (fltim >= tim2b1) hstg = 0.0 ;
            }
        // plume
            if ((rktype == 3 || rktype == 2) && fltim >= 0.0 && fltim <= tim2 && nburn >= 1) {
               exes[0] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (-hstg * cpa + 0.0 * spa) + xt ;
               whys[0] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (-hstg * spa - 0.0 * cpa) + yt ;
               exes[1] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (-(hstg + 10.0) * cpa - 5.0 * spa) + xt ;
               whys[1] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (-(hstg + 10.0) * spa + 5.0 * cpa) + yt ;
               exes[2] = (int) (fact*(posx[nsav][npt]))
                    + (int) (-(hstg + 25.) * cpa + 0.0 * spa) + xt ;
               whys[2] = (int) (fact*(-posy[nsav][npt]))
                    - (int) (-(hstg + 25.) * spa - 0.0 * cpa)+ yt ;
               exes[3] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (-(hstg + 10.) * cpa + 5.0 * spa) + xt ;
               whys[3] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (-(hstg + 10.) * spa - 5.0 * cpa) + yt ;
               exes[4] = (int) (fact*(posx[nsav][npt])) 
                    + (int) (-hstg * cpa + 0.0 * spa) + xt ;
               whys[4] = (int) (fact*(-posy[nsav][npt])) 
                    - (int) (-hstg * spa - 0.0 * cpa) + yt ;
               if (rktype == 3) offsGg.setColor(Color.orange) ;
               if (rktype == 2) offsGg.setColor(Color.blue) ;
               offsGg.fillPolygon(exes,whys,4) ;
            }
        // parachute
            if (rktype >= 2 && fltim >= timd && rtype >= 1 && vloc > 0.0) {
              exes[0] = (int) (fact*(posx[nsav][npt])) + xt ;
              whys[0] = (int) (fact*(-posy[nsav][npt])) + yt ;
              offsGg.setColor(Color.black) ;
              offsGg.fillArc(exes[0]-20,whys[0]-70,40,15,20,140) ;
              exes[0] = (int) (fact*(posx[nsav][npt])) + xt ;
              whys[0] = (int) (fact*(-posy[nsav][npt])) - 40 + yt ;
              exes[1] = (int) (fact*(posx[nsav][npt])) + 15 + xt ;
              whys[1] = (int) (fact*(-posy[nsav][npt])) - 65 + yt ;
              offsGg.setColor(Color.black) ;
              offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
              exes[1] = (int) (fact*(posx[nsav][npt])) - 15 + xt ;
              whys[1] = (int) (fact*(-posy[nsav][npt])) - 65 + yt ;
              offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            }
               // launch rail
            exes[0] = (int) (5.0 * Math.sin((90.0 - lnchang) * convdr)) + xt ;
            whys[0] = -(int) (- 5.0 * Math.cos((90.0 -lnchang) * convdr)) + yt ;
            exes[1] = (int) (56. * Math.cos((90.0 - lnchang) * convdr) 
                         + 5.0 * Math.sin((90.0 - lnchang) * convdr)) + xt - 1; 
            whys[1] = -(int) (56. * Math.sin((90.0 - lnchang) * convdr)
                           - 5.0 * Math.cos((90.0 - lnchang) * convdr)) + yt ;
            offsGg.setColor(Color.black) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
          }
     // ballistic shell
          if (ldisplay == 1) {
            cpa = Math.cos((90.0 - lnchang)*convdr) ;
            spa = Math.sin((90.0 - lnchang)*convdr) ;
               // cannon
            exes[0] = (int) (5.0 * spa) + xt ;
            whys[0] = -(int) (- 5.0 * cpa) + yt ;
            exes[1] = (int) (20. * cpa + 5.0 * spa) + xt - 1; 
            whys[1] = -(int) (20. * spa - 5.0 * cpa) + yt ;
            offsGg.setColor(Color.blue) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            exes[0] = (int) (-5.0 * spa) + xt ;
            whys[0] = -(int) (+ 5.0 * cpa) + yt ;
            exes[1] = (int) (20. * cpa - 5.0 * spa) + xt ;
            whys[1] = -(int) (20. * spa + 5.0 * cpa) + yt ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            exes[0] = (int) (fact*(posx[nsav][npt])) - 5 + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt])) - 5 + yt;
            offsGg.setColor(Color.blue) ;
            offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
          }
     // baseball
          if (ldisplay == 2) {
            cpa = Math.cos((90.0 - lnchang)*convdr) ;
            spa = Math.sin((90.0 - lnchang)*convdr) ;
  //               cpa = Math.cos(lnchang*convdr) ;
  //               spa = Math.sin(lnchang*convdr) ;
            exes[0] = (int) (0.0) + xt ;
            whys[0] = -(int) (0.0) + yt ;
            exes[1] = (int) (20. * cpa) + xt ; 
            whys[1] = -(int) (20. * spa) + yt ;
            offsGg.setColor(Color.black) ;
            offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            exes[0] = (int) (fact*(posx[nsav][npt])) - 5 + xt ;
            whys[0] = (int) (fact*(-posy[nsav][npt])) - 5 + yt;
            offsGg.setColor(Color.white) ;
            offsGg.fillArc(exes[0],whys[0],10,10,0,360) ;
          }
 
   // wind vector
          exes[0] = 140 ;
          whys[0] = 75;
          exes[1] = 140 + (int) (5.*wind) ;
          whys[1] = 75 ;
          offsGg.setColor(Color.black) ;
          offsGg.drawString("Wind",exes[0]-15,whys[0]+15) ;
          offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
          if (wind >= 0.0) {
            exes[0] = exes[1] - 5 ;
            whys[0] = whys[1] - 3 ;
            exes[2] = exes[1] - 5 ;
            whys[2] = whys[1] + 3 ;
            exes[3] = exes[1] - 5 ;
            whys[3] = whys[1] - 3 ;
          }
          if (wind < 0.0) {
            exes[0] = exes[1] + 5 ;
            whys[0] = whys[1] - 3 ;
            exes[2] = exes[1] + 5 ;
            whys[2] = whys[1] + 3 ;
            exes[3] = exes[1] + 5 ;
            whys[3] = whys[1] - 3 ;
          }
          offsGg.fillPolygon(exes,whys,4) ;

          if (trakon > 0) {
            offsGg.setColor(Color.black) ;
            if (planet == 2) offsGg.setColor(Color.white) ;
            offsGg.drawString("TRACKING  MODE",120,415) ;
          }
        }
 
        if (viewflg == 2) {   // data traces
           offsGg.setColor(Color.white) ;
           offsGg.fillRect(0,0,600,600) ;
           if (gridon >= 0) {       // Grid paper background
             for (j=0; j<=50; ++j) {
               offsGg.setColor(Color.cyan) ;
               exes[0] = 0 ; 
               exes[1] = 500 ;
               whys[0] = whys[1] = (int) (fact*(10.*j)) + yt;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               whys[0] = whys[1] = (int) (-fact*(10.*j)) + yt;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
             }
             for (j=0; j<=60; ++j) {
               offsGg.setColor(Color.cyan) ;
               whys[0] = 0 ; whys[1] = 500 ;
               exes[0] = exes[1] = (int) (fact*(10.0*j)) + xt  ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
               exes[0] = exes[1] = (int) (-fact*(10.0*j)) + xt  ;
               offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
             }
          }
          for (i=5; i<= 9; ++ i) {
            exes[0] = (int) (fact*(0.0)) + xt ;
            whys[0] = (int) (fact*((i-4) * 50.0 - posy[i][0])) + yt ;
            scale = 1.0 ;
            if (i == 5) {
               offsGg.setColor(Color.black) ;
               offsGg.drawString("Thrust",exes[0]-50,whys[0]) ;
            }
            if (i == 6) {
               offsGg.setColor(Color.blue) ;
               ylabel = (int) (fact*((i-4) * 50.0)) + yt ;
               offsGg.drawString("Weight",exes[0]-50,ylabel) ;
            }
            if (i == 7) {
               offsGg.setColor(Color.red) ;
               offsGg.drawString("Drag",exes[0]-50,whys[0]) ;
            }
            if (i == 8) {
               offsGg.setColor(Color.magenta) ;
               if (spdmax > 0.0) {
                 scale = 50.0 /spdmax ;
                 whys[0] = (int) (fact*((i-4) * 50.0 - scale * posy[i][0])) + yt ;
               }
               ylabel = (int) (fact*((i-4) * 50.0)) + yt ;
               offsGg.drawString("Velocity",exes[0]-50,ylabel) ;
            }
            if (i == 9) {
               offsGg.setColor(Color.green) ;
               if (vmax > 0.0) {
                 scale = 50.0 / vmax ;
                 whys[0] = (int) (fact*((i-4) * 50.0 - scale * posy[i][0])) + yt ;
               }
               offsGg.drawString("Height",exes[0]-50,whys[0]) ;
            }
            for (j=1; j<=npt; ++j){
              exes[1] = exes[0] ;
              whys[1] = whys[0] ;
              exes[0] = (int) (fact*(posx[i][j])) + xt ;
              whys[0] = (int) (fact*((i-4) * 50.0 - scale * posy[i][j])) + yt ;
              offsGg.drawLine(exes[0],whys[0],exes[1],whys[1]) ;
            }
          }
          offsGg.setColor(Color.black) ;
          exes[0] = (int) (fact*(50.0)) + xt ;
          whys[0] = (int) (fact*(260.0)) + yt ;
          offsGg.drawString("Time",exes[0],whys[0]) ;
        }
 // border 
 // side zoom widget
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(0,0,35,450) ;
        offsGg.setColor(Color.black) ;
        offsGg.drawString("Zoom",2,265) ;
        offsGg.drawLine(15,50,15,250) ;
        offsGg.fillRect(5,sldloc,20,5) ;

        if (gridon < 0) {     // Grid button
           offsGg.setColor(Color.blue) ;
           offsGg.fillRect(0,30,30,15) ;
           offsGg.setColor(Color.white) ;
           offsGg.drawString("Grid",2,42) ;
        }
        if (gridon >= 0) {
           offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(0,30,30,15) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Grid",2,42) ;
        }
 // bottom
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(34,415,400,40) ;
        offsGg.setColor(Color.blue) ;
        offsGg.fillRect(100,420,40,20) ;
        offsGg.setColor(Color.white) ;
        offsGg.drawString("Find",108,435) ;
        if (trakon < 0) {  // Track button
           offsGg.setColor(Color.blue) ;
           offsGg.fillRect(200,420,40,20) ;
           offsGg.setColor(Color.white) ;
           offsGg.drawString("Track",205,435) ;
        }
        if (trakon >= 0) {
           offsGg.setColor(Color.yellow) ;
           offsGg.fillRect(200,420,40,20) ;
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Track",205,435) ;
        }
 // top
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(34,0,700,25) ;
        if (viewflg == 0) {
           if (lnchgrf == 0) {
             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(35,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Nose",45,15) ;

             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(100,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Payload",105,15) ;

             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(165,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Body",175,15) ;

             offsGg.setColor(Color.blue) ;
             offsGg.fillRect(230,2,60,20) ;
             offsGg.setColor(Color.white) ;
             offsGg.drawString("Fins",240,15) ;

             if (part == 1) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(35,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Nose",45,15) ;
             }

             if (part == 2) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(100,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Payload",105,15) ;
             }

             if (part == 3) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(165,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Body",175,15) ;
             }

             if (part == 4) {
                offsGg.setColor(Color.yellow) ;
                offsGg.fillRect(230,2,60,20) ;
                offsGg.setColor(Color.black) ;
                offsGg.drawString("Fins",240,15) ;
             }
           }
        }
        if (viewflg == 1) {
               // time-height boxes
           offsGg.setColor(Color.black) ;
           offsGg.drawString("Time",40,15) ;
           offsGg.drawString("Height",150,15) ;
           offsGg.drawString("Max",250,15) ;
           offsGg.drawString("Distance",350,15) ;
           offsGg.fillRect(80,2,40,18) ;
           offsGg.fillRect(200,2,40,18) ;
           offsGg.fillRect(280,2,40,18) ;
           offsGg.fillRect(400,2,40,18) ;
           if (fltim <= 0.0) {
             offsGg.setColor(Color.green) ;
             offsGg.drawString(String.valueOf(filter0(fltim)),90,15) ;
           }
           if (fltim > 0.0) {
             offsGg.setColor(Color.yellow) ;
             offsGg.drawString(String.valueOf(filter1(fltim)),90,15) ;
           }
           offsGg.setColor(Color.yellow) ;
           offsGg.drawString(String.valueOf(filter0(vloc*lconv1)),205,15) ;
           offsGg.drawString(String.valueOf(filter0(vmax*lconv1)),285,15) ;
           offsGg.drawString(String.valueOf(filter0(posx[nsav][npt]*lconv1)),405,15) ;
/*
           offsGg.setColor(Color.blue) ;
           offsGg.fillRect(650,5,30,15) ;
           offsGg.setColor(Color.white) ;
           offsGg.drawString("Save",652,17) ;
*/
        }
 // right 
        offsGg.setColor(Color.lightGray) ;
        offsGg.fillRect(680,0,30,450) ;
 
        g.drawImage(offImg,0,0,this) ;   

     }  // end Paint
  }  // End View

} // end HitModeler
